%?python_enable_dependency_generator

%define srcname nmstate
%define libname libnmstate
%define is_snapshot 0

%if %{is_snapshot}
%global debug_package %{nil}
%endif

Name:           nmstate
Version:        2.2.52
Release:        1%{?dist}
Summary:        Declarative network manager API
License:        Apache-2.0 AND LGPL-2.1-or-later
URL:            https://github.com/%{srcname}/%{srcname}
%if ! %{is_snapshot}
Source0:        %{url}/releases/download/v%{version}/%{srcname}-%{version}.tar.gz
Source1:        %{url}/releases/download/v%{version}/%{srcname}-%{version}.tar.gz.asc
Source2:        https://nmstate.io/nmstate.gpg
%else
Source0:        %{srcname}-%{version}-alpha-1.tar.gz
%endif
%if %{is_snapshot}
Source3:        %{srcname}-vendor-%{version}-alpha-1.tar.xz
%else
%if 0%{?rhel}
Source3:        %{url}/releases/download/v%{version}/%{srcname}-vendor-%{version}.tar.xz
%endif
%endif
BuildRequires:  python3-devel
%if 0%{?fedora} >= 43
%define use_pyproject 1
%else
%define use_pyproject 0
BuildRequires:  python3-setuptools
%endif
BuildRequires:  gnupg2
BuildRequires:  systemd-rpm-macros
%if 0%{?rhel}
BuildRequires:  rust-toolset
%else
BuildRequires:  rust-packaging
%if ! %{is_snapshot}
BuildRequires:  (crate(clap/cargo) >= 3.1 with crate(clap/cargo) < 4.0)
BuildRequires:  (crate(clap/default) >= 3.1 with crate(clap/default) < 4.0)
BuildRequires:  (crate(chrono/default) >= 0.4 with crate(chrono/default) < 0.5)
BuildRequires:  (crate(env_logger/default) >= 0.11 with crate(env_logger/default) < 0.12)
BuildRequires:  (crate(libc/default) >= 0.2 with crate(libc/default) < 0.3)
BuildRequires:  (crate(log/default) >= 0.4 with crate(log/default) < 0.5)
BuildRequires:  (crate(nispor/default) >= 1.2.12 with crate(nispor/default) < 2.0)
BuildRequires:  (crate(serde/default) >= 1.0 with crate(serde/default) < 2.0)
BuildRequires:  (crate(serde/derive) >= 1.0 with crate(serde/derive) < 2.0)
BuildRequires:  (crate(serde_json/default) >= 1.0 with crate(serde_json/default) < 2.0)
BuildRequires:  (crate(serde_yaml/default) >= 0.9 with crate(serde_yaml/default) < 1.0)
BuildRequires:  (crate(uuid/v4) >= 1.1 with crate(uuid/v4) < 2.0)
BuildRequires:  (crate(uuid/v5) >= 1.1 with crate(uuid/v5) < 2.0)
BuildRequires:  (crate(zbus/default) >= 5.1 with crate(zbus/default) < 6.0)
BuildRequires:  (crate(zvariant/default) >= 5.1 with crate(zvariant/default) < 6.0)
BuildRequires:  (crate(nix/default) >= 0.26 with crate(nix/default) < 0.27)
BuildRequires:  (crate(toml/default) >= 0.8 with crate(toml/default) < 0.9)
BuildRequires:  (crate(tokio/default) >= 1.3 with crate(tokio/default) < 2.0)
BuildRequires:  (crate(tokio/net) >= 1.3 with crate(tokio/net) < 2.0)
BuildRequires:  (crate(tokio/rt) >= 1.3 with crate(tokio/rt) < 2.0)
BuildRequires:  (crate(tokio/signal) >= 1.3 with crate(tokio/signal) < 2.0)
%endif
%endif

%if %{use_pyproject}
%generate_buildrequires
pushd rust/src/python >/dev/null
%pyproject_buildrequires
popd >/dev/null
%endif

%description
Nmstate is a library with an accompanying command line tool that manages host
networking settings in a declarative manner and aimed to satisfy enterprise
needs to manage host networking through a northbound declarative API and multi
provider support on the southbound.


%package libs
Summary:        C binding of nmstate
# Use Recommends for NetworkManager because only access to NM DBus is required,
# but NM could be running on a different host
Recommends:     NetworkManager
License:        Apache-2.0

%description libs
C binding of nmstate.

%package devel
Summary:        Development files for nmstate
Group:          Development/Libraries
Requires:       %{name}-libs%{?_isa} = %{version}-%{release}
License:        Apache-2.0

%description devel
Development files of nmstate C binding.

%package static
Summary:        Static development files for nmstate
Group:          Development/Libraries
License:        Apache-2.0
Requires:       %{name}-devel%{?_isa} = %{version}-%{release}

%description static
Static C library bindings for nmstate.

%package -n python3-%{libname}
Summary:        nmstate Python 3 API library
# Use Recommends for NetworkManager because only access to NM DBus is required,
# but NM could be running on a different host
Recommends:     NetworkManager
Recommends:     (NetworkManager-ovs if openvswitch)
Provides:       nmstate-plugin-ovsdb = %{version}-%{release}
Requires:       %{name}-libs%{?_isa} = %{version}-%{release}
Obsoletes:      nmstate-plugin-ovsdb < 2.0-1
License:        Apache-2.0

%description -n python3-%{libname}
This package contains the Python 3 library for Nmstate.

%if ! 0%{?rhel} && ! %{is_snapshot}
%package -n rust-%{name}-devel
Summary:        Rust crate of nmstate
BuildArch:      noarch
License:        Apache-2.0

%description -n rust-%{name}-devel
This package contains library source intended for building other packages
which use "%{name}" crate.

%package -n rust-%{name}+default-devel
Summary:        Rust crate of nmstate with default feature
BuildArch:      noarch
License:        Apache-2.0

%description -n rust-%{name}+default-devel
This package contains library source intended for building other packages
which use "%{name}" crate with default feature.

%package -n rust-%{name}+gen_conf-devel
Summary:        Rust crate of nmstate with default feature
BuildArch:      noarch
License:        Apache-2.0

%description -n rust-%{name}+gen_conf-devel
This package contains library source intended for building other packages
which use "%{name}" crate with gen_conf feature.

%package -n rust-%{name}+query_apply-devel
Summary:        Rust crate of nmstate with default feature
BuildArch:      noarch
License:        Apache-2.0
# https://bugzilla.redhat.com/show_bug.cgi?id=2161128
Requires:  (crate(nispor/default) >= 1.2.12 with crate(nispor/default) < 2.0)
Requires:  (crate(nix/default) >= 0.26 with crate(nix/default) < 0.27)
Requires:  (crate(zbus/default) >= 5.1 with crate(zbus/default) < 6.0)

%description -n rust-%{name}+query_apply-devel
This package contains library source intended for building other packages
which use "%{name}" crate with query_apply feature.
%endif

%prep
%autosetup -p1
%if ! %{is_snapshot}
gpg2 --import --import-options import-export,import-minimal \
    %{SOURCE2} > ./gpgkey-mantainers.gpg
gpgv2 --keyring ./gpgkey-mantainers.gpg %{SOURCE1} %{SOURCE0}
%endif


pushd rust

%if 0%{?rhel}
# Source3 is vendored dependencies
%cargo_prep -V 3
%elif %{?is_snapshot}
tar xf %{SOURCE3}
# Source3 is vendored dependencies
%cargo_prep -v vendor
%else
%cargo_prep
%endif

popd

%build
pushd rust
%if 0%{?rhel} == 9
# It is safe to ignore minimum rust version. The main blocker on MSRV is
# toml which just increase their MSRV by a robot for no hard reason.
%cargo_build --ignore-rust-version
%else
%cargo_build
%endif
popd

pushd rust/src/python
%if %{use_pyproject}
%pyproject_wheel
%else
%py3_build
%endif
popd

%install
env SKIP_PYTHON_INSTALL=1 \
    PREFIX=%{_prefix} \
    LIBDIR=%{_libdir} \
    SYSCONFDIR=%{_sysconfdir} \
    %make_install

pushd rust/src/python
%if %{use_pyproject}
%pyproject_install
%else
%py3_install
%endif
popd

%if ! 0%{?rhel} && ! %{is_snapshot}
pushd rust/src/lib
# Fedora cargo2rpm has problem when working with worksace dependency
#   https://pagure.io/fedora-rust/cargo2rpm/issue/13
# we use `cargo package` to generate the expanded Cargo.toml which
# is also the one used in crates.io
cargo package --frozen --no-verify --target-dir %{_tmppath}
tar xf %{_tmppath}/package/nmstate-%{version}.crate \
  nmstate-%{version}/Cargo.toml
mv nmstate-%{version}/Cargo.toml ./Cargo.toml
# Remove worksapce Cargo.toml
rm ../../Cargo.toml
%cargo_install
popd
%endif

%files
%doc README.md
%doc examples/
%{_mandir}/man8/nmstatectl.8*
%{_mandir}/man8/nmstate-autoconf.8*
%{_mandir}/man8/nmstate.service.8*
%{_bindir}/nmstatectl
%{_bindir}/nmstate-autoconf
%{_unitdir}/nmstate.service
%dir %{_sysconfdir}/%{name}
%{_sysconfdir}/%{name}/README

%files libs
%{_libdir}/libnmstate.so.*

%files devel
%{_libdir}/libnmstate.so
%{_includedir}/nmstate.h
%{_libdir}/pkgconfig/nmstate.pc

%files -n python3-%{libname}
%license LICENSE
%{python3_sitelib}/%{libname}
%if %{use_pyproject}
%{python3_sitelib}/%{srcname}-*.dist-info/
%else
%{python3_sitelib}/%{srcname}-*.egg-info/
%endif

%files static
%{_libdir}/libnmstate.a

%if ! 0%{?rhel} && ! %{is_snapshot}
%files -n rust-%{name}-devel
%license LICENSE
%{cargo_registry}/%{name}-%{version}/

%files -n rust-%{name}+default-devel
%ghost %{cargo_registry}/%{name}-%{version}/Cargo.toml

%files -n rust-%{name}+gen_conf-devel
%ghost %{cargo_registry}/%{name}-%{version}/Cargo.toml

%files -n rust-%{name}+query_apply-devel
%ghost %{cargo_registry}/%{name}-%{version}/Cargo.toml
%endif

%changelog
%if 0%{?rhel}
* Tue Sep 16 2025 N. N. - 2.2.52-0.20250916.2649gitd4274a62
-- snapshot build
%else
%autochangelog
%endif
