/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _PS3_INNER_DATA_H_
#define _PS3_INNER_DATA_H_

#ifndef _WINDOWS
#include <linux/types.h>
#include <linux/workqueue.h>
#include <linux/irq_poll.h>
#include <linux/atomic.h>
#include <linux/completion.h>
#include <linux/mutex.h>
#else
#include "ps3_worker.h"
#endif

#include "ps3_htp_event.h"
#include "ps3_htp_dev.h"
#include "ps3_htp_pci.h"
#include "hwapi/include_v200/s1861_regs/s1861_global_baseaddr.h"
#include "hwapi/include_v200/s1861_regs/s1861_hil_reg0_ps3_request_queue_reg.h"
#include "hwapi/include_v200/s1861_regs/s1861_hil_reg0_ps3_register_f_reg.h"
#include "hwapi/include_v200/s1861_regs/s1861_hil_reg0_ps3_register_s_reg.h"

#include "ps3_device_manager.h"
#include "ps3_htp_register_fifo.h"
#include "ps3_err_def.h"
#include "ps3_kernel_version.h"
#define PS3_DEFAULT_PAGE_SIZE_SHIFT (12)
#define PS3_CMD_SGE_FRAME_BUFFER_SIZE (4096)
#define PS3_DUMP_DMA_BUF_SIZE (0x100000)
#define PS3_DEFAULT_TASK_MGR_TIMEOUT (50)
#define PS3_DEFAULT_MGR_CMD_TIMEOUT (180)
#define PS3_CANCEL_MGR_CMD_TIMEOUT (30)
#define PS3_UNLOAD_MGR_CMD_TIMEOUT (60)
#define PS3_RAID_UNLOAD_MGR_CMD_TIMEOUT (360)
#define PS3_SOFT_RESET_WAIT_TIMEOUT (30)
#define PS3_SLEEP_TOLERATE_TIMEOUT (10)
#define PS3_RESET_WAIT_IO_REPLY_MAX_TIME (5)
#define PS3_REGISTER_SET_SIZE (147456)
#define PS3_MAX_DEBUG_REG_CNT (8)

#define PS3_HARD_RESET_MAX_RETRY (2)

#define PS3_MAX_REPLY_QUE_COUNT (128)
#define PS3_RAIDHBA_NUM_ADJUST_VALUE (1)

#define PS3_DEVICE_IO_BUSY_THRESHOLD (8)

#if defined(PS3_MAP_QUEUES)
#define MAP_QUEUES_RET_TYPE void
#define MAP_QUEUES_RET_VAL(x)
#else
#define MAP_QUEUES_RET_TYPE int
#define MAP_QUEUES_RET_VAL(x) (x)
#endif

#define PS3_BLOCK_NUM_OF_32K (1 << 6)
#define PS3_VD_IO_16_OUTSTANDING (16)
#define PS3_VD_IO_1_OUTSTANDING (1)
enum {
	PS3_SCSI_CMD_TIMEOUT_MIN = 10,
	PS3_SCSI_CMD_TIMEOUT_DEFAULT = 90,
	PS3_SCSI_CMD_TIMEOUT_MAX = 255,
};

enum {
	PS3_DEVICE_QDEPTH_DEFAULT_VALUE = 16,
};


enum PS3FuncID {
	PS3_FUNC_ID_0 = 0,
	PS3_FUNC_ID_1 = 1,
	PS3_FUNC_UNLIMITED = 2,
};

enum {
	PS3_SHIFT_BYTE = 8,
	PS3_SHIFT_WORD = 16,
	PS3_SHIFT_3BYTE = 24,
	PS3_SHIFT_DWORD = 32,
};

enum {
	PS3_SGL_MODE_SGE_COUNT_NO_DATA = 0,
	PS3_SGL_MODE_SGE_COUNT_DIRECT = 1,
};

struct ps3_event_delay_work {
#ifdef _WINDOWS
	struct ps3_worker event_work;
#else
	struct delayed_work event_work;
#endif
	struct ps3_cmd *cmd;
	unsigned int event_delay;
};

struct ps3_event_context {
	struct PS3EventInfo *event_info;
	struct ps3_cmd *event_cmd;
	struct ps3_cmd *event_abort_cmd;
	atomic_t abort_eventcmd;
#ifdef _WINDOWS
	struct ps3_event_delay_work delay_work;
#else
	struct ps3_event_delay_work *delay_work;
	struct ps3_event_delay_work *delay_work_pool;
#endif
	unsigned long long event_phy_addr;
	atomic_t subwork;
	unsigned char flag;
};

struct ps3_webSubscribe_context {
	struct ps3_cmd *webSubscribe_cmd;
	struct ps3_cmd *web_abort_cmd;
	atomic_t is_subscribe;
	atomic_t is_abort;
	atomic_t subscribe_count;
	atomic_t abort_webcmd;
};

#ifndef _WINDOWS
struct ps3_refire_delay_work {
	struct delayed_work refire_cmd_work;
	struct ps3_cmd *refire_cmd;
};
#endif

struct ps3_cmd_attr_context {
	int throttle_que_depth;
	int cur_can_que;
	unsigned int vd_io_threshold;
	unsigned int nvme_page_size;
	unsigned char is_support_direct_cmd;
	unsigned char reserved[7];
};

enum {
	PS3_REG_OFFSET_REQUEST_QUE =
		(HIL_REG0_PS3_REQUEST_QUEUE_PS3_REQUEST_QUEUE_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DOORBELL = (HIL_REG0_PS3_REGISTER_F_PS3_DOORBELL_ADDR -
				   HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DOORBELL_IRQ_CLEAR =
		(HIL_REG0_PS3_REGISTER_F_PS3_DOORBELL_IRQ_CLEAR_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DOORBELL_IRQ_MASK =
		(HIL_REG0_PS3_REGISTER_F_PS3_DOORBELL_IRQ_MASK_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_IRQ_CONTROL =
		(HIL_REG0_PS3_REGISTER_F_PS3_IRQ_CONTROL_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_SOFTRESET_KEY =
		(HIL_REG0_PS3_REGISTER_F_PS3_SOFTRESET_KEY_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_SOFTRESET_STATE =
		(HIL_REG0_PS3_REGISTER_F_PS3_SOFTRESET_STATE_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_SOFTRESET = (HIL_REG0_PS3_REGISTER_F_PS3_SOFTRESET_ADDR -
				    HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_SOFTRESET_IRQ_CLEAR =
		(HIL_REG0_PS3_REGISTER_F_PS3_SOFTRESET_IRQ_CLEAR_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_SOFTRESET_IRQ_MASK =
		(HIL_REG0_PS3_REGISTER_F_PS3_SOFTRESET_IRQ_MASK_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_SOFTRESET_KEY_SHIFT_REG_LOW =
		(HIL_REG0_PS3_REGISTER_F_PS3_SOFTRESET_KEY_SHIFT_REG_LOW_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_SOFTRESET_KEY_SHIFT_REG_HIGH =
		(HIL_REG0_PS3_REGISTER_F_PS3_SOFTRESET_KEY_SHIFT_REG_HIGH_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_SOFTRESET_TIME_CNT =
		(HIL_REG0_PS3_REGISTER_F_PS3_SOFTRESET_TIME_CNT_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_SOFTRESET_TIME_OUT_CNT =
		(HIL_REG0_PS3_REGISTER_F_PS3_SOFTRESET_TIME_OUT_EN_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_HARDRESET_KEY =
		(HIL_REG0_PS3_REGISTER_F_PS3_HARDRESET_KEY_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_HARDRESET_STATE =
		(HIL_REG0_PS3_REGISTER_F_PS3_HARDRESET_STATE_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_HARDRESET = (HIL_REG0_PS3_REGISTER_F_PS3_HARDRESET_ADDR -
				    HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_HARDRESET_KEY_SHIFT_REG_LOW =
		(HIL_REG0_PS3_REGISTER_F_PS3_HARDRESET_KEY_SHIFT_REG_LOW_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_HARDRESET_KEY_SHIFT_REG_HIGH =
		(HIL_REG0_PS3_REGISTER_F_PS3_HARDRESET_KEY_SHIFT_REG_HIGH_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_HARDRESET_TIME_CNT =
		(HIL_REG0_PS3_REGISTER_F_PS3_HARDRESET_TIME_CNT_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_HARDRESET_TIME_OUT_CNT =
		(HIL_REG0_PS3_REGISTER_F_PS3_HARDRESET_TIME_OUT_EN_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_KEY_GAP_CFG =
		(HIL_REG0_PS3_REGISTER_F_PS3_KEY_GAP_CFG_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_HARDRESET_IRQ_CLEAR =
		(HIL_REG0_PS3_REGISTER_F_PS3_HARDRESET_IRQ_CLEAR_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_HARDRESET_IRQ_MASK =
		(HIL_REG0_PS3_REGISTER_F_PS3_HARDRESET_IRQ_MASK_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_SOC_FW_STATE =
		(HIL_REG0_PS3_REGISTER_F_PS3_SOC_FW_STATE_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_MAX_FW_CMD =
		(HIL_REG0_PS3_REGISTER_F_PS3_MAX_FW_CMD_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_MAX_CHAIN_SIZE =
		(HIL_REG0_PS3_REGISTER_F_PS3_MAX_CHAIN_SIZE_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_MAX_VD_INFO_SIZE =
		(HIL_REG0_PS3_REGISTER_F_PS3_MAX_VD_INFO_SIZE_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_MAX_NVME_PAGE_SIZE =
		(HIL_REG0_PS3_REGISTER_F_PS3_MAX_NVME_PAGE_SIZE_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_FEATURE_SUPPORT =
		(HIL_REG0_PS3_REGISTER_F_PS3_FEATURE_SUPPORT_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_FIRMWARE_VERSION =
		(HIL_REG0_PS3_REGISTER_F_PS3_FIRMWARE_VERSION_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_REPLY_QUE =
		(HIL_REG0_PS3_REGISTER_F_PS3_MAX_REPLYQUE_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_HARDWARE_VERSION =
		(HIL_REG0_PS3_REGISTER_F_PS3_HARDWARE_VERSION_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_MGR_QUEUE_DEPTH =
		(HIL_REG0_PS3_REGISTER_F_PS3_MGR_QUEUE_DEPTH_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_CMD_QUEUE_DEPTH =
		(HIL_REG0_PS3_REGISTER_F_PS3_CMD_QUEUE_DEPTH_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_TFIFO_DEPTH =
		(HIL_REG0_PS3_REGISTER_F_PS3_TFIFO_DEPTH_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_MAX_SEC_R1X_CMDS =
		(HIL_REG0_PS3_REGISTER_F_PS3_MAX_SEC_R1X_CMDS_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_HIL_ADVICE2DIRECT_CNT0 =
		(HIL_REG0_PS3_REGISTER_F_PS3_HIL_ADVICE2DIRECT_CNT0_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_HIL_ADVICE2DIRECT_CNT1 =
		(HIL_REG0_PS3_REGISTER_F_PS3_HIL_ADVICE2DIRECT_CNT1_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_HIL_ADVICE2DIRECT_CNT2 =
		(HIL_REG0_PS3_REGISTER_F_PS3_HIL_ADVICE2DIRECT_CNT2_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_HIL_ADVICE2DIRECT_CNT3 =
		(HIL_REG0_PS3_REGISTER_F_PS3_HIL_ADVICE2DIRECT_CNT3_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_HIL_ADVICE2DIRECT_CNT_ALL =
		(HIL_REG0_PS3_REGISTER_F_PS3_HIL_ADVICE2DIRECT_CNT_ALL_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_IRQ_STATUS_RPT =
		(HIL_REG0_PS3_REGISTER_F_PS3_IRQ_STATUS_RPT_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DUMP_CTRL = (HIL_REG0_PS3_REGISTER_F_PS3_DUMP_CTRL_ADDR -
				    HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DUMP_CTRl_IRQ_CLEAR =
		(HIL_REG0_PS3_REGISTER_F_PS3_DUMP_CTRL_IRQ_CLEAR_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DUMP_CTRl_IRQ_MASK =
		(HIL_REG0_PS3_REGISTER_F_PS3_DUMP_CTRL_IRQ_MASK_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DUMP_STATUS =
		(HIL_REG0_PS3_REGISTER_F_PS3_DUMP_STATUS_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DUMP_DATA_SIZE =
		(HIL_REG0_PS3_REGISTER_F_PS3_DUMP_DATA_SIZE_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_CMD_TRIGGER =
		(HIL_REG0_PS3_REGISTER_F_PS3_CMD_TRIGGER_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_CMD_TRIGGER_IRQ_CLEAR =
		(HIL_REG0_PS3_REGISTER_F_PS3_CMD_TRIGGER_IRQ_CLEAR_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_CMD_TRIGGER_IRQ_MASK =
		(HIL_REG0_PS3_REGISTER_F_PS3_CMD_TRIGGER_IRQ_MASK_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_REG_CMD_STATE =
		(HIL_REG0_PS3_REGISTER_F_PS3_REG_CMD_STATE_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_SOFTRESET_COUNTER =
		(HIL_REG0_PS3_REGISTER_F_PS3_SOFTRESET_COUNTER_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG0 = (HIL_REG0_PS3_REGISTER_F_PS3_DEBUG0_ADDR -
				 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG0_IRQ_CLEAR =
		(HIL_REG0_PS3_REGISTER_F_PS3_DEBUG0_IRQ_CLEAR_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG0_IRQ_MASK =
		(HIL_REG0_PS3_REGISTER_F_PS3_DEBUG0_IRQ_MASK_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG1 = (HIL_REG0_PS3_REGISTER_F_PS3_DEBUG1_ADDR -
				 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG1_IRQ_CLEAR =
		(HIL_REG0_PS3_REGISTER_F_PS3_DEBUG1_IRQ_CLEAR_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG1_IRQ_MASK =
		(HIL_REG0_PS3_REGISTER_F_PS3_DEBUG1_IRQ_MASK_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG2 = (HIL_REG0_PS3_REGISTER_F_PS3_DEBUG2_ADDR -
				 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG2_IRQ_CLEAR =
		(HIL_REG0_PS3_REGISTER_F_PS3_DEBUG2_IRQ_CLEAR_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG2_IRQ_MASK =
		(HIL_REG0_PS3_REGISTER_F_PS3_DEBUG2_IRQ_MASK_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG3 = (HIL_REG0_PS3_REGISTER_F_PS3_DEBUG3_ADDR -
				 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG3_IRQ_CLEAR =
		(HIL_REG0_PS3_REGISTER_F_PS3_DEBUG3_IRQ_CLEAR_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG3_IRQ_MASK =
		(HIL_REG0_PS3_REGISTER_F_PS3_DEBUG3_IRQ_MASK_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG4 = (HIL_REG0_PS3_REGISTER_F_PS3_DEBUG4_ADDR -
				 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG4_IRQ_CLEAR =
		(HIL_REG0_PS3_REGISTER_F_PS3_DEBUG4_IRQ_CLEAR_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG4_IRQ_MASK =
		(HIL_REG0_PS3_REGISTER_F_PS3_DEBUG4_IRQ_MASK_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG5 = (HIL_REG0_PS3_REGISTER_F_PS3_DEBUG5_ADDR -
				 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG6 = (HIL_REG0_PS3_REGISTER_F_PS3_DEBUG6_ADDR -
				 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG7 = (HIL_REG0_PS3_REGISTER_F_PS3_DEBUG7_ADDR -
				 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG8 = (HIL_REG0_PS3_REGISTER_F_PS3_DEBUG8_ADDR -
				 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG9 = (HIL_REG0_PS3_REGISTER_F_PS3_DEBUG9_ADDR -
				 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG10 = (HIL_REG0_PS3_REGISTER_F_PS3_DEBUG10_ADDR -
				  HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG11 = (HIL_REG0_PS3_REGISTER_F_PS3_DEBUG11_ADDR -
				  HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_OFFSET_DEBUG12 = (HIL_REG0_PS3_REGISTER_F_PS3_DEBUG12_ADDR -
				  HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_SESSION_ADDR =
		(HIL_REG0_PS3_REGISTER_F_PS3_SESSIONCMD_ADDR_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_SESSION_ADDR_IRQ_CLEAR =
		(HIL_REG0_PS3_REGISTER_F_PS3_SESSIONCMD_ADDR_IRQ_CLEAR_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
	PS3_REG_SESSION_ADDR_IRQ_MASK =
		(HIL_REG0_PS3_REGISTER_F_PS3_SESSIONCMD_ADDR_IRQ_MASK_ADDR -
		 HIL_REG0_PS3_REGISTER_F_BASEADDR),
};
#endif
