/* SPDX-License-Identifier: GPL-2.0 */
#ifndef __PS3_HTP_MGR_EVT_RAIDHBA_H__
#define __PS3_HTP_MGR_EVT_RAIDHBA_H__
#include "ps3_mgr_evt_common.h"

enum MgrEvtType {
	PS3_EVT_ILLEGAL_TYPE = 0,
	PS3_EVT_SAS_INFO = 0x1,
	PS3_EVT_PD_COUNT = 0x2,
	PS3_EVT_VD_COUNT = 0x4,
	PS3_EVT_CTRL_INFO = 0x8,
	PS3_EVT_PD_ATTR = 0x10,
	PS3_EVT_VD_ATTR = 0x20,
	PS3_EVT_DG_INFO = 0x40,
	PS3_EVT_BBU_INFO = 0x80,
	PS3_EVT_CONFIG = 0x100,
	PS3_EVT_IO_INFO = 0x200,
	PS3_EVT_UKEY_INFO = 0x400,
	PS3_EVT_HWR_INFO = 0x800,
	PS3_EVT_ALARM_INFO = 0x1000,
	PS3_EVT_ECC_INFO = 0x2000,
	PS3_EVT_UPGRADE_INFO = 0x4000,
	PS3_EVT_TEMP_INFO = 0x8000,
	PS3_EVT_PD_ATTR_EXTEND = 0x10000,
};

static inline const char *nameMgrEvtType(unsigned int e)
{
	switch (e) {
	case PS3_EVT_SAS_INFO:
		return "PS3_EVT_SAS_INFO";
	case PS3_EVT_PD_COUNT:
		return "PS3_EVT_PD_COUNT";
	case PS3_EVT_VD_COUNT:
		return "PS3_EVT_VD_COUNT";
	case PS3_EVT_CTRL_INFO:
		return "PS3_EVT_CTRL_INFO";
	case PS3_EVT_PD_ATTR:
		return "PS3_EVT_PD_ATTR";
	case PS3_EVT_VD_ATTR:
		return "PS3_EVT_VD_ATTR";
	case PS3_EVT_DG_INFO:
		return "PS3_EVT_DG_INFO";
	case PS3_EVT_BBU_INFO:
		return "PS3_EVT_BBU_INFO";
	case PS3_EVT_CONFIG:
		return "PS3_EVT_CONFIG";
	case PS3_EVT_IO_INFO:
		return "PS3_EVT_IO_INFO";
	case PS3_EVT_UKEY_INFO:
		return "PS3_EVT_UKEY_INFO";
	case PS3_EVT_HWR_INFO:
		return "PS3_EVT_HWR_INFO";
	case PS3_EVT_ALARM_INFO:
		return "PS3_EVT_ALARM_INFO";
	case PS3_EVT_ECC_INFO:
		return "PS3_EVT_ECC_INFO";
	case PS3_EVT_UPGRADE_INFO:
		return "PS3_EVT_UPGRADE_INFO";
	case PS3_EVT_TEMP_INFO:
		return "PS3_EVT_TEMP_INFO";
	case PS3_EVT_PD_ATTR_EXTEND:
		return "PS3_EVT_PD_ATTR_EXTEND";
	default:
		return "PS3_EVT_ILLEGAL_TYPE";
	}
}

enum {
	PS3_EVT_SAS_INFO_LOCAL = 1,
	PS3_EVT_PD_COUNT_LOCAL = 2,
	PS3_EVT_VD_COUNT_LOCAL = 3,
	PS3_EVT_CTRL_INFO_LOCAL = 4,
	PS3_EVT_PD_ATTR_LOCAL = 5,
	PS3_EVT_VD_ATTR_LOCAL = 6,
	PS3_EVT_DG_INFO_LOCAL = 7,
	PS3_EVT_BBU_INFO_LOCAL = 8,
	PS3_EVT_CONFIG_LOCAL = 9,
	PS3_EVT_IO_INFO_LOCAL = 10,
	PS3_EVT_UKEY_INFO_LOCAL = 11,
	PS3_EVT_HWR_INFO_LOCAL = 12,
	PS3_EVT_ALARM_INFO_LOCAL = 13,
	PS3_EVT_ECC_INFO_LOCAL = 14,
	PS3_EVT_UPGRADE_INFO_LOCAL = 15,
	PS3_EVT_TEMP_INFO_LOCAL = 16,
	PS3_EVT_PD_ATTR_EXTEND_LOCAL = 17,
	PS3_EVT_DEFAULT_UNUSED_LOCAL,
	PS3_EVT_MAX_TYPE_LOCAL,
};

static inline const char *nameMgrEvtLocalType(unsigned int e)
{
	switch (e) {
	case PS3_EVT_SAS_INFO_LOCAL:
		return "PS3_EVT_SAS_INFO_LOCAL";
	case PS3_EVT_PD_COUNT_LOCAL:
		return "PS3_EVT_PD_COUNT_LOCAL";
	case PS3_EVT_VD_COUNT_LOCAL:
		return "PS3_EVT_VD_COUNT_LOCAL";
	case PS3_EVT_CTRL_INFO_LOCAL:
		return "PS3_EVT_CTRL_INFO_LOCAL";
	case PS3_EVT_PD_ATTR_LOCAL:
		return "PS3_EVT_PD_ATTR_LOCAL";
	case PS3_EVT_VD_ATTR_LOCAL:
		return "PS3_EVT_VD_ATTR_LOCAL";
	case PS3_EVT_DG_INFO_LOCAL:
		return "PS3_EVT_DG_INFO_LOCAL";
	case PS3_EVT_BBU_INFO_LOCAL:
		return "PS3_EVT_BBU_INFO_LOCAL";
	case PS3_EVT_CONFIG_LOCAL:
		return "PS3_EVT_CONFIG_LOCAL";
	case PS3_EVT_IO_INFO_LOCAL:
		return "PS3_EVT_IO_INFO_LOCAL";
	case PS3_EVT_UKEY_INFO_LOCAL:
		return "PS3_EVT_UKEY_INFO_LOCAL";
	case PS3_EVT_HWR_INFO_LOCAL:
		return "PS3_EVT_HWR_INFO_LOCAL";
	case PS3_EVT_ALARM_INFO_LOCAL:
		return "PS3_EVT_ALARM_INFO_LOCAL";
	case PS3_EVT_ECC_INFO_LOCAL:
		return "PS3_EVT_ECC_INFO_LOCAL";
	case PS3_EVT_UPGRADE_INFO_LOCAL:
		return "PS3_EVT_UPGRADE_INFO_LOCAL";
	case PS3_EVT_TEMP_INFO_LOCAL:
		return "PS3_EVT_TEMP_INFO_LOCAL";
	case PS3_EVT_PD_ATTR_EXTEND_LOCAL:
		return "PS3_EVT_PD_ATTR_EXTEND_LOCAL";
	default:
		return "PS3_EVT_ILLEGAL_TYPE";
	}
}

enum MgrEvtSASInfoCode {
	MGR_EVT_SAS_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_SAS_INFO_LOCAL),
	MGR_EVT_SAS_EXPANDER_IN = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_SAS_START + 0x1),
	MGR_EVT_SAS_EXPANDER_OUT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_SAS_START + 0x2),
	MGR_EVT_SAS_EXPANDER_UPDATE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_SAS_START + 0x3),
	MGR_EVT_SAS_EXPANDER_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_SAS_START + 0x4),
	MGR_EVT_ENCL_TEMP_NORMAL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_SAS_START + 0x5),
	MGR_EVT_ENCL_TEMP_WARNING = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_SAS_START + 0x6),
	MGR_EVT_ENCL_TEMP_CRITICAL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_SAS_START + 0x7),
	MGR_EVT_TOPO_LOOP = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_SAS_START + 0x8),
	MGR_EVT_LOOP_RESOLUTION = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_SAS_START + 0x9),
	MGR_EVT_CASCADED_SCAN_SMP_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_SAS_START + 0xa),
	MGR_EVT_ENCL_EXCEED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_SAS_START + 0xb),
	MGR_EVT_TRI_MODE_SWITCH = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_SAS_START + 0xc),
	MGR_EVT_CHANGE_PHY_BY_USER = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_SAS_START + 0xd),
	MGR_EVT_REV_HIBERNATE_CMD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_SAS_START + 0xe),
	MGR_EVT_PHY_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_SAS_START + 0xf),
	MGR_EVT_INQUIRY_INFO = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_SAS_START + 0x10),
	MGR_EVT_SAS_SATA_LINK_SPEED_NOMATCH = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_SAS_START + 0x11),
	MGR_EVT_SAS_SATA_LN_EXCEPTION = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_SAS_START + 0x12),
	MGR_EVT_SAS_SATA_DRIVER_INFO = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_SAS_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_SAS_START + 0x13),
	MGR_EVT_SAS_END = (MGR_EVT_SAS_START+0x14),
};

enum MgrEvtPdCountCode {
	MGR_EVT_PD_COUNT_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_PD_COUNT_LOCAL),
	MGR_EVT_DEVM_DISK_IN = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_COUNT_START + 0x1),
	MGR_EVT_DEVM_DISK_OUT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_COUNT_START + 0x2),
	MGR_EVT_MULITPILE_PD_IN = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_TRUE,
			PS3_EVT_PD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_COUNT_START + 0x3),
	MGR_EVT_MULITPILE_PD_OUT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_TRUE,
			PS3_EVT_PD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_COUNT_START + 0x4),
	MGR_EVT_DEVM_JBOD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_COUNT_START + 0x5),
	MGR_EVT_DEVM_READY = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_COUNT_START + 0x6),
	MGR_EVT_MULITPILE_JBOD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_TRUE,
			PS3_EVT_PD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_COUNT_START + 0x7),
	MGR_EVT_MULITPILE_READY = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_TRUE,
			PS3_EVT_PD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_COUNT_START + 0x8),
	MGR_EVT_BACKPLANE_ON = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_COUNT_START + 0x9),
	MGR_EVT_BACKPLANE_OFF = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_COUNT_START + 0xa),
	MGR_EVT_MULITPILE_PD_STATE_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_TRUE,
			PS3_EVT_PD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_COUNT_START + 0xb),
	MGR_EVT_DEVM_DISK_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_COUNT_START + 0xc),
	MGR_EVT_DEFAULT_UNUSED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_COUNT_START + 0xd),
	MGR_EVT_PD_PRE_READY = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_INTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_COUNT_START + 0xe),
	MGR_EVT_PD_COUNT_END = (MGR_EVT_PD_COUNT_START+0xf),
};

enum MgrEvtVdCountCode {
	MGR_EVT_VD_COUNT_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_VD_COUNT_LOCAL),
	MGR_EVT_VD_OPTIMAL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_COUNT_START + 0x1),
	MGR_EVT_VD_PARTIAL_DEGRADE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_COUNT_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_VD_COUNT_START + 0x2),
	MGR_EVT_VD_DEGRADE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_COUNT_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_VD_COUNT_START + 0x3),
	MGR_EVT_VD_CREATED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_COUNT_START + 0x4),
	MGR_EVT_VD_DELETED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_COUNT_START + 0x5),
	MGR_EVT_VD_HIDDEN_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_COUNT_START + 0x6),
	MGR_EVT_MULITPILE_VD_IN = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_TRUE,
			PS3_EVT_VD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_COUNT_START + 0x7),
	MGR_EVT_MULITPILE_VD_OUT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_TRUE,
			PS3_EVT_VD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_COUNT_START + 0x8),
	MGR_EVT_VD_UNLOCK = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_COUNT_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_COUNT_START + 0x9),
	MGR_EVT_VD_OFFLINE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_COUNT_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_VD_COUNT_START + 0xa),
	MGR_EVT_VD_COUNT_END = (MGR_EVT_VD_COUNT_START+0xb),
};

enum MgrEvtCtrlInfoCode {
	MGR_EVT_CTRL_INFO_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_CTRL_INFO_LOCAL),
	MGR_EVT_CTRL_REBOOT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x1),
	MGR_EVT_CTRL_SHUTDOWN = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x2),
	MGR_EVT_CTRL_TIME_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x3),
	MGR_EVT_CTRL_EVENT_LOG_CLEARED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x4),
	MGR_EVT_CTRL_RBLD_RATE_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x5),
	MGR_EVT_CTRL_ENABLEMOVEBACK_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x6),
	MGR_EVT_CTRL_ENABLENCQ_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x7),
	MGR_EVT_CTRL_AUTO_REBUILD_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x8),
	MGR_EVT_CTRL_EGHS_READY_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x9),
	MGR_EVT_CTRL_EGHS_SPARE_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0xa),
	MGR_EVT_CTRL_BGI_RATE_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0xb),
	MGR_EVT_CTRL_MIGRATE_RATE_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0xc),
	MGR_EVT_CTRL_CC_RATE_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0xd),
	MGR_EVT_CTRL_DIRECT_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0xe),
	MGR_EVT_CTRL_PR_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0xf),
	MGR_EVT_CTRL_PR_PAUSE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x10),
	MGR_EVT_CTRL_PR_REMINDER_PAUSE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x11),
	MGR_EVT_CTRL_PR_RESUME = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x12),
	MGR_EVT_CTRL_PR_DONE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x13),
	MGR_EVT_CTRL_PR_RATE_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x14),
	MGR_EVT_CTRL_PR_CANT_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x15),
	MGR_EVT_CTRL_PR_PROP_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x16),
	MGR_EVT_CTRL_PARAM_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x17),
	MGR_EVT_CTRL_AUTO_CC_PARAM_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x18),
	MGR_EVT_CTRL_RECOVERY_FACTORY = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x19),
	MGR_EVT_CTRL_PROFILEID_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x1a),
	MGR_EVT_CTRL_SANPSHOT_CREATE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x1b),
	MGR_EVT_CTRL_SANPSHOT_DELETE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x1c),
	MGR_EVT_CTRL_ENABLEPDM_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x1d),
	MGR_EVT_CTRL_PDMSUPPORTREADYPD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x1e),
	MGR_EVT_CTRL_PDMTIMERINTERVAL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x1f),
	MGR_EVT_CTRL_SECURITY_KEY_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x20),
	MGR_EVT_CTRL_SECURITY_KEY_CREATE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x21),
	MGR_EVT_CTRL_SECURITY_KEY_DESTROY = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x22),
	MGR_EVT_CTRL_SECURITY_KEY_ESCROW = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x23),
	MGR_EVT_CTRL_SECURITY_KEY_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x24),
	MGR_EVT_CTRL_SECURITY_KEY_INVALID = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x25),
	MGR_EVT_AUTOCONFIG = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x26),
	MGR_EVT_CTRL_FOREIGN_IMPORTED_ALL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x27),
	MGR_EVT_CTRL_FOREIGN_CLEAR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x28),
	MGR_EVT_CTRL_FOREIGN_IMPORT_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x29),
	MGR_EVT_CTRL_FOREIGN_IMPORT_PART_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x2a),
	MGR_EVT_CTRL_FOREIGN_IMPORT_FAIL_PDS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x2b),
	MGR_EVT_CTRL_FOREIGN_PD_DETECTED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x2c),
	MGR_EVT_PD_INSERT_TO_DG = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x2d),
	MGR_EVT_PD_IMPORT_TO_DG = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x2e),
	MGR_EVT_HARD_RESET = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x2f),
	MGR_EVT_DPF_CFG_MODIFY = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x30),
	MGR_EVT_SPOR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x31),
	MGR_EVT_ONF_ABNORMAL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_CTRL_INFO_START + 0x32),
	MGR_EVT_CTRL_LOADED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x33),
	MGR_EVT_CACHE_PROTECTION_CMPT_READY = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x34),
	MGR_EVT_CACHE_PROTECTION_CMPT_NOT_READY = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x35),
	MGR_EVT_CACHE_PROTECTION_CMPT_INSTABLE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_CTRL_INFO_START + 0x36),
	MGR_EVT_MAIN_MEDIUM_NOT_AVAILABLE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_CTRL_INFO_START + 0x37),
	MGR_EVT_BACKUP_MEDIUM_NOT_AVAILABLE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_CTRL_INFO_START + 0x38),
	MGR_EVT_MEDIUM_DATA_RECOVER = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x39),
	MGR_EVT_INIT_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x3a),
	MGR_EVT_CTRL_POWER_MODE_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CTRL_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CTRL_INFO_START + 0x3b),
	MGR_EVT_CTRL_INFO_END = (MGR_EVT_CTRL_INFO_START+0x3c),
};

enum MgrEvtPdAttrCode {
	MGR_EVT_PD_ATTR_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_PD_ATTR_LOCAL),
	MGR_EVT_PD_INFO_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x1),
	MGR_EVT_PD_STATE_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x2),
	MGR_EVT_PD_MARKED_JBOD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x3),
	MGR_EVT_PD_MARKED_READY = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x4),
	MGR_EVT_PD_MARKED_ONLINE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x5),
	MGR_EVT_PD_MARKED_OFFLINE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x6),
	MGR_EVT_PD_MARKED_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_START + 0x7),
	MGR_EVT_PD_MARKED_MISSING = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_START + 0x8),
	MGR_EVT_PD_MARKED_REBUILD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x9),
	MGR_EVT_PD_MARKED_REPLACE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0xa),
	MGR_EVT_PD_MARKED_UNCONFIGUREDBAD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0xb),
	MGR_EVT_PD_MARKED_FOREIGN = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0xc),
	MGR_EVT_PD_NR_GLOBAL_SPARE_ADDED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0xd),
	MGR_EVT_PD_NR_GLOBAL_SPARE_DELETED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0xe),
	MGR_EVT_PD_NR_DEDICATED_SPARE_ADDED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0xf),
	MGR_EVT_PD_NR_DEDICATED_SPARE_DELETED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x10),
	MGR_EVT_PD_R_GLOBAL_SPARE_ADDED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x11),
	MGR_EVT_PD_R_GLOBAL_SPARE_DELETED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x12),
	MGR_EVT_PD_R_DEDICATED_SPARE_ADDED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x13),
	MGR_EVT_PD_R_DEDICATED_SPARE_DELETED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x14),
	MGR_EVT_PD_RBLD_ABORT_BY_USER = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x15),
	MGR_EVT_PD_RBLD_DONE_PD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x16),
	MGR_EVT_PD_RBLD_FAILED_BAD_SOURCE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_START + 0x17),
	MGR_EVT_PD_RBLD_FAILED_BAD_TARGET = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_START + 0x18),
	MGR_EVT_PD_RBLD_PROGRESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_PROCESS,
			MGR_EVT_PD_ATTR_START + 0x19),
	MGR_EVT_PD_RBLD_SUSPENDED_REMINDER = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x1a),
	MGR_EVT_PD_RBLD_SUSPENDED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x1b),
	MGR_EVT_PD_RBLD_RESUME = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x1c),
	MGR_EVT_PD_RBLD_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x1d),
	MGR_EVT_PD_RBLD_START_AUTO = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x1e),
	MGR_EVT_PD_RBLD_MEDIUM_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_PD_ATTR_START + 0x1f),
	MGR_EVT_PD_EMERGENCY_SPARE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x20),
	MGR_EVT_PD_RECOVER_MEDIUM_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_PD_ATTR_START + 0x21),
	MGR_EVT_PD_MOVEBACK_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x22),
	MGR_EVT_PD_MOVEBACK_ABORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x23),
	MGR_EVT_PD_MOVEBACK_ABORT_FOR_REBUILD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_START + 0x24),
	MGR_EVT_PD_MOVEBACK_DONE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x25),
	MGR_EVT_PD_MOVEBACK_PROGRESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_PROCESS,
			MGR_EVT_PD_ATTR_START + 0x26),
	MGR_EVT_PD_MOVEBACK_SUSPENDED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x27),
	MGR_EVT_PD_MOVEBACK_SUSPENDED_REMINDER = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x28),
	MGR_EVT_PD_MOVEBACK_RESUME = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x29),
	MGR_EVT_PD_MOVEBACK_START_AUTO = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x2a),
	MGR_EVT_PD_MOVEBACK_FAILED_BAD_SOURCE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_START + 0x2b),
	MGR_EVT_PD_MOVEBACK_FAILED_BAD_TARGET = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x2c),
	MGR_EVT_PD_MOVEBACK_ABORT_BY_USER = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x2d),
	MGR_EVT_PD_MOVEBACK_MEDIUM_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_PD_ATTR_START + 0x2e),
	MGR_EVT_PD_FGI_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x2f),
	MGR_EVT_PD_FGI_COMPLETE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x30),
	MGR_EVT_PD_FGI_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_START + 0x31),
	MGR_EVT_PD_FGI_PROGRESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_PROCESS,
			MGR_EVT_PD_ATTR_START + 0x32),
	MGR_EVT_PD_FGI_ABORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x33),
	MGR_EVT_PD_PR_ABORTED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_PD_ATTR_START + 0x34),
	MGR_EVT_PD_PR_CORRECTED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x35),
	MGR_EVT_PD_PR_UNCORRECTABLE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_PD_ATTR_START + 0x36),
	MGR_EVT_PD_PR_FOUND_MEDIUM_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_PD_ATTR_START + 0x37),
	MGR_EVT_PD_PR_PROGRESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_PROCESS,
			MGR_EVT_PD_ATTR_START + 0x38),
	MGR_EVT_PD_SET_BOOT_DRIVE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x39),
	MGR_EVT_PD_RESET_BOOT_DRIVE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x3a),
	MGR_EVT_PD_RESET_BOOT_DRIVE_WITH_DISK_OUT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x3b),
	MGR_EVT_PD_SET_BOOT_DRIVE_WITH_DISK_IN = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x3c),
	MGR_EVT_PD_POWERSAVE_TO_ON = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x3d),
	MGR_EVT_PD_POWERSAVE_TO_TRANSITION = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x3e),
	MGR_EVT_PD_TRANSITION_TO_ON = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x3f),
	MGR_EVT_PD_TRANSITION_TO_POWERSAVE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x40),
	MGR_EVT_PD_ON_TO_POWERSAVE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x41),
	MGR_EVT_PD_START_LOCATE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x42),
	MGR_EVT_PD_STOP_LOCATE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x43),
	MGR_EVT_PD_PFA_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_PD_ATTR_START + 0x44),
	MGR_EVT_PD_NOT_PRESENT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_PD_ATTR_START + 0x45),
	MGR_EVT_DEVM_DISK_FAULT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_START + 0x46),
	MGR_EVT_PHY_FLASHOFFLINE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_PD_ATTR_START + 0x47),
	MGR_EVT_PHY_FLASHONLINE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x48),
	MGR_EVT_NFR_DONE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x49),
	MGR_EVT_NFR_REPAIRED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x4a),
	MGR_EVT_NFR_REPORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x4b),
	MGR_EVT_NFR_STOP = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x4c),
	MGR_EVT_PD_DOWNLOAD_DONE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x4d),
	MGR_EVT_PD_DOWNLOAD_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x4e),
	MGR_EVT_NVME_PHY_BAD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_START + 0x4f),
	MGR_EVT_PD_ATTR_END = (MGR_EVT_PD_ATTR_START+0x50),
};

enum MgrEvtVdAttrCode {
	MGR_EVT_VD_ATTR_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_VD_ATTR_LOCAL),
	MGR_EVT_MULITPILE_VD_STATE_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_TRUE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x1),
	MGR_EVT_VD_OFFLINE_OLD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_VD_ATTR_START + 0x2),
	MGR_EVT_VD_LOCK = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_VD_ATTR_START + 0x3),
	MGR_EVT_VD_PASSWD_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x4),
	MGR_EVT_VD_SETTINGS_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x5),
	MGR_EVT_VD_PD_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_INTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x6),
	MGR_EVT_VD_STATE_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x7),
	MGR_EVT_PD_RBLD_DONE_LD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x8),
	MGR_EVT_VD_FGI_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x9),
	MGR_EVT_VD_FGI_COMPLETE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0xa),
	MGR_EVT_VD_FGI_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_VD_ATTR_START + 0xb),
	MGR_EVT_VD_FGI_PROGRESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_PROCESS,
			MGR_EVT_VD_ATTR_START + 0xc),
	MGR_EVT_VD_FGI_ABORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0xd),
	MGR_EVT_VD_BGI_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0xe),
	MGR_EVT_VD_BGI_COMPLETE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0xf),
	MGR_EVT_VD_BGI_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_VD_ATTR_START + 0x10),
	MGR_EVT_VD_BGI_PROGRESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_PROCESS,
			MGR_EVT_VD_ATTR_START + 0x11),
	MGR_EVT_VD_BGI_ABORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_VD_ATTR_START + 0x12),
	MGR_EVT_VD_BGI_PAUSE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x13),
	MGR_EVT_VD_BGI_REMINDER_PAUSE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x14),
	MGR_EVT_VD_BGI_RESUME = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x15),
	MGR_EVT_VD_BGI_CORRECTABLE_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x16),
	MGR_EVT_VD_BGI_UNCORRECTABLE_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_VD_ATTR_START + 0x17),
	MGR_EVT_VD_ALTER_ATTR_BY_MIGRATION = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x18),
	MGR_EVT_VD_BBM_CLEARED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x19),
	MGR_EVT_VD_BBM_PERCENT_FULL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_VD_ATTR_START + 0x1a),
	MGR_EVT_VD_BBM_100_FULL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_VD_ATTR_START + 0x1b),
	MGR_EVT_VD_BBM_LOG_FULL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_VD_ATTR_START + 0x1c),
	MGR_EVT_VD_BBM_LOG_RCT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_VD_ATTR_START + 0x1d),
	MGR_EVT_VD_BBM_LOG_WCT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_VD_ATTR_START + 0x1e),
	MGR_EVT_VD_BBM_DEL_RCT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_TRUE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x1f),
	MGR_EVT_VD_CC_ABORTED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x20),
	MGR_EVT_VD_CC_CORRECTED_MEDIUM_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x21),
	MGR_EVT_VD_CC_DOUBLE_MEDIUM_ERRORS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_VD_ATTR_START + 0x22),
	MGR_EVT_VD_CC_DONE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x23),
	MGR_EVT_VD_CC_DONE_INCON = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x24),
	MGR_EVT_VD_CC_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_VD_ATTR_START + 0x25),
	MGR_EVT_VD_CC_FAILED_UNCOR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_VD_ATTR_START + 0x26),
	MGR_EVT_VD_CC_INCONSISTENT_PARITY = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_VD_ATTR_START + 0x27),
	MGR_EVT_VD_CC_INCONSISTENT_PARITY_LOGGING_DISABLED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_VD_ATTR_START + 0x28),
	MGR_EVT_VD_CC_PROGRESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_PROCESS,
			MGR_EVT_VD_ATTR_START + 0x29),
	MGR_EVT_VD_CC_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x2a),
	MGR_EVT_VD_CC_PAUSE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x2b),
	MGR_EVT_VD_CC_REMINDER_PAUSE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x2c),
	MGR_EVT_VD_CC_RESUME = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x2d),
	MGR_EVT_VD_RW_RAID1X_WRITE_CARDBUSY = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x2e),
	MGR_EVT_VD_SET_BOOT_DRIVE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x2f),
	MGR_EVT_VD_RESET_BOOT_DRIVE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x30),
	MGR_EVT_VD_RESET_BOOT_DRIVE_WITH_DISK_OUT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x31),
	MGR_EVT_VD_SET_BOOT_DRIVE_WITH_DISK_IN = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x32),
	MGR_EVT_ALL_CONFIGS_MISSING = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x33),
	MGR_EVT_PDS_MISSING = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x34),
	MGR_EVT_NVSRAM_RECOVER_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x35),
	MGR_EVT_NVSRAM_UPDATE_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x36),
	MGR_EVT_VD_ERASE_ABORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x37),
	MGR_EVT_VD_ERASE_COMPLETE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x38),
	MGR_EVT_VD_ERASE_DISK_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_VD_ATTR_START + 0x39),
	MGR_EVT_VD_ERASE_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_VD_ATTR_START + 0x3a),
	MGR_EVT_VD_ERASE_PROGRESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_PROCESS,
			MGR_EVT_VD_ATTR_START + 0x3b),
	MGR_EVT_VD_ERASE_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x3c),
	MGR_EVT_VD_EXPAND_FINISH = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x3d),
	MGR_EVT_VD_EXPAND_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x3e),
	MGR_EVT_VD_FLUSH_CLEAR_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x3f),
	MGR_EVT_VD_FLUSH_RECORD_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x40),
	MGR_EVT_VD_FLUSH_SET_INCONSIST = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x41),
	MGR_EVT_VDS_MISSING = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x42),
	MGR_EVT_VD_BBM_UNCORRECTABLE_LOGGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_VD_ATTR_START + 0x43),
	MGR_EVT_VD_FLUSH_CACHE_PINNED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_VD_ATTR_START + 0x44),
	MGR_EVT_VD_FLUSH_OCR_CACHE_PINNED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_VD_ATTR_START + 0x45),
	MGR_EVT_VD_FLUSH_CACHE_DISCARDED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x46),
	MGR_EVT_VD_FLUSH_CACHE_DISCARDED_DEL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x47),
	MGR_EVT_VD_FLUSH_CACHE_DESTAGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_VD_ATTR_START + 0x48),
	MGR_EVT_VD_CM_RECOVERY_CRC_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_VD_ATTR_START + 0x49),
	MGR_EVT_VD_BGI_COMPLETE_UNCOR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_VD_ATTR_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_VD_ATTR_START + 0x4a),
	MGR_EVT_VD_ATTR_END = (MGR_EVT_VD_ATTR_START+0x4b),
};

enum MgrEvtDgInfoCode {
	MGR_EVT_DG_INFO_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_DG_INFO_LOCAL),
	MGR_EVT_DG_CREATED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_DG_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_DG_INFO_START + 0x1),
	MGR_EVT_DG_DELETED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_DG_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_DG_INFO_START + 0x2),
	MGR_EVT_DG_SETTING_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_DG_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_DG_INFO_START + 0x3),
	MGR_EVT_DG_MIGRATION_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_DG_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_DG_INFO_START + 0x4),
	MGR_EVT_DG_MIGRATION_RECOVER = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_DG_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_DG_INFO_START + 0x5),
	MGR_EVT_DG_MIGRATION_SUCCESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_DG_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_DG_INFO_START + 0x6),
	MGR_EVT_DG_MIGRATION_ALLOC_RESOURCE_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_DG_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_DG_INFO_START + 0x7),
	MGR_EVT_DG_MIGRATION_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_DG_INFO_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_DG_INFO_START + 0x8),
	MGR_EVT_DG_MIGRATION_RECOVER_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_DG_INFO_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_DG_INFO_START + 0x9),
	MGR_EVT_DG_MIGRATION_PROGRESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_DG_INFO_LOCAL, PS3_EVT_CLASS_PROCESS,
			MGR_EVT_DG_INFO_START + 0xa),
	MGR_EVT_DG_MIGRATION_INTERNAL_WARNING = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_DG_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_DG_INFO_START + 0xb),
	MGR_EVT_DG_PRSWITCH_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_DG_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_DG_INFO_START + 0xc),
	MGR_EVT_DG_PR_ABORTED_WM_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_DG_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_DG_INFO_START + 0xd),
	MGR_EVT_DG_PR_ABORTED_SPINUP_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_DG_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_DG_INFO_START + 0xe),
	MGR_EVT_DG_INFO_END = (MGR_EVT_DG_INFO_START+0xf),
};

enum MgrEvtBbuInfoCode {
	MGR_EVT_BBU_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_BBU_INFO_LOCAL),
	MGR_EVT_BBU_PRESENT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0x1),
	MGR_EVT_BBU_NOT_PRESENT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0x2),
	MGR_EVT_BBU_GOOD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0x3),
	MGR_EVT_BBU_BAD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_BBU_START + 0x4),
	MGR_EVT_BBU_CAP_BELOW_THRESHOLD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0x5),
	MGR_EVT_BBU_CAP_ABOVE_THRESHOLD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0x6),
	MGR_EVT_BBU_CHARGE_STATUS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0x7),
	MGR_EVT_BBU_CHARGE_COMPLETE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0x8),
	MGR_EVT_BBU_INSERT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0x9),
	MGR_EVT_BBU_ABSENT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_BBU_START + 0xa),
	MGR_EVT_BBU_TEMPERATURE_NORMAL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0xb),
	MGR_EVT_BBU_TEMPERATURE_HIGH = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_BBU_START + 0xc),
	MGR_EVT_BBU_VOLTAGE_NORMAL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0xd),
	MGR_EVT_BBU_VOLTAGE_HIGH = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_BBU_START + 0xe),
	MGR_EVT_BBU_CURRENT_NORMAL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0xf),
	MGR_EVT_BBU_CURRENT_HIGH = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_BBU_START + 0x10),
	MGR_EVT_BBU_LOAD_NORMAL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0x11),
	MGR_EVT_BBU_VOLTAGE_LOW = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_BBU_START + 0x12),
	MGR_EVT_BBU_BATTERY_CAP_ABOVE_SOH_THRESHOLD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0x13),
	MGR_EVT_BBU_BATTERY_CAP_BELOW_SOH_THRESHOLD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_BBU_START + 0x14),
	MGR_EVT_BBU_LEARN_STAGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0x15),
	MGR_EVT_BBU_LEARN_REQUESTED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_BBU_START + 0x16),
	MGR_EVT_BBU_LEARN_POSTPONED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0x17),
	MGR_EVT_BBU_LEARN_TIMEOUT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_BBU_START + 0x18),
	MGR_EVT_BBU_LEARN_MANUAL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_BBU_START + 0x19),
	MGR_EVT_BBU_LEARN_RESCHEDULED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0x1a),
	MGR_EVT_BBU_PROPERTIES_CHANGED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_BBU_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_BBU_START + 0x1b),
	MGR_EVT_BBU_END = (MGR_EVT_BBU_START+0x1c),
};

enum MgrEvtConfigCode {
	MGR_EVT_CONFIG_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_CONFIG_LOCAL),
	MGR_EVT_CONFIG_INFO = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CONFIG_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CONFIG_START + 0x1),
	MGR_EVT_CONFIG_FLASH_READ_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CONFIG_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CONFIG_START + 0x2),
	MGR_EVT_CONFIG_FLASH_WRITE_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CONFIG_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CONFIG_START + 0x3),
	MGR_EVT_CONFIG_NVSRAM_READ_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CONFIG_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CONFIG_START + 0x4),
	MGR_EVT_CONFIG_NVSRAM_WRITE_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CONFIG_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CONFIG_START + 0x5),
	MGR_EVT_CONFIG_VERSION_MISMATCH = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CONFIG_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CONFIG_START + 0x6),
	MGR_EVT_CONFIG_MEDIA_VALUE_CHECK_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CONFIG_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CONFIG_START + 0x7),
	MGR_EVT_CONFIG_ERASE_NVSRAM = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CONFIG_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CONFIG_START + 0x8),
	MGR_EVT_PHY_LINKSPEED_CFG_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_CONFIG_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_CONFIG_START + 0x9),
	MGR_EVT_CONFIG_END = (MGR_EVT_CONFIG_START+0xa),
};

enum MgrEvtIoInfoCode {
	MGR_EVT_IO_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_IO_INFO_LOCAL),
	MGR_EVT_IO_TEST = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_IO_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_IO_START + 0x1),
	MGR_EVT_IO_SENSE_DATA = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_IO_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_IO_START + 0x2),
	MGR_EVT_DEVICE_RESET = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_IO_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_IO_START + 0x3),
	MGR_EVT_NVME_DEVICE_RESET = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_IO_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_IO_START + 0x4),
	MGR_EVT_DEVICE_ABNORMAL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_IO_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_IO_START + 0x5),
	MGR_EVT_IO_SENSE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_IO_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_IO_START + 0x6),
	MGR_EVT_IO_END = (MGR_EVT_IO_START+0x7),
};

enum MgrEvtUkeyInfoCode {
	MGR_EVT_UKEY_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_UKEY_INFO_LOCAL),
	MGR_EVT_UKEY_INSERT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UKEY_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_UKEY_START + 0x1),
	MGR_EVT_UKEY_DEGRADE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UKEY_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_UKEY_START + 0x2),
	MGR_EVT_RAID_KEY_OVERCURRENT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UKEY_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_UKEY_START + 0x3),
	MGR_EVT_RAID_KEY_OVERCURRENT_RECOVER = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UKEY_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_UKEY_START + 0x4),
	MGR_EVT_UKEY_END = (MGR_EVT_UKEY_START+0x5),
};

enum MgrEvtHwRInfoCode {
	MGR_EVT_HWR_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_HWR_INFO_LOCAL),
	MGR_EVT_HWR_HAC_RESET_BEGIN = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_HWR_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_HWR_START + 0x1),
	MGR_EVT_HWR_HAC_RESET_END = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_HWR_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_HWR_START + 0x2),
	MGR_EVT_REPORT_HAC_ECC = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_HWR_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_HWR_START + 0x3),
	MGR_EVT_HWR_END = (MGR_EVT_HWR_START+0x4),
};

enum MgrEvtAlarmInfoCode {
	MGR_EVT_ALARM_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_ALARM_INFO_LOCAL),
	MGR_EVT_ALARM_ENABLED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_ALARM_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_ALARM_START + 0x1),
	MGR_EVT_ALARM_DISABLED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_ALARM_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_ALARM_START + 0x2),
	MGR_EVT_ALARM_END = (MGR_EVT_ALARM_START+0x3),
};

enum MgrEvtEccInfoCode {
	MGR_EVT_ECC_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_ECC_INFO_LOCAL),
	MGR_EVT_ECC_CNT_EXCEED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_ECC_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_ECC_START + 0x1),
	MGR_EVT_ECC_ERR_INTR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_ECC_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_ECC_START + 0x2),
	MGR_EVT_ECC_CNT_CLEAR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_ECC_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_ECC_START + 0x3),
	MGR_EVT_ECC_CLI_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_ECC_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_ECC_START + 0x4),
	MGR_EVT_ECC_FACTORY_CHANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_INTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_ECC_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_ECC_START + 0x5),
	MGR_EVT_ECC_END = (MGR_EVT_ECC_START+0x6),
};

enum MgrEvtUpgradeInfoCode {
	MGR_EVT_UPGRADE_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_UPGRADE_INFO_LOCAL),
	MGR_EVT_IMAGE_DOWNLOAD_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UPGRADE_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_UPGRADE_START + 0x1),
	MGR_EVT_IMAGE_AUTHENTICATION_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UPGRADE_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_UPGRADE_START + 0x2),
	MGR_EVT_IMAGE_VERSION_CHECK_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UPGRADE_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_UPGRADE_START + 0x3),
	MGR_EVT_IMAGE_CHECKSUM_CHECK_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UPGRADE_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_UPGRADE_START + 0x4),
	MGR_EVT_IMAGE_FROM_BACKUP = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UPGRADE_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_UPGRADE_START + 0x5),
	MGR_EVT_DEV_OPEN_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UPGRADE_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_UPGRADE_START + 0x6),
	MGR_EVT_DEV_FLASH_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UPGRADE_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_UPGRADE_START + 0x7),
	MGR_EVT_DEV_ERASE_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UPGRADE_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_UPGRADE_START + 0x8),
	MGR_EVT_DEV_CLOSE_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UPGRADE_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_UPGRADE_START + 0x9),
	MGR_EVT_FLASH_GENERAL_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UPGRADE_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_UPGRADE_START + 0xa),
	MGR_EVT_FLASH_TIMEOUT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UPGRADE_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_UPGRADE_START + 0xb),
	MGR_EVT_UPGRADE_SUCCESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UPGRADE_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_UPGRADE_START + 0xc),
	MGR_EVT_UPGRADE_SYNC_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UPGRADE_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_UPGRADE_START + 0xd),
	MGR_EVT_UPGRADE_SYNC_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UPGRADE_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_UPGRADE_START + 0xe),
	MGR_EVT_UPGRADE_SYNC_SUCCESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_UPGRADE_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_UPGRADE_START + 0xf),
	MGR_EVT_UPGRADE_END = (MGR_EVT_UPGRADE_START+0x10),
};

enum MgrEvtTempInfoCode {
	MGR_EVT_TEMP_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_TEMP_INFO_LOCAL),
	MGR_EVT_TEMP_WITHIN_OPTIMAL_RANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_TEMP_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_TEMP_START + 0x1),
	MGR_EVT_TEMP_ABOVE_OPTIMAL_RANGE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_TEMP_INFO_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_TEMP_START + 0x2),
	MGR_EVT_TEMP_WARNING = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_TEMP_INFO_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_TEMP_START + 0x3),
	MGR_EVT_TEMP_CRITICAL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_TEMP_INFO_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_TEMP_START + 0x4),
	MGR_EVT_TEMP_END = (MGR_EVT_TEMP_START+0x5),
};

enum MgrEvtPdAttrExtendCode {
	MGR_EVT_PD_ATTR_EXTEND_START = MGR_EVT_TYPE_BASE_LOCAL(PS3_EVT_PD_ATTR_EXTEND_LOCAL),
	MGR_EVT_PD_ERASE_ABORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x1),
	MGR_EVT_PD_ERASE_COMPLETE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x2),
	MGR_EVT_PD_ERASE_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x3),
	MGR_EVT_PD_ERASE_PROGRESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_PROCESS,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x4),
	MGR_EVT_PD_ERASE_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x5),
	MGR_EVT_PD_PDM_ABORT_BY_USER = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x6),
	MGR_EVT_PD_PDM_ABORT_FOR_REBUILD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x7),
	MGR_EVT_PD_PDM_ABORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x8),
	MGR_EVT_PD_PDM_DONE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x9),
	MGR_EVT_PD_PDM_FAILED_BAD_SOURCE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_EXTEND_START + 0xa),
	MGR_EVT_PD_PDM_FAILED_BAD_TARGET = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0xb),
	MGR_EVT_PD_PDM_MEDIUM_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_PD_ATTR_EXTEND_START + 0xc),
	MGR_EVT_PD_PDM_PROGRESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_PROCESS,
			MGR_EVT_PD_ATTR_EXTEND_START + 0xd),
	MGR_EVT_PD_PDM_REPLACED_SOURCE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0xe),
	MGR_EVT_PD_PDM_RESUME = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0xf),
	MGR_EVT_PD_PDM_START_AUTO = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x10),
	MGR_EVT_PD_PDM_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x11),
	MGR_EVT_PD_PDM_SUSPENDED_REMINDER = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x12),
	MGR_EVT_PD_PDM_SUSPENDED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x13),
	MGR_EVT_PD_PFA_ERROR_CLEAR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x14),
	MGR_EVT_PD_SANITIZE_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x15),
	MGR_EVT_PD_FORMAT_START = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x16),
	MGR_EVT_PD_SANITIZE_PROGRESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_PROCESS,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x17),
	MGR_EVT_PD_SANITIZE_DONE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x18),
	MGR_EVT_PD_FORMAT_DONE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x19),
	MGR_EVT_PD_DPF_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x1a),
	MGR_EVT_PD_MARKED_SHIELD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x1b),
	MGR_EVT_PD_BBM_CORRECTED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x1c),
	MGR_EVT_PD_BBM_UNRECOVERABLE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x1d),
	MGR_EVT_PD_BBM_PUNCTURING = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x1e),
	MGR_EVT_PD_BBM_REASSIGN_WR_ERROR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_FATAL,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x1f),
	MGR_EVT_PD_UNABLE_ACCESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x20),
	MGR_EVT_MULITPILE_PD_UNABLE_ACCESS = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_TRUE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x21),
	MGR_EVT_PD_INSERT_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x22),
	MGR_EVT_PHY_SATA_D2H_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x23),
	MGR_EVT_PD_NOT_INSERTED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x24),
	MGR_EVT_PD_NOT_SUPPORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x25),
	MGR_EVT_MULITPILE_PD_NOT_SUPPORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_TRUE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x26),
	MGR_EVT_NVDATA_INVALID = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x27),
	MGR_EVT_PD_RBLD_NON_UNMAP_PD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x28),
	MGR_EVT_PD_MOVEBACK_NON_UNMAP_PD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x29),
	MGR_EVT_PD_PDM_NON_UNMAP_PD = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x2a),
	MGR_EVT_PD_RBLD_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x2b),
	MGR_EVT_PD_SANITIZE_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_CRITICAL,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x2c),
	MGR_EVT_PD_SPIN_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x2d),
	MGR_EVT_PD_RBLD_MEDIA_MIX_NOT_SUPPORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x2e),
	MGR_EVT_PD_RBLD_DRIVE_MIX_NOT_SUPPORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x2f),
	MGR_EVT_PD_PDM_MEDIA_MIX_NOT_SUPPORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x30),
	MGR_EVT_PD_PDM_DRIVE_MIX_NOT_SUPPORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x31),
	MGR_EVT_PD_MOVEBACK_MEDIA_MIX_NOT_SUPPORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x32),
	MGR_EVT_PD_MOVEBACK_DRIVE_MIX_NOT_SUPPORT = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x33),
	MGR_EVT_NFR_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x34),
	MGR_EVT_PD_RBLD_SMALL_SIZE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x35),
	MGR_EVT_PD_MOVEBACK_SMALL_SIZE = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x36),
	MGR_EVT_NEGO_LOWER_LINK_SPEED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x37),
	MGR_EVT_PD_NVME_CMD_ERR = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x38),
	MGR_EVT_PD_NVME_CMD_TO = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x39),
	MGR_EVT_PD_NVME_INSERT_FAIL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x3a),
	MGR_EVT_PCIE_LINK_NEGO_ABNORMAL = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x3b),
	MGR_EVT_PD_ISOLATION = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x3c),
	MGR_EVT_PD_REPAIR_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x3d),
	MGR_EVT_PD_PCIE_LINK_UP_WITHOUT_I2C = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x3e),
	MGR_EVT_PD_PCIE_ENUMERATE_FAILED = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_EXTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_WARNING,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x3f),
	MGR_EVT_PD_MISS_LIGHTING = PS3_MK_EVT(PS3_EVT_TYPE_RAIDHBA,
			PS3_EVT_EXP_INTERNAL, PS3_EVT_IS_BATCH_FALSE,
			PS3_EVT_PD_ATTR_EXTEND_LOCAL, PS3_EVT_CLASS_INFO,
			MGR_EVT_PD_ATTR_EXTEND_START + 0x40),
	MGR_EVT_PD_ATTR_EXTEND_END = (MGR_EVT_PD_ATTR_EXTEND_START+0x41),
};

static inline unsigned int ps3EvtCodeExtendToNormal(unsigned int evtcode)
{
	unsigned int event = 0;

	switch (evtcode) {
	case PS3_EVT_PD_ATTR_EXTEND_LOCAL:
		event = PS3_EVT_PD_ATTR_LOCAL;
		break;
	default:
		event = evtcode;
		break;
	}
	return event;
}

#endif
