/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class AVA
implements ASN1Value {
    private OBJECT_IDENTIFIER oid;
    private ANY value;
    public static final Tag TAG = SEQUENCE.TAG;

    @Override
    public Tag getTag() {
        return TAG;
    }

    public AVA(OBJECT_IDENTIFIER oid, ASN1Value value) {
        this.oid = oid;
        if (value instanceof ANY) {
            this.value = (ANY)value;
        } else {
            byte[] encoded = ASN1Util.encode(value);
            try {
                this.value = (ANY)ASN1Util.decode(ANY.getTemplate(), encoded);
            }
            catch (InvalidBERException e) {
                throw new RuntimeException("InvalidBERException while decoding as ANY: " + e.getMessage(), e);
            }
        }
    }

    public OBJECT_IDENTIFIER getOID() {
        return this.oid;
    }

    public ANY getValue() {
        return this.value;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement(this.oid);
        seq.addElement(this.value);
        seq.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.Template seqt = new SEQUENCE.Template();
            seqt.addElement(new OBJECT_IDENTIFIER.Template());
            seqt.addElement(new ANY.Template());
            SEQUENCE seq = (SEQUENCE)seqt.decode(implicit, istream);
            assert (seq.size() == 2);
            return new AVA((OBJECT_IDENTIFIER)seq.elementAt(0), seq.elementAt(1));
        }
    }
}

