/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class GetCRL
implements ASN1Value {
    public static final int unused = 0;
    public static final int keyCompromise = 1;
    public static final int cACompromise = 2;
    public static final int affiliationChanged = 3;
    public static final int superseded = 4;
    public static final int cessationOfOperation = 5;
    public static final int certificateHold = 6;
    private ANY issuerName;
    private ANY cRLName;
    private GeneralizedTime time;
    private BIT_STRING reasons;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public ANY getIssuerName() {
        return this.issuerName;
    }

    public ANY getCRLName() {
        return this.cRLName;
    }

    public GeneralizedTime getTime() {
        return this.time;
    }

    public BIT_STRING getReasons() {
        return this.reasons;
    }

    public GetCRL(ANY issuerName, ANY cRLName, GeneralizedTime time, BIT_STRING reasons) {
        if (issuerName == null) {
            throw new IllegalArgumentException("issuerName parameter to GetCRL constructor is null");
        }
        this.sequence = new SEQUENCE();
        this.issuerName = issuerName;
        this.sequence.addElement(issuerName);
        this.cRLName = cRLName;
        this.sequence.addElement(cRLName);
        this.time = time;
        this.sequence.addElement(time);
        this.reasons = reasons;
        reasons.setRemoveTrailingZeroes(true);
        this.sequence.addElement(reasons);
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(ANY.getTemplate());
            this.seqt.addOptionalElement(ANY.getTemplate());
            this.seqt.addOptionalElement(GeneralizedTime.getTemplate());
            this.seqt.addOptionalElement(BIT_STRING.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new GetCRL((ANY)seq.elementAt(0), (ANY)seq.elementAt(1), (GeneralizedTime)seq.elementAt(2), (BIT_STRING)seq.elementAt(3));
        }
    }
}

