/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RevocationReason
implements Serializable {
    private static final long serialVersionUID = -2582403666913588806L;
    public static final Collection<RevocationReason> INSTANCES = new ArrayList<RevocationReason>();
    public static final Map<Integer, RevocationReason> CODES = new LinkedHashMap<Integer, RevocationReason>();
    public static final Map<String, RevocationReason> LABELS = new LinkedHashMap<String, RevocationReason>();
    public static final RevocationReason UNSPECIFIED = new RevocationReason(0, "Unspecified");
    public static final RevocationReason KEY_COMPROMISE = new RevocationReason(1, "Key_Compromise");
    public static final RevocationReason CA_COMPROMISE = new RevocationReason(2, "CA_Compromise");
    public static final RevocationReason AFFILIATION_CHANGED = new RevocationReason(3, "Affiliation_Changed");
    public static final RevocationReason SUPERSEDED = new RevocationReason(4, "Superseded");
    public static final RevocationReason CESSATION_OF_OPERATION = new RevocationReason(5, "Cessation_of_Operation");
    public static final RevocationReason CERTIFICATE_HOLD = new RevocationReason(6, "Certificate_Hold");
    public static final RevocationReason REMOVE_FROM_CRL = new RevocationReason(8, "Remove_from_CRL");
    public static final RevocationReason PRIVILEGE_WITHDRAWN = new RevocationReason(9, "Privilege_Withdrawn");
    public static final RevocationReason AA_COMPROMISE = new RevocationReason(10, "AA_Compromise");
    private int code;
    private String label;

    private RevocationReason(int reason, String label) {
        this.code = reason;
        this.label = label;
        INSTANCES.add(this);
        CODES.put(reason, this);
        LABELS.put(label.toLowerCase(), this);
    }

    public int getCode() {
        return this.code;
    }

    public String getLabel() {
        return this.label;
    }

    public static RevocationReason fromInt(int reason) {
        return RevocationReason.valueOf(reason);
    }

    public static RevocationReason valueOf(int reason) {
        return CODES.get(reason);
    }

    public static RevocationReason valueOf(String string) {
        if (string == null) {
            return null;
        }
        return LABELS.get(string.toLowerCase());
    }

    public int toInt() {
        return this.code;
    }

    public String toString() {
        return this.label;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RevocationReason other = (RevocationReason)obj;
        if (this.code != other.code) {
            return false;
        }
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.code;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }
}

