/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.BitArray;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;

public class KeyUsageExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 2899719374157256708L;
    public static final String IDENT = "x509.info.extensions.KeyUsage";
    public static final String NAME = "KeyUsage";
    public static final String DIGITAL_SIGNATURE = "digital_signature";
    public static final String NON_REPUDIATION = "non_repudiation";
    public static final String KEY_ENCIPHERMENT = "key_encipherment";
    public static final String DATA_ENCIPHERMENT = "data_encipherment";
    public static final String KEY_AGREEMENT = "key_agreement";
    public static final String KEY_CERTSIGN = "key_certsign";
    public static final String CRL_SIGN = "crl_sign";
    public static final String ENCIPHER_ONLY = "encipher_only";
    public static final String DECIPHER_ONLY = "decipher_only";
    public static final int DIGITAL_SIGNATURE_BIT = 0;
    public static final int NON_REPUDIATION_BIT = 1;
    public static final int KEY_ENCIPHERMENT_BIT = 2;
    public static final int DATA_ENCIPHERMENT_BIT = 3;
    public static final int KEY_AGREEMENT_BIT = 4;
    public static final int KEY_CERTSIGN_BIT = 5;
    public static final int CRL_SIGN_BIT = 6;
    public static final int ENCIPHER_ONLY_BIT = 7;
    public static final int DECIPHER_ONLY_BIT = 8;
    public static final int NBITS = 9;
    public static String[] names = new String[9];
    private boolean[] bitString;

    private void encodeThis() throws IOException {
        try (DerOutputStream os = new DerOutputStream();){
            os.putUnalignedBitString(this.bitString);
            this.extensionValue = os.toByteArray();
        }
    }

    private boolean isSet(int position) {
        if (this.bitString.length <= position) {
            return false;
        }
        return this.bitString[position];
    }

    private void set(int position, boolean val) {
        if (position >= this.bitString.length) {
            boolean[] tmp = new boolean[position + 1];
            System.arraycopy(this.bitString, 0, tmp, 0, this.bitString.length);
            this.bitString = tmp;
        }
        this.bitString[position] = val;
    }

    public KeyUsageExtension(boolean critical, byte[] bitString) throws IOException {
        this.bitString = new BitArray(bitString.length * 8, bitString).toBooleanArray();
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public KeyUsageExtension(byte[] bitString) throws IOException {
        this.bitString = new BitArray(bitString.length * 8, bitString).toBooleanArray();
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = true;
        this.encodeThis();
    }

    public KeyUsageExtension(boolean critical, boolean[] bitString) throws IOException {
        this.bitString = bitString;
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public KeyUsageExtension(boolean[] bitString) throws IOException {
        this.bitString = bitString;
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = true;
        this.encodeThis();
    }

    public KeyUsageExtension(BitArray bitString) throws IOException {
        this.bitString = bitString.toBooleanArray();
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = true;
        this.encodeThis();
    }

    public KeyUsageExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        BitArray bitArray = val.getUnalignedBitString();
        if (bitArray == null) {
            throw new IOException("Invalid bit string");
        }
        this.bitString = bitArray.toBooleanArray();
    }

    public KeyUsageExtension() {
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = true;
        this.bitString = new boolean[0];
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        this.clearValue();
        if (!(obj instanceof Boolean)) {
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean val = (Boolean)obj;
        if (name.equalsIgnoreCase(DIGITAL_SIGNATURE)) {
            this.set(0, val);
        } else if (name.equalsIgnoreCase(NON_REPUDIATION)) {
            this.set(1, val);
        } else if (name.equalsIgnoreCase(KEY_ENCIPHERMENT)) {
            this.set(2, val);
        } else if (name.equalsIgnoreCase(DATA_ENCIPHERMENT)) {
            this.set(3, val);
        } else if (name.equalsIgnoreCase(KEY_AGREEMENT)) {
            this.set(4, val);
        } else if (name.equalsIgnoreCase(KEY_CERTSIGN)) {
            this.set(5, val);
        } else if (name.equalsIgnoreCase(CRL_SIGN)) {
            this.set(6, val);
        } else if (name.equalsIgnoreCase(ENCIPHER_ONLY)) {
            this.set(7, val);
        } else if (name.equalsIgnoreCase(DECIPHER_ONLY)) {
            this.set(8, val);
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:KeyUsage.");
        }
        this.encodeThis();
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(DIGITAL_SIGNATURE)) {
            return this.isSet(0);
        }
        if (name.equalsIgnoreCase(NON_REPUDIATION)) {
            return this.isSet(1);
        }
        if (name.equalsIgnoreCase(KEY_ENCIPHERMENT)) {
            return this.isSet(2);
        }
        if (name.equalsIgnoreCase(DATA_ENCIPHERMENT)) {
            return this.isSet(3);
        }
        if (name.equalsIgnoreCase(KEY_AGREEMENT)) {
            return this.isSet(4);
        }
        if (name.equalsIgnoreCase(KEY_CERTSIGN)) {
            return this.isSet(5);
        }
        if (name.equalsIgnoreCase(CRL_SIGN)) {
            return this.isSet(6);
        }
        if (name.equalsIgnoreCase(ENCIPHER_ONLY)) {
            return this.isSet(7);
        }
        if (name.equalsIgnoreCase(DECIPHER_ONLY)) {
            return this.isSet(8);
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:KeyUsage.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (name.equalsIgnoreCase(DIGITAL_SIGNATURE)) {
            this.set(0, false);
        } else if (name.equalsIgnoreCase(NON_REPUDIATION)) {
            this.set(1, false);
        } else if (name.equalsIgnoreCase(KEY_ENCIPHERMENT)) {
            this.set(2, false);
        } else if (name.equalsIgnoreCase(DATA_ENCIPHERMENT)) {
            this.set(3, false);
        } else if (name.equalsIgnoreCase(KEY_AGREEMENT)) {
            this.set(4, false);
        } else if (name.equalsIgnoreCase(KEY_CERTSIGN)) {
            this.set(5, false);
        } else if (name.equalsIgnoreCase(CRL_SIGN)) {
            this.set(6, false);
        } else if (name.equalsIgnoreCase(ENCIPHER_ONLY)) {
            this.set(7, false);
        } else if (name.equalsIgnoreCase(DECIPHER_ONLY)) {
            this.set(8, false);
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:KeyUsage.");
        }
    }

    @Override
    public String toString() {
        String s = super.toString() + "KeyUsage [\n";
        try {
            if (this.isSet(0)) {
                s = s + "  DigitalSignature\n";
            }
            if (this.isSet(1)) {
                s = s + "  Non_repudiation\n";
            }
            if (this.isSet(2)) {
                s = s + "  Key_Encipherment\n";
            }
            if (this.isSet(3)) {
                s = s + "  Data_Encipherment\n";
            }
            if (this.isSet(4)) {
                s = s + "  Key_Agreement\n";
            }
            if (this.isSet(5)) {
                s = s + "  Key_CertSign\n";
            }
            if (this.isSet(6)) {
                s = s + "  Crl_Sign\n";
            }
            if (this.isSet(7)) {
                s = s + "  Encipher_Only\n";
            }
            if (this.isSet(8)) {
                s = s + "  Decipher_Only\n";
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        s = s + "]\n";
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.KeyUsage_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(DIGITAL_SIGNATURE);
        elements.addElement(NON_REPUDIATION);
        elements.addElement(KEY_ENCIPHERMENT);
        elements.addElement(DATA_ENCIPHERMENT);
        elements.addElement(KEY_AGREEMENT);
        elements.addElement(KEY_CERTSIGN);
        elements.addElement(CRL_SIGN);
        elements.addElement(ENCIPHER_ONLY);
        elements.addElement(DECIPHER_ONLY);
        return elements.elements();
    }

    public boolean[] getBits() {
        return (boolean[])this.bitString.clone();
    }

    @Override
    public String getName() {
        return NAME;
    }

    static {
        KeyUsageExtension.names[0] = DIGITAL_SIGNATURE;
        KeyUsageExtension.names[1] = NON_REPUDIATION;
        KeyUsageExtension.names[2] = KEY_ENCIPHERMENT;
        KeyUsageExtension.names[3] = DATA_ENCIPHERMENT;
        KeyUsageExtension.names[4] = KEY_AGREEMENT;
        KeyUsageExtension.names[5] = KEY_CERTSIGN;
        KeyUsageExtension.names[6] = CRL_SIGN;
        KeyUsageExtension.names[7] = ENCIPHER_ONLY;
        KeyUsageExtension.names[8] = DECIPHER_ONLY;
    }
}

