/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateIssuerName;
import org.mozilla.jss.netscape.security.x509.CertificateSerialNumber;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X500Signer;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;

public final class CertAndKeyGen {
    private String sigAlg;
    private KeyPairGenerator keyGen;
    private X509Key publicKey;
    private PrivateKey privateKey;

    public CertAndKeyGen(String keyType, String sigAlg) throws NoSuchAlgorithmException {
        this.keyGen = KeyPairGenerator.getInstance(keyType);
        this.sigAlg = sigAlg;
    }

    public void generate(int keyBits) throws InvalidKeyException {
        KeyPair pair;
        try {
            this.keyGen.initialize(keyBits);
            pair = this.keyGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        PublicKey publicKey = pair.getPublic();
        if (!(publicKey instanceof X509Key)) {
            throw new InvalidKeyException("public key " + publicKey + " not an X509Key.");
        }
        this.publicKey = (X509Key)publicKey;
        this.privateKey = pair.getPrivate();
    }

    public X509Key getPublicKey() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getSelfCertificate(X500Name myname, long validity) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            X500Signer issuer = this.getSigner(myname);
            Date firstDate = new Date();
            Date lastDate = new Date();
            lastDate.setTime(lastDate.getTime() + validity * 1000L);
            CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
            X509CertInfo info = new X509CertInfo();
            info.set("version", new CertificateVersion(0));
            info.set("serialNumber", new CertificateSerialNumber((int)(firstDate.getTime() / 1000L)));
            AlgorithmId algID = issuer.getAlgorithmId();
            info.set("algorithmID", new CertificateAlgorithmId(algID));
            info.set("subject", new CertificateSubjectName(myname));
            info.set("key", new CertificateX509Key(this.publicKey));
            info.set("validity", interval);
            info.set("issuer", new CertificateIssuerName(issuer.getSigner()));
            X509CertImpl cert = new X509CertImpl(info);
            cert.sign(this.privateKey, algID.getName());
            return cert;
        }
        catch (IOException e) {
            throw new CertificateEncodingException("getSelfCertificate: " + e.getMessage());
        }
    }

    public PKCS10 getCertRequest(X500Name myname) throws InvalidKeyException, SignatureException {
        PKCS10 req = new PKCS10(this.publicKey);
        try {
            req.encodeAndSign(this.getSigner(myname));
        }
        catch (CertificateException e) {
            throw new SignatureException(this.sigAlg + " CertificateException");
        }
        catch (IOException e) {
            throw new SignatureException(this.sigAlg + " IOException");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(this.sigAlg + " unavailable?");
        }
        return req;
    }

    private X500Signer getSigner(X500Name me) throws InvalidKeyException, NoSuchAlgorithmException {
        Signature signature = Signature.getInstance(this.sigAlg);
        signature.initSign(this.privateKey);
        return new X500Signer(signature, me);
    }
}

