/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import org.mozilla.jss.netscape.security.util.ASN1CharStrConvMap;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.BitArray;
import org.mozilla.jss.netscape.security.util.DerInputBuffer;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.GenericValueConverter;

public class DerValue {
    public static final byte TAG_UNIVERSAL = 0;
    public static final byte TAG_APPLICATION = 64;
    public static final byte TAG_CONTEXT = -128;
    public static final byte TAG_PRIVATE = -64;
    public byte tag;
    protected DerInputBuffer buffer;
    public DerInputStream data;
    private int length;
    public static final byte tag_Boolean = 1;
    public static final byte tag_Integer = 2;
    public static final byte tag_BitString = 3;
    public static final byte tag_OctetString = 4;
    public static final byte tag_Null = 5;
    public static final byte tag_ObjectId = 6;
    public static final byte tag_Enumerated = 10;
    public static final byte tag_PrintableString = 19;
    public static final byte tag_VisibleString = 26;
    public static final byte tag_T61String = 20;
    public static final byte tag_IA5String = 22;
    public static final byte tag_UtcTime = 23;
    public static final byte tag_GeneralizedTime = 24;
    public static final byte tag_GeneralString = 27;
    public static final byte tag_BMPString = 30;
    public static final byte tag_UniversalString = 28;
    public static final byte tag_UTF8String = 12;
    public static final byte[] tags_DirectoryString = new byte[]{20, 19, 28, 12, 30};
    public static final byte tag_Sequence = 48;
    public static final byte tag_SequenceOf = 48;
    public static final byte tag_Set = 49;
    public static final byte tag_SetOf = 49;

    boolean isUniversal() {
        return (this.tag & 0xC0) == 0;
    }

    boolean isApplication() {
        return (this.tag & 0xC0) == 64;
    }

    public boolean isContextSpecific() {
        return (this.tag & 0xC0) == 128;
    }

    public boolean isContextSpecific(byte cntxtTag) {
        if (!this.isContextSpecific()) {
            return false;
        }
        return (this.tag & 0x1F) == cntxtTag;
    }

    boolean isPrivate() {
        return (this.tag & 0xC0) == 192;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) == 32;
    }

    public DerValue(String value) throws IOException {
        GenericValueConverter genericValue = new GenericValueConverter();
        DerValue val = genericValue.getValue(value);
        this.tag = val.tag;
        this.buffer = val.buffer;
        this.length = val.length;
        this.data = val.data;
        this.data.mark(Integer.MAX_VALUE);
    }

    public DerValue(byte tag, byte[] data) {
        this.tag = tag;
        this.buffer = new DerInputBuffer((byte[])data.clone());
        this.length = data.length;
        this.data = new DerInputStream(this.buffer);
        this.data.mark(Integer.MAX_VALUE);
    }

    public DerValue(byte tag, byte[] data, int offset, int length) {
        this(tag, Arrays.copyOfRange(data, offset, offset + length));
    }

    DerValue(DerInputBuffer in) throws IOException {
        this.tag = (byte)in.read();
        this.length = DerInputStream.getLength(in);
        this.buffer = in.dup();
        this.buffer.truncate(this.length);
        this.data = new DerInputStream(this.buffer);
        in.skip(this.length);
    }

    public DerValue(byte[] buf) throws IOException {
        this.init(true, new ByteArrayInputStream(buf));
    }

    public DerValue(byte[] buf, int offset, int len) throws IOException {
        this.init(true, new ByteArrayInputStream(buf, offset, len));
    }

    public DerValue(InputStream in) throws IOException {
        this.init(false, in);
    }

    private void init(boolean fullyBuffered, InputStream in) throws IOException {
        this.tag = (byte)in.read();
        this.length = DerInputStream.getLength(in);
        if (fullyBuffered && in.available() != this.length) {
            throw new IOException("extra DER value data (constructor)");
        }
        byte[] bytes = new byte[this.length];
        DataInputStream dis = new DataInputStream(in);
        dis.readFully(bytes);
        this.buffer = new DerInputBuffer(bytes);
        this.data = new DerInputStream(this.buffer);
    }

    public void encode(DerOutputStream out) throws IOException {
        out.write(this.tag);
        out.putLength(this.length);
        this.buffer.dump(out, this.length);
    }

    public boolean getBoolean() throws IOException {
        if (this.tag != 1) {
            throw new IOException("DerValue.getBoolean, not a BOOLEAN " + this.tag);
        }
        if (this.length != 1) {
            throw new IOException("DerValue.getBoolean, invalid length " + this.length);
        }
        return this.buffer.read() != 0;
    }

    public ObjectIdentifier getOID() throws IOException {
        if (this.tag != 6) {
            throw new IOException("DerValue.getOID, not an OID " + this.tag);
        }
        return new ObjectIdentifier(this.buffer);
    }

    public byte[] getOctetString() throws IOException {
        if (this.tag != 4) {
            throw new IOException("DerValue.getOctetString, not an Octet String: " + this.tag);
        }
        byte[] bytes = new byte[this.length];
        int n = this.buffer.read(bytes);
        if (n != this.length && (n != -1 || this.length != 0)) {
            throw new IOException("getOctetString: short read on DerValue buffer: expected to read " + this.length + " bytes; actually read " + n + " bytes.");
        }
        return bytes;
    }

    public int getEnumerated() throws IOException {
        if (this.tag != 10) {
            throw new IOException("DerValue.getEnumerated, not an ENUMERATED " + this.tag);
        }
        if (this.length == 0) {
            return 0;
        }
        if (this.length > 4 || this.length < 1) {
            throw new IOException("DerValue.getEnumerated, invalid length " + this.length + "(must be between 1 and 4)");
        }
        byte value = 0;
        int nextbyte = this.buffer.read();
        if (nextbyte == -1) {
            throw new IOException("short read on DerValue buffer");
        }
        value = (byte)nextbyte;
        for (int i = this.length - 1; i > 0; --i) {
            nextbyte = this.buffer.read();
            if (nextbyte == -1) {
                throw new IOException("short read on DerValue buffer");
            }
            value = (byte)(256 * value + nextbyte);
        }
        return value;
    }

    public BigInt getInteger() throws IOException {
        if (this.tag != 2) {
            throw new IOException("DerValue.getInteger, not an int " + this.tag);
        }
        return this.buffer.getUnsigned(this.data.available());
    }

    public BigInt getInteger(boolean tagImplicit) throws IOException {
        if (!tagImplicit && this.tag != 2) {
            throw new IOException("DerValue.getInteger, not an int " + this.tag);
        }
        return this.buffer.getUnsigned(this.data.available());
    }

    public byte[] getBitString() throws IOException {
        if (this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getBitString();
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getUnalignedBitString();
    }

    public String getAsString() throws IOException {
        GenericValueConverter genericValue = new GenericValueConverter();
        return genericValue.getAsString(this);
    }

    public byte[] getBitString(boolean tagImplicit) throws IOException {
        if (!tagImplicit && this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getBitString();
    }

    public BitArray getUnalignedBitString(boolean tagImplicit) throws IOException {
        if (!tagImplicit && this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getUnalignedBitString();
    }

    public String getPrintableString() throws IOException {
        if (this.tag != 19) {
            throw new IOException("DerValue.getPrintableString, not a string " + this.tag);
        }
        return this.getASN1CharString();
    }

    public String getDirectoryString() throws IOException {
        boolean tagValid = false;
        for (int i = 0; i < tags_DirectoryString.length; ++i) {
            if (this.tag != tags_DirectoryString[i]) continue;
            tagValid = true;
            break;
        }
        if (!tagValid) {
            throw new IOException("DerValue.getDirectoryString: invalid tag: " + this.tag);
        }
        return this.getASN1CharString();
    }

    public String getASN1CharString() throws IOException {
        try {
            CharsetDecoder decoder = ASN1CharStrConvMap.getDefault().getDecoder(this.tag);
            if (decoder == null) {
                return null;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.length);
            this.data.reset();
            this.data.getBytes(byteBuffer.array());
            CharBuffer charBuffer = decoder.decode(byteBuffer);
            return charBuffer.toString();
        }
        catch (CharacterCodingException e) {
            throw new IOException("Misformed DER value", e);
        }
    }

    public String getT61String() throws IOException {
        if (this.tag != 20) {
            throw new IOException("DerValue.getT61String, not T61 " + this.tag);
        }
        return this.getASN1CharString();
    }

    public String getIA5String() throws IOException {
        if (this.tag != 22) {
            throw new IOException("DerValue.getIA5String, not IA5 " + this.tag);
        }
        return this.getASN1CharString();
    }

    public String getBMPString() throws IOException {
        if (this.tag != 30) {
            throw new IOException("DerValue.getBMPString, not BMP " + this.tag);
        }
        return this.getASN1CharString();
    }

    public String getUniversalString() throws IOException {
        if (this.tag != 28) {
            throw new IOException("DerValue.getUniversalString, not UniversalString " + this.tag);
        }
        return this.getASN1CharString();
    }

    public String getUTF8String() throws IOException {
        if (this.tag != 12) {
            throw new IOException("DerValue.getUTF8String, not UTF8String " + this.tag);
        }
        return this.getASN1CharString();
    }

    public boolean equals(Object other) {
        if (other instanceof DerValue) {
            return this.equals((DerValue)other);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.buffer == null ? 0 : this.buffer.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + this.length;
        result = 31 * result + this.tag;
        return result;
    }

    public boolean equals(DerValue other) {
        this.data.reset();
        other.data.reset();
        if (this == other) {
            return true;
        }
        if (this.tag != other.tag) {
            return false;
        }
        return this.buffer.equals(other.buffer);
    }

    public String toString() {
        try {
            String s = this.getAsString();
            if (s != null) {
                return s;
            }
            if (this.tag == 5) {
                return "[DerValue, null]";
            }
            if (this.tag == 6) {
                return "OID." + this.getOID();
            }
            return "[DerValue, tag = " + this.tag + ", length = " + this.length + "]";
        }
        catch (IOException e) {
            throw new IllegalArgumentException("misformatted DER value");
        }
    }

    public byte[] toByteArray() throws IOException {
        DerOutputStream out = new DerOutputStream();
        this.encode(out);
        this.data.reset();
        return out.toByteArray();
    }

    public DerInputStream toDerInputStream() throws IOException {
        if (this.tag == 48 || this.tag == 49) {
            return new DerInputStream(this.buffer);
        }
        throw new IOException("toDerInputStream rejects tag type " + this.tag);
    }

    public int length() {
        return this.length;
    }

    public static byte createTag(byte tagClass, boolean form, byte val) {
        byte tag = (byte)(tagClass | val);
        if (form) {
            tag = (byte)(tag | 0x20);
        }
        return tag;
    }

    public void resetTag(byte tag) {
        this.tag = tag;
    }
}

