/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.PBEParameter;
import org.mozilla.jss.pkix.primitive.PBES2Params;
import org.mozilla.jss.pkix.primitive.PBKDF2Params;
import org.mozilla.jss.util.Password;

public class EncryptedContentInfo
implements ASN1Value {
    private OBJECT_IDENTIFIER contentType;
    private AlgorithmIdentifier contentEncryptionAlgorithm;
    private OCTET_STRING encryptedContent;
    private SEQUENCE sequence = new SEQUENCE();
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public OBJECT_IDENTIFIER getContentType() {
        return this.contentType;
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public OCTET_STRING getEncryptedContent() {
        return this.encryptedContent;
    }

    public boolean hasEncryptedContent() {
        return this.encryptedContent != null;
    }

    public EncryptedContentInfo(OBJECT_IDENTIFIER contentType, AlgorithmIdentifier contentEncryptionAlgorithm, OCTET_STRING encryptedContent) {
        this(contentType, contentEncryptionAlgorithm, encryptedContent, false);
    }

    public EncryptedContentInfo(OBJECT_IDENTIFIER contentType, AlgorithmIdentifier contentEncryptionAlgorithm, OCTET_STRING encryptedContent, boolean createHackedCRSCompatibleECI) {
        this.contentType = contentType;
        this.contentEncryptionAlgorithm = contentEncryptionAlgorithm;
        this.encryptedContent = encryptedContent;
        this.sequence.addElement(contentType);
        this.sequence.addElement(contentEncryptionAlgorithm);
        if (encryptedContent != null) {
            if (createHackedCRSCompatibleECI) {
                this.sequence.addElement(new EXPLICIT(new Tag(0L), encryptedContent));
            } else {
                this.sequence.addElement(new Tag(0L), encryptedContent);
            }
        }
    }

    public static EncryptedContentInfo createCRSCompatibleEncryptedContentInfo(OBJECT_IDENTIFIER contentType, AlgorithmIdentifier contentEncryptionAlgorithm, OCTET_STRING encryptedContent) {
        return new EncryptedContentInfo(contentType, contentEncryptionAlgorithm, encryptedContent, true);
    }

    public static EncryptedContentInfo createPBE(PBEAlgorithm pbeAlg, Password password, byte[] salt, int iterationCount, KeyGenerator.CharToByteConverter charToByteConverter, byte[] toBeEncrypted) throws NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, CharConversionException {
        try {
            CryptoManager cman = CryptoManager.getInstance();
            CryptoToken token = cman.getInternalCryptoToken();
            KeyGenerator kg = token.getKeyGenerator(pbeAlg);
            PBEKeyGenParams pbekgParams = new PBEKeyGenParams(password, salt, iterationCount);
            if (charToByteConverter != null) {
                kg.setCharToByteConverter(charToByteConverter);
            }
            kg.initialize(pbekgParams);
            SymmetricKey key = kg.generate();
            EncryptionAlgorithm encAlg = pbeAlg.getEncryptionAlg();
            AlgorithmParameterSpec params = null;
            Class<?>[] paramClasses = encAlg.getParameterClasses();
            for (int i = 0; i < paramClasses.length; ++i) {
                if (paramClasses[i].equals(IvParameterSpec.class)) {
                    params = new IVParameterSpec(kg.generatePBE_IV());
                    break;
                }
                if (!paramClasses[i].equals(RC2ParameterSpec.class)) continue;
                params = new RC2ParameterSpec(key.getStrength(), kg.generatePBE_IV());
                break;
            }
            Cipher cipher = token.getCipherContext(encAlg);
            cipher.initEncrypt(key, params);
            byte[] encrypted = cipher.doFinal(Cipher.pad(toBeEncrypted, encAlg.getBlockSize()));
            PBEParameter pbeParam = new PBEParameter(salt, iterationCount);
            AlgorithmIdentifier encAlgID = new AlgorithmIdentifier(pbeAlg.toOID(), pbeParam);
            return new EncryptedContentInfo(ContentInfo.DATA, encAlgID, new OCTET_STRING(encrypted));
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("IllegalBlockSizeException in EncryptedContentInfo.createPBE: " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("BadPaddingException in EncryptedContentInfo.createPBE: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(Password pass, KeyGenerator.CharToByteConverter charToByteConverter) throws IllegalStateException, NotInitializedException, NoSuchAlgorithmException, InvalidBERException, IOException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, IllegalBlockSizeException, BadPaddingException {
        if (this.encryptedContent == null) {
            return null;
        }
        KeyGenAlgorithm kgAlg = KeyGenAlgorithm.fromOID(this.contentEncryptionAlgorithm.getOID());
        if (!(kgAlg instanceof PBEAlgorithm)) {
            throw new NoSuchAlgorithmException("KeyGenAlgorithm is not a PBE algorithm");
        }
        ASN1Value params = this.contentEncryptionAlgorithm.getParameters();
        if (params == null) {
            throw new InvalidAlgorithmParameterException("PBE algorithms require parameters");
        }
        byte[] salt = null;
        int iterations = 0;
        EncryptionAlgorithm encAlg = null;
        AlgorithmParameterSpec algParams = null;
        HMACAlgorithm hashAlg = null;
        KeyGenerator.CharToByteConverter passwordConverter = charToByteConverter;
        if (!kgAlg.toOID().equals(PBEAlgorithm.PBE_PKCS5_PBES2.toOID())) {
            PBEParameter pbeParams;
            if (params instanceof PBEParameter) {
                pbeParams = (PBEParameter)params;
            } else {
                byte[] encodedParams = ASN1Util.encode(params);
                pbeParams = (PBEParameter)ASN1Util.decode(PBEParameter.getTemplate(), encodedParams);
            }
            salt = pbeParams.getSalt();
            iterations = pbeParams.getIterations();
            encAlg = ((PBEAlgorithm)kgAlg).getEncryptionAlg();
            if (passwordConverter == null) {
                passwordConverter = new PasswordConverter();
            }
        } else {
            byte[] encodedParams = ASN1Util.encode(params);
            PBES2Params pbe2Params = (PBES2Params)ASN1Util.decode(PBES2Params.getTemplate(), encodedParams);
            AlgorithmIdentifier keyDerivationFunc = pbe2Params.getKeyDerivationFunc();
            AlgorithmIdentifier encryptionScheme = pbe2Params.getEncryptionScheme();
            if (!keyDerivationFunc.getOID().equals(PBEAlgorithm.PBE_PKCS5_PBKDF2.toOID())) {
                throw new InvalidAlgorithmParameterException("PBEs2 requires a PBKDF2 keyDerivationFunc" + keyDerivationFunc.getOID().toDottedString());
            }
            byte[] encodedPBKParams = ASN1Util.encode(keyDerivationFunc.getParameters());
            PBKDF2Params pbkParams = (PBKDF2Params)ASN1Util.decode(PBKDF2Params.getTemplate(), encodedPBKParams);
            salt = pbkParams.getSalt();
            iterations = pbkParams.getIterations();
            encAlg = EncryptionAlgorithm.fromOID(encryptionScheme.getOID());
            hashAlg = HMACAlgorithm.fromOID(pbkParams.getPrf().getOID());
            OCTET_STRING iv = (OCTET_STRING)ASN1Util.decode(OCTET_STRING.getTemplate(), ASN1Util.encode(encryptionScheme.getParameters()));
            algParams = new IVParameterSpec(iv.toByteArray());
        }
        PBEKeyGenParams kgp = new PBEKeyGenParams(pass.getChars(), salt, iterations, encAlg, hashAlg);
        try {
            CryptoToken token = CryptoManager.getInstance().getInternalCryptoToken();
            KeyGenerator kg = token.getKeyGenerator(kgAlg);
            if (passwordConverter != null) {
                kg.setCharToByteConverter(passwordConverter);
            }
            kg.initialize(kgp);
            SymmetricKey key = kg.generate();
            if (algParams == null) {
                Class<?>[] paramClasses = encAlg.getParameterClasses();
                for (int i = 0; i < paramClasses.length; ++i) {
                    if (paramClasses[i].equals(IvParameterSpec.class)) {
                        algParams = new IVParameterSpec(kg.generatePBE_IV());
                        break;
                    }
                    if (!paramClasses[i].equals(RC2ParameterSpec.class)) continue;
                    algParams = new RC2ParameterSpec(key.getStrength(), kg.generatePBE_IV());
                    break;
                }
            }
            Cipher cipher = token.getCipherContext(encAlg);
            cipher.initDecrypt(key, algParams);
            byte[] ec = this.encryptedContent.toByteArray();
            byte[] byArray = cipher.doFinal(ec);
            return byArray;
        }
        finally {
            kgp.clear();
        }
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    @Override
    public void encode(Tag tag, OutputStream ostream) throws IOException {
        this.sequence.encode(tag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        @Override
        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.Template seqt = new SEQUENCE.Template();
            seqt.addElement(new OBJECT_IDENTIFIER.Template());
            seqt.addElement(new AlgorithmIdentifier.Template());
            seqt.addOptionalElement(new Tag(0L), new OCTET_STRING.Template());
            SEQUENCE seq = (SEQUENCE)seqt.decode(implicitTag, istream);
            assert (seq.size() == 3);
            return new EncryptedContentInfo((OBJECT_IDENTIFIER)seq.elementAt(0), (AlgorithmIdentifier)seq.elementAt(1), (OCTET_STRING)seq.elementAt(2));
        }
    }
}

