/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.X509Key;

public class CertificateX509Key
implements CertAttrSet,
Serializable {
    private static final long serialVersionUID = 6718749024328681131L;
    public static final String IDENT = "x509.info.key";
    public static final String NAME = "key";
    public static final String KEY = "value";
    private X509Key key;

    public CertificateX509Key(X509Key key) {
        this.key = key;
    }

    public CertificateX509Key(DerInputStream in) throws IOException {
        DerValue val = in.getDerValue();
        this.key = X509Key.parse(val);
    }

    public CertificateX509Key(InputStream in) throws IOException {
        DerValue val = new DerValue(in);
        this.key = X509Key.parse(val);
    }

    @Override
    public String toString() {
        if (this.key == null) {
            return "";
        }
        return this.key.toString();
    }

    @Override
    public void decode(InputStream in) throws IOException {
        DerValue val = new DerValue(in);
        this.key = X509Key.parse(val);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.encode(stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        this.decode(stream);
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.key.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof X509Key)) {
            throw new IOException("Attribute must be of type X509Key.");
        }
        if (!name.equalsIgnoreCase(KEY)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateX509Key.");
        }
        this.key = (X509Key)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(KEY)) {
            return this.key;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateX509Key.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(KEY)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateX509Key.");
        }
        this.key = null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(KEY);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

