/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.X509AttributeName;
import org.mozilla.jss.netscape.security.x509.X509ExtensionException;

public class CRLExtensions
extends Vector<Extension> {
    private static final long serialVersionUID = 365767738692986418L;
    private Hashtable<String, Extension> map = new Hashtable();

    private void parseExtension(Extension ext) throws X509ExtensionException {
        try {
            Class<?> extClass = OIDMap.getClass(ext.getExtensionId());
            if (extClass == null) {
                if (ext.isCritical()) {
                    throw new IOException("Unsupported CRITICAL extension: " + ext.getExtensionId());
                }
                this.map.put(ext.getExtensionId().toString(), ext);
                this.addElement(ext);
                return;
            }
            Class[] params = new Class[]{Boolean.class, Object.class};
            Constructor<?> cons = extClass.getConstructor(params);
            byte[] extData = ext.getExtensionValue();
            int extLen = extData.length;
            Object value = Array.newInstance(Byte.TYPE, extLen);
            for (int i = 0; i < extLen; ++i) {
                Array.setByte(value, i, extData[i]);
            }
            Object[] passed = new Object[]{ext.isCritical(), value};
            CertAttrSet crlExt = (CertAttrSet)cons.newInstance(passed);
            this.map.put(crlExt.getName(), (Extension)((Object)crlExt));
            this.addElement((Extension)((Object)crlExt));
        }
        catch (InvocationTargetException invk) {
            throw new X509ExtensionException(invk.getTargetException().getMessage());
        }
        catch (Exception e) {
            throw new X509ExtensionException(e.toString());
        }
    }

    public CRLExtensions() {
    }

    public CRLExtensions(DerInputStream in) throws CRLException, X509ExtensionException {
        try {
            DerValue[] exts = in.getSequence(5);
            for (int i = 0; i < exts.length; ++i) {
                Extension ext = new Extension(exts[i]);
                this.parseExtension(ext);
            }
        }
        catch (IOException e) {
            throw new CRLException("Parsing error: " + e.toString());
        }
    }

    public void decode(InputStream in) throws CRLException, X509ExtensionException {
        try {
            DerValue val = new DerValue(in);
            DerInputStream str = val.toDerInputStream();
            this.map = new Hashtable();
            DerValue[] exts = str.getSequence(5);
            for (int i = 0; i < exts.length; ++i) {
                Extension ext = new Extension(exts[i]);
                this.parseExtension(ext);
            }
        }
        catch (IOException e) {
            throw new CRLException("Parsing error: " + e.toString());
        }
    }

    public void encode(OutputStream out, boolean isExplicit) throws CRLException {
        try (DerOutputStream tmp = new DerOutputStream();){
            if (this.size() == 0) {
                return;
            }
            DerOutputStream extOut = new DerOutputStream();
            for (int i = 0; i < this.size(); ++i) {
                Object thisOne = this.elementAt(i);
                if (thisOne instanceof CertAttrSet) {
                    ((CertAttrSet)thisOne).encode(extOut);
                    continue;
                }
                if (thisOne instanceof Extension) {
                    ((Extension)thisOne).encode(extOut);
                    continue;
                }
                throw new CRLException("Illegal extension object");
            }
            DerOutputStream seq = new DerOutputStream();
            seq.write((byte)48, extOut);
            if (isExplicit) {
                tmp.write(DerValue.createTag((byte)-128, true, (byte)0), seq);
                out.write(tmp.toByteArray());
            } else {
                out.write(seq.toByteArray());
            }
        }
        catch (IOException e) {
            throw new CRLException("Encoding error: " + e.toString());
        }
        catch (CertificateException e) {
            throw new CRLException("Encoding error: " + e.toString());
        }
    }

    public Extension get(String alias) throws X509ExtensionException {
        String name;
        X509AttributeName attr = new X509AttributeName(alias);
        String id = attr.getPrefix();
        if (id.equalsIgnoreCase("x509")) {
            int index = alias.lastIndexOf(".");
            name = alias.substring(index + 1);
        } else {
            name = alias;
        }
        Extension ext = this.map.get(name);
        if (ext == null) {
            throw new X509ExtensionException("No extension found with name: " + alias);
        }
        return ext;
    }

    public void set(String alias, Extension obj) throws IOException {
        this.map.put(alias, obj);
        this.addElement(obj);
    }

    public Enumeration<Extension> getElements() {
        return this.map.elements();
    }

    @Override
    public synchronized int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CRLExtensions other = (CRLExtensions)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }
}

