/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CharConverter;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.Tag;

public abstract class CharacterString
implements ASN1Value {
    static final Form FORM = Form.PRIMITIVE;
    private char[] chars;
    private byte[] cachedContents;

    abstract CharConverter getCharConverter();

    @Override
    public abstract Tag getTag();

    public String toString() {
        return new String(this.chars);
    }

    public char[] toCharArray() {
        return this.chars;
    }

    protected CharacterString(char[] chars) throws CharConversionException {
        this.chars = chars;
        this.cachedContents = this.computeContents();
    }

    protected CharacterString(String s) throws CharConversionException {
        this.chars = s.toCharArray();
        this.cachedContents = this.computeContents();
    }

    private byte[] getEncodedContents() {
        return this.cachedContents;
    }

    private byte[] computeContents() throws CharConversionException {
        CharConverter converter = this.getCharConverter();
        byte[] contents = converter.charToByte(this.chars, 0, this.chars.length);
        return contents;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        byte[] contents = this.getEncodedContents();
        ASN1Header head = new ASN1Header(implicitTag, FORM, contents.length);
        head.encode(ostream);
        ostream.write(contents);
    }

    public static abstract class Template
    implements ASN1Template {
        protected abstract Tag getTag();

        @Override
        public abstract boolean tagMatch(Tag var1);

        protected abstract CharConverter getCharConverter();

        protected abstract CharacterString generateInstance(char[] var1) throws CharConversionException;

        protected abstract String typeName();

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            try {
                byte[] raw;
                ASN1Header head = new ASN1Header(istream);
                head.validate(implicitTag);
                if (head.getContentLength() == -1L) {
                    ASN1Header ahead;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    do {
                        if ((ahead = ASN1Header.lookAhead(istream)).isEOC()) continue;
                        OCTET_STRING.Template ot = new OCTET_STRING.Template();
                        OCTET_STRING os = (OCTET_STRING)ot.decode(istream);
                        bos.write(os.toByteArray());
                    } while (!ahead.isEOC());
                    ahead = new ASN1Header(istream);
                    raw = bos.toByteArray();
                } else {
                    raw = new byte[(int)head.getContentLength()];
                    ASN1Util.readFully(raw, istream);
                }
                char[] chars = this.getCharConverter().byteToChar(raw, 0, raw.length);
                return this.generateInstance(chars);
            }
            catch (CharConversionException e) {
                throw new InvalidBERException(e.getMessage());
            }
            catch (InvalidBERException e) {
                throw new InvalidBERException(e, this.typeName());
            }
        }
    }
}

