/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl.javax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import javax.net.ssl.SSLParameters;
import org.mozilla.jss.ssl.SSLCipher;
import org.mozilla.jss.ssl.SSLVersion;
import org.mozilla.jss.ssl.SSLVersionRange;

public class JSSParameters
extends SSLParameters {
    private SSLCipher[] suites;
    private SSLVersionRange range;
    private String alias;
    private String hostname;
    private Collection<? extends EventListener> listeners;

    public JSSParameters() {
        super(null, null);
    }

    public JSSParameters(SSLParameters downcast) {
        this();
        if (downcast == null) {
            return;
        }
        this.setCipherSuites(downcast.getCipherSuites());
        this.setProtocols(downcast.getProtocols());
        this.setAlgorithmConstraints(downcast.getAlgorithmConstraints());
        this.setEndpointIdentificationAlgorithm(downcast.getEndpointIdentificationAlgorithm());
        this.setServerNames(downcast.getServerNames());
        this.setSNIMatchers(downcast.getSNIMatchers());
        this.setUseCipherSuitesOrder(downcast.getUseCipherSuitesOrder());
        if (downcast.getWantClientAuth()) {
            this.setWantClientAuth(downcast.getWantClientAuth());
        }
        if (downcast.getNeedClientAuth()) {
            this.setNeedClientAuth(downcast.getNeedClientAuth());
        }
    }

    public JSSParameters(String[] cipherSuites) {
        super(cipherSuites);
    }

    public JSSParameters(String[] cipherSuites, String[] protocols) {
        super(cipherSuites, protocols);
    }

    @Override
    public void setCipherSuites(String[] cipherSuites) throws IllegalArgumentException {
        if (cipherSuites == null || cipherSuites.length == 0) {
            this.suites = null;
            return;
        }
        ArrayList<SSLCipher> converted = new ArrayList<SSLCipher>();
        for (String cipherSuite : cipherSuites) {
            try {
                converted.add(SSLCipher.valueOf(cipherSuite));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("JSSParameters.setCipherSuites() - Unknown cipher suite (" + cipherSuite + "): " + e.getMessage(), e);
            }
        }
        this.suites = converted.toArray(new SSLCipher[0]);
    }

    public void setCipherSuites(SSLCipher[] cipherSuites) {
        if (cipherSuites == null || cipherSuites.length == 0) {
            this.suites = null;
            return;
        }
        this.suites = new SSLCipher[cipherSuites.length];
        for (int index = 0; index < cipherSuites.length; ++index) {
            this.suites[index] = cipherSuites[index];
        }
    }

    @Override
    public String[] getCipherSuites() {
        if (this.suites == null) {
            return null;
        }
        ArrayList<String> ciphers = new ArrayList<String>();
        for (SSLCipher suite : this.suites) {
            ciphers.add(suite.name());
        }
        return ciphers.toArray(new String[0]);
    }

    public SSLCipher[] getSSLCiphers() {
        return this.suites;
    }

    @Override
    public void setProtocols(String[] protocols) throws IllegalArgumentException {
        if (protocols == null || protocols.length == 0) {
            this.range = null;
            return;
        }
        try {
            SSLVersion minProtocol;
            SSLVersion maxProtocol = minProtocol = SSLVersion.findByAlias(protocols[0]);
            for (String protocol : protocols) {
                SSLVersion version = SSLVersion.findByAlias(protocol);
                if (minProtocol.ordinal() > version.ordinal()) {
                    minProtocol = version;
                }
                if (maxProtocol.ordinal() >= version.ordinal()) continue;
                maxProtocol = version;
            }
            this.range = new SSLVersionRange(minProtocol, maxProtocol);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("JSSParameters.setProtocols() - unknown protocol: " + e.getMessage(), e);
        }
    }

    public void setProtocols(SSLVersion min, SSLVersion max) {
        this.range = new SSLVersionRange(min, max);
    }

    public void setProtocols(SSLVersionRange vrange) {
        this.range = vrange;
    }

    @Override
    public String[] getProtocols() {
        if (this.range == null) {
            return null;
        }
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        for (SSLVersion v : SSLVersion.values()) {
            if (this.range.getMinVersion().ordinal() > v.ordinal() || v.ordinal() > this.range.getMaxVersion().ordinal()) continue;
            if (v.aliases().length >= 2) {
                enabledProtocols.add(v.aliases()[1]);
                continue;
            }
            enabledProtocols.add(v.aliases()[0]);
        }
        return enabledProtocols.toArray(new String[0]);
    }

    public SSLVersionRange getSSLVersionRange() {
        return this.range;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String cert_alias) {
        this.alias = cert_alias;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String server_hostname) {
        this.hostname = server_hostname;
    }

    public Collection<? extends EventListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(Collection<? extends EventListener> new_listeners) {
        this.listeners = new_listeners;
    }
}

