/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.InitializationValues;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.ssl.ClientHandshakeCB;
import org.mozilla.jss.ssl.PrintOutputStreamWriter;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.TestCertApprovalCallback;
import org.mozilla.jss.ssl.TestClientCertificateSelectionCallback;

public class SSLClient {
    boolean handshakeEventHappened = false;
    boolean doClientAuth = false;
    HashMap<String, String> args;
    PrintStream results;
    String versionStr;
    String[] argNames = new String[]{"filename", "port", "ipaddr", "hostname", "filesize", "status", "sessionKeySize", "sessionSecretSize", "cipher", "issuer", "subject", "certSerialNum"};
    String[] values = new String[]{"/index", "443", "", "trading.etrade.com", "1024", "2", "128", "128", "RC48", "CN=Hardcore Certificate Server II, OU=Hardcore, O=Netscape Communications Corporation, C=US", "CN=hbombsgi.mcom.com, OU=Hardcore, C=US", "00C3"};
    String okay = "okay";
    String failed = "FAILED";
    private static String htmlHeader = "SSL Client Tester";
    static final int[] cipherSuites = new int[]{4, 10, 9, 3, 6, 1, 0};

    private boolean isInvalid(String s) {
        return s == null || s.equals("");
    }

    private String getArgument(String key) {
        return this.args.get(key);
    }

    private String cmp(String s1, String s2) {
        return s1.equals(s2) ? this.okay : this.failed;
    }

    private String cmp(String s1, int s2) {
        return this.cmp(s1, Integer.toString(s2));
    }

    public void run(boolean printHeader, boolean testRegression) {
        try {
            String addrstr;
            ClientHandshakeCB listener = null;
            if (printHeader) {
                this.results.println(htmlHeader);
            }
            this.results.println("SSL Client Tester");
            this.results.println("$Id$ " + this.versionStr);
            String filename = this.getArgument("filename");
            if (this.isInvalid(filename)) {
                filename = "/index.html";
            }
            String msg = "GET " + filename;
            String portstr = this.getArgument("port");
            int port = this.isInvalid(portstr) ? 443 : Integer.parseInt(portstr);
            String hostname = addrstr = this.getArgument("ipaddr");
            String tmpStr = this.getArgument("clientauth");
            if (this.isInvalid(tmpStr)) {
                this.doClientAuth = false;
            } else {
                boolean bl = this.doClientAuth = !(tmpStr = tmpStr.toLowerCase()).equals("off") && !tmpStr.equals("false") && !tmpStr.equals("0");
            }
            if (this.isInvalid(addrstr) && this.isInvalid(hostname = this.getArgument("hostname"))) {
                throw new Exception("hostname not specified");
            }
            this.results.println("Connecting to " + hostname + " on port " + port);
            TestCertApprovalCallback approvalCallback = new TestCertApprovalCallback();
            TestClientCertificateSelectionCallback certSelectionCallback = new TestClientCertificateSelectionCallback();
            Socket js = new Socket(InetAddress.getByName(hostname), port);
            try (SSLSocket s = new SSLSocket(js, hostname, approvalCallback, certSelectionCallback);){
                s.forceHandshake();
                this.results.println("Connected.");
                listener = new ClientHandshakeCB(this);
                s.addHandshakeCompletedListener(listener);
                OutputStream o = s.getOutputStream();
                PrintOutputStreamWriter out = new PrintOutputStreamWriter(o);
                this.results.println("Sending: " + msg + " to " + hostname + ", " + port);
                out.println(msg + "\r");
                InputStream in = s.getInputStream();
                byte[] bytes = new byte[4096];
                int totalBytes = 0;
                int numReads = 0;
                String lastBytes = null;
                try {
                    while (true) {
                        this.results.println("Calling Read.");
                        int n = in.read(bytes, 0, bytes.length);
                        if (n == -1) {
                            this.results.println("EOF found.");
                            break;
                        }
                        if (n == 0) {
                            this.results.println("Zero bytes read?");
                            break;
                        }
                        ++numReads;
                        if (totalBytes == 0) {
                            String data = new String(bytes, 0, 30, StandardCharsets.ISO_8859_1);
                            this.results.println("Read " + n + " bytes of data");
                            this.results.println("First 30 bytes: " + this.escapeHTML(data));
                        }
                        totalBytes += n;
                        lastBytes = new String(bytes, n - 31, 30, StandardCharsets.ISO_8859_1);
                    }
                    this.results.println("Last 30 bytes: " + lastBytes);
                    this.results.println("Number of read() calls: " + numReads);
                    this.results.println("Diagnostics");
                }
                catch (IOException e) {
                    try {
                        this.results.println("IOException while reading from pipe?  Actually got " + totalBytes + " bytes total");
                        e.printStackTrace(this.results);
                        this.results.println("");
                        throw e;
                    }
                    catch (Throwable throwable) {
                        this.results.println("Last 30 bytes: " + lastBytes);
                        this.results.println("Number of read() calls: " + numReads);
                        this.results.println("Diagnostics");
                        SSLSecurityStatus status = s.getStatus();
                        this.results.println("Total bytes read: " + totalBytes);
                        this.results.println("Security status of session:");
                        this.results.println(status.toString());
                        if (testRegression) {
                            this.results.println("Regression Tests");
                            this.results.println("Handshake callback event happened: " + (this.handshakeEventHappened ? this.okay : this.failed));
                            String tmp = this.getArgument("filesize");
                            if (!this.isInvalid(tmp)) {
                                this.results.println("filesize: " + this.cmp(tmp, totalBytes));
                            }
                            if (!this.isInvalid(tmp = this.getArgument("status"))) {
                                this.results.println("status: " + this.cmp(tmp, status.getSecurityStatus()));
                            }
                            if (!this.isInvalid(tmp = this.getArgument("sessionKeySize"))) {
                                this.results.println("sessionKeySize: " + this.cmp(tmp, status.getSessionKeySize()));
                            }
                            if (!this.isInvalid(tmp = this.getArgument("sessionSecretSize"))) {
                                this.results.println("sessionSecretSize: " + this.cmp(tmp, status.getSessionSecretSize()));
                            }
                            if (!this.isInvalid(tmp = this.getArgument("cipher"))) {
                                this.results.println("cipher: " + this.cmp(tmp, status.getCipher()));
                            }
                            if (!this.isInvalid(tmp = this.getArgument("issuer"))) {
                                this.results.println("issuer: " + this.cmp(tmp, status.getRemoteIssuer()));
                            }
                            if (!this.isInvalid(tmp = this.getArgument("subject"))) {
                                this.results.println("subject: " + this.cmp(tmp, status.getRemoteSubject()));
                            }
                            if (!this.isInvalid(tmp = this.getArgument("certSerialNum"))) {
                                String serialNum = status.getSerialNumber();
                                this.results.println("certSerialNum: " + this.cmp(tmp, serialNum));
                            }
                        }
                        throw throwable;
                    }
                }
                SSLSecurityStatus status = s.getStatus();
                this.results.println("Total bytes read: " + totalBytes);
                this.results.println("Security status of session:");
                this.results.println(status.toString());
                if (testRegression) {
                    this.results.println("Regression Tests");
                    this.results.println("Handshake callback event happened: " + (this.handshakeEventHappened ? this.okay : this.failed));
                    String tmp = this.getArgument("filesize");
                    if (!this.isInvalid(tmp)) {
                        this.results.println("filesize: " + this.cmp(tmp, totalBytes));
                    }
                    if (!this.isInvalid(tmp = this.getArgument("status"))) {
                        this.results.println("status: " + this.cmp(tmp, status.getSecurityStatus()));
                    }
                    if (!this.isInvalid(tmp = this.getArgument("sessionKeySize"))) {
                        this.results.println("sessionKeySize: " + this.cmp(tmp, status.getSessionKeySize()));
                    }
                    if (!this.isInvalid(tmp = this.getArgument("sessionSecretSize"))) {
                        this.results.println("sessionSecretSize: " + this.cmp(tmp, status.getSessionSecretSize()));
                    }
                    if (!this.isInvalid(tmp = this.getArgument("cipher"))) {
                        this.results.println("cipher: " + this.cmp(tmp, status.getCipher()));
                    }
                    if (!this.isInvalid(tmp = this.getArgument("issuer"))) {
                        this.results.println("issuer: " + this.cmp(tmp, status.getRemoteIssuer()));
                    }
                    if (!this.isInvalid(tmp = this.getArgument("subject"))) {
                        this.results.println("subject: " + this.cmp(tmp, status.getRemoteSubject()));
                    }
                    if (!this.isInvalid(tmp = this.getArgument("certSerialNum"))) {
                        String serialNum = status.getSerialNumber();
                        this.results.println("certSerialNum: " + this.cmp(tmp, serialNum));
                    }
                }
                o.close();
                o = null;
                in.close();
                in = null;
                if (listener != null) {
                    s.removeHandshakeCompletedListener(listener);
                    listener = null;
                }
            }
        }
        catch (Exception e) {
            this.results.println("***** TEST FAILED *****");
            e.printStackTrace(this.results);
            this.results.println("If there is no stack trace, try disabling the JIT and trying again.");
        }
        this.results.println("END OF TEST");
    }

    private String escapeHTML(String s) {
        StringBuilder result = new StringBuilder();
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block5;
                }
                case '>': {
                    result.append("&gt;");
                    continue block5;
                }
                case '&': {
                    result.append("&amp;");
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public SSLClient(PrintStream ps, String verStr, String[] argv) {
        int i;
        this.args = new HashMap();
        this.results = ps;
        this.versionStr = verStr;
        for (i = 0; i < this.argNames.length; ++i) {
            String value = this.values[i];
            if (value == null) continue;
            this.args.put(this.argNames[i], value);
        }
        for (i = 0; i < argv.length; i += 2) {
            this.args.put(argv[i], argv[i + 1]);
        }
    }

    public static void main(String[] argv) throws Exception {
        int i;
        try {
            InitializationValues vals = new InitializationValues(".");
            CryptoManager.initialize(vals);
        }
        catch (KeyDatabaseException kdbe) {
            System.out.println("Couldn't open the key database");
            return;
        }
        catch (CertDatabaseException cdbe) {
            System.out.println("Couldn't open the certificate database");
            return;
        }
        catch (AlreadyInitializedException aie) {
            System.out.println("CryptoManager already initialized???");
            return;
        }
        catch (Exception e) {
            System.out.println("Exception occurred: " + e.getMessage());
            return;
        }
        for (i = 65281; i <= 65287; ++i) {
            if (i == 65285) continue;
            SSLSocket.setCipherPreferenceDefault(i, true);
        }
        i = 0;
        while (cipherSuites[i] != 0) {
            SSLSocket.setCipherPreferenceDefault(cipherSuites[i], true);
            ++i;
        }
        SSLClient x = new SSLClient(System.out, "Stand alone Ver 0.01", argv);
        x.run(true, false);
    }
}

