/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerEncoder;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateIssuerName;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.SerialNumber;
import org.mozilla.jss.netscape.security.x509.UniqueIdentity;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509AttributeName;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertImpl
extends X509Certificate
implements DerEncoder {
    private static final String CANNOT_OVERWRITE_EXISTING_CERTIFICATE = "Cannot overwrite existing certificate";
    private static final String MISSING_CERTIFICATE_TO_ENCODE = "Missing certificate to encode";
    private static final String UNABLE_TO_PARSE_CERTIFICATE_DATA = "Unable to parse certificate data: ";
    public static final Logger logger = LoggerFactory.getLogger(X509CertImpl.class);
    static final long serialVersionUID = -2048442350420423405L;
    private static final String DOT = ".";
    public static final String NAME = "x509";
    public static final String INFO = "info";
    public static final String ALG_ID = "algorithm";
    public static final String SIGNATURE = "signature";
    public static final String SIGNED_CERT = "signed_cert";
    public static final String SUBJECT_DN = "x509.info.subject.dname";
    public static final String ISSUER_DN = "x509.info.issuer.dname";
    public static final String SERIAL_ID = "x509.info.serialNumber.number";
    public static final String PUBLIC_KEY = "x509.info.key.value";
    public static final String SIG_ALG = "x509.algorithm";
    public static final String SIG = "x509.signature";
    private boolean readOnly = false;
    private byte[] signedCert;
    protected X509CertInfo info = null;
    protected AlgorithmId algId;
    protected byte[] signature;
    private static final String KEY_USAGE_OID = "2.5.29.15";
    private static final String BASIC_CONSTRAINT_OID = "2.5.29.19";

    public X509CertImpl() {
    }

    public X509CertImpl(byte[] certData) throws CertificateException {
        this(certData, null);
    }

    public X509CertImpl(byte[] certData, X509CertInfo certInfo) throws CertificateException {
        this.info = certInfo;
        try {
            DerValue in = new DerValue(certData);
            this.parse(in);
            this.signedCert = certData;
        }
        catch (IOException e) {
            throw new CertificateException(UNABLE_TO_PARSE_CERTIFICATE_DATA + e.getMessage(), e);
        }
    }

    public X509CertImpl(InputStream in) throws CertificateException {
        try {
            DerValue val = new DerValue(in);
            this.parse(val);
            this.signedCert = val.toByteArray();
        }
        catch (IOException e) {
            throw new CertificateException(UNABLE_TO_PARSE_CERTIFICATE_DATA + e.getMessage(), e);
        }
    }

    public X509CertImpl(X509CertInfo certInfo) {
        this.info = certInfo;
    }

    public X509CertImpl(DerValue derVal) throws CertificateException {
        try {
            this.parse(derVal);
            this.signedCert = derVal.toByteArray();
        }
        catch (IOException e) {
            throw new CertificateException(UNABLE_TO_PARSE_CERTIFICATE_DATA + e.getMessage(), e);
        }
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return true;
    }

    public void decode(InputStream in) throws CertificateException, IOException {
        DerValue val = new DerValue(in);
        this.parse(val);
        this.signedCert = val.toByteArray();
    }

    public void encode(OutputStream out) throws CertificateEncodingException {
        if (this.signedCert == null) {
            throw new CertificateEncodingException(MISSING_CERTIFICATE_TO_ENCODE);
        }
        try {
            out.write(this.signedCert);
        }
        catch (IOException e) {
            throw new CertificateEncodingException("Unable to encode certificate: " + e.getMessage(), e);
        }
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        if (this.signedCert == null) {
            throw new IOException(MISSING_CERTIFICATE_TO_ENCODE);
        }
        out.write(this.signedCert);
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        if (this.signedCert == null) {
            throw new CertificateEncodingException(MISSING_CERTIFICATE_TO_ENCODE);
        }
        byte[] dup = new byte[this.signedCert.length];
        System.arraycopy(this.signedCert, 0, dup, 0, dup.length);
        return dup;
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String sigProvider = null;
        this.verify(key, sigProvider);
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (this.signedCert == null) {
            throw new CertificateEncodingException("Missing certificate");
        }
        Signature sigVerf = null;
        sigVerf = Signature.getInstance(this.algId.getName(), sigProvider);
        sigVerf.initVerify(key);
        byte[] rawCert = this.info.getEncodedInfo();
        sigVerf.update(rawCert, 0, rawCert.length);
        if (!sigVerf.verify(this.signature)) {
            throw new SignatureException("Signature does not match");
        }
    }

    public void sign(PrivateKey key, String algorithm) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.sign(key, algorithm, null);
    }

    public void sign(PrivateKey key, String algorithm, String provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try (DerOutputStream out = new DerOutputStream();){
            if (this.readOnly) {
                throw new CertificateEncodingException(CANNOT_OVERWRITE_EXISTING_CERTIFICATE);
            }
            Signature sigEngine = null;
            sigEngine = provider == null ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, provider);
            sigEngine.initSign(key);
            this.algId = AlgorithmId.get(sigEngine.getAlgorithm());
            DerOutputStream tmp = new DerOutputStream();
            this.info.encode(tmp);
            byte[] rawCert = tmp.toByteArray();
            this.algId.encode(tmp);
            sigEngine.update(rawCert, 0, rawCert.length);
            this.signature = sigEngine.sign();
            tmp.putBitString(this.signature);
            out.write((byte)48, tmp);
            this.signedCert = out.toByteArray();
            this.readOnly = true;
        }
        catch (IOException e) {
            throw new CertificateEncodingException("Unable to sign certificate: " + e.getMessage(), e);
        }
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        Date date = new Date();
        this.checkValidity(date);
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        CertificateValidity interval = null;
        try {
            interval = (CertificateValidity)this.info.get("validity");
        }
        catch (Exception e) {
            throw new CertificateNotYetValidException("Incorrect validity period: " + e.getMessage());
        }
        if (interval == null) {
            throw new CertificateNotYetValidException("Null validity period");
        }
        interval.valid(date);
    }

    public Object get(String name) throws CertificateParsingException {
        X509AttributeName attr = new X509AttributeName(name);
        String id = attr.getPrefix();
        if (!id.equalsIgnoreCase(NAME)) {
            throw new CertificateParsingException("Invalid root of attribute name, expected [x509], received [" + id + "]");
        }
        id = (attr = new X509AttributeName(attr.getSuffix())).getPrefix();
        if (id.equalsIgnoreCase(INFO)) {
            if (attr.getSuffix() == null) {
                return this.info;
            }
            try {
                return this.info.get(attr.getSuffix());
            }
            catch (IOException | CertificateException e) {
                throw new CertificateParsingException("Unable to get certificate attribute: " + e.getMessage(), e);
            }
        }
        if (id.equalsIgnoreCase(ALG_ID)) {
            return this.algId;
        }
        if (id.equalsIgnoreCase(SIGNATURE)) {
            return this.signature;
        }
        if (id.equalsIgnoreCase(SIGNED_CERT)) {
            return this.signedCert;
        }
        throw new CertificateParsingException("Attribute name not recognized or get() not allowed for the same: " + id);
    }

    public void set(String name, Object obj) throws CertificateException, IOException {
        if (this.readOnly) {
            throw new CertificateException(CANNOT_OVERWRITE_EXISTING_CERTIFICATE);
        }
        X509AttributeName attr = new X509AttributeName(name);
        String id = attr.getPrefix();
        if (!id.equalsIgnoreCase(NAME)) {
            throw new CertificateException("Invalid root of attribute name, expected [x509], received " + id);
        }
        id = (attr = new X509AttributeName(attr.getSuffix())).getPrefix();
        if (id.equalsIgnoreCase(INFO)) {
            if (attr.getSuffix() == null) {
                if (!(obj instanceof X509CertInfo)) {
                    throw new CertificateException("Attribute value should be of type X509CertInfo.");
                }
                this.info = (X509CertInfo)obj;
                this.signedCert = null;
            } else {
                this.info.set(attr.getSuffix(), obj);
                this.signedCert = null;
            }
        } else {
            throw new CertificateException("Attribute name not recognized or set() not allowed for the same: " + id);
        }
    }

    public void delete(String name) throws CertificateException, IOException {
        if (this.readOnly) {
            throw new CertificateException(CANNOT_OVERWRITE_EXISTING_CERTIFICATE);
        }
        X509AttributeName attr = new X509AttributeName(name);
        String id = attr.getPrefix();
        if (!id.equalsIgnoreCase(NAME)) {
            throw new CertificateException("Invalid root of attribute name, expected [x509], received " + id);
        }
        id = (attr = new X509AttributeName(attr.getSuffix())).getPrefix();
        if (id.equalsIgnoreCase(INFO)) {
            if (attr.getSuffix() != null) {
                this.info = null;
            } else {
                this.info.delete(attr.getSuffix());
            }
        } else if (id.equalsIgnoreCase(ALG_ID)) {
            this.algId = null;
        } else if (id.equalsIgnoreCase(SIGNATURE)) {
            this.signature = null;
        } else if (id.equalsIgnoreCase(SIGNED_CERT)) {
            this.signedCert = null;
        } else {
            throw new CertificateException("Attribute name not recognized or delete() not allowed for the same: " + id);
        }
    }

    public Enumeration<String> getElements() {
        Vector<String> elements = new Vector<String>();
        elements.addElement("x509.info");
        elements.addElement(SIG_ALG);
        elements.addElement(SIG);
        elements.addElement("x509.signed_cert");
        return elements.elements();
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String toString() {
        if (this.info == null || this.algId == null || this.signature == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("[\n" + this.info.toString() + "\n  Algorithm: [" + this.algId.toString() + "]\n");
        PrettyPrintFormat pp = new PrettyPrintFormat(" ", 20);
        String signaturebits = pp.toHexString(this.signature);
        sb.append("  Signature:\n" + signaturebits);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public PublicKey getPublicKey() {
        if (this.info == null) {
            return null;
        }
        try {
            return (PublicKey)this.info.get("key.value");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int getVersion() {
        if (this.info == null) {
            return -1;
        }
        try {
            return (Integer)this.info.get("version.number");
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public BigInteger getSerialNumber() {
        if (this.info == null) {
            return null;
        }
        try {
            SerialNumber ser = (SerialNumber)this.info.get("serialNumber.number");
            return ser.getNumber().toBigInteger();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    @Deprecated(since="5.2.0")
    public Principal getSubjectDN() {
        return this.getSubjectName();
    }

    public X500Name getSubjectName() {
        if (this.info == null) {
            return null;
        }
        try {
            String name = "subject.dname";
            return (X500Name)this.info.get(name);
        }
        catch (Exception e) {
            logger.warn("Unable to get subject name: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public CertificateSubjectName getSubjectObj() {
        return this.info.getSubjectObj();
    }

    public X509CertInfo getInfo() {
        return this.info;
    }

    @Override
    @Deprecated(since="5.2.0")
    public Principal getIssuerDN() {
        return this.getIssuerName();
    }

    public X500Name getIssuerName() {
        if (this.info == null) {
            return null;
        }
        try {
            String name = "issuer.dname";
            return (X500Name)this.info.get(name);
        }
        catch (Exception e) {
            logger.warn("Unable to get issuer name: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public CertificateIssuerName getIssuerObj() {
        return this.info.getIssuerObj();
    }

    @Override
    public Date getNotBefore() {
        if (this.info == null) {
            return null;
        }
        try {
            return (Date)this.info.get("validity.notBefore");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Date getNotAfter() {
        if (this.info == null) {
            return null;
        }
        try {
            return (Date)this.info.get("validity.notAfter");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        if (this.info == null) {
            throw new CertificateEncodingException("Uninitialized certificate");
        }
        return this.info.getEncodedInfo();
    }

    @Override
    public byte[] getSignature() {
        if (this.signature == null) {
            return null;
        }
        byte[] dup = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, dup, 0, dup.length);
        return dup;
    }

    @Override
    public String getSigAlgName() {
        if (this.algId == null) {
            return null;
        }
        return this.algId.getName();
    }

    @Override
    public String getSigAlgOID() {
        if (this.algId == null) {
            return null;
        }
        ObjectIdentifier oid = this.algId.getOID();
        return oid.toString();
    }

    @Override
    public byte[] getSigAlgParams() {
        if (this.algId == null) {
            return null;
        }
        try {
            return this.algId.getEncodedParams();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        if (this.info == null) {
            return null;
        }
        try {
            UniqueIdentity id = (UniqueIdentity)this.info.get("issuerID.id");
            return id == null ? null : id.getId();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        if (this.info == null) {
            return null;
        }
        try {
            UniqueIdentity id = (UniqueIdentity)this.info.get("subjectID.id");
            return id == null ? null : id.getId();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (this.info == null) {
            return null;
        }
        try {
            CertificateExtensions exts = (CertificateExtensions)this.info.get("extensions");
            if (exts == null) {
                return null;
            }
            LinkedHashSet<String> extSet = new LinkedHashSet<String>();
            Enumeration<Extension> e = exts.getAttributes();
            while (e.hasMoreElements()) {
                Extension ex = e.nextElement();
                if (!ex.isCritical()) continue;
                extSet.add(ex.getExtensionId().toString());
            }
            return extSet;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (this.info == null) {
            return null;
        }
        try {
            CertificateExtensions exts = (CertificateExtensions)this.info.get("extensions");
            if (exts == null) {
                return null;
            }
            LinkedHashSet<String> extSet = new LinkedHashSet<String>();
            Enumeration<Extension> e = exts.getAttributes();
            while (e.hasMoreElements()) {
                Extension ex = e.nextElement();
                if (ex.isCritical()) continue;
                extSet.add(ex.getExtensionId().toString());
            }
            return extSet;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Extension getExtension(String oid) {
        try {
            CertificateExtensions exts = (CertificateExtensions)this.info.get("extensions");
            if (exts == null) {
                return null;
            }
            ObjectIdentifier findOID = new ObjectIdentifier(oid);
            Extension ex = null;
            Enumeration<Extension> e = exts.getAttributes();
            while (e.hasMoreElements()) {
                ex = e.nextElement();
                ObjectIdentifier inCertOID = ex.getExtensionId();
                if (!inCertOID.equals(findOID)) continue;
                return ex;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getExtensionValue(String oid) {
        try (DerOutputStream out = new DerOutputStream();){
            byte[] byArray;
            CertificateExtensions exts;
            String extAlias = OIDMap.getName(new ObjectIdentifier(oid));
            Extension certExt = null;
            if (extAlias == null) {
                exts = (CertificateExtensions)this.info.get("extensions");
                if (exts == null) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
                ObjectIdentifier findOID = new ObjectIdentifier(oid);
                Extension ex = null;
                Enumeration<Extension> e = exts.getAttributes();
                while (e.hasMoreElements()) {
                    ex = e.nextElement();
                    ObjectIdentifier inCertOID = ex.getExtensionId();
                    if (!inCertOID.equals(findOID)) continue;
                    certExt = ex;
                    break;
                }
            } else {
                certExt = (Extension)this.get(extAlias);
            }
            if (certExt == null) {
                exts = null;
                return exts;
            }
            byte[] extData = certExt.getExtensionValue();
            if (extData == null) {
                byArray = null;
                return byArray;
            }
            out.putOctetString(extData);
            byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean[] getKeyUsage() {
        try {
            String extAlias = OIDMap.getName(new ObjectIdentifier(KEY_USAGE_OID));
            if (extAlias == null) {
                return null;
            }
            KeyUsageExtension certExt = (KeyUsageExtension)this.get(extAlias);
            if (certExt == null) {
                return null;
            }
            return certExt.getBits();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int getBasicConstraints() {
        try {
            String extAlias = OIDMap.getName(new ObjectIdentifier(BASIC_CONSTRAINT_OID));
            if (extAlias == null) {
                return -1;
            }
            BasicConstraintsExtension certExt = (BasicConstraintsExtension)this.get(extAlias);
            if (certExt == null) {
                return -1;
            }
            if (((Boolean)certExt.get("is_ca")).booleanValue()) {
                return (Integer)certExt.get("path_len");
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean getBasicConstraintsIsCA() {
        boolean isCA = false;
        try {
            String extAlias = OIDMap.getName(new ObjectIdentifier(BASIC_CONSTRAINT_OID));
            if (extAlias == null) {
                return false;
            }
            BasicConstraintsExtension certExt = (BasicConstraintsExtension)this.get(extAlias);
            if (certExt == null) {
                return false;
            }
            isCA = (Boolean)certExt.get("is_ca");
        }
        catch (Exception e) {
            return false;
        }
        return isCA;
    }

    private void parse(DerValue val) throws CertificateException, IOException {
        if (this.readOnly) {
            throw new CertificateParsingException(CANNOT_OVERWRITE_EXISTING_CERTIFICATE);
        }
        this.readOnly = true;
        DerValue[] seq = new DerValue[]{val.data.getDerValue(), val.data.getDerValue(), val.data.getDerValue()};
        if (val.data.available() != 0) {
            throw new CertificateParsingException("signed overrun, bytes = " + val.data.available());
        }
        if (seq[0].tag != 48) {
            throw new CertificateParsingException("signed fields invalid");
        }
        this.algId = AlgorithmId.parse(seq[1]);
        this.signature = seq[2].getBitString();
        if (seq[1].data.available() != 0) {
            throw new CertificateParsingException("algid field overrun");
        }
        if (seq[2].data.available() != 0) {
            throw new CertificateParsingException("signed fields overrun");
        }
        if (this.info == null) {
            this.info = new X509CertInfo(seq[0]);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws CertificateException {
        this.encode(stream);
    }

    private void readObject(ObjectInputStream stream) throws CertificateException, IOException {
        this.decode(stream);
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertificateRep1("X.509", this.getEncoded());
        }
        catch (CertificateException e) {
            throw new NotSerializableException("java.security.cert.Certificate: X.509: " + e.getMessage());
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.signature);
        result = 31 * result + Arrays.hashCode(this.signedCert);
        result = 31 * result + Objects.hash(this.algId, this.info, this.readOnly);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        X509CertImpl other = (X509CertImpl)obj;
        return Objects.equals(this.algId, other.algId) && Objects.equals(this.info, other.info) && this.readOnly == other.readOnly && Arrays.equals(this.signature, other.signature) && Arrays.equals(this.signedCert, other.signedCert);
    }

    protected static class CertificateRep1
    implements Serializable {
        private static final long serialVersionUID = -5207881613631592409L;
        private String type1;
        private byte[] data1;

        protected CertificateRep1(String type, byte[] data) {
            this.type1 = type;
            this.data1 = data;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                CertificateFactory cf = CertificateFactory.getInstance(this.type1);
                return new X509CertImpl(this.data1);
            }
            catch (CertificateException e) {
                throw new NotSerializableException("java.security.cert.Certificate: " + this.type1 + ": " + e.getMessage());
            }
        }
    }
}

