/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.commons.lang3.ArrayUtils;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cert {
    private static Logger logger = LoggerFactory.getLogger(Cert.class);
    public static final String HEADER = "-----BEGIN CERTIFICATE-----";
    public static final String FOOTER = "-----END CERTIFICATE-----";
    public static final String PKCS7_HEADER = "-----BEGIN PKCS7-----";
    public static final String PKCS7_FOOTER = "-----END PKCS7-----";
    public static final String REQUEST_HEADER = "-----BEGIN CERTIFICATE REQUEST-----";
    public static final String REQUEST_FOOTER = "-----END CERTIFICATE REQUEST-----";

    public static SignatureAlgorithm mapAlgorithmToJss(String algname) {
        if (algname.equals("MD5withRSA")) {
            return SignatureAlgorithm.RSASignatureWithMD5Digest;
        }
        if (algname.equals("MD2withRSA")) {
            return SignatureAlgorithm.RSASignatureWithMD2Digest;
        }
        if (algname.equals("SHA1withRSA")) {
            return SignatureAlgorithm.RSASignatureWithSHA1Digest;
        }
        if (algname.equals("SHA1withDSA")) {
            return SignatureAlgorithm.DSASignatureWithSHA1Digest;
        }
        if (algname.equals("SHA256withRSA")) {
            return SignatureAlgorithm.RSASignatureWithSHA256Digest;
        }
        if (algname.equals("SHA384withRSA")) {
            return SignatureAlgorithm.RSASignatureWithSHA384Digest;
        }
        if (algname.equals("SHA512withRSA")) {
            return SignatureAlgorithm.RSASignatureWithSHA512Digest;
        }
        if (algname.equals("SHA1withEC")) {
            return SignatureAlgorithm.ECSignatureWithSHA1Digest;
        }
        if (algname.equals("SHA256withEC")) {
            return SignatureAlgorithm.ECSignatureWithSHA256Digest;
        }
        if (algname.equals("SHA384withEC")) {
            return SignatureAlgorithm.ECSignatureWithSHA384Digest;
        }
        if (algname.equals("SHA512withEC")) {
            return SignatureAlgorithm.ECSignatureWithSHA512Digest;
        }
        if (algname.equals("SHA256withRSA/PSS")) {
            return SignatureAlgorithm.RSAPSSSignatureWithSHA256Digest;
        }
        if (algname.equals("SHA384withRSA/PSS")) {
            return SignatureAlgorithm.RSAPSSSignatureWithSHA384Digest;
        }
        if (algname.equals("SHA512withRSA/PSS")) {
            return SignatureAlgorithm.RSAPSSSignatureWithSHA512Digest;
        }
        return null;
    }

    public static String stripBrackets(String s) {
        if (s == null) {
            return s;
        }
        if (s.startsWith(HEADER) && s.endsWith(FOOTER)) {
            return s.substring(HEADER.length(), s.length() - FOOTER.length());
        }
        if (s.startsWith(PKCS7_HEADER) && s.endsWith(PKCS7_FOOTER)) {
            return s.substring(PKCS7_HEADER.length(), s.length() - PKCS7_FOOTER.length());
        }
        if (s.startsWith("-----BEGIN PKCS #7 SIGNED DATA-----") && s.endsWith("-----END PKCS #7 SIGNED DATA-----")) {
            return s.substring(35, s.length() - 33);
        }
        return s;
    }

    public static String stripCRLBrackets(String s) {
        if (s == null) {
            return s;
        }
        if (s.startsWith("-----BEGIN CERTIFICATE REVOCATION LIST-----") && s.endsWith("-----END CERTIFICATE REVOCATION LIST-----")) {
            return s.substring(43, s.length() - 41);
        }
        return s;
    }

    public static String stripCertBrackets(String s) {
        return Cert.stripBrackets(s);
    }

    public static X509CertImpl mapCert(String mime64) throws IOException {
        mime64 = Cert.stripCertBrackets(mime64.trim());
        String newval = Cert.normalizeCertStr(mime64);
        byte[] rawPub = Utils.base64decode(newval);
        X509CertImpl cert = null;
        try {
            cert = new X509CertImpl(rawPub);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return cert;
    }

    public static X509Certificate[] mapCertFromPKCS7(String mime64) throws IOException {
        mime64 = Cert.stripCertBrackets(mime64.trim());
        String newval = Cert.normalizeCertStr(mime64);
        byte[] rawPub = Utils.base64decode(newval);
        PKCS7 p7 = null;
        try {
            p7 = new PKCS7(rawPub);
        }
        catch (Exception e) {
            throw new IOException("Unable to parse PKCS #7 data: " + e.getMessage(), e);
        }
        return p7.getCertificates();
    }

    public static X509CRL mapCRL(String mime64) throws IOException {
        mime64 = Cert.stripCRLBrackets(mime64.trim());
        String newval = Cert.normalizeCertStr(mime64);
        byte[] rawPub = Utils.base64decode(newval);
        X509CRLImpl crl = null;
        try {
            crl = new X509CRLImpl(rawPub);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return crl;
    }

    public static X509CRL mapCRL1(String mime64) throws IOException {
        mime64 = Cert.stripCRLBrackets(mime64.trim());
        byte[] rawPub = Utils.base64decode(mime64);
        X509CRLImpl crl = null;
        try {
            crl = new X509CRLImpl(rawPub);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        return crl;
    }

    public static String normalizeCertStr(String s) {
        StringBuilder val = new StringBuilder();
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) == '\n' || s.charAt(i) == '\r' || s.charAt(i) == '\"' || s.charAt(i) == ' ') continue;
                val.append(s.charAt(i));
            }
        }
        return val.toString();
    }

    public static String normalizeCertStrAndReq(String s) {
        StringBuilder val = new StringBuilder();
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) == '\n' || s.charAt(i) == '\r' || s.charAt(i) == '\"') continue;
                val.append(s.charAt(i));
            }
        }
        return val.toString();
    }

    public static byte[] parseCertificate(String cert) {
        String encoded = Cert.normalizeCertStrAndReq(cert);
        String b64 = Cert.stripBrackets(encoded);
        return Utils.base64decode(b64);
    }

    public static X509Certificate[] sortCertificateChain(X509Certificate[] certs) throws Exception {
        X509Certificate cert2;
        if (certs == null) {
            return null;
        }
        if (certs.length == 0) {
            return certs;
        }
        LinkedHashMap<String, X509Certificate> certMap = new LinkedHashMap<String, X509Certificate>();
        HashMap<String, String> parentMap = new HashMap<String, String>();
        HashMap<String, String> childMap = new HashMap<String, String>();
        for (X509Certificate cert2 : certs) {
            String subjectDN = cert2.getSubjectX500Principal().toString();
            String issuerDN = cert2.getIssuerX500Principal().toString();
            if (certMap.containsKey(subjectDN)) {
                throw new Exception("Duplicate certificate: " + subjectDN);
            }
            certMap.put(subjectDN, cert2);
            if (subjectDN.equals(issuerDN)) continue;
            if (childMap.containsKey(issuerDN)) {
                throw new Exception("Branched chain: " + issuerDN);
            }
            parentMap.put(subjectDN, issuerDN);
            childMap.put(issuerDN, subjectDN);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Certificates:");
            for (String subjectDN : certMap.keySet()) {
                String child;
                logger.debug(" - " + subjectDN);
                String parent = (String)parentMap.get(subjectDN);
                if (parent != null) {
                    logger.debug("   parent: " + parent);
                }
                if ((child = (String)childMap.get(subjectDN)) == null) continue;
                logger.debug("   child: " + child);
            }
        }
        ArrayList leafCerts = new ArrayList();
        leafCerts.addAll(certMap.keySet());
        leafCerts.removeAll(childMap.keySet());
        if (leafCerts.isEmpty()) {
            throw new Exception("Unable to find leaf certificate");
        }
        if (leafCerts.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (String subjectDN : leafCerts) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("[" + subjectDN + "]");
            }
            throw new Exception("Multiple leaf certificates: " + sb);
        }
        LinkedList<X509Certificate> chain = new LinkedList<X509Certificate>();
        String current = (String)leafCerts.get(0);
        while (current != null && (cert2 = (X509Certificate)certMap.get(current)) != null) {
            chain.addFirst(cert2);
            current = (String)parentMap.get(current);
        }
        return chain.toArray(new X509Certificate[chain.size()]);
    }

    public static X509Certificate[] sortCertificateChain(X509Certificate[] certs, boolean reverse) throws Exception {
        certs = Cert.sortCertificateChain(certs);
        if (reverse) {
            ArrayUtils.reverse((Object[])certs);
        }
        return certs;
    }
}

