/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.TokenException;

public abstract class KeyPairGeneratorSpi {
    public abstract void initialize(int var1, SecureRandom var2);

    public abstract void initialize(AlgorithmParameterSpec var1, SecureRandom var2) throws InvalidAlgorithmParameterException;

    public abstract KeyPair generateKeyPair() throws TokenException;

    public abstract int getCurveCodeByName(String var1) throws InvalidParameterException;

    public abstract void temporaryPairs(boolean var1);

    public abstract void sensitivePairs(boolean var1);

    public abstract void extractablePairs(boolean var1);

    public abstract boolean keygenOnInternalToken();

    public abstract void setKeyPairUsages(Usage[] var1, Usage[] var2);

    public static enum Usage {
        ENCRYPT(256L),
        DECRYPT(512L),
        SIGN(2048L),
        SIGN_RECOVER(4096L),
        VERIFY(8192L),
        VERIFY_RECOVER(16384L),
        WRAP(131072L),
        UNWRAP(262144L),
        DERIVE(524288L);

        private final long value;

        private Usage(long value) {
            this.value = value;
        }

        @Deprecated
        public int getVal() {
            return this.ordinal();
        }

        public long value() {
            return this.value;
        }
    }
}

