/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.CharacterString;
import org.mozilla.jss.asn1.CountingStream;
import org.mozilla.jss.asn1.ENUMERATED;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.IA5String;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.NULL;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;

public class SEQUENCE
extends SET {
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 16L);

    @Override
    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return new Template();
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.BERencode(implicitTag, ostream);
    }

    public static void main(String[] args) {
        block25: {
            try {
                if (args.length > 0) {
                    int i;
                    byte[] stuff;
                    Template type = new Template();
                    type.addOptionalElement(new Tag(15L), new INTEGER.Template());
                    type.addElement(new Tag(16L), new INTEGER.Template(), new INTEGER(42L));
                    type.addElement(new INTEGER.Template());
                    type.addElement(new BOOLEAN.Template());
                    type.addElement(new INTEGER.Template());
                    type.addOptionalElement(new Tag(12L), new INTEGER.Template());
                    type.addElement(new BOOLEAN.Template());
                    type.addElement(new Tag(13L), new INTEGER.Template(), new INTEGER(53L));
                    type.addElement(new INTEGER.Template());
                    type.addElement(new INTEGER.Template());
                    type.addOptionalElement(new Tag(14L), new INTEGER.Template());
                    type.addElement(new OBJECT_IDENTIFIER.Template());
                    type.addElement(new NULL.Template());
                    type.addElement(new EXPLICIT.Template(new Tag(27L), new INTEGER.Template()));
                    type.addElement(new ENUMERATED.Template());
                    type.addElement(new OCTET_STRING.Template());
                    type.addElement(new IA5String.Template());
                    CHOICE.Template choice = new CHOICE.Template();
                    choice.addElement(new Tag(23L), new INTEGER.Template());
                    choice.addElement(new BOOLEAN.Template());
                    type.addElement(choice);
                    type.addElement(new BIT_STRING.Template());
                    type.addElement(new ANY.Template());
                    type.addElement(new PrintableString.Template());
                    type.addElement(new OF_Template(new INTEGER.Template()));
                    type.addElement(new OF_Template(new INTEGER.Template()));
                    try (FileInputStream fin = new FileInputStream(args[0]);){
                        System.out.println("Available: " + fin.available());
                        stuff = new byte[fin.available()];
                        ASN1Util.readFully(stuff, fin);
                    }
                    SET s = null;
                    for (i = 0; i < 1; ++i) {
                        s = (SEQUENCE)type.decode(new ByteArrayInputStream(stuff));
                    }
                    for (i = 0; i < s.size(); ++i) {
                        ASN1Value v = s.elementAt(i);
                        if (v instanceof ENUMERATED) {
                            ENUMERATED en = (ENUMERATED)v;
                            System.out.println("ENUMERATED: " + en);
                            continue;
                        }
                        if (v instanceof INTEGER) {
                            INTEGER in = (INTEGER)v;
                            System.out.println("INTEGER: " + in);
                            continue;
                        }
                        if (v instanceof BOOLEAN) {
                            BOOLEAN bo = (BOOLEAN)v;
                            System.out.println("BOOLEAN: " + bo);
                            continue;
                        }
                        if (v instanceof OBJECT_IDENTIFIER) {
                            OBJECT_IDENTIFIER oid = (OBJECT_IDENTIFIER)v;
                            System.out.println("OID: " + oid);
                            continue;
                        }
                        if (v instanceof NULL) {
                            NULL n = (NULL)v;
                            System.out.println("NULL");
                            continue;
                        }
                        if (v instanceof EXPLICIT) {
                            EXPLICIT ex = (EXPLICIT)v;
                            INTEGER in = (INTEGER)ex.getContent();
                            System.out.println("EXPLICIT [" + ex.getTag() + "]: INTEGER: " + in);
                            continue;
                        }
                        if (v instanceof OCTET_STRING) {
                            OCTET_STRING os = (OCTET_STRING)v;
                            byte[] bytes = os.toByteArray();
                            System.out.print("OCTET_STRING: ");
                            for (int j = 0; j < bytes.length; ++j) {
                                System.out.print(bytes[j] + " ");
                            }
                            System.out.println("");
                            continue;
                        }
                        if (v instanceof CharacterString) {
                            CharacterString cs = (CharacterString)v;
                            System.out.println("String: " + cs);
                            continue;
                        }
                        if (v instanceof BIT_STRING) {
                            BIT_STRING bs = (BIT_STRING)v;
                            System.out.print("BIT_STRING: padCount=" + bs.getPadCount() + " : ");
                            byte[] bits = bs.getBits();
                            for (int j = 0; j < bits.length; ++j) {
                                System.out.print(bits[j] + " ");
                            }
                            System.out.println("");
                            continue;
                        }
                        if (v instanceof ANY) {
                            ANY any = (ANY)v;
                            Tag tag = any.getTag();
                            System.out.println("Got ANY, tag is " + tag);
                            ByteArrayInputStream bos = new ByteArrayInputStream(any.getEncoded());
                            INTEGER in = (INTEGER)new INTEGER.Template().decode(bos);
                            System.out.println("    INTEGER: " + in);
                            continue;
                        }
                        if (v instanceof SEQUENCE) {
                            SEQUENCE seq = (SEQUENCE)v;
                            System.out.println("SEQUENCE: ");
                            for (int j = 0; j < seq.size(); ++j) {
                                INTEGER in = (INTEGER)seq.elementAt(j);
                                System.out.println("    INTEGER: " + in);
                            }
                            continue;
                        }
                        System.out.println("Unknown value");
                    }
                    break block25;
                }
                SEQUENCE seq = new SEQUENCE();
                seq.addElement(new INTEGER(5L));
                seq.addElement(new BOOLEAN(true));
                seq.addElement(new INTEGER(-322L));
                seq.addElement(new BOOLEAN(false));
                seq.addElement(new INTEGER(0L));
                seq.addElement(new INTEGER("2934293834242"));
                seq.addElement(new OBJECT_IDENTIFIER(new long[]{1L, 2L, 127L, 563L, 1231982L}));
                seq.addElement(new NULL());
                seq.addElement(new EXPLICIT(new Tag(27L), new INTEGER(39L)));
                seq.addElement(new ENUMERATED(983L));
                seq.addElement(new OCTET_STRING(new byte[]{0, -1, -52}));
                seq.addElement(new IA5String("foobar"));
                seq.addElement(new Tag(23L), new INTEGER(234L));
                byte[] bits = new byte[]{-128, -1, 15};
                seq.addElement(new BIT_STRING(bits, 3));
                seq.addElement(new INTEGER(82734L));
                seq.addElement(new PrintableString("I'm printable??"));
                SEQUENCE nested = new SEQUENCE();
                nested.addElement(new INTEGER(5L));
                nested.addElement(new INTEGER(6L));
                seq.addElement(nested);
                nested = new SEQUENCE();
                seq.addElement(nested);
                seq.encode(System.out);
                System.out.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class Template
    implements ASN1Template {
        private ArrayList<Element> elements = new ArrayList();

        private void addElement(Element el) {
            this.elements.add(el);
        }

        private void insertElementAt(Element e, int index) {
            this.elements.add(index, e);
        }

        public void addElement(ASN1Template t) {
            this.addElement(new Element(null, t, false));
        }

        public void insertElementAt(ASN1Template t, int index) {
            this.insertElementAt(new Element(null, t, false), index);
        }

        public void addElement(Tag implicitTag, ASN1Template t) {
            this.addElement(new Element(implicitTag, t, false));
        }

        public void insertElementAt(Tag implicit, ASN1Template t, int index) {
            this.insertElementAt(new Element(implicit, t, false), index);
        }

        public void addOptionalElement(ASN1Template t) {
            this.addElement(new Element(null, t, true));
        }

        public void insertOptionalElementAt(ASN1Template t, int index) {
            this.insertElementAt(new Element(null, t, true), index);
        }

        public void addOptionalElement(Tag implicitTag, ASN1Template t) {
            this.addElement(new Element(implicitTag, t, true));
        }

        public void insertOptionalElementAt(Tag implicit, ASN1Template t, int index) {
            this.insertElementAt(new Element(implicit, t, true), index);
        }

        public void addElement(ASN1Template t, ASN1Value def) {
            this.addElement(new Element(null, t, def));
        }

        public void insertElementAt(ASN1Template t, ASN1Value def, int index) {
            this.insertElementAt(new Element(null, t, def), index);
        }

        public void addElement(Tag implicitTag, ASN1Template t, ASN1Value def) {
            this.addElement(new Element(implicitTag, t, def));
        }

        public void insertElementAt(Tag implicit, ASN1Template t, ASN1Value def, int index) {
            this.insertElementAt(new Element(implicit, t, def), index);
        }

        public Tag implicitTagAt(int index) {
            return this.elements.get(index).getImplicitTag();
        }

        public ASN1Template templateAt(int index) {
            return this.elements.get(index).getTemplate();
        }

        public boolean isOptionalAt(int index) {
            return this.elements.get(index).isOptional();
        }

        public ASN1Value defaultAt(int index) {
            return this.elements.get(index).getDefault();
        }

        public int size() {
            return this.elements.size();
        }

        public void removeAllElements() {
            this.elements.clear();
        }

        public void removeElementAt(int index) {
            this.elements.remove(index);
        }

        Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), istream);
        }

        @Override
        public ASN1Value decode(Tag tag, InputStream istream) throws IOException, InvalidBERException {
            int index = 0;
            try {
                ASN1Header header = new ASN1Header(istream);
                header.validate(tag, Form.CONSTRUCTED);
                long remainingContent = header.getContentLength();
                boolean repeatableElement = false;
                SEQUENCE seq = new SEQUENCE();
                ASN1Header lookAhead = null;
                for (index = 0; index < this.size(); ++index) {
                    ASN1Value val;
                    lookAhead = remainingContent == 0L ? null : ASN1Header.lookAhead(istream);
                    Element e = this.elements.get(index);
                    if (lookAhead == null || lookAhead.isEOC() || !e.tagMatch(lookAhead.getTag())) {
                        if (e.isRepeatable()) {
                            repeatableElement = true;
                            continue;
                        }
                        if (e.isOptional()) {
                            seq.addElement(null);
                            continue;
                        }
                        if (e.getDefault() != null) {
                            seq.addElement(e.getDefault());
                            continue;
                        }
                        String tagDesc = lookAhead == null ? "(null)" : lookAhead.getTag().toString();
                        throw new InvalidBERException("Missing item #" + index + ": found " + tagDesc);
                    }
                    ASN1Template t = e.getTemplate();
                    try (CountingStream countstream = new CountingStream(istream);){
                        val = e.getImplicitTag() == null ? t.decode(countstream) : t.decode(e.getImplicitTag(), countstream);
                        long len = countstream.getNumRead();
                        if (remainingContent != -1L) {
                            if (remainingContent < len) {
                                throw new InvalidBERException("Item went " + (len - remainingContent) + " bytes past the end of the SEQUENCE");
                            }
                            remainingContent -= len;
                        }
                    }
                    if (e.producesOutput()) {
                        if (e.getImplicitTag() == null) {
                            seq.addElement(val);
                        } else {
                            seq.addElement(e.getImplicitTag(), val);
                        }
                    }
                    if (!e.isRepeatable()) continue;
                    repeatableElement = true;
                    --index;
                }
                if (remainingContent > 0L) {
                    throw new InvalidBERException("SEQUENCE is " + remainingContent + " bytes longer than expected");
                }
                assert (remainingContent == 0L || remainingContent == -1L);
                if (remainingContent == -1L && !(lookAhead = new ASN1Header(istream)).isEOC()) {
                    throw new InvalidBERException("No end-of-contents marker");
                }
                if (!repeatableElement) assert (index == seq.size());
                return seq;
            }
            catch (InvalidBERException e) {
                e.append("SEQUENCE(item #" + index + ")");
                throw e;
            }
        }

        static class Element {
            private boolean doesProduceOutput = true;
            private boolean repeatable;
            private boolean optional;
            private Tag implicitTag = null;
            private ASN1Template type;
            private ASN1Value defaultVal = null;

            public Element(Tag implicitTag, ASN1Template type, boolean optional) {
                this(implicitTag, type, optional, true);
            }

            public Element(Tag implicitTag, ASN1Template type, boolean optional, boolean doesProduceOutput) {
                this.type = type;
                this.defaultVal = null;
                this.optional = optional;
                this.implicitTag = implicitTag;
                this.doesProduceOutput = doesProduceOutput;
            }

            public Element(Tag implicitTag, ASN1Template type, ASN1Value defaultVal) {
                this.type = type;
                this.defaultVal = defaultVal;
                this.optional = false;
                this.implicitTag = implicitTag;
            }

            boolean producesOutput() {
                return this.doesProduceOutput;
            }

            void makeRepeatable() {
                this.repeatable = true;
            }

            boolean isRepeatable() {
                return this.repeatable;
            }

            public boolean isOptional() {
                return this.optional;
            }

            public Tag getImplicitTag() {
                return this.implicitTag;
            }

            public boolean tagMatch(Tag tag) {
                if (this.implicitTag != null) {
                    return this.implicitTag.equals(tag);
                }
                return this.type.tagMatch(tag);
            }

            public ASN1Template getTemplate() {
                return this.type;
            }

            public ASN1Value getDefault() {
                return this.defaultVal;
            }
        }
    }

    public static class OF_Template
    implements ASN1Template {
        Template template;

        private OF_Template() {
        }

        public OF_Template(ASN1Template type) {
            this.template = new Template();
            Template.Element el = new Template.Element(null, type, true);
            el.makeRepeatable();
            this.template.addElement(el);
        }

        public static OF_Template makeOutputlessOFTemplate(ASN1Template type) {
            OF_Template t = new OF_Template();
            t.template = new Template();
            Template.Element el = new Template.Element(null, type, true, false);
            el.makeRepeatable();
            t.template.addElement(el);
            return t;
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.template.decode(istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            return this.template.decode(implicitTag, istream);
        }
    }
}

