/** BEGIN COPYRIGHT BLOCK
 * This Program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; version 2 of the License.
 *
 * This Program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this Program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Copyright (C) 2005 Red Hat, Inc.
 * All rights reserved.
 * END COPYRIGHT BLOCK **/


#ifndef __COOLKEY_API_H__
#define __COOLKEY_API_H__


typedef struct tokenInfo {
    int keyType;
    char* cuid;
    char* atr;
    char* issuerInfo;
    char* issuer;
    char* issuedTo;
    unsigned int   status;
} tokenInfo;

#ifdef __cplusplus
extern "C" {
#endif

typedef int (*CoolKeyNotifyCallback)(void *data,
   unsigned long aKeyType, const char *aKeyID, unsigned long aKeyState,
   unsigned long aData, const char *aStrData);

void coolkey_init(const char *db_dir,CoolKeyNotifyCallback cb, void *notifyClient,const char *dbusUniqueName);

void coolkey_destroy();

tokenInfo *coolkey_get_token_info(int keyType,const char *keyID);
void coolkey_free_token_info(tokenInfo *tInfo);

#ifdef __cplusplus
}
#endif
#endif /* __COOLKEY_MGR_H__ */

