Elpres v1.0.1 2021-08-10

# Short description

The `elpres` class is intended to be used for presentations on a screen or
with a beamer/projector. It is derived from LaTeX’s article class and can
be used with with LaTeX, pdfLaTeX and LuaLaTeX. The default "virtual paper
size" of presentations generated by this class corresponds to a 4:3
(width:height) aspect ratio. Other aspect ratios for widescreen monitors
(16:9, 16:10) are available. 

The elpres class requires: `ifthen`, `fancyhdr`, `hyperref`, `graphicx`,
`xcolor` and `geometry`.

For enhanced features the packages `ragged2e`, `overlays`, `wallpaper`,
`eso-pic`, `tcolorbox` and `footmisc` are useful.

A homepage for the elpres project: http://vkiefel.de/elpres.html with
additional material.

# Changes in v1.0.1

* A new class option `ballsymb` was added,
* The manual was updated,
* Detailed installation instructions for manual installation were
  updated in this file (`README.md`).


# Installation 

For a working installation of `elpres.cls` it is required that all of the
following files:

	elpres.cls,
	elpresbluelightgrayscheme.sty,
	elpresgrayscheme.sty,
	elpreswhitebluescheme.sty,
	elpreswhiteredscheme.sty,
	elpreswhitetealscheme.sty,
	ep-ball-01.png,
	ep-ball-02.png,
	ep-ball-03.png,
	ep-ball-04.png,
	ep-ball-05.png,
	ep-ball-01.eps,
	ep-ball-02.eps,
	ep-ball-03.eps,
	ep-ball-04.eps,
	ep-ball-05.eps

(in short: `elpres.cls` and all `*.sty`, `*.png` and `*.eps` files) are
copied into a directory in the `.../tex/...`-branch of a `texmf`-tree
like `../texmf/tex/latex/elpres`, where `texmf` may be `texmf-dist` or
`texmf-local` or an analogous directory. 

The manual and the example file:

	elpres-manual.pdf,
	elpres-manual.tex,
	elpres-example.pdf,
	elpres-example.tex,
	ctan-lion.pdf
	
are to be copied into a directory of the `.../doc/...`-branch of a
`texmf`-tree like `../texmf/doc/latex/elpres`, where `texmf` may be
`texmf-dist` or `texmf-local` or an analogous directory.  Finally the file
location database (e.g. `ls-R`) should be updated. More details can be found
in the manual.

# Support

The project web page is found on 
[http://vkiefel.de/elpres.html](http://vkiefel.de/elpres.html)

# License

This work may be distributed and/or modified under the conditions of the
LaTeX Project Public License (LPPL). The latest version of this license is
available in the file:
[http://www.latex-project.org/lppl.txt](http://www.latex-project.org/lppl.txt)


Current maintainer of `elpres` is Volker Kiefel.
