#******************************************************************************
# Copyright (c) 2022 Advanced Micro Devices, Inc. All rights reserved.
#
#Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
#1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
#2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
#3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#*******************************************************************************

#------------------------------------------------------------------------------
#  This script runs cnn_benchmarks for GoogleNet, Resent50, Resnet152, VGG11
#  models and gives throghput numbers
#
#------------------------------------------------------------------------------
python -c 'import torchvision'

if [[ $? -ne 0 ]]
then
    echo "ERROR: Torchvision is not installed"
    exit
fi

torch_vision_version="$(python -c "import torchvision; print(torchvision.__version__)")"
if [ `echo $torch_vision_version | grep -c "0.13.0+cpu" ` -gt 0 ]
    then
        echo "Torchvision 0.13.0 is installed"
    else
        echo "ERROR: Inappropriate Torchvision version is installed"
        exit
fi

if [ "$(python -c "import torch; print(torch._C.has_zendnn)")" = "True" ];
    then
        echo "PyTorch+ZenDNN is installed"
    else
        echo "WARNING: Current PyTorch is not built with ZenDNN support"
fi

# Extracting NPS settings
N="$(lscpu | awk '/NUMA node\(s\):/{print $3}')"
S="$(lscpu | awk '/Socket\(s\):/{print $2}')"
Y=$((N/S))
if [[ $Y == 1 ]];
then
    NPS='--cpunodebind=0 --interleave=0'
elif [[ $Y == 2 ]];
then
    NPS='--cpunodebind=0-1 --interleave=0-1'
else [[ $Y == 4 ]];
    NPS='--cpunodebind=0-3 --interleave=0-3'
fi

BATCH_SIZE=640
NUM_OF_BATCHES=100
WARMUP_SIZE=10

#command for benchmark
numactl $NPS python scripts/pt_cnn_benchmarks.py --arch resnet50 --batch_size $BATCH_SIZE --iterations $NUM_OF_BATCHES --warmups $WARMUP_SIZE
numactl $NPS python scripts/pt_cnn_benchmarks.py --arch resnet152 --batch_size $BATCH_SIZE --iterations $NUM_OF_BATCHES --warmups $WARMUP_SIZE
numactl $NPS python scripts/pt_cnn_benchmarks.py --arch googlenet --batch_size $BATCH_SIZE --iterations $NUM_OF_BATCHES --warmups $WARMUP_SIZE
numactl $NPS python scripts/pt_cnn_benchmarks.py --arch vgg11 --batch_size $BATCH_SIZE --iterations $NUM_OF_BATCHES --warmups $WARMUP_SIZE
