#*******************************************************************************
# Copyright (c) 2022 Advanced Micro Devices, Inc. All rights reserved.
#
#Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
#1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
#2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
#3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#*******************************************************************************

#-----------------------------------------------------------------------------
#   PT_ZenDNN_setup_release.sh
#   This script sets up PT + ZenDNN Release binary package
#
#   Prerequisite:
#   1. Appropriate conda env should be created and activated
#----------------------------------------------------------------------------

# Source ZenDNN env settings
source scripts/zendnn_PT_env_setup.sh
#-----------------------------------------------------------------------------
# Check ZENDNN_PARENT_FOLDER, PYTORCH_GIT_ROOT is defined
if [ -z "$ZENDNN_PARENT_FOLDER" ];
then
    echo "Error: Environment variable ZENDNN_PARENT_FOLDER needs to be set"
    return
else
    echo "ZENDNN_PARENT_FOLDER: $ZENDNN_PARENT_FOLDER"
fi
#-----------------------------------------------------------------------------

# Install whl file
cd $ZENDNN_PARENT_FOLDER

WHL_FILE=$(find ./ -maxdepth 1 -name "*.whl")
echo $WHL_FILE

# Installing PT wheel inside the conda env
echo "install PT whl"
python -m pip install $WHL_FILE
retVal=$?
if [ $retVal -ne 0 ]; then
    echo "Error while install $WHL_FILE"
    return
fi

echo "To check the installed version of PT:"
python -c 'import torch as pt; print(pt.__version__)'
retVal=$?
if [ $retVal -ne 0 ]; then
    echo "Issue with Installing Pytorch"
    return
fi

#-----------------------------------------------------------------------------
# Finally go to $ZENDNN_PARENT_FOLDER
cd $ZENDNN_PARENT_FOLDER

echo "ZenDNN Release Setup is complete"
echo "------------------------------------------------------------------------"
