/* SPDX-License-Identifier: LGPL-2.1+ */
#pragma once

#include <stddef.h>

#include "macro.h"
#include "missing.h"

typedef struct LockFile {
        char *path;
        int fd;
        int operation;
} LockFile;

int make_lock_file(const char *p, int operation, LockFile *ret);
int make_lock_file_for(const char *p, int operation, LockFile *ret);
void release_lock_file(LockFile *f);

#define LOCK_FILE_INIT { .fd = -1, .path = NULL }
