#!/usr/bin/env python
#
# (C)2012 Red Hat, Inc., Lukas Czerner <lczerner@redhat.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Unittests for the system storage manager btrfs backend


import unittest
from ssmlib import main
from ssmlib import misc
from ssmlib import problem
from ssmlib.backends import crypt
from tests.unittests.common import *
from unittest.mock import MagicMock, patch

IGNORE_CMDS = ['udevadm']

class CryptFunctionCheck(MockSystemDataSource):

    def test_get_version(self):
        """Traceback (most recent call last):
        File "./test.py", line 32, in <module>
            from ssmlib import main
        File "/var/str/source/ssmlib/main.py", line 31, in <module>
            from ssmlib.backends import lvm, crypt, btrfs, md, multipath
        File "/var/str/source/ssmlib/backends/crypt.py", line 60, in <module>
            CRYPTSETUP_VERSION = get_cryptsetup_version()
        File "/var/str/source/ssmlib/backends/crypt.py", line 55, in get_cryptsetup_version
            version = list(map(int, output.strip().split()[-1].split('.', 3)))
        ValueError: invalid literal for int() with base 10: '0-rc0'
                """

        mock = MagicMock(return_value=(None, "cryptsetup 1.2.3-rc0"))
        with patch('ssmlib.misc.run', mock):
            self.assertEqual([1, 2, 3], crypt.get_cryptsetup_version())

        mock = MagicMock(return_value=(None, "cryptsetup 10.21.32"))
        with patch('ssmlib.misc.run', mock):
            self.assertEqual([10, 21, 32], crypt.get_cryptsetup_version())