.TH "rsync" "1" "28 Jan 2018" "" ""
.SH "NAME"
rsync \- a fast, versatile, remote (and local) file\-copying tool
.SH "SYNOPSIS"

.PP 
.nf 
Local:  rsync [OPTION...] SRC... [DEST]

Access via remote shell:
  Pull: rsync [OPTION...] [USER@]HOST:SRC... [DEST]
  Push: rsync [OPTION...] SRC... [USER@]HOST:DEST

Access via rsync daemon:
  Pull: rsync [OPTION...] [USER@]HOST::SRC... [DEST]
        rsync [OPTION...] rsync://[USER@]HOST[:PORT]/SRC... [DEST]
  Push: rsync [OPTION...] SRC... [USER@]HOST::DEST
        rsync [OPTION...] SRC... rsync://[USER@]HOST[:PORT]/DEST
.fi 

.PP 
Usages with just one SRC arg and no DEST arg will list the source files
instead of copying.
.PP 
.SH "DESCRIPTION"

.PP 
Rsync is a fast and extraordinarily versatile file copying tool.  It can
copy locally, to/from another host over any remote shell, or to/from a
remote rsync daemon.  It offers a large number of options that control
every aspect of its behavior and permit very flexible specification of the
set of files to be copied.  It is famous for its delta\-transfer algorithm,
which reduces the amount of data sent over the network by sending only the
differences between the source files and the existing files in the
destination.  Rsync is widely used for backups and mirroring and as an
improved copy command for everyday use.
.PP 
Rsync finds files that need to be transferred using a \(dq\&quick check\(dq\&
algorithm (by default) that looks for files that have changed in size or
in last\-modified time.  Any changes in the other preserved attributes (as
requested by options) are made on the destination file directly when the
quick check indicates that the file\(cq\&s data does not need to be updated.
.PP 
Some of the additional features of rsync are:
.PP 
.IP o 
support for copying links, devices, owners, groups, and permissions
.IP o 
exclude and exclude\-from options similar to GNU tar
.IP o 
a CVS exclude mode for ignoring the same files that CVS would ignore
.IP o 
can use any transparent remote shell, including ssh or rsh
.IP o 
does not require super\-user privileges
.IP o 
pipelining of file transfers to minimize latency costs
.IP o 
support for anonymous or authenticated rsync daemons (ideal for
mirroring)

.PP 
.SH "GENERAL"

.PP 
Rsync copies files either to or from a remote host, or locally on the
current host (it does not support copying files between two remote hosts).
.PP 
There are two different ways for rsync to contact a remote system: using a
remote\-shell program as the transport (such as ssh or rsh) or contacting an
rsync daemon directly via TCP.  The remote\-shell transport is used whenever
the source or destination path contains a single colon (:) separator after
a host specification.  Contacting an rsync daemon directly happens when the
source or destination path contains a double colon (::) separator after a
host specification, OR when an rsync:// URL is specified (see also the
\(dq\&USING RSYNC\-DAEMON FEATURES VIA A REMOTE\-SHELL CONNECTION\(dq\& section for
an exception to this latter rule).
.PP 
As a special case, if a single source arg is specified without a
destination, the files are listed in an output format similar to \(dq\&ls \-l\(dq\&.
.PP 
As expected, if neither the source or destination path specify a remote
host, the copy occurs locally (see also the \fB\-\-list\-only\fP option).
.PP 
Rsync refers to the local side as the \(dq\&client\(dq\& and the remote side as the
\(dq\&server\(dq\&.  Don\(cq\&t confuse \(dq\&server\(dq\& with an rsync daemon \-\- a daemon is always a
server, but a server can be either a daemon or a remote\-shell spawned process.
.PP 
.SH "SETUP"

.PP 
See the file README for installation instructions.
.PP 
Once installed, you can use rsync to any machine that you can access via
a remote shell (as well as some that you can access using the rsync
daemon\-mode protocol).  For remote transfers, a modern rsync uses ssh
for its communications, but it may have been configured to use a
different remote shell by default, such as rsh or remsh.
.PP 
You can also specify any remote shell you like, either by using the \fB\-e\fP
command line option, or by setting the RSYNC_RSH environment variable.
.PP 
Note that rsync must be installed on both the source and destination
machines.
.PP 
.SH "USAGE"

.PP 
You use rsync in the same way you use rcp. You must specify a source
and a destination, one of which may be remote.
.PP 
Perhaps the best way to explain the syntax is with some examples:
.PP 
.RS 
\f(CWrsync \-t *.c foo:src/\fP
.RE

.PP 
This would transfer all files matching the pattern *.c from the
current directory to the directory src on the machine foo. If any of
the files already exist on the remote system then the rsync
remote\-update protocol is used to update the file by sending only the
differences in the data.  Note that the expansion of wildcards on the
commandline (*.c) into a list of files is handled by the shell before
it runs rsync and not by rsync itself (exactly the same as all other
posix\-style programs).
.PP 
.RS 
\f(CWrsync \-avz foo:src/bar /data/tmp\fP
.RE

.PP 
This would recursively transfer all files from the directory src/bar on the
machine foo into the /data/tmp/bar directory on the local machine. The
files are transferred in \(dq\&archive\(dq\& mode, which ensures that symbolic
links, devices, attributes, permissions, ownerships, etc. are preserved
in the transfer.  Additionally, compression will be used to reduce the
size of data portions of the transfer.
.PP 
.RS 
\f(CWrsync \-avz foo:src/bar/ /data/tmp\fP
.RE

.PP 
A trailing slash on the source changes this behavior to avoid creating an
additional directory level at the destination.  You can think of a trailing
/ on a source as meaning \(dq\&copy the contents of this directory\(dq\& as opposed
to \(dq\&copy the directory by name\(dq\&, but in both cases the attributes of the
containing directory are transferred to the containing directory on the
destination.  In other words, each of the following commands copies the
files in the same way, including their setting of the attributes of
/dest/foo:
.PP 
.RS 
\f(CWrsync \-av /src/foo /dest\fP
.br 
\f(CWrsync \-av /src/foo/ /dest/foo\fP
.br 
.RE

.PP 
Note also that host and module references don\(cq\&t require a trailing slash to
copy the contents of the default directory.  For example, both of these
copy the remote directory\(cq\&s contents into \(dq\&/dest\(dq\&:
.PP 
.RS 
\f(CWrsync \-av host: /dest\fP
.br 
\f(CWrsync \-av host::module /dest\fP
.br 
.RE

.PP 
You can also use rsync in local\-only mode, where both the source and
destination don\(cq\&t have a \(cq\&:\(cq\& in the name. In this case it behaves like
an improved copy command.
.PP 
Finally, you can list all the (listable) modules available from a
particular rsync daemon by leaving off the module name:
.PP 
.RS 
\f(CWrsync somehost.mydomain.com::\fP
.RE

.PP 
See the following section for more details.
.PP 
.SH "ADVANCED USAGE"

.PP 
The syntax for requesting multiple files from a remote host is done by
specifying additional remote\-host args in the same style as the first,
or with the hostname omitted.  For instance, all these work:
.PP 
.RS 
\f(CWrsync \-av host:file1 :file2 host:file{3,4} /dest/\fP
.br 
\f(CWrsync \-av host::modname/file{1,2} host::modname/file3 /dest/\fP
.br 
\f(CWrsync \-av host::modname/file1 ::modname/file{3,4}\fP
.RE

.PP 
Older versions of rsync required using quoted spaces in the SRC, like these
examples:
.PP 
.RS 
\f(CWrsync \-av host:'\&dir1/file1 dir2/file2'\& /dest\fP
.br 
\f(CWrsync host::'\&modname/dir1/file1 modname/dir2/file2'\& /dest\fP
.RE

.PP 
This word\-splitting still works (by default) in the latest rsync, but is
not as easy to use as the first method.
.PP 
If you need to transfer a filename that contains whitespace, you can either
specify the \fB\-\-protect\-args\fP (\fB\-s\fP) option, or you\(cq\&ll need to escape
the whitespace in a way that the remote shell will understand.  For
instance:
.PP 
.RS 
\f(CWrsync \-av host:'\&file\e name\e with\e spaces'\& /dest\fP
.RE

.PP 
.SH "CONNECTING TO AN RSYNC DAEMON"

.PP 
It is also possible to use rsync without a remote shell as the transport.
In this case you will directly connect to a remote rsync daemon, typically
using TCP port 873.  (This obviously requires the daemon to be running on
the remote system, so refer to the STARTING AN RSYNC DAEMON TO ACCEPT
CONNECTIONS section below for information on that.)
.PP 
Using rsync in this way is the same as using it with a remote shell except
that:
.PP 
.IP o 
you either use a double colon :: instead of a single colon to
separate the hostname from the path, or you use an rsync:// URL.
.IP o 
the first word of the \(dq\&path\(dq\& is actually a module name.
.IP o 
the remote daemon may print a message of the day when you
connect.
.IP o 
if you specify no path name on the remote daemon then the
list of accessible paths on the daemon will be shown.
.IP o 
if you specify no local destination then a listing of the
specified files on the remote daemon is provided.
.IP o 
you must not specify the \fB\-\-rsh\fP (\fB\-e\fP) option.

.PP 
An example that copies all the files in a remote module named \(dq\&src\(dq\&:
.PP 
.nf 
    rsync \-av host::src /dest
.fi 

.PP 
Some modules on the remote daemon may require authentication. If so,
you will receive a password prompt when you connect. You can avoid the
password prompt by setting the environment variable RSYNC_PASSWORD to
the password you want to use or using the \fB\-\-password\-file\fP option. This
may be useful when scripting rsync.
.PP 
WARNING: On some systems environment variables are visible to all
users. On those systems using \fB\-\-password\-file\fP is recommended.
.PP 
You may establish the connection via a web proxy by setting the
environment variable RSYNC_PROXY to a hostname:port pair pointing to
your web proxy.  Note that your web proxy\(cq\&s configuration must support
proxy connections to port 873.
.PP 
You may also establish a daemon connection using a program as a proxy by
setting the environment variable RSYNC_CONNECT_PROG to the commands you
wish to run in place of making a direct socket connection.  The string may
contain the escape \(dq\&%H\(dq\& to represent the hostname specified in the rsync
command (so use \(dq\&%%\(dq\& if you need a single \(dq\&%\(dq\& in your string).  For
example:
.PP 
.nf 
  export RSYNC_CONNECT_PROG='\&ssh proxyhost nc %H 873'\&
  rsync \-av targethost1::module/src/ /dest/
  rsync \-av rsync:://targethost2/module/src/ /dest/ 
.fi 

.PP 
The command specified above uses ssh to run nc (netcat) on a proxyhost,
which forwards all data to port 873 (the rsync daemon) on the targethost
(%H).
.PP 
.SH "USING RSYNC\-DAEMON FEATURES VIA A REMOTE\-SHELL CONNECTION"

.PP 
It is sometimes useful to use various features of an rsync daemon (such as
named modules) without actually allowing any new socket connections into a
system (other than what is already required to allow remote\-shell access).
Rsync supports connecting to a host using a remote shell and then spawning
a single\-use \(dq\&daemon\(dq\& server that expects to read its config file in the
home dir of the remote user.  This can be useful if you want to encrypt a
daemon\-style transfer\(cq\&s data, but since the daemon is started up fresh by
the remote user, you may not be able to use features such as chroot or
change the uid used by the daemon.  (For another way to encrypt a daemon
transfer, consider using ssh to tunnel a local port to a remote machine and
configure a normal rsync daemon on that remote host to only allow
connections from \(dq\&localhost\(dq\&.)
.PP 
From the user\(cq\&s perspective, a daemon transfer via a remote\-shell
connection uses nearly the same command\-line syntax as a normal
rsync\-daemon transfer, with the only exception being that you must
explicitly set the remote shell program on the command\-line with the
\fB\-\-rsh=COMMAND\fP option.  (Setting the RSYNC_RSH in the environment
will not turn on this functionality.)  For example:
.PP 
.nf 
    rsync \-av \-\-rsh=ssh host::module /dest
.fi 

.PP 
If you need to specify a different remote\-shell user, keep in mind that the
user@ prefix in front of the host is specifying the rsync\-user value (for a
module that requires user\-based authentication).  This means that you must
give the \(cq\&\-l user\(cq\& option to ssh when specifying the remote\-shell, as in
this example that uses the short version of the \fB\-\-rsh\fP option:
.PP 
.nf 
    rsync \-av \-e \(dq\&ssh \-l ssh\-user\(dq\& rsync\-user@host::module /dest
.fi 

.PP 
The \(dq\&ssh\-user\(dq\& will be used at the ssh level; the \(dq\&rsync\-user\(dq\& will be
used to log\-in to the \(dq\&module\(dq\&.
.PP 
.SH "STARTING AN RSYNC DAEMON TO ACCEPT CONNECTIONS"

.PP 
In order to connect to an rsync daemon, the remote system needs to have a
daemon already running (or it needs to have configured something like inetd
to spawn an rsync daemon for incoming connections on a particular port).
For full information on how to start a daemon that will handling incoming
socket connections, see the \fBrsyncd.conf\fP(5) man page \-\- that is the config
file for the daemon, and it contains the full details for how to run the
daemon (including stand\-alone and inetd configurations).
.PP 
If you\(cq\&re using one of the remote\-shell transports for the transfer, there is
no need to manually start an rsync daemon.
.PP 
.SH "SORTED TRANSFER ORDER"

.PP 
Rsync always sorts the specified filenames into its internal transfer list.
This handles the merging together of the contents of identically named
directories, makes it easy to remove duplicate filenames, and may confuse
someone when the files are transferred in a different order than what was
given on the command\-line.
.PP 
If you need a particular file to be transferred prior to another, either
separate the files into different rsync calls, or consider using
\fB\-\-delay\-updates\fP (which doesn\(cq\&t affect the sorted transfer order, but
does make the final file\-updating phase happen much more rapidly).
.PP 
.SH "EXAMPLES"

.PP 
Here are some examples of how I use rsync.
.PP 
To backup my wife\(cq\&s home directory, which consists of large MS Word
files and mail folders, I use a cron job that runs
.PP 
.RS 
\f(CWrsync \-Cavz . arvidsjaur:backup\fP
.RE

.PP 
each night over a PPP connection to a duplicate directory on my machine
\(dq\&arvidsjaur\(dq\&.
.PP 
To synchronize my samba source trees I use the following Makefile
targets:
.PP 
.nf 
    get:
            rsync \-avuzb \-\-exclude '\&*~'\& samba:samba/ .
    put:
            rsync \-Cavuzb . samba:samba/
    sync: get put
.fi 

.PP 
this allows me to sync with a CVS directory at the other end of the
connection. I then do CVS operations on the remote machine, which saves a
lot of time as the remote CVS protocol isn\(cq\&t very efficient.
.PP 
I mirror a directory between my \(dq\&old\(dq\& and \(dq\&new\(dq\& ftp sites with the
command:
.PP 
\f(CWrsync \-az \-e ssh \-\-delete ~ftp/pub/samba nimbus:\(dq\&~ftp/pub/tridge\(dq\&\fP
.PP 
This is launched from cron every few hours.
.PP 
.SH "OPTIONS SUMMARY"

.PP 
Here is a short summary of the options available in rsync. Please refer
to the detailed description below for a complete description.  
.nf 

 \-v, \-\-verbose               increase verbosity
     \-\-info=FLAGS            fine\-grained informational verbosity
     \-\-debug=FLAGS           fine\-grained debug verbosity
     \-\-msgs2stderr           special output handling for debugging
 \-q, \-\-quiet                 suppress non\-error messages
     \-\-no\-motd               suppress daemon\-mode MOTD (see caveat)
 \-c, \-\-checksum              skip based on checksum, not mod\-time & size
 \-a, \-\-archive               archive mode; equals \-rlptgoD (no \-H,\-A,\-X)
     \-\-no\-OPTION             turn off an implied OPTION (e.g. \-\-no\-D)
 \-r, \-\-recursive             recurse into directories
 \-R, \-\-relative              use relative path names
     \-\-no\-implied\-dirs       don'\&t send implied dirs with \-\-relative
 \-b, \-\-backup                make backups (see \-\-suffix & \-\-backup\-dir)
     \-\-backup\-dir=DIR        make backups into hierarchy based in DIR
     \-\-suffix=SUFFIX         backup suffix (default ~ w/o \-\-backup\-dir)
 \-u, \-\-update                skip files that are newer on the receiver
     \-\-inplace               update destination files in\-place
     \-\-append                append data onto shorter files
     \-\-append\-verify         \-\-append w/old data in file checksum
 \-d, \-\-dirs                  transfer directories without recursing
 \-l, \-\-links                 copy symlinks as symlinks
 \-L, \-\-copy\-links            transform symlink into referent file/dir
     \-\-copy\-unsafe\-links     only \(dq\&unsafe\(dq\& symlinks are transformed
     \-\-safe\-links            ignore symlinks that point outside the tree
     \-\-munge\-links           munge symlinks to make them safer
 \-k, \-\-copy\-dirlinks         transform symlink to dir into referent dir
 \-K, \-\-keep\-dirlinks         treat symlinked dir on receiver as dir
 \-H, \-\-hard\-links            preserve hard links
 \-p, \-\-perms                 preserve permissions
 \-E, \-\-executability         preserve executability
     \-\-chmod=CHMOD           affect file and/or directory permissions
 \-A, \-\-acls                  preserve ACLs (implies \-p)
 \-X, \-\-xattrs                preserve extended attributes
 \-o, \-\-owner                 preserve owner (super\-user only)
 \-g, \-\-group                 preserve group
     \-\-devices               preserve device files (super\-user only)
     \-\-specials              preserve special files
 \-D                          same as \-\-devices \-\-specials
 \-t, \-\-times                 preserve modification times
 \-O, \-\-omit\-dir\-times        omit directories from \-\-times
 \-J, \-\-omit\-link\-times       omit symlinks from \-\-times
     \-\-super                 receiver attempts super\-user activities
     \-\-fake\-super            store/recover privileged attrs using xattrs
 \-S, \-\-sparse                turn sequences of nulls into sparse blocks
     \-\-preallocate           allocate dest files before writing
 \-n, \-\-dry\-run               perform a trial run with no changes made
 \-W, \-\-whole\-file            copy files whole (w/o delta\-xfer algorithm)
     \-\-checksum\-choice=STR   choose the checksum algorithms
 \-x, \-\-one\-file\-system       don'\&t cross filesystem boundaries
 \-B, \-\-block\-size=SIZE       force a fixed checksum block\-size
 \-e, \-\-rsh=COMMAND           specify the remote shell to use
     \-\-rsync\-path=PROGRAM    specify the rsync to run on remote machine
     \-\-existing              skip creating new files on receiver
     \-\-ignore\-existing       skip updating files that exist on receiver
     \-\-remove\-source\-files   sender removes synchronized files (non\-dir)
     \-\-del                   an alias for \-\-delete\-during
     \-\-delete                delete extraneous files from dest dirs
     \-\-delete\-before         receiver deletes before xfer, not during
     \-\-delete\-during         receiver deletes during the transfer
     \-\-delete\-delay          find deletions during, delete after
     \-\-delete\-after          receiver deletes after transfer, not during
     \-\-delete\-excluded       also delete excluded files from dest dirs
     \-\-ignore\-missing\-args   ignore missing source args without error
     \-\-delete\-missing\-args   delete missing source args from destination
     \-\-ignore\-errors         delete even if there are I/O errors
     \-\-force                 force deletion of dirs even if not empty
     \-\-max\-delete=NUM        don'\&t delete more than NUM files
     \-\-max\-size=SIZE         don'\&t transfer any file larger than SIZE
     \-\-min\-size=SIZE         don'\&t transfer any file smaller than SIZE
     \-\-partial               keep partially transferred files
     \-\-partial\-dir=DIR       put a partially transferred file into DIR
     \-\-delay\-updates         put all updated files into place at end
 \-m, \-\-prune\-empty\-dirs      prune empty directory chains from file\-list
     \-\-numeric\-ids           don'\&t map uid/gid values by user/group name
     \-\-usermap=STRING        custom username mapping
     \-\-groupmap=STRING       custom groupname mapping
     \-\-chown=USER:GROUP      simple username/groupname mapping
     \-\-timeout=SECONDS       set I/O timeout in seconds
     \-\-contimeout=SECONDS    set daemon connection timeout in seconds
 \-I, \-\-ignore\-times          don'\&t skip files that match size and time
     \-\-size\-only             skip files that match in size
 \-@, \-\-modify\-window=NUM     set the accuracy for mod\-time comparisons
 \-T, \-\-temp\-dir=DIR          create temporary files in directory DIR
 \-y, \-\-fuzzy                 find similar file for basis if no dest file
     \-\-compare\-dest=DIR      also compare received files relative to DIR
     \-\-copy\-dest=DIR         ... and include copies of unchanged files
     \-\-link\-dest=DIR         hardlink to files in DIR when unchanged
 \-z, \-\-compress              compress file data during the transfer
     \-\-compress\-level=NUM    explicitly set compression level
     \-\-skip\-compress=LIST    skip compressing files with suffix in LIST
 \-C, \-\-cvs\-exclude           auto\-ignore files in the same way CVS does
 \-f, \-\-filter=RULE           add a file\-filtering RULE
 \-F                          same as \-\-filter='\&dir\-merge /.rsync\-filter'\&
                             repeated: \-\-filter='\&\- .rsync\-filter'\&
     \-\-exclude=PATTERN       exclude files matching PATTERN
     \-\-exclude\-from=FILE     read exclude patterns from FILE
     \-\-include=PATTERN       don'\&t exclude files matching PATTERN
     \-\-include\-from=FILE     read include patterns from FILE
     \-\-files\-from=FILE       read list of source\-file names from FILE
 \-0, \-\-from0                 all *from/filter files are delimited by 0s
 \-s, \-\-protect\-args          no space\-splitting; wildcard chars only
     \-\-address=ADDRESS       bind address for outgoing socket to daemon
     \-\-port=PORT             specify double\-colon alternate port number
     \-\-sockopts=OPTIONS      specify custom TCP options
     \-\-blocking\-io           use blocking I/O for the remote shell
     \-\-outbuf=N|L|B          set out buffering to None, Line, or Block
     \-\-stats                 give some file\-transfer stats
 \-8, \-\-8\-bit\-output          leave high\-bit chars unescaped in output
 \-h, \-\-human\-readable        output numbers in a human\-readable format
     \-\-progress              show progress during transfer
 \-P                          same as \-\-partial \-\-progress
 \-i, \-\-itemize\-changes       output a change\-summary for all updates
 \-M, \-\-remote\-option=OPTION  send OPTION to the remote side only
     \-\-out\-format=FORMAT     output updates using the specified FORMAT
     \-\-log\-file=FILE         log what we'\&re doing to the specified FILE
     \-\-log\-file\-format=FMT   log updates using the specified FMT
     \-\-password\-file=FILE    read daemon\-access password from FILE
     \-\-list\-only             list the files instead of copying them
     \-\-bwlimit=RATE          limit socket I/O bandwidth
     \-\-write\-batch=FILE      write a batched update to FILE
     \-\-only\-write\-batch=FILE like \-\-write\-batch but w/o updating dest
     \-\-read\-batch=FILE       read a batched update from FILE
     \-\-protocol=NUM          force an older protocol version to be used
     \-\-iconv=CONVERT_SPEC    request charset conversion of filenames
     \-\-checksum\-seed=NUM     set block/file checksum seed (advanced)
 \-4, \-\-ipv4                  prefer IPv4
 \-6, \-\-ipv6                  prefer IPv6
     \-\-version               print version number
(\-h) \-\-help                  show this help (see below for \-h comment)
.fi 

.PP 
Rsync can also be run as a daemon, in which case the following options are
accepted: 
.nf 

     \-\-daemon                run as an rsync daemon
     \-\-address=ADDRESS       bind to the specified address
     \-\-bwlimit=RATE          limit socket I/O bandwidth
     \-\-config=FILE           specify alternate rsyncd.conf file
 \-M, \-\-dparam=OVERRIDE       override global daemon config parameter
     \-\-no\-detach             do not detach from the parent
     \-\-port=PORT             listen on alternate port number
     \-\-log\-file=FILE         override the \(dq\&log file\(dq\& setting
     \-\-log\-file\-format=FMT   override the \(dq\&log format\(dq\& setting
     \-\-sockopts=OPTIONS      specify custom TCP options
 \-v, \-\-verbose               increase verbosity
 \-4, \-\-ipv4                  prefer IPv4
 \-6, \-\-ipv6                  prefer IPv6
 \-h, \-\-help                  show this help (if used after \-\-daemon)
.fi 

.PP 
.SH "OPTIONS"

.PP 
Rsync accepts both long (double\-dash + word) and short (single\-dash + letter)
options.  The full list of the available options are described below.  If an
option can be specified in more than one way, the choices are comma\-separated.
Some options only have a long variant, not a short.  If the option takes a
parameter, the parameter is only listed after the long variant, even though it
must also be specified for the short.  When specifying a parameter, you can
either use the form \-\-option=param or replace the \(cq\&=\(cq\& with whitespace.  The
parameter may need to be quoted in some manner for it to survive the shell\(cq\&s
command\-line parsing.  Keep in mind that a leading tilde (~) in a filename is
substituted by your shell, so \-\-option=~/foo will not change the tilde into
your home directory (remove the \(cq\&=\(cq\& for that).
.PP 
.IP "\fB\-\-help\fP"
Print a short help page describing the options
available in rsync and exit.  For backward\-compatibility with older
versions of rsync, the help will also be output if you use the \fB\-h\fP
option without any other args.
.IP 
.IP "\fB\-\-version\fP"
print the rsync version number and exit.
.IP 
.IP "\fB\-v, \-\-verbose\fP"
This option increases the amount of information you
are given during the transfer.  By default, rsync works silently. A
single \fB\-v\fP will give you information about what files are being
transferred and a brief summary at the end. Two \fB\-v\fP options will give you
information on what files are being skipped and slightly more
information at the end. More than two \fB\-v\fP options should only be used if
you are debugging rsync.
.IP 
In a modern rsync, the \fB\-v\fP option is equivalent to the setting of groups
of \fB\-\-info\fP and \fB\-\-debug\fP options.  You can choose to use these newer
options in addition to, or in place of using \fB\-\-verbose\fP, as any
fine\-grained settings override the implied settings of \fB\-v\fP.  Both
\fB\-\-info\fP and \fB\-\-debug\fP have a way to ask for help that tells you
exactly what flags are set for each increase in verbosity.
.IP 
However, do keep in mind that a daemon\(cq\&s \(dq\&max verbosity\(dq\& setting will limit how
high of a level the various individual flags can be set on the daemon side.
For instance, if the max is 2, then any info and/or debug flag that is set to
a higher value than what would be set by \fB\-vv\fP will be downgraded to the
\fB\-vv\fP level in the daemon\(cq\&s logging.
.IP 
.IP "\fB\-\-info=FLAGS\fP"
This option lets you have fine\-grained control over the
information
output you want to see.  An individual flag name may be followed by a level
number, with 0 meaning to silence that output, 1 being the default output
level, and higher numbers increasing the output of that flag (for those
that support higher levels).  Use
\fB\-\-info=help\fP
to see all the available flag names, what they output, and what flag names
are added for each increase in the verbose level.  Some examples:
.IP 
.nf 
    rsync \-a \-\-info=progress2 src/ dest/
    rsync \-avv \-\-info=stats2,misc1,flist0 src/ dest/ 
.fi 

.IP 
Note that \fB\-\-info=name\fP\(cq\&s output is affected by the \fB\-\-out\-format\fP and
\fB\-\-itemize\-changes\fP (\fB\-i\fP) options.  See those options for more
information on what is output and when.
.IP 
This option was added to 3.1.0, so an older rsync on the server side might
reject your attempts at fine\-grained control (if one or more flags needed
to be send to the server and the server was too old to understand them).
See also the \(dq\&max verbosity\(dq\& caveat above when dealing with a daemon.
.IP 
.IP "\fB\-\-debug=FLAGS\fP"
This option lets you have fine\-grained control over the debug
output you want to see.  An individual flag name may be followed by a level
number, with 0 meaning to silence that output, 1 being the default output
level, and higher numbers increasing the output of that flag (for those
that support higher levels).  Use
\fB\-\-debug=help\fP
to see all the available flag names, what they output, and what flag names
are added for each increase in the verbose level.  Some examples:
.IP 
.nf 
    rsync \-avvv \-\-debug=none src/ dest/
    rsync \-avA \-\-del \-\-debug=del2,acl src/ dest/ 
.fi 

.IP 
Note that some debug messages will only be output when \fB\-\-msgs2stderr\fP is
specified, especially those pertaining to I/O and buffer debugging.
.IP 
This option was added to 3.1.0, so an older rsync on the server side might
reject your attempts at fine\-grained control (if one or more flags needed
to be send to the server and the server was too old to understand them).
See also the \(dq\&max verbosity\(dq\& caveat above when dealing with a daemon.
.IP 
.IP "\fB\-\-msgs2stderr\fP"
This option changes rsync to send all its output
directly to stderr rather than to send messages to the client side via the
protocol (which normally outputs info messages via stdout).  This is mainly
intended for debugging in order to avoid changing the data sent via the
protocol, since the extra protocol data can change what is being tested.
The option does not affect the remote side of a transfer without using
\fB\-\-remote\-option\fP \-\- e.g. \fB\-M\-\-msgs2stderr\fP.
Also keep in mind that a daemon connection does not have a stderr channel to send
messages back to the client side, so if you are doing any daemon\-transfer
debugging using this option, you should start up a daemon using \fB\-\-no\-detach\fP
so that you can see the stderr output on the daemon side.
.IP 
This option has the side\-effect of making stderr output get line\-buffered so
that the merging of the output of 3 programs happens in a more readable manner.
.IP 
.IP "\fB\-q, \-\-quiet\fP"
This option decreases the amount of information you
are given during the transfer, notably suppressing information messages
from the remote server. This option is useful when invoking rsync from
cron.
.IP 
.IP "\fB\-\-no\-motd\fP"
This option affects the information that is output
by the client at the start of a daemon transfer.  This suppresses the
message\-of\-the\-day (MOTD) text, but it also affects the list of modules
that the daemon sends in response to the \(dq\&rsync host::\(dq\& request (due to
a limitation in the rsync protocol), so omit this option if you want to
request the list of modules from the daemon.
.IP 
.IP "\fB\-I, \-\-ignore\-times\fP"
Normally rsync will skip any files that are
already the same size and have the same modification timestamp.
This option turns off this \(dq\&quick check\(dq\& behavior, causing all files to
be updated.
.IP 
.IP "\fB\-\-size\-only\fP"
This modifies rsync\(cq\&s \(dq\&quick check\(dq\& algorithm for
finding files that need to be transferred, changing it from the default of
transferring files with either a changed size or a changed last\-modified
time to just looking for files that have changed in size.  This is useful
when starting to use rsync after using another mirroring system which may
not preserve timestamps exactly.
.IP 
.IP "\fB\-@, \-\-modify\-window\fP"
When comparing two timestamps, rsync treats the
timestamps as being equal if they differ by no more than the modify\-window
value.  The default is 0, which matches just integer seconds.  If you specify a
negative value (and the receiver is at least version 3.1.3) then nanoseconds
will also be taken into account.  Specifying 1 is useful for copies to/from MS
Windows FAT filesystems, because FAT represents times with a 2\-second
resolution (allowing times to differ from the original by up to 1 second).
.IP 
If you want all your transfers to default to comparing nanoseconds, you can
create a ~/.popt file and put these lines in it:
.IP 
.RS 
\f(CW   rsync alias \-a \-a@\-1\fP
.RE
.RS 
\f(CW   rsync alias \-t \-t@\-1\fP
.RE

.IP 
With that as the default, you\(cq\&d need to specify \fB\-\-modify\-window=0\fP (aka
\fB\-@0\fP) to override it and ignore nanoseconds, e.g. if you\(cq\&re copying between
ext3 and ext4, or if the receiving rsync is older than 3.1.3.
.IP 
.IP "\fB\-c, \-\-checksum\fP"
This changes the way rsync checks if the files have
been changed and are in need of a transfer.  Without this option, rsync
uses a \(dq\&quick check\(dq\& that (by default) checks if each file\(cq\&s size and time
of last modification match between the sender and receiver.  This option
changes this to compare a 128\-bit checksum for each file that has a
matching size.  Generating the checksums means that both sides will expend
a lot of disk I/O reading all the data in the files in the transfer (and
this is prior to any reading that will be done to transfer changed files),
so this can slow things down significantly.
.IP 
The sending side generates its checksums while it is doing the file\-system
scan that builds the list of the available files.  The receiver generates
its checksums when it is scanning for changed files, and will checksum any
file that has the same size as the corresponding sender\(cq\&s file:  files with
either a changed size or a changed checksum are selected for transfer.
.IP 
Note that rsync always verifies that each \fItransferred\fP file was
correctly reconstructed on the receiving side by checking a whole\-file
checksum that is generated as the file is transferred, but that
automatic after\-the\-transfer verification has nothing to do with this
option\(cq\&s before\-the\-transfer \(dq\&Does this file need to be updated?\(dq\& check.
.IP 
For protocol 30 and beyond (first supported in 3.0.0), the checksum used is
MD5.  For older protocols, the checksum used is MD4.
.IP 
.IP "\fB\-a, \-\-archive\fP"
This is equivalent to \fB\-rlptgoD\fP. It is a quick
way of saying you want recursion and want to preserve almost
everything (with \-H being a notable omission).
The only exception to the above equivalence is when \fB\-\-files\-from\fP is
specified, in which case \fB\-r\fP is not implied.
.IP 
Note that \fB\-a\fP \fBdoes not preserve hardlinks\fP, because
finding multiply\-linked files is expensive.  You must separately
specify \fB\-H\fP.
.IP 
.IP "\-\-no\-OPTION"
You may turn off one or more implied options by prefixing
the option name with \(dq\&no\-\(dq\&.  Not all options may be prefixed with a \(dq\&no\-\(dq\&:
only options that are implied by other options (e.g. \fB\-\-no\-D\fP,
\fB\-\-no\-perms\fP) or have different defaults in various circumstances
(e.g. \fB\-\-no\-whole\-file\fP, \fB\-\-no\-blocking\-io\fP, \fB\-\-no\-dirs\fP).  You may
specify either the short or the long option name after the \(dq\&no\-\(dq\& prefix
(e.g. \fB\-\-no\-R\fP is the same as \fB\-\-no\-relative\fP).
.IP 
For example: if you want to use \fB\-a\fP (\fB\-\-archive\fP) but don\(cq\&t want
\fB\-o\fP (\fB\-\-owner\fP), instead of converting \fB\-a\fP into \fB\-rlptgD\fP, you
could specify \fB\-a \-\-no\-o\fP (or \fB\-a \-\-no\-owner\fP).
.IP 
The order of the options is important:  if you specify \fB\-\-no\-r \-a\fP, the
\fB\-r\fP option would end up being turned on, the opposite of \fB\-a \-\-no\-r\fP.
Note also that the side\-effects of the \fB\-\-files\-from\fP option are NOT
positional, as it affects the default state of several options and slightly
changes the meaning of \fB\-a\fP (see the \fB\-\-files\-from\fP option for more
details).
.IP 
.IP "\fB\-r, \-\-recursive\fP"
This tells rsync to copy directories
recursively.  See also \fB\-\-dirs\fP (\fB\-d\fP).
.IP 
Beginning with rsync 3.0.0, the recursive algorithm used is now an
incremental scan that uses much less memory than before and begins the
transfer after the scanning of the first few directories have been
completed.  This incremental scan only affects our recursion algorithm, and
does not change a non\-recursive transfer.  It is also only possible when
both ends of the transfer are at least version 3.0.0.
.IP 
Some options require rsync to know the full file list, so these options
disable the incremental recursion mode.  These include: \fB\-\-delete\-before\fP,
\fB\-\-delete\-after\fP, \fB\-\-prune\-empty\-dirs\fP, and \fB\-\-delay\-updates\fP.
Because of this, the default delete mode when you specify \fB\-\-delete\fP is now
\fB\-\-delete\-during\fP when both ends of the connection are at least 3.0.0
(use \fB\-\-del\fP or \fB\-\-delete\-during\fP to request this improved deletion mode
explicitly).  See also the \fB\-\-delete\-delay\fP option that is a better choice
than using \fB\-\-delete\-after\fP.
.IP 
Incremental recursion can be disabled using the \fB\-\-no\-inc\-recursive\fP
option or its shorter \fB\-\-no\-i\-r\fP alias.
.IP 
.IP "\fB\-R, \-\-relative\fP"
Use relative paths. This means that the full path
names specified on the command line are sent to the server rather than
just the last parts of the filenames. This is particularly useful when
you want to send several different directories at the same time. For
example, if you used this command:
.IP 
.RS 
\f(CW   rsync \-av /foo/bar/baz.c remote:/tmp/\fP
.RE

.IP 
\&... this would create a file named baz.c in /tmp/ on the remote
machine. If instead you used
.IP 
.RS 
\f(CW   rsync \-avR /foo/bar/baz.c remote:/tmp/\fP
.RE

.IP 
then a file named /tmp/foo/bar/baz.c would be created on the remote
machine, preserving its full path.  These extra path elements are called
\(dq\&implied directories\(dq\& (i.e. the \(dq\&foo\(dq\& and the \(dq\&foo/bar\(dq\& directories in the
above example).
.IP 
Beginning with rsync 3.0.0, rsync always sends these implied directories as
real directories in the file list, even if a path element is really a
symlink on the sending side.  This prevents some really unexpected
behaviors when copying the full path of a file that you didn\(cq\&t realize had
a symlink in its path.  If you want to duplicate a server\-side symlink,
include both the symlink via its path, and referent directory via its real
path.  If you\(cq\&re dealing with an older rsync on the sending side, you may
need to use the \fB\-\-no\-implied\-dirs\fP option.
.IP 
It is also possible to limit the amount of path information that is sent as
implied directories for each path you specify.  With a modern rsync on the
sending side (beginning with 2.6.7), you can insert a dot and a slash into
the source path, like this:
.IP 
.RS 
\f(CW   rsync \-avR /foo/./bar/baz.c remote:/tmp/\fP
.RE

.IP 
That would create /tmp/bar/baz.c on the remote machine.  (Note that the
dot must be followed by a slash, so \(dq\&/foo/.\(dq\& would not be abbreviated.)
For older rsync versions, you would need to use a chdir to limit the
source path.  For example, when pushing files:
.IP 
.RS 
\f(CW   (cd /foo; rsync \-avR bar/baz.c remote:/tmp/) \fP
.RE

.IP 
(Note that the parens put the two commands into a sub\-shell, so that the
\(dq\&cd\(dq\& command doesn\(cq\&t remain in effect for future commands.)
If you\(cq\&re pulling files from an older rsync, use this idiom (but only
for a non\-daemon transfer):
.IP 
.RS 
\f(CW   rsync \-avR \-\-rsync\-path=\(dq\&cd /foo; rsync\(dq\& \e \fP
.br 
\f(CW       remote:bar/baz.c /tmp/\fP
.RE

.IP 
.IP "\fB\-\-no\-implied\-dirs\fP"
This option affects the default behavior of the
\fB\-\-relative\fP option.  When it is specified, the attributes of the implied
directories from the source names are not included in the transfer.  This
means that the corresponding path elements on the destination system are
left unchanged if they exist, and any missing implied directories are
created with default attributes.  This even allows these implied path
elements to have big differences, such as being a symlink to a directory on
the receiving side.
.IP 
For instance, if a command\-line arg or a files\-from entry told rsync to
transfer the file \(dq\&path/foo/file\(dq\&, the directories \(dq\&path\(dq\& and \(dq\&path/foo\(dq\&
are implied when \fB\-\-relative\fP is used.  If \(dq\&path/foo\(dq\& is a symlink to
\(dq\&bar\(dq\& on the destination system, the receiving rsync would ordinarily
delete \(dq\&path/foo\(dq\&, recreate it as a directory, and receive the file into
the new directory.  With \fB\-\-no\-implied\-dirs\fP, the receiving rsync updates
\(dq\&path/foo/file\(dq\& using the existing path elements, which means that the file
ends up being created in \(dq\&path/bar\(dq\&.  Another way to accomplish this link
preservation is to use the \fB\-\-keep\-dirlinks\fP option (which will also
affect symlinks to directories in the rest of the transfer).
.IP 
When pulling files from an rsync older than 3.0.0, you may need to use this
option if the sending side has a symlink in the path you request and you
wish the implied directories to be transferred as normal directories.
.IP 
.IP "\fB\-b, \-\-backup\fP"
With this option, preexisting destination files are
renamed as each file is transferred or deleted.  You can control where the
backup file goes and what (if any) suffix gets appended using the
\fB\-\-backup\-dir\fP and \fB\-\-suffix\fP options.
.IP 
Note that if you don\(cq\&t specify \fB\-\-backup\-dir\fP, (1) the
\fB\-\-omit\-dir\-times\fP option will be forced on, and (2) if \fB\-\-delete\fP is
also in effect (without \fB\-\-delete\-excluded\fP), rsync will add a \(dq\&protect\(dq\&
filter\-rule for the backup suffix to the end of all your existing excludes
(e.g. \fB\-f \(dq\&P *~\(dq\&\fP).  This will prevent previously backed\-up files from being
deleted.  Note that if you are supplying your own filter rules, you may
need to manually insert your own exclude/protect rule somewhere higher up
in the list so that it has a high enough priority to be effective (e.g., if
your rules specify a trailing inclusion/exclusion of \(cq\&*\(cq\&, the auto\-added
rule would never be reached).
.IP 
.IP "\fB\-\-backup\-dir=DIR\fP"
In combination with the \fB\-\-backup\fP option, this
tells rsync to store all backups in the specified directory on the receiving
side.  This can be used for incremental backups.  You can additionally
specify a backup suffix using the \fB\-\-suffix\fP option
(otherwise the files backed up in the specified directory
will keep their original filenames).
.IP 
Note that if you specify a relative path, the backup directory will be
relative to the destination directory, so you probably want to specify
either an absolute path or a path that starts with \(dq\&../\(dq\&.  If an rsync
daemon is the receiver, the backup dir cannot go outside the module\(cq\&s path
hierarchy, so take extra care not to delete it or copy into it.
.IP 
.IP "\fB\-\-suffix=SUFFIX\fP"
This option allows you to override the default
backup suffix used with the \fB\-\-backup\fP (\fB\-b\fP) option. The default suffix is a ~
if no \-\fB\-backup\-dir\fP was specified, otherwise it is an empty string.
.IP 
.IP "\fB\-u, \-\-update\fP"
This forces rsync to skip any files which exist on
the destination and have a modified time that is newer than the source
file.  (If an existing destination file has a modification time equal to the
source file\(cq\&s, it will be updated if the sizes are different.)
.IP 
Note that this does not affect the copying of dirs, symlinks, or other special
files.  Also, a difference of file format between the sender and receiver
is always considered to be important enough for an update, no matter what
date is on the objects.  In other words, if the source has a directory
where the destination has a file, the transfer would occur regardless of
the timestamps.
.IP 
This option is a transfer rule, not an exclude, so it doesn\(cq\&t affect the
data that goes into the file\-lists, and thus it doesn\(cq\&t affect deletions.
It just limits the files that the receiver requests to be transferred.
.IP 
.IP "\fB\-\-inplace\fP"
This option changes how rsync transfers a file when
its data needs to be updated: instead of the default method of creating
a new copy of the file and moving it into place when it is complete, rsync
instead writes the updated data directly to the destination file.
.IP 
This has several effects:
.IP 
.RS 
.IP o 
Hard links are not broken.  This means the new data will be visible
through other hard links to the destination file.  Moreover, attempts to
copy differing source files onto a multiply\-linked destination file will
result in a \(dq\&tug of war\(dq\& with the destination data changing back and forth.
.IP o 
In\-use binaries cannot be updated (either the OS will prevent this from
happening, or binaries that attempt to swap\-in their data will misbehave or
crash).
.IP o 
The file\(cq\&s data will be in an inconsistent state during the transfer
and will be left that way if the transfer is interrupted or if an update
fails.
.IP o 
A file that rsync cannot write to cannot be updated. While a super user
can update any file, a normal user needs to be granted write permission for
the open of the file for writing to be successful.
.IP o 
The efficiency of rsync\(cq\&s delta\-transfer algorithm may be reduced if
some data in the destination file is overwritten before it can be copied to
a position later in the file.  This does not apply if you use \fB\-\-backup\fP,
since rsync is smart enough to use the backup file as the basis file for the
transfer.
.RE

.IP 
WARNING: you should not use this option to update files that are being
accessed by others, so be careful when choosing to use this for a copy.
.IP 
This option is useful for transferring large files with block\-based changes
or appended data, and also on systems that are disk bound, not network
bound.  It can also help keep a copy\-on\-write filesystem snapshot from
diverging the entire contents of a file that only has minor changes.
.IP 
The option implies \fB\-\-partial\fP (since an interrupted transfer does not delete
the file), but conflicts with \fB\-\-partial\-dir\fP and \fB\-\-delay\-updates\fP.
Prior to rsync 2.6.4 \fB\-\-inplace\fP was also incompatible with \fB\-\-compare\-dest\fP
and \fB\-\-link\-dest\fP.
.IP 
.IP "\fB\-\-append\fP"
This causes rsync to update a file by appending data onto
the end of the file, which presumes that the data that already exists on
the receiving side is identical with the start of the file on the sending
side.  If a file needs to be transferred and its size on the receiver is
the same or longer than the size on the sender, the file is skipped.  This
does not interfere with the updating of a file\(cq\&s non\-content attributes
(e.g. permissions, ownership, etc.) when the file does not need to be
transferred, nor does it affect the updating of any non\-regular files.
Implies \fB\-\-inplace\fP.
.IP 
The use of \fB\-\-append\fP can be dangerous if you aren\(cq\&t 100% sure that the files
that are longer have only grown by the appending of data onto the end.  You
should thus use include/exclude/filter rules to ensure that such a transfer is
only affecting files that you know to be growing via appended data.
.IP 
.IP "\fB\-\-append\-verify\fP"
This works just like the \fB\-\-append\fP option, but
the existing data on the receiving side is included in the full\-file
checksum verification step, which will cause a file to be resent if the
final verification step fails (rsync uses a normal, non\-appending
\fB\-\-inplace\fP transfer for the resend).
.IP 
Note: prior to rsync 3.0.0, the \fB\-\-append\fP option worked like
\fB\-\-append\-verify\fP, so if you are interacting with an older rsync (or the
transfer is using a protocol prior to 30), specifying either append option
will initiate an \fB\-\-append\-verify\fP transfer.
.IP 
.IP "\fB\-d, \-\-dirs\fP"
Tell the sending side to include any directories that
are encountered.  Unlike \fB\-\-recursive\fP, a directory\(cq\&s contents are not copied
unless the directory name specified is \(dq\&.\(dq\& or ends with a trailing slash
(e.g. \(dq\&.\(dq\&, \(dq\&dir/.\(dq\&, \(dq\&dir/\(dq\&, etc.).  Without this option or the
\fB\-\-recursive\fP option, rsync will skip all directories it encounters (and
output a message to that effect for each one).  If you specify both
\fB\-\-dirs\fP and \fB\-\-recursive\fP, \fB\-\-recursive\fP takes precedence.
.IP 
The \fB\-\-dirs\fP option is implied by the \fB\-\-files\-from\fP option
or the \fB\-\-list\-only\fP option (including an implied
\fB\-\-list\-only\fP usage) if \fB\-\-recursive\fP wasn\(cq\&t specified (so that
directories are seen in the listing).  Specify \fB\-\-no\-dirs\fP (or \fB\-\-no\-d\fP)
if you want to turn this off.
.IP 
There is also a backward\-compatibility helper option, \fB\-\-old\-dirs\fP (or
\fB\-\-old\-d\fP) that tells rsync to use a hack of \(dq\&\-r \-\-exclude=\(cq\&/*/*\(cq\&\(dq\& to get
an older rsync to list a single directory without recursing.
.IP 
.IP "\fB\-l, \-\-links\fP"
When symlinks are encountered, recreate the
symlink on the destination.
.IP 
.IP "\fB\-L, \-\-copy\-links\fP"
When symlinks are encountered, the item that
they point to (the referent) is copied, rather than the symlink.  In older
versions of rsync, this option also had the side\-effect of telling the
receiving side to follow symlinks, such as symlinks to directories.  In a
modern rsync such as this one, you\(cq\&ll need to specify \fB\-\-keep\-dirlinks\fP (\fB\-K\fP)
to get this extra behavior.  The only exception is when sending files to
an rsync that is too old to understand \fB\-K\fP \-\- in that case, the \fB\-L\fP option
will still have the side\-effect of \fB\-K\fP on that older receiving rsync.
.IP 
.IP "\fB\-\-copy\-unsafe\-links\fP"
This tells rsync to copy the referent of
symbolic links that point outside the copied tree.  Absolute symlinks
are also treated like ordinary files, and so are any symlinks in the
source path itself when \fB\-\-relative\fP is used.  This option has no
additional effect if \fB\-\-copy\-links\fP was also specified.
.IP 
.IP "\fB\-\-safe\-links\fP"
This tells rsync to ignore any symbolic links
which point outside the copied tree. All absolute symlinks are
also ignored. Using this option in conjunction with \fB\-\-relative\fP may
give unexpected results.
.IP 
.IP "\fB\-\-munge\-links\fP"
This option tells rsync to (1) modify all symlinks on
the receiving side in a way that makes them unusable but recoverable (see
below), or (2) to unmunge symlinks on the sending side that had been stored in
a munged state.  This is useful if you don\(cq\&t quite trust the source of the data
to not try to slip in a symlink to a unexpected place.
.IP 
The way rsync disables the use of symlinks is to prefix each one with the
string \(dq\&/rsyncd\-munged/\(dq\&.  This prevents the links from being used as long as
that directory does not exist.  When this option is enabled, rsync will refuse
to run if that path is a directory or a symlink to a directory.
.IP 
The option only affects the client side of the transfer, so if you need it to
affect the server, specify it via \fB\-\-remote\-option\fP.  (Note that in a local
transfer, the client side is the sender.)
.IP 
This option has no affect on a daemon, since the daemon configures whether it
wants munged symlinks via its \(dq\&munge symlinks\(dq\& parameter.  See also the
\(dq\&munge\-symlinks\(dq\& perl script in the support directory of the source code.
.IP 
.IP "\fB\-k, \-\-copy\-dirlinks\fP"
This option causes the sending side to treat
a symlink to a directory as though it were a real directory.  This is
useful if you don\(cq\&t want symlinks to non\-directories to be affected, as
they would be using \fB\-\-copy\-links\fP.
.IP 
Without this option, if the sending side has replaced a directory with a
symlink to a directory, the receiving side will delete anything that is in
the way of the new symlink, including a directory hierarchy (as long as
\fB\-\-force\fP or \fB\-\-delete\fP is in effect).
.IP 
See also \fB\-\-keep\-dirlinks\fP for an analogous option for the receiving
side.
.IP 
\fB\-\-copy\-dirlinks\fP applies to all symlinks to directories in the source.  If
you want to follow only a few specified symlinks, a trick you can use is to
pass them as additional source args with a trailing slash, using \fB\-\-relative\fP
to make the paths match up right.  For example:
.IP 
.RS 
\f(CWrsync \-r \-\-relative src/./ src/./follow\-me/ dest/\fP
.RE

.IP 
This works because rsync calls \fBlstat\fP(2) on the source arg as given, and the
trailing slash makes \fBlstat\fP(2) follow the symlink, giving rise to a directory
in the file\-list which overrides the symlink found during the scan of \(dq\&src/./\(dq\&.
.IP 
.IP "\fB\-K, \-\-keep\-dirlinks\fP"
This option causes the receiving side to treat
a symlink to a directory as though it were a real directory, but only if it
matches a real directory from the sender.  Without this option, the
receiver\(cq\&s symlink would be deleted and replaced with a real directory.
.IP 
For example, suppose you transfer a directory \(dq\&foo\(dq\& that contains a file
\(dq\&file\(dq\&, but \(dq\&foo\(dq\& is a symlink to directory \(dq\&bar\(dq\& on the receiver.  Without
\fB\-\-keep\-dirlinks\fP, the receiver deletes symlink \(dq\&foo\(dq\&, recreates it as a
directory, and receives the file into the new directory.  With
\fB\-\-keep\-dirlinks\fP, the receiver keeps the symlink and \(dq\&file\(dq\& ends up in
\(dq\&bar\(dq\&.
.IP 
One note of caution:  if you use \fB\-\-keep\-dirlinks\fP, you must trust all
the symlinks in the copy!  If it is possible for an untrusted user to
create their own symlink to any directory, the user could then (on a
subsequent copy) replace the symlink with a real directory and affect the
content of whatever directory the symlink references.  For backup copies,
you are better off using something like a bind mount instead of a symlink
to modify your receiving hierarchy.
.IP 
See also \fB\-\-copy\-dirlinks\fP for an analogous option for the sending side.
.IP 
.IP "\fB\-H, \-\-hard\-links\fP"
This tells rsync to look for hard\-linked files in
the source and link together the corresponding files on the destination.
Without this option, hard\-linked files in the source are treated
as though they were separate files.
.IP 
This option does NOT necessarily ensure that the pattern of hard links on the
destination exactly matches that on the source.  Cases in which the
destination may end up with extra hard links include the following:
.IP 
.RS 
.IP o 
If the destination contains extraneous hard\-links (more linking than
what is present in the source file list), the copying algorithm will not
break them explicitly.  However, if one or more of the paths have content
differences, the normal file\-update process will break those extra links
(unless you are using the \fB\-\-inplace\fP option).
.IP o 
If you specify a \fB\-\-link\-dest\fP directory that contains hard links,
the linking of the destination files against the \fB\-\-link\-dest\fP files can
cause some paths in the destination to become linked together due to the
\fB\-\-link\-dest\fP associations.
.RE

.IP 
Note that rsync can only detect hard links between files that are inside
the transfer set.  If rsync updates a file that has extra hard\-link
connections to files outside the transfer, that linkage will be broken.  If
you are tempted to use the \fB\-\-inplace\fP option to avoid this breakage, be
very careful that you know how your files are being updated so that you are
certain that no unintended changes happen due to lingering hard links (and
see the \fB\-\-inplace\fP option for more caveats).
.IP 
If incremental recursion is active (see \fB\-\-recursive\fP), rsync may transfer
a missing hard\-linked file before it finds that another link for that contents
exists elsewhere in the hierarchy.  This does not affect the accuracy of
the transfer (i.e. which files are hard\-linked together), just its efficiency
(i.e. copying the data for a new, early copy of a hard\-linked file that could
have been found later in the transfer in another member of the hard\-linked
set of files).  One way to avoid this inefficiency is to disable
incremental recursion using the \fB\-\-no\-inc\-recursive\fP option.
.IP 
.IP "\fB\-p, \-\-perms\fP"
This option causes the receiving rsync to set the
destination permissions to be the same as the source permissions.  (See
also the \fB\-\-chmod\fP option for a way to modify what rsync considers to
be the source permissions.)
.IP 
When this option is \fIoff\fP, permissions are set as follows:
.IP 
.RS 
.IP o 
Existing files (including updated files) retain their existing
permissions, though the \fB\-\-executability\fP option might change just
the execute permission for the file.
.IP o 
New files get their \(dq\&normal\(dq\& permission bits set to the source
file\(cq\&s permissions masked with the receiving directory\(cq\&s default
permissions (either the receiving process\(cq\&s umask, or the permissions
specified via the destination directory\(cq\&s default ACL), and
their special permission bits disabled except in the case where a new
directory inherits a setgid bit from its parent directory.
.RE

.IP 
Thus, when \fB\-\-perms\fP and \fB\-\-executability\fP are both disabled,
rsync\(cq\&s behavior is the same as that of other file\-copy utilities,
such as \fBcp\fP(1) and \fBtar\fP(1).
.IP 
In summary: to give destination files (both old and new) the source
permissions, use \fB\-\-perms\fP.  To give new files the destination\-default
permissions (while leaving existing files unchanged), make sure that the
\fB\-\-perms\fP option is off and use \fB\-\-chmod=ugo=rwX\fP (which ensures that
all non\-masked bits get enabled).  If you\(cq\&d care to make this latter
behavior easier to type, you could define a popt alias for it, such as
putting this line in the file ~/.popt (the following defines the \fB\-Z\fP option,
and includes \-\-no\-g to use the default group of the destination dir):
.IP 
.RS 
\f(CW   rsync alias \-Z \-\-no\-p \-\-no\-g \-\-chmod=ugo=rwX\fP
.RE

.IP 
You could then use this new option in a command such as this one:
.IP 
.RS 
\f(CW   rsync \-avZ src/ dest/\fP
.RE

.IP 
(Caveat: make sure that \fB\-a\fP does not follow \fB\-Z\fP, or it will re\-enable
the two \(dq\&\-\-no\-*\(dq\& options mentioned above.)
.IP 
The preservation of the destination\(cq\&s setgid bit on newly\-created
directories when \fB\-\-perms\fP is off was added in rsync 2.6.7.  Older rsync
versions erroneously preserved the three special permission bits for
newly\-created files when \fB\-\-perms\fP was off, while overriding the
destination\(cq\&s setgid bit setting on a newly\-created directory.  Default ACL
observance was added to the ACL patch for rsync 2.6.7, so older (or
non\-ACL\-enabled) rsyncs use the umask even if default ACLs are present.
(Keep in mind that it is the version of the receiving rsync that affects
these behaviors.)
.IP 
.IP "\fB\-E, \-\-executability\fP"
This option causes rsync to preserve the
executability (or non\-executability) of regular files when \fB\-\-perms\fP is
not enabled.  A regular file is considered to be executable if at least one
\(cq\&x\(cq\& is turned on in its permissions.  When an existing destination file\(cq\&s
executability differs from that of the corresponding source file, rsync
modifies the destination file\(cq\&s permissions as follows:
.IP 
.RS 
.IP o 
To make a file non\-executable, rsync turns off all its \(cq\&x\(cq\&
permissions.
.IP o 
To make a file executable, rsync turns on each \(cq\&x\(cq\& permission that
has a corresponding \(cq\&r\(cq\& permission enabled.
.RE

.IP 
If \fB\-\-perms\fP is enabled, this option is ignored.
.IP 
.IP "\fB\-A, \-\-acls\fP"
This option causes rsync to update the destination
ACLs to be the same as the source ACLs.
The option also implies \fB\-\-perms\fP.
.IP 
The source and destination systems must have compatible ACL entries for this
option to work properly.  See the \fB\-\-fake\-super\fP option for a way to backup
and restore ACLs that are not compatible.
.IP 
.IP "\fB\-X, \-\-xattrs\fP"
This option causes rsync to update the destination
extended attributes to be the same as the source ones.
.IP 
For systems that support extended\-attribute namespaces, a copy being done by a
super\-user copies all namespaces except system.*.  A normal user only copies
the user.* namespace.  To be able to backup and restore non\-user namespaces as
a normal user, see the \fB\-\-fake\-super\fP option.
.IP 
The above name filtering can be overridden by using one or more filter options
with the \fBx\fP modifier. When you specify an xattr\-affecting filter rule, rsync
requires that you do your own system/user filtering, as well as any additional
filtering for what xattr names are copied and what names are allowed to be
deleted.  For example, to skip the system namespace, you could specify:
.IP 
.RS 
\-\-filter=\(cq\&\-x system.*\(cq\&
.RE

.IP 
To skip all namespaces except the user namespace, you could specify a
negated\-user match:
.IP 
.RS 
\-\-filter=\(cq\&\-x! user.*\(cq\&
.RE

.IP 
To prevent any attributes from being deleted, you could specify a receiver\-only
rule that excludes all names:
.IP 
.RS 
\-\-filter=\(cq\&\-xr *\(cq\&
.RE

.IP 
Note that the \fB\-X\fP option does not copy rsync\(cq\&s special xattr values (e.g.
those used by \fB\-\-fake\-super\fP) unless you repeat the option (e.g. \-XX).
This \(dq\&copy all xattrs\(dq\& mode cannot be used with \fB\-\-fake\-super\fP.
.IP 
.IP "\fB\-\-chmod\fP"
This option tells rsync to apply one or more
comma\-separated \(dq\&chmod\(dq\& modes to the permission of the files in the
transfer.  The resulting value is treated as though it were the permissions
that the sending side supplied for the file, which means that this option
can seem to have no effect on existing files if \fB\-\-perms\fP is not enabled.
.IP 
In addition to the normal parsing rules specified in the \fBchmod\fP(1)
manpage, you can specify an item that should only apply to a directory by
prefixing it with a \(cq\&D\(cq\&, or specify an item that should only apply to a
file by prefixing it with a \(cq\&F\(cq\&.  For example, the following will ensure
that all directories get marked set\-gid, that no files are other\-writable,
that both are user\-writable and group\-writable, and that both have
consistent executability across all bits:
.IP 
.RS 
\-\-chmod=Dg+s,ug+w,Fo\-w,+X
.RE

.IP 
Using octal mode numbers is also allowed:
.IP 
.RS 
\-\-chmod=D2775,F664
.RE

.IP 
It is also legal to specify multiple \fB\-\-chmod\fP options, as each
additional option is just appended to the list of changes to make.
.IP 
See the \fB\-\-perms\fP and \fB\-\-executability\fP options for how the resulting
permission value can be applied to the files in the transfer.
.IP 
.IP "\fB\-o, \-\-owner\fP"
This option causes rsync to set the owner of the
destination file to be the same as the source file, but only if the
receiving rsync is being run as the super\-user (see also the \fB\-\-super\fP
and \fB\-\-fake\-super\fP options).
Without this option, the owner of new and/or transferred files are set to
the invoking user on the receiving side.
.IP 
The preservation of ownership will associate matching names by default, but
may fall back to using the ID number in some circumstances (see also the
\fB\-\-numeric\-ids\fP option for a full discussion).
.IP 
.IP "\fB\-g, \-\-group\fP"
This option causes rsync to set the group of the
destination file to be the same as the source file.  If the receiving
program is not running as the super\-user (or if \fB\-\-no\-super\fP was
specified), only groups that the invoking user on the receiving side
is a member of will be preserved.
Without this option, the group is set to the default group of the invoking
user on the receiving side.
.IP 
The preservation of group information will associate matching names by
default, but may fall back to using the ID number in some circumstances
(see also the \fB\-\-numeric\-ids\fP option for a full discussion).
.IP 
.IP "\fB\-\-devices\fP"
This option causes rsync to transfer character and
block device files to the remote system to recreate these devices.
This option has no effect if the receiving rsync is not run as the
super\-user (see also the \fB\-\-super\fP and \fB\-\-fake\-super\fP options).
.IP 
.IP "\fB\-\-specials\fP"
This option causes rsync to transfer special files
such as named sockets and fifos.
.IP 
.IP "\fB\-D\fP"
The \fB\-D\fP option is equivalent to \fB\-\-devices\fP \fB\-\-specials\fP.
.IP 
.IP "\fB\-t, \-\-times\fP"
This tells rsync to transfer modification times along
with the files and update them on the remote system.  Note that if this
option is not used, the optimization that excludes files that have not been
modified cannot be effective; in other words, a missing \fB\-t\fP or \fB\-a\fP will
cause the next transfer to behave as if it used \fB\-I\fP, causing all files to be
updated (though rsync\(cq\&s delta\-transfer algorithm will make the update fairly efficient
if the files haven\(cq\&t actually changed, you\(cq\&re much better off using \fB\-t\fP).
.IP 
.IP "\fB\-O, \-\-omit\-dir\-times\fP"
This tells rsync to omit directories when
it is preserving modification times (see \fB\-\-times\fP).  If NFS is sharing
the directories on the receiving side, it is a good idea to use \fB\-O\fP.
This option is inferred if you use \fB\-\-backup\fP without \fB\-\-backup\-dir\fP.
.IP 
This option also has the side\-effect of avoiding early creation of directories
in incremental recursion copies.  The default \fB\-\-inc\-recursive\fP copying
normally does an early\-create pass of all the sub\-directories in a parent
directory in order for it to be able to then set the modify time of the parent
directory right away (without having to delay that until a bunch of recursive
copying has finished).  This early\-create idiom is not necessary if directory
modify times are not being preserved, so it is skipped.  Since early\-create
directories don\(cq\&t have accurate mode, mtime, or ownership, the use of this
option can help when someone wants to avoid these partially\-finished
directories.
.IP 
.IP "\fB\-J, \-\-omit\-link\-times\fP"
This tells rsync to omit symlinks when
it is preserving modification times (see \fB\-\-times\fP).
.IP 
.IP "\fB\-\-super\fP"
This tells the receiving side to attempt super\-user
activities even if the receiving rsync wasn\(cq\&t run by the super\-user.  These
activities include: preserving users via the \fB\-\-owner\fP option, preserving
all groups (not just the current user\(cq\&s groups) via the \fB\-\-groups\fP
option, and copying devices via the \fB\-\-devices\fP option.  This is useful
for systems that allow such activities without being the super\-user, and
also for ensuring that you will get errors if the receiving side isn\(cq\&t
being run as the super\-user.  To turn off super\-user activities, the
super\-user can use \fB\-\-no\-super\fP.
.IP 
.IP "\fB\-\-fake\-super\fP"
When this option is enabled, rsync simulates
super\-user activities by saving/restoring the privileged attributes via
special extended attributes that are attached to each file (as needed).  This
includes the file\(cq\&s owner and group (if it is not the default), the file\(cq\&s
device info (device & special files are created as empty text files), and
any permission bits that we won\(cq\&t allow to be set on the real file (e.g.
the real file gets u\-s,g\-s,o\-t for safety) or that would limit the owner\(cq\&s
access (since the real super\-user can always access/change a file, the
files we create can always be accessed/changed by the creating user).
This option also handles ACLs (if \fB\-\-acls\fP was specified) and non\-user
extended attributes (if \fB\-\-xattrs\fP was specified).
.IP 
This is a good way to backup data without using a super\-user, and to store
ACLs from incompatible systems.
.IP 
The \fB\-\-fake\-super\fP option only affects the side where the option is used.
To affect the remote side of a remote\-shell connection, use the
\fB\-\-remote\-option\fP (\fB\-M\fP) option:
.IP 
.RS 
\f(CW  rsync \-av \-M\-\-fake\-super /src/ host:/dest/\fP
.RE

.IP 
For a local copy, this option affects both the source and the destination.
If you wish a local copy to enable this option just for the destination
files, specify \fB\-M\-\-fake\-super\fP.  If you wish a local copy to enable
this option just for the source files, combine \fB\-\-fake\-super\fP with
\fB\-M\-\-super\fP.
.IP 
This option is overridden by both \fB\-\-super\fP and \fB\-\-no\-super\fP.
.IP 
See also the \(dq\&fake super\(dq\& setting in the daemon\(cq\&s rsyncd.conf file.
.IP 
.IP "\fB\-S, \-\-sparse\fP"
Try to handle sparse files efficiently so they take
up less space on the destination.  If combined with \fB\-\-inplace\fP the
file created might not end up with sparse blocks with some combinations
of kernel version and/or filesystem type.  If \fB\-\-whole\-file\fP is in
effect (e.g. for a local copy) then it will always work because rsync
truncates the file prior to writing out the updated version.
.IP 
Note that versions of rsync older than 3.1.3 will reject the combination of
\fB\-\-sparse\fP and \fB\-\-inplace\fP.
.IP 
.IP "\fB\-\-preallocate\fP"
This tells the receiver to allocate each destination
file to its eventual size before writing data to the file.  Rsync will only
use the real filesystem\-level preallocation support provided by Linux\(cq\&s
\fBfallocate\fP(2) system call or Cygwin\(cq\&s \fBposix_fallocate\fP(3), not the slow
glibc implementation that writes a null byte into each block.
.IP 
Without this option, larger files may not be entirely contiguous on the
filesystem, but with this option rsync will probably copy more slowly.  If the
destination is not an extent\-supporting filesystem (such as ext4, xfs, NTFS,
etc.), this option may have no positive effect at all.
.IP 
If combined with \fB\-\-sparse\fP, the file will only have sparse blocks (as
opposed to allocated sequences of null bytes) if the kernel version and
filesystem type support creating holes in the allocated data.
.IP 
.IP "\fB\-n, \-\-dry\-run\fP"
This makes rsync perform a trial run that doesn\(cq\&t
make any changes (and produces mostly the same output as a real run).  It
is most commonly used in combination with the \fB\-v, \-\-verbose\fP and/or
\fB\-i, \-\-itemize\-changes\fP options to see what an rsync command is going
to do before one actually runs it.
.IP 
The output of \fB\-\-itemize\-changes\fP is supposed to be exactly the same on a
dry run and a subsequent real run (barring intentional trickery and system
call failures); if it isn\(cq\&t, that\(cq\&s a bug.  Other output should be mostly
unchanged, but may differ in some areas.  Notably, a dry run does not
send the actual data for file transfers, so \fB\-\-progress\fP has no effect,
the \(dq\&bytes sent\(dq\&, \(dq\&bytes received\(dq\&, \(dq\&literal data\(dq\&, and \(dq\&matched data\(dq\&
statistics are too small, and the \(dq\&speedup\(dq\& value is equivalent to a run
where no file transfers were needed.
.IP 
.IP "\fB\-W, \-\-whole\-file\fP"
This option disables rsync\(cq\&s delta\-transfer algorithm,
which causes all transferred files to be sent whole.  The transfer may be
faster if this option is used when the bandwidth between the source and
destination machines is higher than the bandwidth to disk (especially when the
\(dq\&disk\(dq\& is actually a networked filesystem).  This is the default when both
the source and destination are specified as local paths, but only if no
batch\-writing option is in effect.
.IP 
.IP "\fB\-\-checksum\-choice=STR\fP"
This option overrides the checksum algoriths.
If one algorithm name is specified, it is used for both the transfer checksums
and (assuming \fB\-\-checksum\fP is specifed) the pre\-transfer checksumming. If two
comma\-separated names are supplied, the first name affects the transfer
checksums, and the second name affects the pre\-transfer checksumming.
.IP 
The algorithm choices are \(dq\&auto\(dq\&, \(dq\&md4\(dq\&, \(dq\&md5\(dq\&, and \(dq\&none\(dq\&.  If \(dq\&none\(dq\& is
specified for the first name, the \fB\-\-whole\-file\fP option is forced on and no
checksum verification is performed on the transferred data.  If \(dq\&none\(dq\& is
specified for the second name, the \fB\-\-checksum\fP option cannot be used. The
\(dq\&auto\(dq\& option is the default, where rsync bases its algorithm choice on the
protocol version (for backward compatibility with older rsync versions).
.IP 
.IP "\fB\-x, \-\-one\-file\-system\fP"
This tells rsync to avoid crossing a
filesystem boundary when recursing.  This does not limit the user\(cq\&s ability
to specify items to copy from multiple filesystems, just rsync\(cq\&s recursion
through the hierarchy of each directory that the user specified, and also
the analogous recursion on the receiving side during deletion.  Also keep
in mind that rsync treats a \(dq\&bind\(dq\& mount to the same device as being on the
same filesystem.
.IP 
If this option is repeated, rsync omits all mount\-point directories from
the copy.  Otherwise, it includes an empty directory at each mount\-point it
encounters (using the attributes of the mounted directory because those of
the underlying mount\-point directory are inaccessible).
.IP 
If rsync has been told to collapse symlinks (via \fB\-\-copy\-links\fP or
\fB\-\-copy\-unsafe\-links\fP), a symlink to a directory on another device is
treated like a mount\-point.  Symlinks to non\-directories are unaffected
by this option.
.IP 
.IP "\fB\-\-existing, \-\-ignore\-non\-existing\fP"
This tells rsync to skip
creating files (including directories) that do not exist
yet on the destination.  If this option is
combined with the \fB\-\-ignore\-existing\fP option, no files will be updated
(which can be useful if all you want to do is delete extraneous files).
.IP 
This option is a transfer rule, not an exclude, so it doesn\(cq\&t affect the
data that goes into the file\-lists, and thus it doesn\(cq\&t affect deletions.
It just limits the files that the receiver requests to be transferred.
.IP 
.IP "\fB\-\-ignore\-existing\fP"
This tells rsync to skip updating files that
already exist on the destination (this does \fInot\fP ignore existing
directories, or nothing would get done).  See also \fB\-\-existing\fP.
.IP 
This option is a transfer rule, not an exclude, so it doesn\(cq\&t affect the
data that goes into the file\-lists, and thus it doesn\(cq\&t affect deletions.
It just limits the files that the receiver requests to be transferred.
.IP 
This option can be useful for those doing backups using the \fB\-\-link\-dest\fP
option when they need to continue a backup run that got interrupted.  Since
a \fB\-\-link\-dest\fP run is copied into a new directory hierarchy (when it is
used properly), using \fB\-\-ignore existing\fP will ensure that the
already\-handled files don\(cq\&t get tweaked (which avoids a change in
permissions on the hard\-linked files).  This does mean that this option
is only looking at the existing files in the destination hierarchy itself.
.IP 
.IP "\fB\-\-remove\-source\-files\fP"
This tells rsync to remove from the sending
side the files (meaning non\-directories) that are a part of the transfer
and have been successfully duplicated on the receiving side.
.IP 
Note that you should only use this option on source files that are quiescent.
If you are using this to move files that show up in a particular directory over
to another host, make sure that the finished files get renamed into the source
directory, not directly written into it, so that rsync can\(cq\&t possibly transfer
a file that is not yet fully written.  If you can\(cq\&t first write the files into
a different directory, you should use a naming idiom that lets rsync avoid
transferring files that are not yet finished (e.g. name the file \(dq\&foo.new\(dq\& when
it is written, rename it to \(dq\&foo\(dq\& when it is done, and then use the option
\fB\-\-exclude='\&*.new'\&\fP for the rsync transfer).
.IP 
Starting with 3.1.0, rsync will skip the sender\-side removal (and output an
error) if the file\(cq\&s size or modify time has not stayed unchanged.
.IP 
.IP "\fB\-\-delete\fP"
This tells rsync to delete extraneous files from the
receiving side (ones that aren\(cq\&t on the sending side), but only for the
directories that are being synchronized.  You must have asked rsync to
send the whole directory (e.g. \(dq\&dir\(dq\& or \(dq\&dir/\(dq\&) without using a wildcard
for the directory\(cq\&s contents (e.g. \(dq\&dir/*\(dq\&) since the wildcard is expanded
by the shell and rsync thus gets a request to transfer individual files, not
the files\(cq\& parent directory.  Files that are excluded from the transfer are
also excluded from being deleted unless you use the \fB\-\-delete\-excluded\fP
option or mark the rules as only matching on the sending side (see the
include/exclude modifiers in the FILTER RULES section).
.IP 
Prior to rsync 2.6.7, this option would have no effect unless \fB\-\-recursive\fP
was enabled.  Beginning with 2.6.7, deletions will also occur when \fB\-\-dirs\fP
(\fB\-d\fP) is enabled, but only for directories whose contents are being copied.
.IP 
This option can be dangerous if used incorrectly!  It is a very good idea to
first try a run using the \fB\-\-dry\-run\fP option (\fB\-n\fP) to see what files are
going to be deleted.
.IP 
If the sending side detects any I/O errors, then the deletion of any
files at the destination will be automatically disabled. This is to
prevent temporary filesystem failures (such as NFS errors) on the
sending side from causing a massive deletion of files on the
destination.  You can override this with the \fB\-\-ignore\-errors\fP option.
.IP 
The \fB\-\-delete\fP option may be combined with one of the \-\-delete\-WHEN options
without conflict, as well as \fB\-\-delete\-excluded\fP.  However, if none of the
\-\-delete\-WHEN options are specified, rsync will choose the
\fB\-\-delete\-during\fP algorithm when talking to rsync 3.0.0 or newer, and
the \fB\-\-delete\-before\fP algorithm when talking to an older rsync.  See also
\fB\-\-delete\-delay\fP and \fB\-\-delete\-after\fP.
.IP 
.IP "\fB\-\-delete\-before\fP"
Request that the file\-deletions on the receiving
side be done before the transfer starts.
See \fB\-\-delete\fP (which is implied) for more details on file\-deletion.
.IP 
Deleting before the transfer is helpful if the filesystem is tight for space
and removing extraneous files would help to make the transfer possible.
However, it does introduce a delay before the start of the transfer,
and this delay might cause the transfer to timeout (if \fB\-\-timeout\fP was
specified).  It also forces rsync to use the old, non\-incremental recursion
algorithm that requires rsync to scan all the files in the transfer into
memory at once (see \fB\-\-recursive\fP).
.IP 
.IP "\fB\-\-delete\-during, \-\-del\fP"
Request that the file\-deletions on the
receiving side be done incrementally as the transfer happens.  The
per\-directory delete scan is done right before each directory is checked
for updates, so it behaves like a more efficient \fB\-\-delete\-before\fP,
including doing the deletions prior to any per\-directory filter files
being updated.  This option was first added in rsync version 2.6.4.
See \fB\-\-delete\fP (which is implied) for more details on file\-deletion.
.IP 
.IP "\fB\-\-delete\-delay\fP"
Request that the file\-deletions on the receiving
side be computed during the transfer (like \fB\-\-delete\-during\fP), and then
removed after the transfer completes.  This is useful when combined with
\fB\-\-delay\-updates\fP and/or \fB\-\-fuzzy\fP, and is more efficient than using
\fB\-\-delete\-after\fP (but can behave differently, since \fB\-\-delete\-after\fP
computes the deletions in a separate pass after all updates are done).
If the number of removed files overflows an internal buffer, a
temporary file will be created on the receiving side to hold the names (it
is removed while open, so you shouldn\(cq\&t see it during the transfer).  If
the creation of the temporary file fails, rsync will try to fall back to
using \fB\-\-delete\-after\fP (which it cannot do if \fB\-\-recursive\fP is doing an
incremental scan).
See \fB\-\-delete\fP (which is implied) for more details on file\-deletion.
.IP 
.IP "\fB\-\-delete\-after\fP"
Request that the file\-deletions on the receiving
side be done after the transfer has completed.  This is useful if you
are sending new per\-directory merge files as a part of the transfer and
you want their exclusions to take effect for the delete phase of the
current transfer.  It also forces rsync to use the old, non\-incremental
recursion algorithm that requires rsync to scan all the files in the
transfer into memory at once (see \fB\-\-recursive\fP).
See \fB\-\-delete\fP (which is implied) for more details on file\-deletion.
.IP 
.IP "\fB\-\-delete\-excluded\fP"
In addition to deleting the files on the
receiving side that are not on the sending side, this tells rsync to also
delete any files on the receiving side that are excluded (see \fB\-\-exclude\fP).
See the FILTER RULES section for a way to make individual exclusions behave
this way on the receiver, and for a way to protect files from
\fB\-\-delete\-excluded\fP.
See \fB\-\-delete\fP (which is implied) for more details on file\-deletion.
.IP 
.IP "\fB\-\-ignore\-missing\-args\fP"
When rsync is first processing the explicitly
requested source files (e.g. command\-line arguments or \fB\-\-files\-from\fP
entries), it is normally an error if the file cannot be found.  This option
suppresses that error, and does not try to transfer the file.  This does not
affect subsequent vanished\-file errors if a file was initially found to be
present and later is no longer there.
.IP 
.IP "\fB\-\-delete\-missing\-args\fP"
This option takes the behavior of (the implied)
\fB\-\-ignore\-missing\-args\fP option a step farther:  each missing arg will become
a deletion request of the corresponding destination file on the receiving side
(should it exist).  If the destination file is a non\-empty directory, it will
only be successfully deleted if \-\-force or \-\-delete are in effect.  Other than
that, this option is independent of any other type of delete processing.
.IP 
The missing source files are represented by special file\-list entries which
display as a \(dq\&*missing\(dq\& entry in the \fB\-\-list\-only\fP output.
.IP 
.IP "\fB\-\-ignore\-errors\fP"
Tells \fB\-\-delete\fP to go ahead and delete files
even when there are I/O errors.
.IP 
.IP "\fB\-\-force\fP"
This option tells rsync to delete a non\-empty directory
when it is to be replaced by a non\-directory.  This is only relevant if
deletions are not active (see \fB\-\-delete\fP for details).
.IP 
Note for older rsync versions: \fB\-\-force\fP used to still be required when
using \fB\-\-delete\-after\fP, and it used to be non\-functional unless the
\fB\-\-recursive\fP option was also enabled.
.IP 
.IP "\fB\-\-max\-delete=NUM\fP"
This tells rsync not to delete more than NUM
files or directories.  If that limit is exceeded, all further deletions are
skipped through the end of the transfer.  At the end, rsync outputs a warning
(including a count of the skipped deletions) and exits with an error code
of 25 (unless some more important error condition also occurred).
.IP 
Beginning with version 3.0.0, you may specify \fB\-\-max\-delete=0\fP to be warned
about any extraneous files in the destination without removing any of them.
Older clients interpreted this as \(dq\&unlimited\(dq\&, so if you don\(cq\&t know what
version the client is, you can use the less obvious \fB\-\-max\-delete=\-1\fP as
a backward\-compatible way to specify that no deletions be allowed (though
really old versions didn\(cq\&t warn when the limit was exceeded).
.IP 
.IP "\fB\-\-max\-size=SIZE\fP"
This tells rsync to avoid transferring any
file that is larger than the specified SIZE. The SIZE value can be
suffixed with a string to indicate a size multiplier, and
may be a fractional value (e.g. \(dq\&\fB\-\-max\-size=1.5m\fP\(dq\&).
.IP 
This option is a transfer rule, not an exclude, so it doesn\(cq\&t affect the
data that goes into the file\-lists, and thus it doesn\(cq\&t affect deletions.
It just limits the files that the receiver requests to be transferred.
.IP 
The suffixes are as follows: \(dq\&K\(dq\& (or \(dq\&KiB\(dq\&) is a kibibyte (1024),
\(dq\&M\(dq\& (or \(dq\&MiB\(dq\&) is a mebibyte (1024*1024), and \(dq\&G\(dq\& (or \(dq\&GiB\(dq\&) is a
gibibyte (1024*1024*1024).
If you want the multiplier to be 1000 instead of 1024, use \(dq\&KB\(dq\&,
\(dq\&MB\(dq\&, or \(dq\&GB\(dq\&.  (Note: lower\-case is also accepted for all values.)
Finally, if the suffix ends in either \(dq\&+1\(dq\& or \(dq\&\-1\(dq\&, the value will
be offset by one byte in the indicated direction.
.IP 
Examples: \-\-max\-size=1.5mb\-1 is 1499999 bytes, and \-\-max\-size=2g+1 is
2147483649 bytes.
.IP 
Note that rsync versions prior to 3.1.0 did not allow \fB\-\-max\-size=0\fP.
.IP 
.IP "\fB\-\-min\-size=SIZE\fP"
This tells rsync to avoid transferring any
file that is smaller than the specified SIZE, which can help in not
transferring small, junk files.
See the \fB\-\-max\-size\fP option for a description of SIZE and other information.
.IP 
Note that rsync versions prior to 3.1.0 did not allow \fB\-\-min\-size=0\fP.
.IP 
.IP "\fB\-B, \-\-block\-size=BLOCKSIZE\fP"
This forces the block size used in
rsync\(cq\&s delta\-transfer algorithm to a fixed value.  It is normally selected based on
the size of each file being updated.  See the technical report for details.
.IP 
.IP "\fB\-e, \-\-rsh=COMMAND\fP"
This option allows you to choose an alternative
remote shell program to use for communication between the local and
remote copies of rsync. Typically, rsync is configured to use ssh by
default, but you may prefer to use rsh on a local network.
.IP 
If this option is used with \fB[user@]host::module/path\fP, then the
remote shell \fICOMMAND\fP will be used to run an rsync daemon on the
remote host, and all data will be transmitted through that remote
shell connection, rather than through a direct socket connection to a
running rsync daemon on the remote host.  See the section \(dq\&USING
RSYNC\-DAEMON FEATURES VIA A REMOTE\-SHELL CONNECTION\(dq\& above.
.IP 
Command\-line arguments are permitted in COMMAND provided that COMMAND is
presented to rsync as a single argument.  You must use spaces (not tabs
or other whitespace) to separate the command and args from each other,
and you can use single\- and/or double\-quotes to preserve spaces in an
argument (but not backslashes).  Note that doubling a single\-quote
inside a single\-quoted string gives you a single\-quote; likewise for
double\-quotes (though you need to pay attention to which quotes your
shell is parsing and which quotes rsync is parsing).  Some examples:
.IP 
.RS 
\f(CW    \-e '\&ssh \-p 2234'\&\fP
.br 
\f(CW    \-e '\&ssh \-o \(dq\&ProxyCommand nohup ssh firewall nc \-w1 %h %p\(dq\&'\&\fP
.br 
.RE

.IP 
(Note that ssh users can alternately customize site\-specific connect
options in their .ssh/config file.)
.IP 
You can also choose the remote shell program using the RSYNC_RSH
environment variable, which accepts the same range of values as \fB\-e\fP.
.IP 
See also the \fB\-\-blocking\-io\fP option which is affected by this option.
.IP 
.IP "\fB\-\-rsync\-path=PROGRAM\fP"
Use this to specify what program is to be run
on the remote machine to start\-up rsync.  Often used when rsync is not in
the default remote\-shell\(cq\&s path (e.g. \-\-rsync\-path=/usr/local/bin/rsync).
Note that PROGRAM is run with the help of a shell, so it can be any
program, script, or command sequence you\(cq\&d care to run, so long as it does
not corrupt the standard\-in & standard\-out that rsync is using to
communicate.
.IP 
One tricky example is to set a different default directory on the remote
machine for use with the \fB\-\-relative\fP option.  For instance:
.IP 
.RS 
\f(CW    rsync \-avR \-\-rsync\-path=\(dq\&cd /a/b && rsync\(dq\& host:c/d /e/\fP
.RE

.IP 
.IP "\fB\-M, \-\-remote\-option=OPTION\fP"
This option is used for more advanced
situations where you want certain effects to be limited to one side of the
transfer only.  For instance, if you want to pass \fB\-\-log\-file=FILE\fP and
\fB\-\-fake\-super\fP to the remote system, specify it like this:
.IP 
.RS 
\f(CW    rsync \-av \-M \-\-log\-file=foo \-M\-\-fake\-super src/ dest/\fP
.RE

.IP 
If you want to have an option affect only the local side of a transfer when
it normally affects both sides, send its negation to the remote side.  Like
this:
.IP 
.RS 
\f(CW    rsync \-av \-x \-M\-\-no\-x src/ dest/\fP
.RE

.IP 
Be cautious using this, as it is possible to toggle an option that will cause
rsync to have a different idea about what data to expect next over the socket,
and that will make it fail in a cryptic fashion.
.IP 
Note that it is best to use a separate \fB\-\-remote\-option\fP for each option you
want to pass.  This makes your useage compatible with the \fB\-\-protect\-args\fP
option.  If that option is off, any spaces in your remote options will be split
by the remote shell unless you take steps to protect them.
.IP 
When performing a local transfer, the \(dq\&local\(dq\& side is the sender and the
\(dq\&remote\(dq\& side is the receiver.
.IP 
Note some versions of the popt option\-parsing library have a bug in them that
prevents you from using an adjacent arg with an equal in it next to a short
option letter (e.g. \f(CW\-M\-\-log\-file=/tmp/foo\fP).  If this bug affects your
version of popt, you can use the version of popt that is included with rsync.
.IP 
.IP "\fB\-C, \-\-cvs\-exclude\fP"
This is a useful shorthand for excluding a
broad range of files that you often don\(cq\&t want to transfer between
systems. It uses a similar algorithm to CVS to determine if
a file should be ignored.
.IP 
The exclude list is initialized to exclude the following items (these
initial items are marked as perishable \-\- see the FILTER RULES section):
.IP 
.RS 
.RS 
\f(CWRCS SCCS CVS CVS.adm RCSLOG cvslog.* tags TAGS .make.state
\&.nse_depinfo *~ #* .#* ,* _$* *$ *.old *.bak *.BAK *.orig *.rej .del\-*
*.a *.olb *.o *.obj *.so *.exe *.Z *.elc *.ln core .svn/ .git/ .hg/ .bzr/\fP
.RE
.RE

.IP 
then, files listed in a $HOME/.cvsignore are added to the list and any
files listed in the CVSIGNORE environment variable (all cvsignore names
are delimited by whitespace).
.IP 
Finally, any file is ignored if it is in the same directory as a
\&.cvsignore file and matches one of the patterns listed therein.  Unlike
rsync\(cq\&s filter/exclude files, these patterns are split on whitespace.
See the \fBcvs\fP(1) manual for more information.
.IP 
If you\(cq\&re combining \fB\-C\fP with your own \fB\-\-filter\fP rules, you should
note that these CVS excludes are appended at the end of your own rules,
regardless of where the \fB\-C\fP was placed on the command\-line.  This makes them
a lower priority than any rules you specified explicitly.  If you want to
control where these CVS excludes get inserted into your filter rules, you
should omit the \fB\-C\fP as a command\-line option and use a combination of
\fB\-\-filter=:C\fP and \fB\-\-filter=\-C\fP (either on your command\-line or by
putting the \(dq\&:C\(dq\& and \(dq\&\-C\(dq\& rules into a filter file with your other rules).
The first option turns on the per\-directory scanning for the .cvsignore
file.  The second option does a one\-time import of the CVS excludes
mentioned above.
.IP 
.IP "\fB\-f, \-\-filter=RULE\fP"
This option allows you to add rules to selectively
exclude certain files from the list of files to be transferred. This is
most useful in combination with a recursive transfer.
.IP 
You may use as many \fB\-\-filter\fP options on the command line as you like
to build up the list of files to exclude.  If the filter contains whitespace,
be sure to quote it so that the shell gives the rule to rsync as a single
argument.  The text below also mentions that you can use an underscore to
replace the space that separates a rule from its arg.
.IP 
See the FILTER RULES section for detailed information on this option.
.IP 
.IP "\fB\-F\fP"
The \fB\-F\fP option is a shorthand for adding two \fB\-\-filter\fP rules to
your command.  The first time it is used is a shorthand for this rule:
.IP 
.RS 
\f(CW   \-\-filter='\&dir\-merge /.rsync\-filter'\&\fP
.RE

.IP 
This tells rsync to look for per\-directory .rsync\-filter files that have
been sprinkled through the hierarchy and use their rules to filter the
files in the transfer.  If \fB\-F\fP is repeated, it is a shorthand for this
rule:
.IP 
.RS 
\f(CW   \-\-filter='\&exclude .rsync\-filter'\&\fP
.RE

.IP 
This filters out the .rsync\-filter files themselves from the transfer.
.IP 
See the FILTER RULES section for detailed information on how these options
work.
.IP 
.IP "\fB\-\-exclude=PATTERN\fP"
This option is a simplified form of the
\fB\-\-filter\fP option that defaults to an exclude rule and does not allow
the full rule\-parsing syntax of normal filter rules.
.IP 
See the FILTER RULES section for detailed information on this option.
.IP 
.IP "\fB\-\-exclude\-from=FILE\fP"
This option is related to the \fB\-\-exclude\fP
option, but it specifies a FILE that contains exclude patterns (one per line).
Blank lines in the file and lines starting with \(cq\&;\(cq\& or \(cq\&#\(cq\& are ignored.
If \fIFILE\fP is \fB\-\fP, the list will be read from standard input.
.IP 
.IP "\fB\-\-include=PATTERN\fP"
This option is a simplified form of the
\fB\-\-filter\fP option that defaults to an include rule and does not allow
the full rule\-parsing syntax of normal filter rules.
.IP 
See the FILTER RULES section for detailed information on this option.
.IP 
.IP "\fB\-\-include\-from=FILE\fP"
This option is related to the \fB\-\-include\fP
option, but it specifies a FILE that contains include patterns (one per line).
Blank lines in the file and lines starting with \(cq\&;\(cq\& or \(cq\&#\(cq\& are ignored.
If \fIFILE\fP is \fB\-\fP, the list will be read from standard input.
.IP 
.IP "\fB\-\-files\-from=FILE\fP"
Using this option allows you to specify the
exact list of files to transfer (as read from the specified FILE or \fB\-\fP
for standard input).  It also tweaks the default behavior of rsync to make
transferring just the specified files and directories easier:
.IP 
.RS 
.IP o 
The \fB\-\-relative\fP (\fB\-R\fP) option is implied, which preserves the path
information that is specified for each item in the file (use
\fB\-\-no\-relative\fP or \fB\-\-no\-R\fP if you want to turn that off).
.IP o 
The \fB\-\-dirs\fP (\fB\-d\fP) option is implied, which will create directories
specified in the list on the destination rather than noisily skipping
them (use \fB\-\-no\-dirs\fP or \fB\-\-no\-d\fP if you want to turn that off).
.IP o 
The \fB\-\-archive\fP (\fB\-a\fP) option\(cq\&s behavior does not imply \fB\-\-recursive\fP
(\fB\-r\fP), so specify it explicitly, if you want it.
.IP o 
These side\-effects change the default state of rsync, so the position
of the \fB\-\-files\-from\fP option on the command\-line has no bearing on how
other options are parsed (e.g. \fB\-a\fP works the same before or after
\fB\-\-files\-from\fP, as does \fB\-\-no\-R\fP and all other options).
.RE

.IP 
The filenames that are read from the FILE are all relative to the
source dir \-\- any leading slashes are removed and no \(dq\&..\(dq\& references are
allowed to go higher than the source dir.  For example, take this
command:
.IP 
.RS 
\f(CW   rsync \-a \-\-files\-from=/tmp/foo /usr remote:/backup\fP
.RE

.IP 
If /tmp/foo contains the string \(dq\&bin\(dq\& (or even \(dq\&/bin\(dq\&), the /usr/bin
directory will be created as /backup/bin on the remote host.  If it
contains \(dq\&bin/\(dq\& (note the trailing slash), the immediate contents of
the directory would also be sent (without needing to be explicitly
mentioned in the file \-\- this began in version 2.6.4).  In both cases,
if the \fB\-r\fP option was enabled, that dir\(cq\&s entire hierarchy would
also be transferred (keep in mind that \fB\-r\fP needs to be specified
explicitly with \fB\-\-files\-from\fP, since it is not implied by \fB\-a\fP).
Also note
that the effect of the (enabled by default) \fB\-\-relative\fP option is to
duplicate only the path info that is read from the file \-\- it does not
force the duplication of the source\-spec path (/usr in this case).
.IP 
In addition, the \fB\-\-files\-from\fP file can be read from the remote host
instead of the local host if you specify a \(dq\&host:\(dq\& in front of the file
(the host must match one end of the transfer).  As a short\-cut, you can
specify just a prefix of \(dq\&:\(dq\& to mean \(dq\&use the remote end of the
transfer\(dq\&.  For example:
.IP 
.RS 
\f(CW   rsync \-a \-\-files\-from=:/path/file\-list src:/ /tmp/copy\fP
.RE

.IP 
This would copy all the files specified in the /path/file\-list file that
was located on the remote \(dq\&src\(dq\& host.
.IP 
If the \fB\-\-iconv\fP and \fB\-\-protect\-args\fP options are specified and the
\fB\-\-files\-from\fP filenames are being sent from one host to another, the
filenames will be translated from the sending host\(cq\&s charset to the
receiving host\(cq\&s charset.
.IP 
NOTE: sorting the list of files in the \-\-files\-from input helps rsync to be
more efficient, as it will avoid re\-visiting the path elements that are shared
between adjacent entries.  If the input is not sorted, some path elements
(implied directories) may end up being scanned multiple times, and rsync will
eventually unduplicate them after they get turned into file\-list elements.
.IP 
.IP "\fB\-0, \-\-from0\fP"
This tells rsync that the rules/filenames it reads from a
file are terminated by a null (\(cq\&\e0\(cq\&) character, not a NL, CR, or CR+LF.
This affects \fB\-\-exclude\-from\fP, \fB\-\-include\-from\fP, \fB\-\-files\-from\fP, and any
merged files specified in a \fB\-\-filter\fP rule.
It does not affect \fB\-\-cvs\-exclude\fP (since all names read from a .cvsignore
file are split on whitespace).
.IP 
.IP "\fB\-s, \-\-protect\-args\fP"
This option sends all filenames and most options to
the remote rsync without allowing the remote shell to interpret them.  This
means that spaces are not split in names, and any non\-wildcard special
characters are not translated (such as ~, $, ;, &, etc.).  Wildcards are
expanded on the remote host by rsync (instead of the shell doing it).
.IP 
If you use this option with \fB\-\-iconv\fP, the args related to the remote
side will also be translated
from the local to the remote character\-set.  The translation happens before
wild\-cards are expanded.  See also the \fB\-\-files\-from\fP option.
.IP 
You may also control this option via the RSYNC_PROTECT_ARGS environment
variable.  If this variable has a non\-zero value, this option will be enabled
by default, otherwise it will be disabled by default.  Either state is
overridden by a manually specified positive or negative version of this option
(note that \fB\-\-no\-s\fP and \fB\-\-no\-protect\-args\fP are the negative versions).
Since this option was first introduced in 3.0.0, you\(cq\&ll need to make sure it\(cq\&s
disabled if you ever need to interact with a remote rsync that is older than
that.
.IP 
Rsync can also be configured (at build time) to have this option enabled by
default (with is overridden by both the environment and the command\-line).
This option will eventually become a new default setting at some
as\-yet\-undetermined point in the future.
.IP 
.IP "\fB\-T, \-\-temp\-dir=DIR\fP"
This option instructs rsync to use DIR as a
scratch directory when creating temporary copies of the files transferred
on the receiving side.  The default behavior is to create each temporary
file in the same directory as the associated destination file.
Beginning with rsync 3.1.1, the temp\-file names inside the specified DIR will
not be prefixed with an extra dot (though they will still have a random suffix
added).
.IP 
This option is most often used when the receiving disk partition does not
have enough free space to hold a copy of the largest file in the transfer.
In this case (i.e. when the scratch directory is on a different disk
partition), rsync will not be able to rename each received temporary file
over the top of the associated destination file, but instead must copy it
into place.  Rsync does this by copying the file over the top of the
destination file, which means that the destination file will contain
truncated data during this copy.  If this were not done this way (even if
the destination file were first removed, the data locally copied to a
temporary file in the destination directory, and then renamed into place)
it would be possible for the old file to continue taking up disk space (if
someone had it open), and thus there might not be enough room to fit the
new version on the disk at the same time.
.IP 
If you are using this option for reasons other than a shortage of disk
space, you may wish to combine it with the \fB\-\-delay\-updates\fP option,
which will ensure that all copied files get put into subdirectories in the
destination hierarchy, awaiting the end of the transfer.  If you don\(cq\&t
have enough room to duplicate all the arriving files on the destination
partition, another way to tell rsync that you aren\(cq\&t overly concerned
about disk space is to use the \fB\-\-partial\-dir\fP option with a relative
path; because this tells rsync that it is OK to stash off a copy of a
single file in a subdir in the destination hierarchy, rsync will use the
partial\-dir as a staging area to bring over the copied file, and then
rename it into place from there. (Specifying a \fB\-\-partial\-dir\fP with
an absolute path does not have this side\-effect.)
.IP 
.IP "\fB\-y, \-\-fuzzy\fP"
This option tells rsync that it should look for a
basis file for any destination file that is missing.  The current algorithm
looks in the same directory as the destination file for either a file that
has an identical size and modified\-time, or a similarly\-named file.  If
found, rsync uses the fuzzy basis file to try to speed up the transfer.
.IP 
If the option is repeated, the fuzzy scan will also be done in any matching
alternate destination directories that are specified via \fB\-\-compare\-dest\fP,
\fB\-\-copy\-dest\fP, or \fB\-\-link\-dest\fP.
.IP 
Note that the use of the \fB\-\-delete\fP option might get rid of any potential
fuzzy\-match files, so either use \fB\-\-delete\-after\fP or specify some
filename exclusions if you need to prevent this.
.IP 
.IP "\fB\-\-compare\-dest=DIR\fP"
This option instructs rsync to use \fIDIR\fP on
the destination machine as an additional hierarchy to compare destination
files against doing transfers (if the files are missing in the destination
directory).  If a file is found in \fIDIR\fP that is identical to the
sender\(cq\&s file, the file will NOT be transferred to the destination
directory.  This is useful for creating a sparse backup of just files that
have changed from an earlier backup.
This option is typically used to copy into an empty (or newly created)
directory.
.IP 
Beginning in version 2.6.4, multiple \fB\-\-compare\-dest\fP directories may be
provided, which will cause rsync to search the list in the order specified
for an exact match.
If a match is found that differs only in attributes, a local copy is made
and the attributes updated.
If a match is not found, a basis file from one of the \fIDIR\fPs will be
selected to try to speed up the transfer.
.IP 
If \fIDIR\fP is a relative path, it is relative to the destination directory.
See also \fB\-\-copy\-dest\fP and \fB\-\-link\-dest\fP.
.IP 
NOTE: beginning with version 3.1.0, rsync will remove a file from a non\-empty
destination hierarchy if an exact match is found in one of the compare\-dest
hierarchies (making the end result more closely match a fresh copy).
.IP 
.IP "\fB\-\-copy\-dest=DIR\fP"
This option behaves like \fB\-\-compare\-dest\fP, but
rsync will also copy unchanged files found in \fIDIR\fP to the destination
directory using a local copy.
This is useful for doing transfers to a new destination while leaving
existing files intact, and then doing a flash\-cutover when all files have
been successfully transferred.
.IP 
Multiple \fB\-\-copy\-dest\fP directories may be provided, which will cause
rsync to search the list in the order specified for an unchanged file.
If a match is not found, a basis file from one of the \fIDIR\fPs will be
selected to try to speed up the transfer.
.IP 
If \fIDIR\fP is a relative path, it is relative to the destination directory.
See also \fB\-\-compare\-dest\fP and \fB\-\-link\-dest\fP.
.IP 
.IP "\fB\-\-link\-dest=DIR\fP"
This option behaves like \fB\-\-copy\-dest\fP, but
unchanged files are hard linked from \fIDIR\fP to the destination directory.
The files must be identical in all preserved attributes (e.g. permissions,
possibly ownership) in order for the files to be linked together.
An example:
.IP 
.RS 
\f(CW  rsync \-av \-\-link\-dest=$PWD/prior_dir host:src_dir/ new_dir/\fP
.RE

.IP 
If file\(cq\&s aren\(cq\&t linking, double\-check their attributes.  Also check if some
attributes are getting forced outside of rsync\(cq\&s control, such a mount option
that squishes root to a single user, or mounts a removable drive with generic
ownership (such as OS X\(cq\&s \(dq\&Ignore ownership on this volume\(dq\& option).
.IP 
Beginning in version 2.6.4, multiple \fB\-\-link\-dest\fP directories may be
provided, which will cause rsync to search the list in the order specified
for an exact match (there is a limit of 20 such directories).
If a match is found that differs only in attributes, a local copy is made
and the attributes updated.
If a match is not found, a basis file from one of the \fIDIR\fPs will be
selected to try to speed up the transfer.
.IP 
This option works best when copying into an empty destination hierarchy, as
existing files may get their attributes tweaked, and that can affect alternate
destination files via hard\-links.  Also, itemizing of changes can get a bit
muddled.  Note that prior to version 3.1.0, an alternate\-directory exact match
would never be found (nor linked into the destination) when a destination file
already exists.
.IP 
Note that if you combine this option with \fB\-\-ignore\-times\fP, rsync will not
link any files together because it only links identical files together as a
substitute for transferring the file, never as an additional check after the
file is updated.
.IP 
If \fIDIR\fP is a relative path, it is relative to the destination directory.
See also \fB\-\-compare\-dest\fP and \fB\-\-copy\-dest\fP.
.IP 
Note that rsync versions prior to 2.6.1 had a bug that could prevent
\fB\-\-link\-dest\fP from working properly for a non\-super\-user when \fB\-o\fP was
specified (or implied by \fB\-a\fP).  You can work\-around this bug by avoiding
the \fB\-o\fP option when sending to an old rsync.
.IP 
.IP "\fB\-z, \-\-compress\fP"
With this option, rsync compresses the file data
as it is sent to the destination machine, which reduces the amount of data
being transmitted \-\- something that is useful over a slow connection.
.IP 
Note that this option typically achieves better compression ratios than can
be achieved by using a compressing remote shell or a compressing transport
because it takes advantage of the implicit information in the matching data
blocks that are not explicitly sent over the connection.  This matching\-data
compression comes at a cost of CPU, though, and can be disabled by repeating
the \fB\-z\fP option, but only if both sides are at least version 3.1.1.
.IP 
Note that if your version of rsync was compiled with an external zlib (instead
of the zlib that comes packaged with rsync) then it will not support the
old\-style compression, only the new\-style (repeated\-option) compression.  In
the future this new\-style compression will likely become the default.
.IP 
The client rsync requests new\-style compression on the server via the
\fB\-\-new\-compress\fP option, so if you see that option rejected it means that
the server is not new enough to support \fB\-zz\fP.  Rsync also accepts the
\fB\-\-old\-compress\fP option for a future time when new\-style compression
becomes the default.
.IP 
See the \fB\-\-skip\-compress\fP option for the default list of file suffixes
that will not be compressed.
.IP 
.IP "\fB\-\-compress\-level=NUM\fP"
Explicitly set the compression level to use
(see \fB\-\-compress\fP) instead of letting it default.  If NUM is non\-zero,
the \fB\-\-compress\fP option is implied.
.IP 
.IP "\fB\-\-skip\-compress=LIST\fP"
Override the list of file suffixes that will
not be compressed.  The \fBLIST\fP should be one or more file suffixes
(without the dot) separated by slashes (/).
.IP 
You may specify an empty string to indicate that no file should be skipped.
.IP 
Simple character\-class matching is supported: each must consist of a list
of letters inside the square brackets (e.g. no special classes, such as
\(dq\&[:alpha:]\(dq\&, are supported, and \(cq\&\-\(cq\& has no special meaning).
.IP 
The characters asterisk (*) and question\-mark (?) have no special meaning.
.IP 
Here\(cq\&s an example that specifies 6 suffixes to skip (since 1 of the 5 rules
matches 2 suffixes):
.IP 
.nf 
    \-\-skip\-compress=gz/jpg/mp[34]/7z/bz2
.fi 

.IP 
The default list of suffixes that will not be compressed is this (in this
version of rsync):
.IP 
\fB7z\fP
\fBace\fP
\fBavi\fP
\fBbz2\fP
\fBdeb\fP
\fBgpg\fP
\fBgz\fP
\fBiso\fP
\fBjpeg\fP
\fBjpg\fP
\fBlz\fP
\fBlzma\fP
\fBlzo\fP
\fBmov\fP
\fBmp3\fP
\fBmp4\fP
\fBogg\fP
\fBpng\fP
\fBrar\fP
\fBrpm\fP
\fBrzip\fP
\fBtbz\fP
\fBtgz\fP
\fBtlz\fP
\fBtxz\fP
\fBxz\fP
\fBz\fP
\fBzip\fP
.IP 
This list will be replaced by your \fB\-\-skip\-compress\fP list in all but one
situation: a copy from a daemon rsync will add your skipped suffixes to
its list of non\-compressing files (and its list may be configured to a
different default).
.IP 
.IP "\fB\-\-numeric\-ids\fP"
With this option rsync will transfer numeric group
and user IDs rather than using user and group names and mapping them
at both ends.
.IP 
By default rsync will use the username and groupname to determine
what ownership to give files. The special uid 0 and the special group
0 are never mapped via user/group names even if the \fB\-\-numeric\-ids\fP
option is not specified.
.IP 
If a user or group has no name on the source system or it has no match
on the destination system, then the numeric ID
from the source system is used instead.  See also the comments on the
\(dq\&use chroot\(dq\& setting in the rsyncd.conf manpage for information on how
the chroot setting affects rsync\(cq\&s ability to look up the names of the
users and groups and what you can do about it.
.IP 
.IP "\fB\-\-usermap=STRING, \-\-groupmap=STRING\fP"
These options allow you to
specify users and groups that should be mapped to other values by the
receiving side.  The \fBSTRING\fP is one or more \fBFROM\fP:\fBTO\fP pairs of
values separated by commas.  Any matching \fBFROM\fP value from the sender is
replaced with a \fBTO\fP value from the receiver.  You may specify usernames
or user IDs for the \fBFROM\fP and \fBTO\fP values, and the \fBFROM\fP value may
also be a wild\-card string, which will be matched against the sender\(cq\&s
names (wild\-cards do NOT match against ID numbers, though see below for
why a \(cq\&*\(cq\& matches everything).  You may instead specify a range of ID
numbers via an inclusive range: LOW\-HIGH.  For example:
.IP 
.nf 
  \-\-usermap=0\-99:nobody,wayne:admin,*:normal \-\-groupmap=usr:1,1:usr
.fi 

.IP 
The first match in the list is the one that is used.  You should specify
all your user mappings using a single \fB\-\-usermap\fP option, and/or all
your group mappings using a single \fB\-\-groupmap\fP option.
.IP 
Note that the sender\(cq\&s name for the 0 user and group are not transmitted
to the receiver, so you should either match these values using a 0, or use
the names in effect on the receiving side (typically \(dq\&root\(dq\&).  All other
\fBFROM\fP names match those in use on the sending side.  All \fBTO\fP names
match those in use on the receiving side.
.IP 
Any IDs that do not have a name on the sending side are treated as having an
empty name for the purpose of matching.  This allows them to be matched via
a \(dq\&*\(dq\& or using an empty name.  For instance:
.IP 
.nf 
  \-\-usermap=:nobody \-\-groupmap=*:nobody
.fi 

.IP 
When the \fB\-\-numeric\-ids\fP option is used, the sender does not send any
names, so all the IDs are treated as having an empty name.  This means that
you will need to specify numeric \fBFROM\fP values if you want to map these
nameless IDs to different values.
.IP 
For the \fB\-\-usermap\fP option to have any effect, the \fB\-o\fP (\fB\-\-owner\fP)
option must be used (or implied), and the receiver will need to be running
as a super\-user (see also the \fB\-\-fake\-super\fP option).  For the \fB\-\-groupmap\fP
option to have any effect, the \fB\-g\fP (\fB\-\-groups\fP) option must be used
(or implied), and the receiver will need to have permissions to set that
group.
.IP 
.IP "\fB\-\-chown=USER:GROUP\fP"
This option forces all files to be owned by USER
with group GROUP.  This is a simpler interface than using \fB\-\-usermap\fP and
\fB\-\-groupmap\fP directly, but it is implemented using those options internally,
so you cannot mix them.  If either the USER or GROUP is empty, no mapping for
the omitted user/group will occur.  If GROUP is empty, the trailing colon may
be omitted, but if USER is empty, a leading colon must be supplied.
.IP 
If you specify \(dq\&\-\-chown=foo:bar, this is exactly the same as specifying
\(dq\&\-\-usermap=*:foo \-\-groupmap=*:bar\(dq\&, only easier.
.IP 
.IP "\fB\-\-timeout=TIMEOUT\fP"
This option allows you to set a maximum I/O
timeout in seconds. If no data is transferred for the specified time
then rsync will exit. The default is 0, which means no timeout.
.IP 
.IP "\fB\-\-contimeout\fP"
This option allows you to set the amount of time
that rsync will wait for its connection to an rsync daemon to succeed.
If the timeout is reached, rsync exits with an error.
.IP 
.IP "\fB\-\-address\fP"
By default rsync will bind to the wildcard address when
connecting to an rsync daemon.  The \fB\-\-address\fP option allows you to
specify a specific IP address (or hostname) to bind to.  See also this
option in the \fB\-\-daemon\fP mode section.
.IP 
.IP "\fB\-\-port=PORT\fP"
This specifies an alternate TCP port number to use
rather than the default of 873.  This is only needed if you are using the
double\-colon (::) syntax to connect with an rsync daemon (since the URL
syntax has a way to specify the port as a part of the URL).  See also this
option in the \fB\-\-daemon\fP mode section.
.IP 
.IP "\fB\-\-sockopts\fP"
This option can provide endless fun for people
who like to tune their systems to the utmost degree. You can set all
sorts of socket options which may make transfers faster (or
slower!). Read the man page for the 
\f(CWsetsockopt()\fP
system call for
details on some of the options you may be able to set. By default no
special socket options are set. This only affects direct socket
connections to a remote rsync daemon.  This option also exists in the
\fB\-\-daemon\fP mode section.
.IP 
.IP "\fB\-\-blocking\-io\fP"
This tells rsync to use blocking I/O when launching
a remote shell transport.  If the remote shell is either rsh or remsh,
rsync defaults to using
blocking I/O, otherwise it defaults to using non\-blocking I/O.  (Note that
ssh prefers non\-blocking I/O.)
.IP 
.IP "\fB\-\-outbuf=MODE\fP"
This sets the output buffering mode.  The mode can be
None (aka Unbuffered), Line, or Block (aka Full).  You may specify as little
as a single letter for the mode, and use upper or lower case.
.IP 
The main use of this option is to change Full buffering to Line buffering
when rsync\(cq\&s output is going to a file or pipe.
.IP 
.IP "\fB\-i, \-\-itemize\-changes\fP"
Requests a simple itemized list of the
changes that are being made to each file, including attribute changes.
This is exactly the same as specifying \fB\-\-out\-format='\&%i %n%L'\&\fP.
If you repeat the option, unchanged files will also be output, but only
if the receiving rsync is at least version 2.6.7 (you can use \fB\-vv\fP
with older versions of rsync, but that also turns on the output of other
verbose messages).
.IP 
The \(dq\&%i\(dq\& escape has a cryptic output that is 11 letters long.  The general
format is like the string \fBYXcstpoguax\fP, where \fBY\fP is replaced by the
type of update being done, \fBX\fP is replaced by the file\-type, and the
other letters represent attributes that may be output if they are being
modified.
.IP 
The update types that replace the \fBY\fP are as follows:
.IP 
.RS 
.IP o 
A \fB<\fP means that a file is being transferred to the remote host
(sent).
.IP o 
A \fB>\fP means that a file is being transferred to the local host
(received).
.IP o 
A \fBc\fP means that a local change/creation is occurring for the item
(such as the creation of a directory or the changing of a symlink, etc.).
.IP o 
A \fBh\fP means that the item is a hard link to another item (requires
\fB\-\-hard\-links\fP).
.IP o 
A \fB.\fP means that the item is not being updated (though it might
have attributes that are being modified).
.IP o 
A \fB*\fP means that the rest of the itemized\-output area contains
a message (e.g. \(dq\&deleting\(dq\&).
.RE

.IP 
The file\-types that replace the \fBX\fP are: \fBf\fP for a file, a \fBd\fP for a
directory, an \fBL\fP for a symlink, a \fBD\fP for a device, and a \fBS\fP for a
special file (e.g. named sockets and fifos).
.IP 
The other letters in the string above are the actual letters that
will be output if the associated attribute for the item is being updated or
a \(dq\&.\(dq\& for no change.  Three exceptions to this are: (1) a newly created
item replaces each letter with a \(dq\&+\(dq\&, (2) an identical item replaces the
dots with spaces, and (3) an unknown attribute replaces each letter with
a \(dq\&?\(dq\& (this can happen when talking to an older rsync).
.IP 
The attribute that is associated with each letter is as follows:
.IP 
.RS 
.IP o 
A \fBc\fP means either that a regular file has a different checksum
(requires \fB\-\-checksum\fP) or that a symlink, device, or special file has
a changed value.
Note that if you are sending files to an rsync prior to 3.0.1, this
change flag will be present only for checksum\-differing regular files.
.IP o 
A \fBs\fP means the size of a regular file is different and will be updated
by the file transfer.
.IP o 
A \fBt\fP means the modification time is different and is being updated
to the sender\(cq\&s value (requires \fB\-\-times\fP).  An alternate value of \fBT\fP
means that the modification time will be set to the transfer time, which happens
when a file/symlink/device is updated without \fB\-\-times\fP and when a
symlink is changed and the receiver can\(cq\&t set its time.
(Note: when using an rsync 3.0.0 client, you might see the \fBs\fP flag combined
with \fBt\fP instead of the proper \fBT\fP flag for this time\-setting failure.)
.IP o 
A \fBp\fP means the permissions are different and are being updated to
the sender\(cq\&s value (requires \fB\-\-perms\fP).
.IP o 
An \fBo\fP means the owner is different and is being updated to the
sender\(cq\&s value (requires \fB\-\-owner\fP and super\-user privileges).
.IP o 
A \fBg\fP means the group is different and is being updated to the
sender\(cq\&s value (requires \fB\-\-group\fP and the authority to set the group).
.IP o 
The \fBu\fP slot is reserved for future use.
.IP o 
The \fBa\fP means that the ACL information changed.
.IP o 
The \fBx\fP means that the extended attribute information changed.
.RE

.IP 
One other output is possible:  when deleting files, the \(dq\&%i\(dq\& will output
the string \(dq\&*deleting\(dq\& for each item that is being removed (assuming that
you are talking to a recent enough rsync that it logs deletions instead of
outputting them as a verbose message).
.IP 
.IP "\fB\-\-out\-format=FORMAT\fP"
This allows you to specify exactly what the
rsync client outputs to the user on a per\-update basis.  The format is a
text string containing embedded single\-character escape sequences prefixed
with a percent (%) character.   A default format of \(dq\&%n%L\(dq\& is assumed if
either \fB\-\-info=name\fP or \fB\-v\fP is specified (this tells you just the name
of the file and, if the item is a link, where it points).  For a full list
of the possible escape characters, see the \(dq\&log format\(dq\& setting in the
rsyncd.conf manpage.
.IP 
Specifying the \fB\-\-out\-format\fP option implies the \fB\-\-info=name\fP option,
which will mention each file, dir, etc. that gets updated in a significant
way (a transferred file, a recreated symlink/device, or a touched
directory).  In addition, if the itemize\-changes escape (%i) is included in
the string (e.g. if the \fB\-\-itemize\-changes\fP option was used), the logging
of names increases to mention any item that is changed in any way (as long
as the receiving side is at least 2.6.4).  See the \fB\-\-itemize\-changes\fP
option for a description of the output of \(dq\&%i\(dq\&.
.IP 
Rsync will output the out\-format string prior to a file\(cq\&s transfer unless
one of the transfer\-statistic escapes is requested, in which case the
logging is done at the end of the file\(cq\&s transfer.  When this late logging
is in effect and \fB\-\-progress\fP is also specified, rsync will also output
the name of the file being transferred prior to its progress information
(followed, of course, by the out\-format output).
.IP 
.IP "\fB\-\-log\-file=FILE\fP"
This option causes rsync to log what it is doing
to a file.  This is similar to the logging that a daemon does, but can be
requested for the client side and/or the server side of a non\-daemon
transfer.  If specified as a client option, transfer logging will be
enabled with a default format of \(dq\&%i %n%L\(dq\&.  See the \fB\-\-log\-file\-format\fP
option if you wish to override this.
.IP 
Here\(cq\&s a example command that requests the remote side to log what is
happening:
.IP 
.nf 
  rsync \-av \-\-remote\-option=\-\-log\-file=/tmp/rlog src/ dest/
.fi 

.IP 
This is very useful if you need to debug why a connection is closing
unexpectedly.
.IP 
.IP "\fB\-\-log\-file\-format=FORMAT\fP"
This allows you to specify exactly what
per\-update logging is put into the file specified by the \fB\-\-log\-file\fP option
(which must also be specified for this option to have any effect).  If you
specify an empty string, updated files will not be mentioned in the log file.
For a list of the possible escape characters, see the \(dq\&log format\(dq\& setting
in the rsyncd.conf manpage.
.IP 
The default FORMAT used if \fB\-\-log\-file\fP is specified and this option is not
is \(cq\&%i %n%L\(cq\&.
.IP 
.IP "\fB\-\-stats\fP"
This tells rsync to print a verbose set of statistics
on the file transfer, allowing you to tell how effective rsync\(cq\&s delta\-transfer
algorithm is for your data.  This option is equivalent to \fB\-\-info=stats2\fP
if combined with 0 or 1 \fB\-v\fP options, or \fB\-\-info=stats3\fP if combined
with 2 or more \fB\-v\fP options.
.IP 
The current statistics are as follows: 
.RS 
.IP o 
\fBNumber of files\fP is the count of all \(dq\&files\(dq\& (in the generic
sense), which includes directories, symlinks, etc.  The total count will
be followed by a list of counts by filetype (if the total is non\-zero).
For example: \(dq\&(reg: 5, dir: 3, link: 2, dev: 1, special: 1)\(dq\& lists the
totals for regular files, directories, symlinks, devices, and special
files.  If any of value is 0, it is completely omitted from the list.
.IP o 
\fBNumber of created files\fP is the count of how many \(dq\&files\(dq\& (generic
sense) were created (as opposed to updated).  The total count will be
followed by a list of counts by filetype (if the total is non\-zero).
.IP o 
\fBNumber of deleted files\fP is the count of how many \(dq\&files\(dq\& (generic
sense) were created (as opposed to updated).  The total count will be
followed by a list of counts by filetype (if the total is non\-zero).
Note that this line is only output if deletions are in effect, and only
if protocol 31 is being used (the default for rsync 3.1.x).
.IP o 
\fBNumber of regular files transferred\fP is the count of normal files
that were updated via rsync\(cq\&s delta\-transfer algorithm, which does not
include dirs, symlinks, etc.  Note that rsync 3.1.0 added the word
\(dq\&regular\(dq\& into this heading.
.IP o 
\fBTotal file size\fP is the total sum of all file sizes in the transfer.
This does not count any size for directories or special files, but does
include the size of symlinks.
.IP o 
\fBTotal transferred file size\fP is the total sum of all files sizes
for just the transferred files.
.IP o 
\fBLiteral data\fP is how much unmatched file\-update data we had to
send to the receiver for it to recreate the updated files.
.IP o 
\fBMatched data\fP is how much data the receiver got locally when
recreating the updated files.
.IP o 
\fBFile list size\fP is how big the file\-list data was when the sender
sent it to the receiver.  This is smaller than the in\-memory size for the
file list due to some compressing of duplicated data when rsync sends the
list.
.IP o 
\fBFile list generation time\fP is the number of seconds that the
sender spent creating the file list.  This requires a modern rsync on the
sending side for this to be present.
.IP o 
\fBFile list transfer time\fP is the number of seconds that the sender
spent sending the file list to the receiver.
.IP o 
\fBTotal bytes sent\fP is the count of all the bytes that rsync sent
from the client side to the server side.
.IP o 
\fBTotal bytes received\fP is the count of all non\-message bytes that
rsync received by the client side from the server side.  \(dq\&Non\-message\(dq\&
bytes means that we don\(cq\&t count the bytes for a verbose message that the
server sent to us, which makes the stats more consistent.
.RE

.IP 
.IP "\fB\-8, \-\-8\-bit\-output\fP"
This tells rsync to leave all high\-bit characters
unescaped in the output instead of trying to test them to see if they\(cq\&re
valid in the current locale and escaping the invalid ones.  All control
characters (but never tabs) are always escaped, regardless of this option\(cq\&s
setting.
.IP 
The escape idiom that started in 2.6.7 is to output a literal backslash (\e)
and a hash (#), followed by exactly 3 octal digits.  For example, a newline
would output as \(dq\&\e#012\(dq\&.  A literal backslash that is in a filename is not
escaped unless it is followed by a hash and 3 digits (0\-9).
.IP 
.IP "\fB\-h, \-\-human\-readable\fP"
Output numbers in a more human\-readable format.
There are 3 possible levels:  (1) output numbers with a separator between each
set of 3 digits (either a comma or a period, depending on if the decimal point
is represented by a period or a comma); (2) output numbers in units of 1000
(with a character suffix for larger units \-\- see below); (3) output numbers in
units of 1024.
.IP 
The default is human\-readable level 1.  Each \fB\-h\fP option increases the level
by one.  You can take the level down to 0 (to output numbers as pure digits) by
specifing the \fB\-\-no\-human\-readable\fP (\fB\-\-no\-h\fP) option.
.IP 
The unit letters that are appended in levels 2 and 3 are: K (kilo), M (mega),
G (giga), or T (tera).  For example, a 1234567\-byte file would output as 1.23M
in level\-2 (assuming that a period is your local decimal point).
.IP 
Backward compatibility note:  versions of rsync prior to 3.1.0 do not support
human\-readable level 1, and they default to level 0.  Thus, specifying one or
two \fB\-h\fP options will behave in a comparable manner in old and new versions
as long as you didn\(cq\&t specify a \fB\-\-no\-h\fP option prior to one or more \fB\-h\fP
options.  See the \fB\-\-list\-only\fP option for one difference.
.IP 
.IP "\fB\-\-partial\fP"
By default, rsync will delete any partially
transferred file if the transfer is interrupted. In some circumstances
it is more desirable to keep partially transferred files. Using the
\fB\-\-partial\fP option tells rsync to keep the partial file which should
make a subsequent transfer of the rest of the file much faster.
.IP 
.IP "\fB\-\-partial\-dir=DIR\fP"
A better way to keep partial files than the
\fB\-\-partial\fP option is to specify a \fIDIR\fP that will be used to hold the
partial data (instead of writing it out to the destination file).
On the next transfer, rsync will use a file found in this
dir as data to speed up the resumption of the transfer and then delete it
after it has served its purpose.
.IP 
Note that if \fB\-\-whole\-file\fP is specified (or implied), any partial\-dir
file that is found for a file that is being updated will simply be removed
(since
rsync is sending files without using rsync\(cq\&s delta\-transfer algorithm).
.IP 
Rsync will create the \fIDIR\fP if it is missing (just the last dir \-\- not
the whole path).  This makes it easy to use a relative path (such as
\(dq\&\fB\-\-partial\-dir=.rsync\-partial\fP\(dq\&) to have rsync create the
partial\-directory in the destination file\(cq\&s directory when needed, and then
remove it again when the partial file is deleted.
.IP 
If the partial\-dir value is not an absolute path, rsync will add an exclude
rule at the end of all your existing excludes.  This will prevent the
sending of any partial\-dir files that may exist on the sending side, and
will also prevent the untimely deletion of partial\-dir items on the
receiving side.  An example: the above \fB\-\-partial\-dir\fP option would add
the equivalent of \(dq\&\fB\-f '\&\-p .rsync\-partial/'\&\fP\(dq\& at the end of any other
filter rules.
.IP 
If you are supplying your own exclude rules, you may need to add your own
exclude/hide/protect rule for the partial\-dir because (1) the auto\-added
rule may be ineffective at the end of your other rules, or (2) you may wish
to override rsync\(cq\&s exclude choice.  For instance, if you want to make
rsync clean\-up any left\-over partial\-dirs that may be lying around, you
should specify \fB\-\-delete\-after\fP and add a \(dq\&risk\(dq\& filter rule, e.g.
\fB\-f '\&R .rsync\-partial/'\&\fP.  (Avoid using \fB\-\-delete\-before\fP or
\fB\-\-delete\-during\fP unless you don\(cq\&t need rsync to use any of the
left\-over partial\-dir data during the current run.)
.IP 
IMPORTANT: the \fB\-\-partial\-dir\fP should not be writable by other users or it
is a security risk.  E.g. AVOID \(dq\&/tmp\(dq\&.
.IP 
You can also set the partial\-dir value the RSYNC_PARTIAL_DIR environment
variable.  Setting this in the environment does not force \fB\-\-partial\fP to be
enabled, but rather it affects where partial files go when \fB\-\-partial\fP is
specified.  For instance, instead of using \fB\-\-partial\-dir=.rsync\-tmp\fP
along with \fB\-\-progress\fP, you could set RSYNC_PARTIAL_DIR=.rsync\-tmp in your
environment and then just use the \fB\-P\fP option to turn on the use of the
\&.rsync\-tmp dir for partial transfers.  The only times that the \fB\-\-partial\fP
option does not look for this environment value are (1) when \fB\-\-inplace\fP was
specified (since \fB\-\-inplace\fP conflicts with \fB\-\-partial\-dir\fP), and (2) when
\fB\-\-delay\-updates\fP was specified (see below).
.IP 
For the purposes of the daemon\-config\(cq\&s \(dq\&refuse options\(dq\& setting,
\fB\-\-partial\-dir\fP does \fInot\fP imply \fB\-\-partial\fP.  This is so that a
refusal of the \fB\-\-partial\fP option can be used to disallow the overwriting
of destination files with a partial transfer, while still allowing the
safer idiom provided by \fB\-\-partial\-dir\fP.
.IP 
.IP "\fB\-\-delay\-updates\fP"
This option puts the temporary file from each
updated file into a holding directory until the end of the
transfer, at which time all the files are renamed into place in rapid
succession.  This attempts to make the updating of the files a little more
atomic.  By default the files are placed into a directory named \(dq\&.~tmp~\(dq\& in
each file\(cq\&s destination directory, but if you\(cq\&ve specified the
\fB\-\-partial\-dir\fP option, that directory will be used instead.  See the
comments in the \fB\-\-partial\-dir\fP section for a discussion of how this
\(dq\&.~tmp~\(dq\& dir will be excluded from the transfer, and what you can do if
you want rsync to cleanup old \(dq\&.~tmp~\(dq\& dirs that might be lying around.
Conflicts with \fB\-\-inplace\fP and \fB\-\-append\fP.
.IP 
This option uses more memory on the receiving side (one bit per file
transferred) and also requires enough free disk space on the receiving
side to hold an additional copy of all the updated files.  Note also that
you should not use an absolute path to \fB\-\-partial\-dir\fP unless (1)
there is no
chance of any of the files in the transfer having the same name (since all
the updated files will be put into a single directory if the path is
absolute)
and (2) there are no mount points in the hierarchy (since the
delayed updates will fail if they can\(cq\&t be renamed into place).
.IP 
See also the \(dq\&atomic\-rsync\(dq\& perl script in the \(dq\&support\(dq\& subdir for an
update algorithm that is even more atomic (it uses \fB\-\-link\-dest\fP and a
parallel hierarchy of files).
.IP 
.IP "\fB\-m, \-\-prune\-empty\-dirs\fP"
This option tells the receiving rsync to get
rid of empty directories from the file\-list, including nested directories
that have no non\-directory children.  This is useful for avoiding the
creation of a bunch of useless directories when the sending rsync is
recursively scanning a hierarchy of files using include/exclude/filter
rules.
.IP 
Note that the use of transfer rules, such as the \fB\-\-min\-size\fP option, does
not affect what goes into the file list, and thus does not leave directories
empty, even if none of the files in a directory match the transfer rule.
.IP 
Because the file\-list is actually being pruned, this option also affects
what directories get deleted when a delete is active.  However, keep in
mind that excluded files and directories can prevent existing items from
being deleted due to an exclude both hiding source files and protecting
destination files.  See the perishable filter\-rule option for how to avoid
this.
.IP 
You can prevent the pruning of certain empty directories from the file\-list
by using a global \(dq\&protect\(dq\& filter.  For instance, this option would ensure
that the directory \(dq\&emptydir\(dq\& was kept in the file\-list:
.IP 
.RS 
\-\-filter \(cq\&protect emptydir/\(cq\&
.RE

.IP 
Here\(cq\&s an example that copies all .pdf files in a hierarchy, only creating
the necessary destination directories to hold the .pdf files, and ensures
that any superfluous files and directories in the destination are removed
(note the hide filter of non\-directories being used instead of an exclude):
.IP 
.RS 
rsync \-avm \-\-del \-\-include=\(cq\&*.pdf\(cq\& \-f \(cq\&hide,! */\(cq\& src/ dest
.RE

.IP 
If you didn\(cq\&t want to remove superfluous destination files, the more
time\-honored options of \(dq\&\fB\-\-include='\&*/'\& \-\-exclude='\&*'\&\fP\(dq\& would work fine
in place of the hide\-filter (if that is more natural to you).
.IP 
.IP "\fB\-\-progress\fP"
This option tells rsync to print information
showing the progress of the transfer. This gives a bored user
something to watch.
With a modern rsync this is the same as specifying
\fB\-\-info=flist2,name,progress\fP, but any user\-supplied settings for those
info flags takes precedence (e.g. \(dq\&\-\-info=flist0 \-\-progress\(dq\&).
.IP 
While rsync is transferring a regular file, it updates a progress line that
looks like this:
.IP 
.nf 
      782448  63%  110.64kB/s    0:00:04
.fi 

.IP 
In this example, the receiver has reconstructed 782448 bytes or 63% of the
sender\(cq\&s file, which is being reconstructed at a rate of 110.64 kilobytes
per second, and the transfer will finish in 4 seconds if the current rate
is maintained until the end.
.IP 
These statistics can be misleading if rsync\(cq\&s delta\-transfer algorithm is
in use.  For example, if the sender\(cq\&s file consists of the basis file
followed by additional data, the reported rate will probably drop
dramatically when the receiver gets to the literal data, and the transfer
will probably take much longer to finish than the receiver estimated as it
was finishing the matched part of the file.
.IP 
When the file transfer finishes, rsync replaces the progress line with a
summary line that looks like this:
.IP 
.nf 
      1,238,099 100%  146.38kB/s    0:00:08  (xfr#5, to\-chk=169/396)
.fi 

.IP 
In this example, the file was 1,238,099 bytes long in total, the average rate
of transfer for the whole file was 146.38 kilobytes per second over the 8
seconds that it took to complete, it was the 5th transfer of a regular file
during the current rsync session, and there are 169 more files for the
receiver to check (to see if they are up\-to\-date or not) remaining out of
the 396 total files in the file\-list.
.IP 
In an incremental recursion scan, rsync won\(cq\&t know the total number of files
in the file\-list until it reaches the ends of the scan, but since it starts to
transfer files during the scan, it will display a line with the text \(dq\&ir\-chk\(dq\&
(for incremental recursion check) instead of \(dq\&to\-chk\(dq\& until the point that it
knows the full size of the list, at which point it will switch to using
\(dq\&to\-chk\(dq\&.  Thus, seeing \(dq\&ir\-chk\(dq\& lets you know that the total count of files
in the file list is still going to increase (and each time it does, the count
of files left to check  will increase by the number of the files added to the
list).
.IP 
.IP "\fB\-P\fP"
The \fB\-P\fP option is equivalent to \fB\-\-partial\fP \fB\-\-progress\fP.  Its
purpose is to make it much easier to specify these two options for a long
transfer that may be interrupted.
.IP 
There is also a \fB\-\-info=progress2\fP option that outputs statistics based
on the whole transfer, rather than individual files.  Use this flag without
outputting a filename (e.g. avoid \fB\-v\fP or specify \fB\-\-info=name0\fP) if you
want to see how the transfer is doing without scrolling the screen with a
lot of names.  (You don\(cq\&t need to specify the \fB\-\-progress\fP option in
order to use \fB\-\-info=progress2\fP.)
.IP 
.IP "\fB\-\-password\-file=FILE\fP"
This option allows you to provide a password for
accessing an rsync daemon via a file or via standard input if \fBFILE\fP is
\fB\-\fP.  The file should contain just the password on the first line (all other
lines are ignored).  Rsync will exit with an error if \fBFILE\fP is world
readable or if a root\-run rsync command finds a non\-root\-owned file.
.IP 
This option does not supply a password to a remote shell transport such as
ssh; to learn how to do that, consult the remote shell\(cq\&s documentation.
When accessing an rsync daemon using a remote shell as the transport, this
option only comes into effect after the remote shell finishes its
authentication (i.e. if you have also specified a password in the daemon\(cq\&s
config file).
.IP 
.IP "\fB\-\-list\-only\fP"
This option will cause the source files to be listed
instead of transferred.  This option is inferred if there is a single source
arg and no destination specified, so its main uses are: (1) to turn a copy
command that includes a
destination arg into a file\-listing command, or (2) to be able to specify
more than one source arg (note: be sure to include the destination).
Caution: keep in mind that a source arg with a wild\-card is expanded by the
shell into multiple args, so it is never safe to try to list such an arg
without using this option.  For example:
.IP 
.nf 
    rsync \-av \-\-list\-only foo* dest/
.fi 

.IP 
Starting with rsync 3.1.0, the sizes output by \fB\-\-list\-only\fP are affected
by the \fB\-\-human\-readable\fP option.  By default they will contain digit
separators, but higher levels of readability will output the sizes with
unit suffixes.  Note also that the column width for the size output has
increased from 11 to 14 characters for all human\-readable levels.  Use
\fB\-\-no\-h\fP if you want just digits in the sizes, and the old column width
of 11 characters.
.IP 
Compatibility note:  when requesting a remote listing of files from an rsync
that is version 2.6.3 or older, you may encounter an error if you ask for a
non\-recursive listing.  This is because a file listing implies the \fB\-\-dirs\fP
option w/o \fB\-\-recursive\fP, and older rsyncs don\(cq\&t have that option.  To
avoid this problem, either specify the \fB\-\-no\-dirs\fP option (if you don\(cq\&t
need to expand a directory\(cq\&s content), or turn on recursion and exclude
the content of subdirectories: \fB\-r \-\-exclude='\&/*/*'\&\fP.
.IP 
.IP "\fB\-\-bwlimit=RATE\fP"
This option allows you to specify the maximum transfer
rate for the data sent over the socket, specified in units per second.  The
RATE value can be suffixed with a string to indicate a size multiplier, and may
be a fractional value (e.g.  \(dq\&\fB\-\-bwlimit=1.5m\fP\(dq\&).  If no suffix is specified,
the value will be assumed to be in units of 1024 bytes (as if \(dq\&K\(dq\& or \(dq\&KiB\(dq\& had
been appended).  See the \fB\-\-max\-size\fP option for a description of all the
available suffixes. A value of zero specifies no limit.
.IP 
For backward\-compatibility reasons, the rate limit will be rounded to the
nearest KiB unit, so no rate smaller than 1024 bytes per second is possible.
.IP 
Rsync writes data over the socket in blocks, and this option both limits the
size of the blocks that rsync writes, and tries to keep the average transfer
rate at the requested limit.  Some \(dq\&burstiness\(dq\& may be seen where rsync writes
out a block of data and then sleeps to bring the average rate into compliance.
.IP 
Due to the internal buffering of data, the \fB\-\-progress\fP option may not be an
accurate reflection on how fast the data is being sent.  This is because some
files can show up as being rapidly sent when the data is quickly buffered,
while other can show up as very slow when the flushing of the output buffer
occurs.  This may be fixed in a future version.
.IP 
.IP "\fB\-\-write\-batch=FILE\fP"
Record a file that can later be applied to
another identical destination with \fB\-\-read\-batch\fP. See the \(dq\&BATCH MODE\(dq\&
section for details, and also the \fB\-\-only\-write\-batch\fP option.
.IP 
.IP "\fB\-\-only\-write\-batch=FILE\fP"
Works like \fB\-\-write\-batch\fP, except that
no updates are made on the destination system when creating the batch.
This lets you transport the changes to the destination system via some
other means and then apply the changes via \fB\-\-read\-batch\fP.
.IP 
Note that you can feel free to write the batch directly to some portable
media: if this media fills to capacity before the end of the transfer, you
can just apply that partial transfer to the destination and repeat the
whole process to get the rest of the changes (as long as you don\(cq\&t mind a
partially updated destination system while the multi\-update cycle is
happening).
.IP 
Also note that you only save bandwidth when pushing changes to a remote
system because this allows the batched data to be diverted from the sender
into the batch file without having to flow over the wire to the receiver
(when pulling, the sender is remote, and thus can\(cq\&t write the batch).
.IP 
.IP "\fB\-\-read\-batch=FILE\fP"
Apply all of the changes stored in FILE, a
file previously generated by \fB\-\-write\-batch\fP.
If \fIFILE\fP is \fB\-\fP, the batch data will be read from standard input.
See the \(dq\&BATCH MODE\(dq\& section for details.
.IP 
.IP "\fB\-\-protocol=NUM\fP"
Force an older protocol version to be used.  This
is useful for creating a batch file that is compatible with an older
version of rsync.  For instance, if rsync 2.6.4 is being used with the
\fB\-\-write\-batch\fP option, but rsync 2.6.3 is what will be used to run the
\fB\-\-read\-batch\fP option, you should use \(dq\&\-\-protocol=28\(dq\& when creating the
batch file to force the older protocol version to be used in the batch
file (assuming you can\(cq\&t upgrade the rsync on the reading system).
.IP 
.IP "\fB\-\-iconv=CONVERT_SPEC\fP"
Rsync can convert filenames between character
sets using this option.  Using a CONVERT_SPEC of \(dq\&.\(dq\& tells rsync to look up
the default character\-set via the locale setting.  Alternately, you can
fully specify what conversion to do by giving a local and a remote charset
separated by a comma in the order \fB\-\-iconv=LOCAL,REMOTE\fP, e.g.
\fB\-\-iconv=utf8,iso88591\fP.  This order ensures that the option
will stay the same whether you\(cq\&re pushing or pulling files.
Finally, you can specify either \fB\-\-no\-iconv\fP or a CONVERT_SPEC of \(dq\&\-\(dq\&
to turn off any conversion.
The default setting of this option is site\-specific, and can also be
affected via the RSYNC_ICONV environment variable.
.IP 
For a list of what charset names your local iconv library supports, you can
run \(dq\&iconv \-\-list\(dq\&.
.IP 
If you specify the \fB\-\-protect\-args\fP option (\fB\-s\fP), rsync will translate
the filenames you specify on the command\-line that are being sent to the
remote host.  See also the \fB\-\-files\-from\fP option.
.IP 
Note that rsync does not do any conversion of names in filter files
(including include/exclude files).  It is up to you to ensure that you\(cq\&re
specifying matching rules that can match on both sides of the transfer.
For instance, you can specify extra include/exclude rules if there are
filename differences on the two sides that need to be accounted for.
.IP 
When you pass an \fB\-\-iconv\fP option to an rsync daemon that allows it, the
daemon uses the charset specified in its \(dq\&charset\(dq\& configuration parameter
regardless of the remote charset you actually pass.  Thus, you may feel free to
specify just the local charset for a daemon transfer (e.g. \fB\-\-iconv=utf8\fP).
.IP 
.IP "\fB\-4, \-\-ipv4\fP or \fB\-6, \-\-ipv6\fP"
Tells rsync to prefer IPv4/IPv6
when creating sockets.  This only affects sockets that rsync has direct
control over, such as the outgoing socket when directly contacting an
rsync daemon.  See also these options in the \fB\-\-daemon\fP mode section.
.IP 
If rsync was complied without support for IPv6, the \fB\-\-ipv6\fP option
will have no effect.  The \fB\-\-version\fP output will tell you if this
is the case.
.IP 
.IP "\fB\-\-checksum\-seed=NUM\fP"
Set the checksum seed to the integer NUM.  This 4
byte checksum seed is included in each block and MD4 file checksum calculation
(the more modern MD5 file checksums don\(cq\&t use a seed).  By default the checksum
seed is generated by the server and defaults to the current 
\f(CWtime()\fP
\&.  This
option is used to set a specific checksum seed, which is useful for
applications that want repeatable block checksums, or in the case where the
user wants a more random checksum seed.  Setting NUM to 0 causes rsync to use
the default of 
\f(CWtime()\fP
for checksum seed.
.IP 
.SH "DAEMON OPTIONS"

.PP 
The options allowed when starting an rsync daemon are as follows:
.PP 
.IP "\fB\-\-daemon\fP"
This tells rsync that it is to run as a daemon.  The
daemon you start running may be accessed using an rsync client using
the \fBhost::module\fP or \fBrsync://host/module/\fP syntax.
.IP 
If standard input is a socket then rsync will assume that it is being
run via inetd, otherwise it will detach from the current terminal and
become a background daemon.  The daemon will read the config file
(rsyncd.conf) on each connect made by a client and respond to
requests accordingly.  See the \fBrsyncd.conf\fP(5) man page for more
details.
.IP 
.IP "\fB\-\-address\fP"
By default rsync will bind to the wildcard address when
run as a daemon with the \fB\-\-daemon\fP option.  The \fB\-\-address\fP option
allows you to specify a specific IP address (or hostname) to bind to.  This
makes virtual hosting possible in conjunction with the \fB\-\-config\fP option.
See also the \(dq\&address\(dq\& global option in the rsyncd.conf manpage.
.IP 
.IP "\fB\-\-bwlimit=RATE\fP"
This option allows you to specify the maximum transfer
rate for the data the daemon sends over the socket.  The client can still
specify a smaller \fB\-\-bwlimit\fP value, but no larger value will be allowed.
See the client version of this option (above) for some extra details.
.IP 
.IP "\fB\-\-config=FILE\fP"
This specifies an alternate config file than
the default.  This is only relevant when \fB\-\-daemon\fP is specified.
The default is /etc/rsyncd.conf unless the daemon is running over
a remote shell program and the remote user is not the super\-user; in that case
the default is rsyncd.conf in the current directory (typically $HOME).
.IP 
.IP "\fB\-M, \-\-dparam=OVERRIDE\fP"
This option can be used to set a daemon\-config
parameter when starting up rsync in daemon mode.  It is equivalent to adding
the parameter at the end of the global settings prior to the first module\(cq\&s
definition.  The parameter names can be specified without spaces, if you so
desire.  For instance:
.IP 
.nf 
    rsync \-\-daemon \-M pidfile=/path/rsync.pid 
.fi 

.IP 
.IP "\fB\-\-no\-detach\fP"
When running as a daemon, this option instructs
rsync to not detach itself and become a background process.  This
option is required when running as a service on Cygwin, and may also
be useful when rsync is supervised by a program such as
\fBdaemontools\fP or AIX\(cq\&s \fBSystem Resource Controller\fP.
\fB\-\-no\-detach\fP is also recommended when rsync is run under a
debugger.  This option has no effect if rsync is run from inetd or
sshd.
.IP 
.IP "\fB\-\-port=PORT\fP"
This specifies an alternate TCP port number for the
daemon to listen on rather than the default of 873.  See also the \(dq\&port\(dq\&
global option in the rsyncd.conf manpage.
.IP 
.IP "\fB\-\-log\-file=FILE\fP"
This option tells the rsync daemon to use the
given log\-file name instead of using the \(dq\&log file\(dq\& setting in the config
file.
.IP 
.IP "\fB\-\-log\-file\-format=FORMAT\fP"
This option tells the rsync daemon to use the
given FORMAT string instead of using the \(dq\&log format\(dq\& setting in the config
file.  It also enables \(dq\&transfer logging\(dq\& unless the string is empty, in which
case transfer logging is turned off.
.IP 
.IP "\fB\-\-sockopts\fP"
This overrides the \fBsocket options\fP setting in the
rsyncd.conf file and has the same syntax.
.IP 
.IP "\fB\-v, \-\-verbose\fP"
This option increases the amount of information the
daemon logs during its startup phase.  After the client connects, the
daemon\(cq\&s verbosity level will be controlled by the options that the client
used and the \(dq\&max verbosity\(dq\& setting in the module\(cq\&s config section.
.IP 
.IP "\fB\-4, \-\-ipv4\fP or \fB\-6, \-\-ipv6\fP"
Tells rsync to prefer IPv4/IPv6
when creating the incoming sockets that the rsync daemon will use to
listen for connections.  One of these options may be required in older
versions of Linux to work around an IPv6 bug in the kernel (if you see
an \(dq\&address already in use\(dq\& error when nothing else is using the port,
try specifying \fB\-\-ipv6\fP or \fB\-\-ipv4\fP when starting the daemon).
.IP 
If rsync was complied without support for IPv6, the \fB\-\-ipv6\fP option
will have no effect.  The \fB\-\-version\fP output will tell you if this
is the case.
.IP 
.IP "\fB\-h, \-\-help\fP"
When specified after \fB\-\-daemon\fP, print a short help
page describing the options available for starting an rsync daemon.
.IP 
.SH "FILTER RULES"

.PP 
The filter rules allow for flexible selection of which files to transfer
(include) and which files to skip (exclude).  The rules either directly
specify include/exclude patterns or they specify a way to acquire more
include/exclude patterns (e.g. to read them from a file).
.PP 
As the list of files/directories to transfer is built, rsync checks each
name to be transferred against the list of include/exclude patterns in
turn, and the first matching pattern is acted on:  if it is an exclude
pattern, then that file is skipped; if it is an include pattern then that
filename is not skipped; if no matching pattern is found, then the
filename is not skipped.
.PP 
Rsync builds an ordered list of filter rules as specified on the
command\-line.  Filter rules have the following syntax:
.PP 
.RS 
\f(CWRULE [PATTERN_OR_FILENAME]\fP
.br 
\f(CWRULE,MODIFIERS [PATTERN_OR_FILENAME]\fP
.br 
.RE

.PP 
You have your choice of using either short or long RULE names, as described
below.  If you use a short\-named rule, the \(cq\&,\(cq\& separating the RULE from the
MODIFIERS is optional.  The PATTERN or FILENAME that follows (when present)
must come after either a single space or an underscore (_).
Here are the available rule prefixes:
.PP 
.RS 
\fBexclude, \-\fP specifies an exclude pattern. 
.br 
\fBinclude, +\fP specifies an include pattern. 
.br 
\fBmerge, .\fP specifies a merge\-file to read for more rules. 
.br 
\fBdir\-merge, :\fP specifies a per\-directory merge\-file. 
.br 
\fBhide, H\fP specifies a pattern for hiding files from the transfer. 
.br 
\fBshow, S\fP files that match the pattern are not hidden. 
.br 
\fBprotect, P\fP specifies a pattern for protecting files from deletion. 
.br 
\fBrisk, R\fP files that match the pattern are not protected. 
.br 
\fBclear, !\fP clears the current include/exclude list (takes no arg) 
.br 
.RE

.PP 
When rules are being read from a file, empty lines are ignored, as are
comment lines that start with a \(dq\&#\(dq\&.
.PP 
Note that the \fB\-\-include\fP/\fB\-\-exclude\fP command\-line options do not allow the
full range of rule parsing as described above \-\- they only allow the
specification of include/exclude patterns plus a \(dq\&!\(dq\& token to clear the
list (and the normal comment parsing when rules are read from a file).
If a pattern
does not begin with \(dq\&\- \(dq\& (dash, space) or \(dq\&+ \(dq\& (plus, space), then the
rule will be interpreted as if \(dq\&+ \(dq\& (for an include option) or \(dq\&\- \(dq\& (for
an exclude option) were prefixed to the string.  A \fB\-\-filter\fP option, on
the other hand, must always contain either a short or long rule name at the
start of the rule.
.PP 
Note also that the \fB\-\-filter\fP, \fB\-\-include\fP, and \fB\-\-exclude\fP options take one
rule/pattern each. To add multiple ones, you can repeat the options on
the command\-line, use the merge\-file syntax of the \fB\-\-filter\fP option, or
the \fB\-\-include\-from\fP/\fB\-\-exclude\-from\fP options.
.PP 
.SH "INCLUDE/EXCLUDE PATTERN RULES"

.PP 
You can include and exclude files by specifying patterns using the \(dq\&+\(dq\&,
\(dq\&\-\(dq\&, etc. filter rules (as introduced in the FILTER RULES section above).
The include/exclude rules each specify a pattern that is matched against
the names of the files that are going to be transferred.  These patterns
can take several forms:
.PP 
.IP o 
if the pattern starts with a / then it is anchored to a
particular spot in the hierarchy of files, otherwise it is matched
against the end of the pathname.  This is similar to a leading ^ in
regular expressions.
Thus \(dq\&/foo\(dq\& would match a name of \(dq\&foo\(dq\& at either the \(dq\&root of the
transfer\(dq\& (for a global rule) or in the merge\-file\(cq\&s directory (for a
per\-directory rule).
An unqualified \(dq\&foo\(dq\& would match a name of \(dq\&foo\(dq\& anywhere in the
tree because the algorithm is applied recursively from the
top down; it behaves as if each path component gets a turn at being the
end of the filename.  Even the unanchored \(dq\&sub/foo\(dq\& would match at
any point in the hierarchy where a \(dq\&foo\(dq\& was found within a directory
named \(dq\&sub\(dq\&.  See the section on ANCHORING INCLUDE/EXCLUDE PATTERNS for
a full discussion of how to specify a pattern that matches at the root
of the transfer.
.IP o 
if the pattern ends with a / then it will only match a
directory, not a regular file, symlink, or device.
.IP o 
rsync chooses between doing a simple string match and wildcard
matching by checking if the pattern contains one of these three wildcard
characters: \(cq\&*\(cq\&, \(cq\&?\(cq\&, and \(cq\&[\(cq\& .
.IP o 
a \(cq\&*\(cq\& matches any path component, but it stops at slashes.
.IP o 
use \(cq\&**\(cq\& to match anything, including slashes.
.IP o 
a \(cq\&?\(cq\& matches any character except a slash (/).
.IP o 
a \(cq\&[\(cq\& introduces a character class, such as [a\-z] or [[:alpha:]].
.IP o 
in a wildcard pattern, a backslash can be used to escape a wildcard
character, but it is matched literally when no wildcards are present.
This means that there is an extra level of backslash removal when a
pattern contains wildcard characters compared to a pattern that has none.
e.g. if you add a wildcard to \(dq\&foo\ebar\(dq\& (which matches the backslash) you
would need to use \(dq\&foo\e\ebar*\(dq\& to avoid the \(dq\&\eb\(dq\& becoming just \(dq\&b\(dq\&.
.IP o 
if the pattern contains a / (not counting a trailing /) or a \(dq\&**\(dq\&,
then it is matched against the full pathname, including any leading
directories. If the pattern doesn\(cq\&t contain a / or a \(dq\&**\(dq\&, then it is
matched only against the final component of the filename.
(Remember that the algorithm is applied recursively so \(dq\&full filename\(dq\&
can actually be any portion of a path from the starting directory on
down.)
.IP o 
a trailing \(dq\&dir_name/***\(dq\& will match both the directory (as if
\(dq\&dir_name/\(dq\& had been specified) and everything in the directory
(as if \(dq\&dir_name/**\(dq\& had been specified).  This behavior was added in
version 2.6.7.

.PP 
Note that, when using the \fB\-\-recursive\fP (\fB\-r\fP) option (which is implied by
\fB\-a\fP), every subdir component of every path is visited left to right, with
each directory having a chance for exclusion before its content.  In this way
include/exclude patterns are applied recursively to the pathname of each node
in the filesystem\(cq\&s tree (those inside the transfer).  The exclude patterns
short\-circuit the directory traversal stage as rsync finds the files to send.
.PP 
For instance, to include \(dq\&/foo/bar/baz\(dq\&, the directories \(dq\&/foo\(dq\& and \(dq\&/foo/bar\(dq\&
must not be excluded.  Excluding one of those parent directories prevents the
examination of its content, cutting off rsync\(cq\&s recursion into those paths and
rendering the include for \(dq\&/foo/bar/baz\(dq\& ineffectual (since rsync can\(cq\&t match
something it never sees in the cut\-off section of the directory hierarchy).
.PP 
The concept path exclusion is particularly important when using a trailing \(cq\&*\(cq\&
rule.  For instance, this won\(cq\&t work:
.PP 
.RS 
\f(CW+ /some/path/this\-file\-will\-not\-be\-found\fP
.br 
\f(CW+ /file\-is\-included\fP
.br 
\f(CW\- *\fP
.br 
.RE

.PP 
This fails because the parent directory \(dq\&some\(dq\& is excluded by the \(cq\&*\(cq\&
rule, so rsync never visits any of the files in the \(dq\&some\(dq\& or \(dq\&some/path\(dq\&
directories.  One solution is to ask for all directories in the hierarchy
to be included by using a single rule: \(dq\&+ */\(dq\& (put it somewhere before the
\(dq\&\- *\(dq\& rule), and perhaps use the \fB\-\-prune\-empty\-dirs\fP option.  Another
solution is to add specific include rules for all
the parent dirs that need to be visited.  For instance, this set of rules
works fine:
.PP 
.RS 
\f(CW+ /some/\fP
.br 
\f(CW+ /some/path/\fP
.br 
\f(CW+ /some/path/this\-file\-is\-found\fP
.br 
\f(CW+ /file\-also\-included\fP
.br 
\f(CW\- *\fP
.br 
.RE

.PP 
Here are some examples of exclude/include matching:
.PP 
.IP o 
\(dq\&\- *.o\(dq\& would exclude all names matching *.o
.IP o 
\(dq\&\- /foo\(dq\& would exclude a file (or directory) named foo in the
transfer\-root directory
.IP o 
\(dq\&\- foo/\(dq\& would exclude any directory named foo
.IP o 
\(dq\&\- /foo/*/bar\(dq\& would exclude any file named bar which is at two
levels below a directory named foo in the transfer\-root directory
.IP o 
\(dq\&\- /foo/**/bar\(dq\& would exclude any file named bar two
or more levels below a directory named foo in the transfer\-root directory
.IP o 
The combination of \(dq\&+ */\(dq\&, \(dq\&+ *.c\(dq\&, and \(dq\&\- *\(dq\& would include all
directories and C source files but nothing else (see also the
\fB\-\-prune\-empty\-dirs\fP option)
.IP o 
The combination of \(dq\&+ foo/\(dq\&, \(dq\&+ foo/bar.c\(dq\&, and \(dq\&\- *\(dq\& would include
only the foo directory and foo/bar.c (the foo directory must be
explicitly included or it would be excluded by the \(dq\&*\(dq\&)

.PP 
The following modifiers are accepted after a \(dq\&+\(dq\& or \(dq\&\-\(dq\&:
.PP 
.IP o 
A \fB/\fP specifies that the include/exclude rule should be matched
against the absolute pathname of the current item.  For example,
\(dq\&\-/ /etc/passwd\(dq\& would exclude the passwd file any time the transfer
was sending files from the \(dq\&/etc\(dq\& directory, and \(dq\&\-/ subdir/foo\(dq\&
would always exclude \(dq\&foo\(dq\& when it is in a dir named \(dq\&subdir\(dq\&, even
if \(dq\&foo\(dq\& is at the root of the current transfer.
.IP o 
A \fB!\fP specifies that the include/exclude should take effect if
the pattern fails to match.  For instance, \(dq\&\-! */\(dq\& would exclude all
non\-directories.
.IP o 
A \fBC\fP is used to indicate that all the global CVS\-exclude rules
should be inserted as excludes in place of the \(dq\&\-C\(dq\&.  No arg should
follow.
.IP o 
An \fBs\fP is used to indicate that the rule applies to the sending
side.  When a rule affects the sending side, it prevents files from
being transferred.  The default is for a rule to affect both sides
unless \fB\-\-delete\-excluded\fP was specified, in which case default rules
become sender\-side only.  See also the hide (H) and show (S) rules,
which are an alternate way to specify sending\-side includes/excludes.
.IP o 
An \fBr\fP is used to indicate that the rule applies to the receiving
side.  When a rule affects the receiving side, it prevents files from
being deleted.  See the \fBs\fP modifier for more info.  See also the
protect (P) and risk (R) rules, which are an alternate way to
specify receiver\-side includes/excludes.
.IP o 
A \fBp\fP indicates that a rule is perishable, meaning that it is
ignored in directories that are being deleted.  For instance, the \fB\-C\fP
option\(cq\&s default rules that exclude things like \(dq\&CVS\(dq\& and \(dq\&*.o\(dq\& are
marked as perishable, and will not prevent a directory that was removed
on the source from being deleted on the destination.
.IP o 
An \fBx\fP indicates that a rule affects xattr names in xattr copy/delete
operations (and is thus ignored when matching file/dir names). If no
xattr\-matching rules are specified, a default xattr filtering rule is
used (see the \fB\-\-xattrs\fP option).

.PP 
.SH "MERGE\-FILE FILTER RULES"

.PP 
You can merge whole files into your filter rules by specifying either a
merge (.) or a dir\-merge (:) filter rule (as introduced in the FILTER RULES
section above).
.PP 
There are two kinds of merged files \-\- single\-instance (\(cq\&.\(cq\&) and
per\-directory (\(cq\&:\(cq\&).  A single\-instance merge file is read one time, and
its rules are incorporated into the filter list in the place of the \(dq\&.\(dq\&
rule.  For per\-directory merge files, rsync will scan every directory that
it traverses for the named file, merging its contents when the file exists
into the current list of inherited rules.  These per\-directory rule files
must be created on the sending side because it is the sending side that is
being scanned for the available files to transfer.  These rule files may
also need to be transferred to the receiving side if you want them to
affect what files don\(cq\&t get deleted (see PER\-DIRECTORY RULES AND DELETE
below).
.PP 
Some examples:
.PP 
.RS 
\f(CWmerge /etc/rsync/default.rules\fP
.br 
\f(CW. /etc/rsync/default.rules\fP
.br 
\f(CWdir\-merge .per\-dir\-filter\fP
.br 
\f(CWdir\-merge,n\- .non\-inherited\-per\-dir\-excludes\fP
.br 
\f(CW:n\- .non\-inherited\-per\-dir\-excludes\fP
.br 
.RE

.PP 
The following modifiers are accepted after a merge or dir\-merge rule:
.PP 
.IP o 
A \fB\-\fP specifies that the file should consist of only exclude
patterns, with no other rule\-parsing except for in\-file comments.
.IP o 
A \fB+\fP specifies that the file should consist of only include
patterns, with no other rule\-parsing except for in\-file comments.
.IP o 
A \fBC\fP is a way to specify that the file should be read in a
CVS\-compatible manner.  This turns on \(cq\&n\(cq\&, \(cq\&w\(cq\&, and \(cq\&\-\(cq\&, but also
allows the list\-clearing token (!) to be specified.  If no filename is
provided, \(dq\&.cvsignore\(dq\& is assumed.
.IP o 
A \fBe\fP will exclude the merge\-file name from the transfer; e.g.
\(dq\&dir\-merge,e .rules\(dq\& is like \(dq\&dir\-merge .rules\(dq\& and \(dq\&\- .rules\(dq\&.
.IP o 
An \fBn\fP specifies that the rules are not inherited by subdirectories.
.IP o 
A \fBw\fP specifies that the rules are word\-split on whitespace instead
of the normal line\-splitting.  This also turns off comments.  Note: the
space that separates the prefix from the rule is treated specially, so
\(dq\&\- foo + bar\(dq\& is parsed as two rules (assuming that prefix\-parsing wasn\(cq\&t
also disabled).
.IP o 
You may also specify any of the modifiers for the \(dq\&+\(dq\& or \(dq\&\-\(dq\& rules
(above) in order to have the rules that are read in from the file
default to having that modifier set (except for the \fB!\fP modifier, which
would not be useful).  For instance, \(dq\&merge,\-/ .excl\(dq\& would
treat the contents of .excl as absolute\-path excludes,
while \(dq\&dir\-merge,s .filt\(dq\& and \(dq\&:sC\(dq\& would each make all their
per\-directory rules apply only on the sending side.  If the merge rule
specifies sides to affect (via the \fBs\fP or \fBr\fP modifier or both),
then the rules in the file must not specify sides (via a modifier or
a rule prefix such as \fBhide\fP).

.PP 
Per\-directory rules are inherited in all subdirectories of the directory
where the merge\-file was found unless the \(cq\&n\(cq\& modifier was used.  Each
subdirectory\(cq\&s rules are prefixed to the inherited per\-directory rules
from its parents, which gives the newest rules a higher priority than the
inherited rules.  The entire set of dir\-merge rules are grouped together in
the spot where the merge\-file was specified, so it is possible to override
dir\-merge rules via a rule that got specified earlier in the list of global
rules.  When the list\-clearing rule (\(dq\&!\(dq\&) is read from a per\-directory
file, it only clears the inherited rules for the current merge file.
.PP 
Another way to prevent a single rule from a dir\-merge file from being inherited is to
anchor it with a leading slash.  Anchored rules in a per\-directory
merge\-file are relative to the merge\-file\(cq\&s directory, so a pattern \(dq\&/foo\(dq\&
would only match the file \(dq\&foo\(dq\& in the directory where the dir\-merge filter
file was found.
.PP 
Here\(cq\&s an example filter file which you\(cq\&d specify via \fB\-\-filter=\(dq\&. file\(dq\&:\fP
.PP 
.RS 
\f(CWmerge /home/user/.global\-filter\fP
.br 
\f(CW\- *.gz\fP
.br 
\f(CWdir\-merge .rules\fP
.br 
\f(CW+ *.[ch]\fP
.br 
\f(CW\- *.o\fP
.br 
.RE

.PP 
This will merge the contents of the /home/user/.global\-filter file at the
start of the list and also turns the \(dq\&.rules\(dq\& filename into a per\-directory
filter file.  All rules read in prior to the start of the directory scan
follow the global anchoring rules (i.e. a leading slash matches at the root
of the transfer).
.PP 
If a per\-directory merge\-file is specified with a path that is a parent
directory of the first transfer directory, rsync will scan all the parent
dirs from that starting point to the transfer directory for the indicated
per\-directory file.  For instance, here is a common filter (see \fB\-F\fP):
.PP 
.RS 
\f(CW\-\-filter='\&: /.rsync\-filter'\&\fP
.RE

.PP 
That rule tells rsync to scan for the file .rsync\-filter in all
directories from the root down through the parent directory of the
transfer prior to the start of the normal directory scan of the file in
the directories that are sent as a part of the transfer.  (Note: for an
rsync daemon, the root is always the same as the module\(cq\&s \(dq\&path\(dq\&.)
.PP 
Some examples of this pre\-scanning for per\-directory files:
.PP 
.RS 
\f(CWrsync \-avF /src/path/ /dest/dir\fP
.br 
\f(CWrsync \-av \-\-filter='\&: ../../.rsync\-filter'\& /src/path/ /dest/dir\fP
.br 
\f(CWrsync \-av \-\-filter='\&: .rsync\-filter'\& /src/path/ /dest/dir\fP
.br 
.RE

.PP 
The first two commands above will look for \(dq\&.rsync\-filter\(dq\& in \(dq\&/\(dq\& and
\(dq\&/src\(dq\& before the normal scan begins looking for the file in \(dq\&/src/path\(dq\&
and its subdirectories.  The last command avoids the parent\-dir scan
and only looks for the \(dq\&.rsync\-filter\(dq\& files in each directory that is
a part of the transfer.
.PP 
If you want to include the contents of a \(dq\&.cvsignore\(dq\& in your patterns,
you should use the rule \(dq\&:C\(dq\&, which creates a dir\-merge of the .cvsignore
file, but parsed in a CVS\-compatible manner.  You can
use this to affect where the \fB\-\-cvs\-exclude\fP (\fB\-C\fP) option\(cq\&s inclusion of the
per\-directory .cvsignore file gets placed into your rules by putting the
\(dq\&:C\(dq\& wherever you like in your filter rules.  Without this, rsync would
add the dir\-merge rule for the .cvsignore file at the end of all your other
rules (giving it a lower priority than your command\-line rules).  For
example:
.PP 
.RS 
\f(CWcat <<EOT | rsync \-avC \-\-filter='\&. \-'\& a/ b\fP
.br 
\f(CW+ foo.o\fP
.br 
\f(CW:C\fP
.br 
\f(CW\- *.old\fP
.br 
\f(CWEOT\fP
.br 
\f(CWrsync \-avC \-\-include=foo.o \-f :C \-\-exclude='\&*.old'\& a/ b\fP
.br 
.RE

.PP 
Both of the above rsync commands are identical.  Each one will merge all
the per\-directory .cvsignore rules in the middle of the list rather than
at the end.  This allows their dir\-specific rules to supersede the rules
that follow the :C instead of being subservient to all your rules.  To
affect the other CVS exclude rules (i.e. the default list of exclusions,
the contents of $HOME/.cvsignore, and the value of $CVSIGNORE) you should
omit the \fB\-C\fP command\-line option and instead insert a \(dq\&\-C\(dq\& rule into
your filter rules; e.g. \(dq\&\fB\-\-filter=\-C\fP\(dq\&.
.PP 
.SH "LIST\-CLEARING FILTER RULE"

.PP 
You can clear the current include/exclude list by using the \(dq\&!\(dq\& filter
rule (as introduced in the FILTER RULES section above).  The \(dq\&current\(dq\&
list is either the global list of rules (if the rule is encountered while
parsing the filter options) or a set of per\-directory rules (which are
inherited in their own sub\-list, so a subdirectory can use this to clear
out the parent\(cq\&s rules).
.PP 
.SH "ANCHORING INCLUDE/EXCLUDE PATTERNS"

.PP 
As mentioned earlier, global include/exclude patterns are anchored at the
\(dq\&root of the transfer\(dq\& (as opposed to per\-directory patterns, which are
anchored at the merge\-file\(cq\&s directory).  If you think of the transfer as
a subtree of names that are being sent from sender to receiver, the
transfer\-root is where the tree starts to be duplicated in the destination
directory.  This root governs where patterns that start with a / match.
.PP 
Because the matching is relative to the transfer\-root, changing the
trailing slash on a source path or changing your use of the \fB\-\-relative\fP
option affects the path you need to use in your matching (in addition to
changing how much of the file tree is duplicated on the destination
host).  The following examples demonstrate this.
.PP 
Let\(cq\&s say that we want to match two source files, one with an absolute
path of \(dq\&/home/me/foo/bar\(dq\&, and one with a path of \(dq\&/home/you/bar/baz\(dq\&.
Here is how the various command choices differ for a 2\-source transfer:
.PP 
.RS 
Example cmd: rsync \-a /home/me /home/you /dest 
.br 
+/\- pattern: /me/foo/bar 
.br 
+/\- pattern: /you/bar/baz 
.br 
Target file: /dest/me/foo/bar 
.br 
Target file: /dest/you/bar/baz 
.br 
.RE

.PP 
.RS 
Example cmd: rsync \-a /home/me/ /home/you/ /dest 
.br 
+/\- pattern: /foo/bar               (note missing \(dq\&me\(dq\&) 
.br 
+/\- pattern: /bar/baz               (note missing \(dq\&you\(dq\&) 
.br 
Target file: /dest/foo/bar 
.br 
Target file: /dest/bar/baz 
.br 
.RE

.PP 
.RS 
Example cmd: rsync \-a \-\-relative /home/me/ /home/you /dest 
.br 
+/\- pattern: /home/me/foo/bar       (note full path) 
.br 
+/\- pattern: /home/you/bar/baz      (ditto) 
.br 
Target file: /dest/home/me/foo/bar 
.br 
Target file: /dest/home/you/bar/baz 
.br 
.RE

.PP 
.RS 
Example cmd: cd /home; rsync \-a \-\-relative me/foo you/ /dest 
.br 
+/\- pattern: /me/foo/bar      (starts at specified path) 
.br 
+/\- pattern: /you/bar/baz     (ditto) 
.br 
Target file: /dest/me/foo/bar 
.br 
Target file: /dest/you/bar/baz 
.br 
.RE

.PP 
The easiest way to see what name you should filter is to just
look at the output when using \fB\-\-verbose\fP and put a / in front of the name
(use the \fB\-\-dry\-run\fP option if you\(cq\&re not yet ready to copy any files).
.PP 
.SH "PER\-DIRECTORY RULES AND DELETE"

.PP 
Without a delete option, per\-directory rules are only relevant on the
sending side, so you can feel free to exclude the merge files themselves
without affecting the transfer.  To make this easy, the \(cq\&e\(cq\& modifier adds
this exclude for you, as seen in these two equivalent commands:
.PP 
.RS 
\f(CWrsync \-av \-\-filter='\&: .excl'\& \-\-exclude=.excl host:src/dir /dest\fP
.br 
\f(CWrsync \-av \-\-filter='\&:e .excl'\& host:src/dir /dest\fP
.br 
.RE

.PP 
However, if you want to do a delete on the receiving side AND you want some
files to be excluded from being deleted, you\(cq\&ll need to be sure that the
receiving side knows what files to exclude.  The easiest way is to include
the per\-directory merge files in the transfer and use \fB\-\-delete\-after\fP,
because this ensures that the receiving side gets all the same exclude
rules as the sending side before it tries to delete anything:
.PP 
.RS 
\f(CWrsync \-avF \-\-delete\-after host:src/dir /dest\fP
.RE

.PP 
However, if the merge files are not a part of the transfer, you\(cq\&ll need to
either specify some global exclude rules (i.e. specified on the command
line), or you\(cq\&ll need to maintain your own per\-directory merge files on
the receiving side.  An example of the first is this (assume that the
remote .rules files exclude themselves):
.PP 
.nf 
rsync \-av \-\-filter=\(cq\&: .rules\(cq\& \-\-filter=\(cq\&. /my/extra.rules\(cq\&
   \-\-delete host:src/dir /dest
.fi 

.PP 
In the above example the extra.rules file can affect both sides of the
transfer, but (on the sending side) the rules are subservient to the rules
merged from the .rules files because they were specified after the
per\-directory merge rule.
.PP 
In one final example, the remote side is excluding the .rsync\-filter
files from the transfer, but we want to use our own .rsync\-filter files
to control what gets deleted on the receiving side.  To do this we must
specifically exclude the per\-directory merge files (so that they don\(cq\&t get
deleted) and then put rules into the local files to control what else
should not get deleted.  Like one of these commands:
.PP 
.nf 
    rsync \-av \-\-filter='\&:e /.rsync\-filter'\& \-\-delete \e 
        host:src/dir /dest
    rsync \-avFF \-\-delete host:src/dir /dest
.fi 

.PP 
.SH "BATCH MODE"

.PP 
Batch mode can be used to apply the same set of updates to many
identical systems. Suppose one has a tree which is replicated on a
number of hosts.  Now suppose some changes have been made to this
source tree and those changes need to be propagated to the other
hosts. In order to do this using batch mode, rsync is run with the
write\-batch option to apply the changes made to the source tree to one
of the destination trees.  The write\-batch option causes the rsync
client to store in a \(dq\&batch file\(dq\& all the information needed to repeat
this operation against other, identical destination trees.
.PP 
Generating the batch file once saves having to perform the file
status, checksum, and data block generation more than once when
updating multiple destination trees. Multicast transport protocols can
be used to transfer the batch update files in parallel to many hosts
at once, instead of sending the same data to every host individually.
.PP 
To apply the recorded changes to another destination tree, run rsync
with the read\-batch option, specifying the name of the same batch
file, and the destination tree.  Rsync updates the destination tree
using the information stored in the batch file.
.PP 
For your convenience, a script file is also created when the write\-batch
option is used:  it will be named the same as the batch file with \(dq\&.sh\(dq\&
appended.  This script file contains a command\-line suitable for updating a
destination tree using the associated batch file. It can be executed using
a Bourne (or Bourne\-like) shell, optionally passing in an alternate
destination tree pathname which is then used instead of the original
destination path.  This is useful when the destination tree path on the
current host differs from the one used to create the batch file.
.PP 
Examples:
.PP 
.RS 
\f(CW$ rsync \-\-write\-batch=foo \-a host:/source/dir/ /adest/dir/\fP
.br 
\f(CW$ scp foo* remote:\fP
.br 
\f(CW$ ssh remote ./foo.sh /bdest/dir/\fP
.br 
.RE

.PP 
.RS 
\f(CW$ rsync \-\-write\-batch=foo \-a /source/dir/ /adest/dir/\fP
.br 
\f(CW$ ssh remote rsync \-\-read\-batch=\- \-a /bdest/dir/ <foo\fP
.br 
.RE

.PP 
In these examples, rsync is used to update /adest/dir/ from /source/dir/
and the information to repeat this operation is stored in \(dq\&foo\(dq\& and
\(dq\&foo.sh\(dq\&.  The host \(dq\&remote\(dq\& is then updated with the batched data going
into the directory /bdest/dir.  The differences between the two examples
reveals some of the flexibility you have in how you deal with batches:
.PP 
.IP o 
The first example shows that the initial copy doesn\(cq\&t have to be
local \-\- you can push or pull data to/from a remote host using either the
remote\-shell syntax or rsync daemon syntax, as desired.
.IP o 
The first example uses the created \(dq\&foo.sh\(dq\& file to get the right
rsync options when running the read\-batch command on the remote host.
.IP o 
The second example reads the batch data via standard input so that
the batch file doesn\(cq\&t need to be copied to the remote machine first.
This example avoids the foo.sh script because it needed to use a modified
\fB\-\-read\-batch\fP option, but you could edit the script file if you wished to
make use of it (just be sure that no other option is trying to use
standard input, such as the \(dq\&\fB\-\-exclude\-from=\-\fP\(dq\& option).

.PP 
Caveats:
.PP 
The read\-batch option expects the destination tree that it is updating
to be identical to the destination tree that was used to create the
batch update fileset.  When a difference between the destination trees
is encountered the update might be discarded with a warning (if the file
appears to be up\-to\-date already) or the file\-update may be attempted
and then, if the file fails to verify, the update discarded with an
error.  This means that it should be safe to re\-run a read\-batch operation
if the command got interrupted.  If you wish to force the batched\-update to
always be attempted regardless of the file\(cq\&s size and date, use the \fB\-I\fP
option (when reading the batch).
If an error occurs, the destination tree will probably be in a
partially updated state. In that case, rsync can
be used in its regular (non\-batch) mode of operation to fix up the
destination tree.
.PP 
The rsync version used on all destinations must be at least as new as the
one used to generate the batch file.  Rsync will die with an error if the
protocol version in the batch file is too new for the batch\-reading rsync
to handle.  See also the \fB\-\-protocol\fP option for a way to have the
creating rsync generate a batch file that an older rsync can understand.
(Note that batch files changed format in version 2.6.3, so mixing versions
older than that with newer versions will not work.)
.PP 
When reading a batch file, rsync will force the value of certain options
to match the data in the batch file if you didn\(cq\&t set them to the same
as the batch\-writing command.  Other options can (and should) be changed.
For instance \fB\-\-write\-batch\fP changes to \fB\-\-read\-batch\fP,
\fB\-\-files\-from\fP is dropped, and the
\fB\-\-filter\fP/\fB\-\-include\fP/\fB\-\-exclude\fP options are not needed unless
one of the \fB\-\-delete\fP options is specified.
.PP 
The code that creates the BATCH.sh file transforms any filter/include/exclude
options into a single list that is appended as a \(dq\&here\(dq\& document to the
shell script file.  An advanced user can use this to modify the exclude
list if a change in what gets deleted by \fB\-\-delete\fP is desired.  A normal
user can ignore this detail and just use the shell script as an easy way
to run the appropriate \fB\-\-read\-batch\fP command for the batched data.
.PP 
The original batch mode in rsync was based on \(dq\&rsync+\(dq\&, but the latest
version uses a new implementation.
.PP 
.SH "SYMBOLIC LINKS"

.PP 
Three basic behaviors are possible when rsync encounters a symbolic
link in the source directory.
.PP 
By default, symbolic links are not transferred at all.  A message
\(dq\&skipping non\-regular\(dq\& file is emitted for any symlinks that exist.
.PP 
If \fB\-\-links\fP is specified, then symlinks are recreated with the same
target on the destination.  Note that \fB\-\-archive\fP implies
\fB\-\-links\fP.
.PP 
If \fB\-\-copy\-links\fP is specified, then symlinks are \(dq\&collapsed\(dq\& by
copying their referent, rather than the symlink.
.PP 
Rsync can also distinguish \(dq\&safe\(dq\& and \(dq\&unsafe\(dq\& symbolic links.  An
example where this might be used is a web site mirror that wishes to
ensure that the rsync module that is copied does not include symbolic links to
\fB/etc/passwd\fP in the public section of the site.  Using
\fB\-\-copy\-unsafe\-links\fP will cause any links to be copied as the file
they point to on the destination.  Using \fB\-\-safe\-links\fP will cause
unsafe links to be omitted altogether.  (Note that you must specify
\fB\-\-links\fP for \fB\-\-safe\-links\fP to have any effect.)
.PP 
Symbolic links are considered unsafe if they are absolute symlinks
(start with \fB/\fP), empty, or if they contain enough \(dq\&..\(dq\&
components to ascend from the directory being copied.
.PP 
Here\(cq\&s a summary of how the symlink options are interpreted.  The list is
in order of precedence, so if your combination of options isn\(cq\&t mentioned,
use the first line that is a complete subset of your options:
.PP 
.IP "\fB\-\-copy\-links\fP"
Turn all symlinks into normal files (leaving no
symlinks for any other options to affect).
.PP 
.IP "\fB\-\-links \-\-copy\-unsafe\-links\fP"
Turn all unsafe symlinks into files
and duplicate all safe symlinks.
.PP 
.IP "\fB\-\-copy\-unsafe\-links\fP"
Turn all unsafe symlinks into files, noisily
skip all safe symlinks.
.PP 
.IP "\fB\-\-links \-\-safe\-links\fP"
Duplicate safe symlinks and skip unsafe
ones.
.PP 
.IP "\fB\-\-links\fP"
Duplicate all symlinks.
.PP 
.SH "DIAGNOSTICS"

.PP 
rsync occasionally produces error messages that may seem a little
cryptic. The one that seems to cause the most confusion is \(dq\&protocol
version mismatch \-\- is your shell clean?\(dq\&.
.PP 
This message is usually caused by your startup scripts or remote shell
facility producing unwanted garbage on the stream that rsync is using
for its transport. The way to diagnose this problem is to run your
remote shell like this:
.PP 
.RS 
\f(CWssh remotehost /bin/true > out.dat\fP
.RE

.PP 
then look at out.dat. If everything is working correctly then out.dat
should be a zero length file. If you are getting the above error from
rsync then you will probably find that out.dat contains some text or
data. Look at the contents and try to work out what is producing
it. The most common cause is incorrectly configured shell startup
scripts (such as .cshrc or .profile) that contain output statements
for non\-interactive logins.
.PP 
If you are having trouble debugging filter patterns, then
try specifying the \fB\-vv\fP option.  At this level of verbosity rsync will
show why each individual file is included or excluded.
.PP 
.SH "EXIT VALUES"

.PP 
.IP "\fB0\fP"
Success
.IP "\fB1\fP"
Syntax or usage error
.IP "\fB2\fP"
Protocol incompatibility
.IP "\fB3\fP"
Errors selecting input/output files, dirs
.IP "\fB4\fP"
Requested action not supported: an attempt
was made to manipulate 64\-bit files on a platform that cannot support
them; or an option was specified that is supported by the client and
not by the server.
.IP "\fB5\fP"
Error starting client\-server protocol
.IP "\fB6\fP"
Daemon unable to append to log\-file
.IP "\fB10\fP"
Error in socket I/O
.IP "\fB11\fP"
Error in file I/O
.IP "\fB12\fP"
Error in rsync protocol data stream
.IP "\fB13\fP"
Errors with program diagnostics
.IP "\fB14\fP"
Error in IPC code
.IP "\fB20\fP"
Received SIGUSR1 or SIGINT
.IP "\fB21\fP"
Some error returned by 
\f(CWwaitpid()\fP
.IP "\fB22\fP"
Error allocating core memory buffers
.IP "\fB23\fP"
Partial transfer due to error
.IP "\fB24\fP"
Partial transfer due to vanished source files
.IP "\fB25\fP"
The \-\-max\-delete limit stopped deletions
.IP "\fB30\fP"
Timeout in data send/receive
.IP "\fB35\fP"
Timeout waiting for daemon connection

.PP 
.SH "ENVIRONMENT VARIABLES"

.PP 
.IP "\fBCVSIGNORE\fP"
The CVSIGNORE environment variable supplements any
ignore patterns in .cvsignore files. See the \fB\-\-cvs\-exclude\fP option for
more details.
.IP "\fBRSYNC_ICONV\fP"
Specify a default \fB\-\-iconv\fP setting using this
environment variable. (First supported in 3.0.0.)
.IP "\fBRSYNC_PROTECT_ARGS\fP"
Specify a non\-zero numeric value if you want the
\fB\-\-protect\-args\fP option to be enabled by default, or a zero value to make
sure that it is disabled by default. (First supported in 3.1.0.)
.IP "\fBRSYNC_RSH\fP"
The RSYNC_RSH environment variable allows you to
override the default shell used as the transport for rsync.  Command line
options are permitted after the command name, just as in the \fB\-e\fP option.
.IP "\fBRSYNC_PROXY\fP"
The RSYNC_PROXY environment variable allows you to
redirect your rsync client to use a web proxy when connecting to a
rsync daemon. You should set RSYNC_PROXY to a hostname:port pair.
.IP "\fBRSYNC_PASSWORD\fP"
Setting RSYNC_PASSWORD to the required
password allows you to run authenticated rsync connections to an rsync
daemon without user intervention. Note that this does not supply a
password to a remote shell transport such as ssh; to learn how to do that,
consult the remote shell\(cq\&s documentation.
.IP "\fBUSER\fP or \fBLOGNAME\fP"
The USER or LOGNAME environment variables
are used to determine the default username sent to an rsync daemon.
If neither is set, the username defaults to \(dq\&nobody\(dq\&.
.IP "\fBHOME\fP"
The HOME environment variable is used to find the user\(cq\&s
default .cvsignore file.

.PP 
.SH "FILES"

.PP 
/etc/rsyncd.conf or rsyncd.conf
.PP 
.SH "SEE ALSO"

.PP 
\fBrsyncd.conf\fP(5)
.PP 
.SH "BUGS"

.PP 
times are transferred as *nix time_t values
.PP 
When transferring to FAT filesystems rsync may re\-sync
unmodified files.
See the comments on the \fB\-\-modify\-window\fP option.
.PP 
file permissions, devices, etc. are transferred as native numerical
values
.PP 
see also the comments on the \fB\-\-delete\fP option
.PP 
Please report bugs! See the web site at
http://rsync.samba.org/
.PP 
.SH "VERSION"

.PP 
This man page is current for version 3.1.3 of rsync.
.PP 
.SH "INTERNAL OPTIONS"

.PP 
The options \fB\-\-server\fP and \fB\-\-sender\fP are used internally by rsync,
and should never be typed by a user under normal circumstances.  Some
awareness of these options may be needed in certain scenarios, such as
when setting up a login that can only run an rsync command.  For instance,
the support directory of the rsync distribution has an example script
named rrsync (for restricted rsync) that can be used with a restricted
ssh login.
.PP 
.SH "CREDITS"

.PP 
rsync is distributed under the GNU General Public License.  See the file
COPYING for details.
.PP 
A WEB site is available at
http://rsync.samba.org/.  The site
includes an FAQ\-O\-Matic which may cover questions unanswered by this
manual page.
.PP 
The primary ftp site for rsync is
ftp://rsync.samba.org/pub/rsync.
.PP 
We would be delighted to hear from you if you like this program.
Please contact the mailing\-list at rsync@lists.samba.org.
.PP 
This program uses the excellent zlib compression library written by
Jean\-loup Gailly and Mark Adler.
.PP 
.SH "THANKS"

.PP 
Special thanks go out to: John Van Essen, Matt McCutchen, Wesley W. Terpstra,
David Dykstra, Jos Backus, Sebastian Krahmer, Martin Pool, and our
gone\-but\-not\-forgotten compadre, J.W. Schultz.
.PP 
Thanks also to Richard Brent, Brendan Mackay, Bill Waite, Stephen Rothwell
and David Bell.  I\(cq\&ve probably missed some people, my apologies if I have.
.PP 
.SH "AUTHOR"

.PP 
rsync was originally written by Andrew Tridgell and Paul Mackerras.
Many people have later contributed to it.  It is currently maintained
by Wayne Davison.
.PP 
Mailing lists for support and development are available at
http://lists.samba.org
