#ifndef ATL_stGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,240,320,400,560,880,1040,1120,1200,1840,2480
 * N : 25,240,320,400,560,880,1040,1120,1200,1840,2480
 * NB : 2,10,10,148,144,140,80,80,150,150,320
 */
#define ATL_stGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 132) (nb_) = 2; \
   else if ((n_) < 360) (nb_) = 10; \
   else if ((n_) < 480) (nb_) = 148; \
   else if ((n_) < 720) (nb_) = 144; \
   else if ((n_) < 960) (nb_) = 140; \
   else if ((n_) < 1160) (nb_) = 80; \
   else if ((n_) < 2160) (nb_) = 150; \
   else (nb_) = 320; \
}


#endif    /* end ifndef ATL_stGetNB_geqrf */
