#include <cctype>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <unistd.h>
#include <zlib.h>

#include "ttmkfdir.h"
#include "encoding.h"

using namespace std;

namespace {
    const char *
    EncodingBase (void)
    {
	static char base[PATH_MAX] = {0,};

	if (!base[0]) {
	    strncpy (base, string(cmdline::instance()->option ("encoding")).c_str (), sizeof (base));
	    char *p = strrchr (base, '/');

	    if (p)
		*(p + 1) = 0;
	    else 
		base[0] = 0;
	}

	return base;
    }

    FILE *
    NextFile (FILE *f, char *name)
    {
	char file_name [1024];
	char line_buf [1024];
	char tmp_file_name[] = "/tmp/ttmkfdir_XXXXXX";
	char inbuf[300000];
	FILE *od;
	gzFile fd;
	int rvalue, tmpfd;

	if (fgets (line_buf, sizeof(line_buf), f) != NULL) {

	    sscanf (line_buf, "%*s %[^\n]\n", file_name);

	    if (file_name[0] == '/') {
		name[0] = 0;
	    } else {
		strcpy (name, EncodingBase ());
	    }
	
	    strcat (name, file_name);

	    bzero(inbuf, sizeof(inbuf));

	    fd = gzopen (name,"rb");
	    rvalue = gzread (fd, inbuf, sizeof(inbuf));

	    tmpfd = mkstemp (tmp_file_name);
	    if (tmpfd == -1) {
		return 0;
	    }

	    od = fdopen (tmpfd,"w");
	    fputs (inbuf, od);
	    fflush (od);
	    fclose (od);

	    od = fopen (tmp_file_name,"r");
	    unlink (tmp_file_name);
	    return od;

	}

	return 0;
    }
}

void
Encodings_t::ReadEncodings (void)
{
    int n;
    FILE *input;
    char name[PATH_MAX];

    FILE *f = fopen (string(cmdline::instance()->option ("encoding")).c_str (), "r");

    if (!f)
	return;
    
    /* read and ignore leading number */
    fscanf(f, "%d\n", &n);
    
    while ((input = NextFile (f, name)) != 0) {
	extern int yylex (char *, Encodings_t &);
	extern void yyrestart (FILE*);
	
	yyrestart (input);
	yylex (name, *this);

	fclose (input);
    }

    fclose (f);
}

Encodings_t::Encodings_t (void)
{
    ReadEncodings ();

    for (int i = 0; Encoding::builtin_encodings[i].size; i++)
	new Encoding (this, Encoding::builtin_encodings + i);
}

Encoding::Encoding (Encodings_t *dest, BuiltinEncoding_t *b):
    size (b->size), enc_size (b->enc_size), start_code (b->start_code)
{
    for (int i = 0; b->aliases[i]; i++)
	names.push_back (b->aliases[i]);

    NumericMapping *m = new NumericMapping (size, b->mapdata.platform, b->mapdata.encoding);

    for (unsigned int i = 0; i < size; i++)
	(*m)[i] = b->mapdata.mappingtable[i];

    AddMapping (m);
    dest->insert (std::make_pair(m->cmapkey(), this));;
}
