#
# This file is a Makefile for Tk.  If it has the name "Makefile.in"
# then it is a template for a Makefile;  to generate the actual Makefile,
# run "./configure", which is a configuration script generated by the
# "autoconf" program (constructs like "@foo@" will get replaced in the
# actual Makefile.

# Current Tk version;  used in various names.

TCLVERSION		= @TCL_VERSION@
TCLPATCHL		= @TCL_PATCH_LEVEL@
VERSION 		= @TK_VERSION@
MAJOR_VERSION		= @TK_MAJOR_VERSION@
MINOR_VERSION		= @TK_MINOR_VERSION@
PATCH_LEVEL		= @TK_PATCH_LEVEL@
LOCALES			= @LOCALES@

#----------------------------------------------------------------
# Things you can change to personalize the Makefile for your own
# site (you can make these changes in either Makefile.in or
# Makefile, but changes to Makefile will get lost if you re-run
# the configuration script).
#----------------------------------------------------------------

# Default top-level directories in which to install architecture-
# specific files (exec_prefix) and machine-independent files such
# as scripts (prefix).  The values specified here may be overridden
# at configure-time with the --exec-prefix and --prefix options
# to the "configure" script.  The *dir vars are standard configure
# substitutions that are based off prefix and exec_prefix.

prefix			= @prefix@
exec_prefix		= @exec_prefix@
bindir			= @bindir@
libdir			= @libdir@
includedir		= @includedir@
datarootdir		= @datarootdir@
mandir			= @mandir@

# The following definition can be set to non-null for special systems
# like AFS with replication.  It allows the pathnames used for installation
# to be different than those used for actually reference files at
# run-time.  INSTALL_ROOT is prepended to $prefix and $exec_prefix
# when installing files.
INSTALL_ROOT		= $(DESTDIR)

# Directory from which applications will reference the library of Tcl
# scripts (note: you can set the TK_LIBRARY environment variable at
# run-time to override the compiled-in location):
TK_LIBRARY		= @TK_LIBRARY@

# Path to use at runtime to refer to LIB_INSTALL_DIR:
LIB_RUNTIME_DIR		= @LIB_RUNTIME_DIR@

# Directory in which to install the program wish:
BIN_INSTALL_DIR		= $(INSTALL_ROOT)$(bindir)

# Directory in which to install the .a or .so binary for the Tk library:
LIB_INSTALL_DIR		= $(INSTALL_ROOT)$(libdir)
DLL_INSTALL_DIR		= @DLL_INSTALL_DIR@

# Path name to use when installing library scripts.
SCRIPT_INSTALL_DIR	= $(INSTALL_ROOT)$(TK_LIBRARY)

# Directory in which to install the include file tk.h:
INCLUDE_INSTALL_DIR	= $(INSTALL_ROOT)$(includedir)

# Path to the private tk header dir:
PRIVATE_INCLUDE_DIR	= @PRIVATE_INCLUDE_DIR@

# Directory in which to (optionally) install the private tk headers:
PRIVATE_INCLUDE_INSTALL_DIR = $(INSTALL_ROOT)$(PRIVATE_INCLUDE_DIR)

# Top-level directory in which to install manual entries:
MAN_INSTALL_DIR		= $(INSTALL_ROOT)$(mandir)

# Directory in which to install manual entry for wish:
MAN1_INSTALL_DIR	= $(MAN_INSTALL_DIR)/man1

# Directory in which to install manual entries for Tk's C library
# procedures:
MAN3_INSTALL_DIR	= $(MAN_INSTALL_DIR)/man3

# Directory in which to install manual entries for the built-in
# Tcl commands implemented by Tk:
MANN_INSTALL_DIR	= $(MAN_INSTALL_DIR)/mann

# Path to the html documentation dir:
HTML_DIR		= @HTML_DIR@

# Directory in which to install html documentation:
HTML_INSTALL_DIR	= $(INSTALL_ROOT)$(HTML_DIR)

# Directory in which to install the configuration file tkConfig.sh:
CONFIG_INSTALL_DIR	= $(INSTALL_ROOT)$(libdir)

# Directory in which to install the demo files:
DEMO_INSTALL_DIR	= $(INSTALL_ROOT)$(TK_LIBRARY)/demos

# The directory containing the Tcl sources and headers appropriate
# for this version of Tk ("srcdir" will be replaced or has already
# been replaced by the configure script):
TCL_GENERIC_DIR		= @TCL_SRC_DIR@/generic

# The directory containing the platform specific Tcl sources and headers
# appropriate for this version of Tk:
TCL_PLATFORM_DIR	= @TCL_SRC_DIR@/unix

# The directory containing the Tcl library archive file appropriate
# for this version of Tk:
TCL_BIN_DIR		= @TCL_BIN_DIR@

# The linker flags needed to link in the Tcl library (ex: -ltcl8.2)
TCL_LIB_FLAG		= @TCL_LIB_FLAG@

# Flag, 1: we're building a shared lib, 0 we're not
TK_SHARED_BUILD		= @TK_SHARED_BUILD@

# Subdirectory of $(libdir) containing the pkgIndex.tcl file for loadable Tk
TK_PKG_DIR		= @TK_PKG_DIR@

# Directory in which to install the pkgIndex.tcl file for loadable Tk
PKG_INSTALL_DIR		= $(LIB_INSTALL_DIR)/$(TK_PKG_DIR)

# Package index file for loadable Tk
PKG_INDEX		= $(PKG_INSTALL_DIR)/pkgIndex.tcl

# warning flags
CFLAGS_WARNING		= @CFLAGS_WARNING@

# The default switches for optimization or debugging
CFLAGS_DEBUG		= @CFLAGS_DEBUG@
CFLAGS_OPTIMIZE		= @CFLAGS_OPTIMIZE@

# To change the compiler switches, for example to change from optimization to
# debugging symbols, change the following line:
#CFLAGS			= $(CFLAGS_DEBUG)
#CFLAGS			= $(CFLAGS_OPTIMIZE)
#CFLAGS			= $(CFLAGS_DEBUG) $(CFLAGS_OPTIMIZE)
CFLAGS			= @CFLAGS_DEFAULT@ @CFLAGS@

# Flags to pass to the linker
LDFLAGS_DEBUG		= @LDFLAGS_DEBUG@
LDFLAGS_OPTIMIZE	= @LDFLAGS_OPTIMIZE@
LDFLAGS			= @LDFLAGS_DEFAULT@ @LDFLAGS@

# A "-I" switch that can be used when compiling to make all of the
# X11 include files accessible (the configure script will try to
# set this value, and will cause it to be an empty string if the
# include files are accessible via /usr/include).
X11_INCLUDES		= @XINCLUDES@

AQUA_INCLUDES		= -I$(MAC_OSX_DIR) -I$(XLIB_DIR)

# Linker switch(es) to use to link with the X11 library archive (the
# configure script will try to set this value automatically, but you
# can override it).
X11_LIB_SWITCHES	= $(XFT_LIBS) @XLIBSW@


# To turn off the security checks that disallow incoming sends when
# the X server appears to be insecure, reverse the comments on the
# following lines:
SECURITY_FLAGS		=
#SECURITY_FLAGS		= -DTK_NO_SECURITY

# To disable ANSI-C procedure prototypes reverse the comment characters
# on the following lines:
PROTO_FLAGS		=
#PROTO_FLAGS		= -DNO_PROTOTYPE

# To enable memory debugging reverse the comment characters on the following
# lines or call configure with --enable-symbols=mem
# Warning:  if you enable memory debugging, you must do it *everywhere*,
# including all the code that calls Tcl, and you must use ckalloc and
# ckfree everywhere instead of malloc and free.
MEM_DEBUG_FLAGS		=
#MEM_DEBUG_FLAGS	= -DTCL_MEM_DEBUG

# If your X server is X11R4 or earlier, then you may wish to reverse
# the comment characters on the following two lines.  This will enable
# extra code to speed up XStringToKeysym.  In X11R5 and later releases
# XStringToKeysym is plenty fast, so you needn't define REDO_KEYSYM_LOOKUP.
KEYSYM_FLAGS		=
#KEYSYM_FLAGS		= -DREDO_KEYSYM_LOOKUP

# Tk does not used deprecated Tcl constructs so it should
# compile fine with -DTCL_NO_DEPRECATED. To remove its own
# set of deprecated code uncomment the second line.
NO_DEPRECATED_FLAGS	= -DTCL_NO_DEPRECATED
#NO_DEPRECATED_FLAGS	= -DTCL_NO_DEPRECATED -DTK_NO_DEPRECATED

# Some versions of make, like SGI's, use the following variable to
# determine which shell to use for executing commands:
SHELL			= @SHELL@

# BUILD_TCLSH is the fully qualified path name of the tclsh shell
# in the Tcl build directory. Test that need to be run in the
# version of tclsh that we are building against should use this
# path. Targets that need an installed tclsh should not depend
# on this variable.

BUILD_TCLSH		= @BUILD_TCLSH@

# TCL_EXE is the name of a tclsh executable that is available *BEFORE*
# running make for the first time. Certain build targets (make genstubs)
# need it to be available on the PATH. This executable should *NOT* be
# required just to do a normal build although it can be required to run
# make dist. This variable is set to "" if no tclsh is available.
EXE_SUFFIX		= @EXEEXT@
TCL_EXE			= @TCLSH_PROG@
WISH_EXE		= wish${EXE_SUFFIX}
TKTEST_EXE		= tktest${EXE_SUFFIX}

# Tk used to let the configure script choose which program to use
# for installing, but there are just too many different versions of
# "install" around;  better to use the install-sh script that comes
# with the distribution, which is slower but guaranteed to work.

INSTALL_STRIP_PROGRAM   = -s
INSTALL_STRIP_LIBRARY   = -S -x

INSTALL			= $(SHELL) $(UNIX_DIR)/install-sh -c
INSTALL_PROGRAM		= ${INSTALL}
INSTALL_LIBRARY		= ${INSTALL}
INSTALL_DATA		= ${INSTALL} -m 644
INSTALL_DATA_DIR	= ${INSTALL} -d -m 755

# The symbol below provides support for dynamic loading and shared
# libraries.  See configure.in for a description of what it means.
# The value of the symbol is normally set by the configure script.

SHLIB_CFLAGS		= @SHLIB_CFLAGS@ -DBUILD_tk

# To enable support for stubs in Tcl.
STUB_LIB_FILE		= @TK_STUB_LIB_FILE@

TK_STUB_LIB_FILE	= @TK_STUB_LIB_FILE@
#TK_STUB_LIB_FILE	= libtkstub.a

# Generic stub lib name used in rules that apply to tcl and tk
STUB_LIB_FILE		= ${TK_STUB_LIB_FILE}

TK_STUB_LIB_FLAG	= @TK_STUB_LIB_FLAG@
#TK_STUB_LIB_FLAG	= -ltkstub

TK_LIB_FILE		= @TK_LIB_FILE@
#TK_LIB_FILE		= libtk.a

# Generic lib name used in rules that apply to tcl and tk
LIB_FILE		= ${TK_LIB_FILE}

TK_LIB_FLAG		= @TK_LIB_FLAG@
#TK_LIB_FLAG		= -ltk

TCL_LIB_SPEC		= @TCL_LIB_SPEC@
TCL_STUB_LIB_SPEC	= @TCL_STUB_LIB_SPEC@
TCL_STUB_LIB_FLAG	= @TCL_STUB_LIB_FLAG@
TCL_STUB_LIB_FILE	= @TCL_STUB_LIB_FILE@

TCL_STUB_FLAGS		= @TCL_STUB_FLAGS@

# Libraries to use when linking.  This definition is determined by the
# configure script.
LIBS = @LIBS@ $(X11_LIB_SWITCHES) @TCL_LIBS@
WISH_LIBS = $(TCL_LIB_SPEC) @LIBS@ $(X11_LIB_SWITCHES) @TCL_LIBS@ @EXTRA_WISH_LIBS@

# The symbols below provide support for dynamic loading and shared
# libraries.  See configure.in for a description of what the
# symbols mean.  The values of the symbols are normally set by the
# configure script.  You shouldn't normally need to modify any of
# these definitions by hand.

STLIB_LD		= @STLIB_LD@
SHLIB_LD		= @SHLIB_LD@
SHLIB_LD_LIBS		= @SHLIB_LD_LIBS@
TK_SHLIB_LD_EXTRAS	= @TK_SHLIB_LD_EXTRAS@

# Additional search flags needed to find the various shared libraries
# at run-time.  The first symbol is for use when creating a binary
# with cc, and the second is for use when running ld directly.
CC_SEARCH_FLAGS	= @CC_SEARCH_FLAGS@
LD_SEARCH_FLAGS	= @LD_SEARCH_FLAGS@

# support for embedded libraries on Darwin / Mac OS X
DYLIB_INSTALL_DIR	= ${LIB_RUNTIME_DIR}

# support for building the Aqua resource file
TK_RSRC_FILE		= @TK_RSRC_FILE@
WISH_RSRC_FILE		= @WISH_RSRC_FILE@
REZ			= @REZ@
REZ_SWITCHES = @REZ_FLAGS@ -i $(GENERIC_DIR) -i $(TCL_GENERIC_DIR)

# support for Xft:
XFT_CFLAGS		= @XFT_CFLAGS@
XFT_LIBS		= @XFT_LIBS@

#----------------------------------------------------------------
# The information below is modified by the configure script when
# Makefile is generated from Makefile.in.  You shouldn't normally
# modify any of this stuff by hand.
#----------------------------------------------------------------

AC_FLAGS		= @DEFS@
AR			= @AR@
RANLIB			= @RANLIB@
SRC_DIR			= @srcdir@
TOP_DIR			= $(SRC_DIR)/..
GENERIC_DIR		= $(TOP_DIR)/generic
TTK_DIR			= $(GENERIC_DIR)/ttk
UNIX_DIR		= $(TOP_DIR)/unix
BMAP_DIR		= $(TOP_DIR)/bitmaps
TOOL_DIR		= @TCL_SRC_DIR@/tools
TEST_DIR		= $(TOP_DIR)/tests
MAC_OSX_DIR		= $(TOP_DIR)/macosx
XLIB_DIR		= $(TOP_DIR)/xlib

#----------------------------------------------------------------
# The information below should be usable as is.  The configure
# script won't modify it and you shouldn't need to modify it
# either.
#----------------------------------------------------------------

# Flags to be passed to installManPage to control how the manpages
# should be installed (symlinks, compression, package name suffix).
MAN_FLAGS               = @MAN_FLAGS@

CC			= @CC@

CC_SWITCHES_NO_STUBS = ${CFLAGS} ${CFLAGS_WARNING} ${SHLIB_CFLAGS} \
-I${UNIX_DIR} -I${GENERIC_DIR} -I${BMAP_DIR} -I${TCL_GENERIC_DIR} \
-I${TCL_PLATFORM_DIR} ${@TK_WINDOWINGSYSTEM@_INCLUDES} ${AC_FLAGS} \
${PROTO_FLAGS} ${SECURITY_FLAGS} ${MEM_DEBUG_FLAGS} ${KEYSYM_FLAGS} \
${NO_DEPRECATED_FLAGS} @EXTRA_CC_SWITCHES@

CC_SWITCHES = $(CC_SWITCHES_NO_STUBS) @TCL_STUB_FLAGS@

APP_CC_SWITCHES = $(CC_SWITCHES_NO_STUBS) @EXTRA_APP_CC_SWITCHES@

DEPEND_SWITCHES = ${CFLAGS} -I${UNIX_DIR} -I${GENERIC_DIR} -I${BMAP_DIR} \
-I${TCL_GENERIC_DIR} -I${TCL_PLATFORM_DIR} ${@TK_WINDOWINGSYSTEM@_INCLUDES} \
${AC_FLAGS} ${PROTO_FLAGS} ${SECURITY_FLAGS} ${MEM_DEBUG_FLAGS} \
${KEYSYM_FLAGS} @EXTRA_CC_SWITCHES@

WISH_OBJS = tkAppInit.o

TKTEST_OBJS = tkTestInit.o tkTest.o tkSquare.o tkOldTest.o \
	$(@TK_WINDOWINGSYSTEM@_TKTEST_OBJS)

WIDG_OBJS = tkButton.o tkEntry.o tkFrame.o tkListbox.o \
	tkMenu.o tkMenubutton.o tkMenuDraw.o tkMessage.o \
	tkPanedWindow.o tkScale.o tkScrollbar.o

CANV_OBJS = tkCanvas.o tkCanvArc.o tkCanvBmap.o tkCanvImg.o \
	tkCanvLine.o tkCanvPoly.o tkCanvPs.o tkCanvText.o \
	tkCanvUtil.o tkCanvWind.o tkRectOval.o tkTrig.o

IMAGE_OBJS = tkImage.o tkImgBmap.o tkImgGIF.o tkImgPNG.o tkImgPPM.o \
	tkImgPhoto.o tkImgPhInstance.o

TEXT_OBJS = tkText.o tkTextBTree.o tkTextDisp.o tkTextImage.o tkTextIndex.o \
	tkTextMark.o tkTextTag.o tkTextWind.o

# either tkUnixFont.o (default) or tkUnixRFont.o (if --enable-xft)
#
FONT_OBJS = @UNIX_FONT_OBJS@

GENERIC_OBJS = tk3d.o tkArgv.o tkAtom.o tkBind.o tkBitmap.o tkBusy.o \
	tkClipboard.o \
	tkCmds.o tkColor.o tkConfig.o tkConsole.o tkCursor.o tkError.o \
	tkEvent.o tkFocus.o tkFont.o tkGet.o tkGC.o tkGeometry.o tkGrab.o \
	tkGrid.o tkMain.o tkObj.o tkOldConfig.o tkOption.o tkPack.o tkPlace.o \
	tkSelect.o tkStyle.o tkUndo.o tkUtil.o tkVisual.o tkWindow.o

TTK_OBJS = \
	ttkBlink.o ttkButton.o ttkCache.o ttkClamTheme.o ttkClassicTheme.o \
	ttkDefaultTheme.o ttkElements.o ttkEntry.o ttkFrame.o ttkImage.o \
	ttkInit.o ttkLabel.o ttkLayout.o ttkManager.o ttkNotebook.o \
	ttkPanedwindow.o ttkProgress.o ttkScale.o ttkScrollbar.o ttkScroll.o \
	ttkSeparator.o ttkSquare.o ttkState.o \
	ttkTagSet.o ttkTheme.o ttkTrace.o ttkTrack.o ttkTreeview.o \
	ttkWidget.o ttkStubInit.o

STUB_OBJS = tkStubInit.o

STUB_LIB_OBJS = tkStubLib.o ttkStubLib.o

X11_OBJS = tkUnix.o tkUnix3d.o tkUnixButton.o tkUnixColor.o tkUnixConfig.o \
	tkUnixCursor.o tkUnixDraw.o tkUnixEmbed.o tkUnixEvent.o \
	tkUnixFocus.o  $(FONT_OBJS) tkUnixInit.o tkUnixKey.o tkUnixMenu.o \
	tkUnixMenubu.o tkUnixScale.o tkUnixScrlbr.o tkUnixSelect.o \
	tkUnixSend.o tkUnixWm.o tkUnixXId.o

AQUA_OBJS = tkMacOSXBitmap.o tkMacOSXButton.o tkMacOSXClipboard.o \
	tkMacOSXColor.o tkMacOSXConfig.o tkMacOSXCursor.o tkMacOSXDebug.o \
	tkMacOSXDialog.o tkMacOSXDraw.o tkMacOSXEmbed.o tkMacOSXEntry.o \
	tkMacOSXEvent.o tkMacOSXFont.o tkMacOSXHLEvents.o tkMacOSXImage.o \
	tkMacOSXInit.o tkMacOSXKeyboard.o tkMacOSXKeyEvent.o tkMacOSXMenu.o \
	tkMacOSXMenubutton.o tkMacOSXMenus.o tkMacOSXMouseEvent.o \
	tkMacOSXNotify.o tkMacOSXRegion.o tkMacOSXScrlbr.o tkMacOSXSend.o \
	tkMacOSXSubwindows.o tkMacOSXWindowEvent.o \
	tkMacOSXWm.o tkMacOSXXStubs.o \
	tkFileFilter.o tkMacWinMenu.o tkPointer.o tkUnix3d.o tkUnixScale.o \
	xcolors.o xdraw.o xgc.o ximage.o xutil.o \
	ttkMacOSXTheme.o

AQUA_TKTEST_OBJS = tkMacOSXTest.o

OBJS =  $(GENERIC_OBJS) $(WIDG_OBJS) $(CANV_OBJS) $(IMAGE_OBJS) $(TEXT_OBJS) \
	$(STUB_OBJS) $(TTK_OBJS) \
	$(@TK_WINDOWINGSYSTEM@_OBJS) @PLAT_OBJS@

TK_DECLS = \
	$(GENERIC_DIR)/tk.decls \
	$(GENERIC_DIR)/tkInt.decls

TTK_DECLS = \
	$(TTK_DIR)/ttk.decls

GENERIC_SRCS = \
	$(GENERIC_DIR)/tk3d.c $(GENERIC_DIR)/tkArgv.c \
	$(GENERIC_DIR)/tkAtom.c $(GENERIC_DIR)/tkBind.c	\
	$(GENERIC_DIR)/tkBitmap.c $(GENERIC_DIR)/tkBusy.c \
	$(GENERIC_DIR)/tkClipboard.c \
	$(GENERIC_DIR)/tkCmds.c $(GENERIC_DIR)/tkColor.c \
	$(GENERIC_DIR)/tkConfig.c $(GENERIC_DIR)/tkCursor.c \
	$(GENERIC_DIR)/tkError.c $(GENERIC_DIR)/tkEvent.c \
	$(GENERIC_DIR)/tkFocus.c $(GENERIC_DIR)/tkFont.c \
	$(GENERIC_DIR)/tkGet.c $(GENERIC_DIR)/tkGC.c \
	$(GENERIC_DIR)/tkGeometry.c $(GENERIC_DIR)/tkGrab.c \
	$(GENERIC_DIR)/tkGrid.c $(GENERIC_DIR)/tkConsole.c \
	$(GENERIC_DIR)/tkMain.c $(GENERIC_DIR)/tkOption.c \
	$(GENERIC_DIR)/tkPack.c $(GENERIC_DIR)/tkPlace.c \
	$(GENERIC_DIR)/tkSelect.c $(GENERIC_DIR)/tkStyle.c \
	$(GENERIC_DIR)/tkUndo.c $(GENERIC_DIR)/tkUtil.c \
	$(GENERIC_DIR)/tkVisual.c $(GENERIC_DIR)/tkWindow.c \
	$(GENERIC_DIR)/tkButton.c $(GENERIC_DIR)/tkObj.c \
	$(GENERIC_DIR)/tkEntry.c $(GENERIC_DIR)/tkFrame.c \
	$(GENERIC_DIR)/tkListbox.c $(GENERIC_DIR)/tkMenu.c \
	$(GENERIC_DIR)/tkMenubutton.c $(GENERIC_DIR)/tkMenuDraw.c \
	$(GENERIC_DIR)/tkMessage.c $(GENERIC_DIR)/tkPanedWindow.c \
	$(GENERIC_DIR)/tkScale.c $(GENERIC_DIR)/tkScrollbar.c \
	$(GENERIC_DIR)/tkCanvas.c $(GENERIC_DIR)/tkCanvArc.c \
	$(GENERIC_DIR)/tkCanvBmap.c $(GENERIC_DIR)/tkCanvImg.c \
	$(GENERIC_DIR)/tkCanvLine.c $(GENERIC_DIR)/tkCanvPoly.c \
	$(GENERIC_DIR)/tkCanvPs.c $(GENERIC_DIR)/tkCanvText.c \
	$(GENERIC_DIR)/tkCanvUtil.c \
	$(GENERIC_DIR)/tkCanvWind.c $(GENERIC_DIR)/tkRectOval.c \
	$(GENERIC_DIR)/tkTrig.c $(GENERIC_DIR)/tkImage.c \
	$(GENERIC_DIR)/tkImgBmap.c $(GENERIC_DIR)/tkImgGIF.c \
	$(GENERIC_DIR)/tkImgPNG.c $(GENERIC_DIR)/tkImgPPM.c \
	$(GENERIC_DIR)/tkImgPhoto.c $(GENERIC_DIR)/tkImgPhInstance.c \
	$(GENERIC_DIR)/tkText.c \
	$(GENERIC_DIR)/tkTextBTree.c $(GENERIC_DIR)/tkTextDisp.c \
	$(GENERIC_DIR)/tkTextImage.c \
	$(GENERIC_DIR)/tkTextIndex.c $(GENERIC_DIR)/tkTextMark.c \
	$(GENERIC_DIR)/tkTextTag.c $(GENERIC_DIR)/tkTextWind.c \
	$(GENERIC_DIR)/tkOldConfig.c $(GENERIC_DIR)/tkOldTest.c \
	$(GENERIC_DIR)/tkSquare.c $(GENERIC_DIR)/tkTest.c \
	$(GENERIC_DIR)/tkStubInit.c

TTK_SRCS = \
	$(TTK_DIR)/ttkBlink.c \
	$(TTK_DIR)/ttkButton.c \
	$(TTK_DIR)/ttkCache.c \
	$(TTK_DIR)/ttkClamTheme.c \
	$(TTK_DIR)/ttkClassicTheme.c \
	$(TTK_DIR)/ttkDefaultTheme.c \
	$(TTK_DIR)/ttkElements.c \
	$(TTK_DIR)/ttkEntry.c \
	$(TTK_DIR)/ttkFrame.c \
	$(TTK_DIR)/ttkImage.c \
	$(TTK_DIR)/ttkInit.c \
	$(TTK_DIR)/ttkLabel.c \
	$(TTK_DIR)/ttkLayout.c \
	$(TTK_DIR)/ttkManager.c \
	$(TTK_DIR)/ttkNotebook.c \
	$(TTK_DIR)/ttkPanedwindow.c \
	$(TTK_DIR)/ttkProgress.c \
	$(TTK_DIR)/ttkScale.c \
	$(TTK_DIR)/ttkScrollbar.c \
	$(TTK_DIR)/ttkScroll.c \
	$(TTK_DIR)/ttkSeparator.c \
	$(TTK_DIR)/ttkSquare.c \
	$(TTK_DIR)/ttkState.c \
	$(TTK_DIR)/ttkTagSet.c \
	$(TTK_DIR)/ttkTheme.c \
	$(TTK_DIR)/ttkTrace.c \
	$(TTK_DIR)/ttkTrack.c \
	$(TTK_DIR)/ttkTreeview.c \
	$(TTK_DIR)/ttkWidget.c

TTK_STUB_SRCS = \
	$(TTK_DIR)/ttkStubInit.c $(TTK_DIR)/ttkStubLib.c

X11_SRCS = \
	$(UNIX_DIR)/tkAppInit.c $(UNIX_DIR)/tkUnix.c \
	$(UNIX_DIR)/tkUnix3d.c \
	$(UNIX_DIR)/tkUnixButton.c $(UNIX_DIR)/tkUnixColor.c \
	$(UNIX_DIR)/tkUnixConfig.c \
	$(UNIX_DIR)/tkUnixCursor.c \
	$(UNIX_DIR)/tkUnixDraw.c \
	$(UNIX_DIR)/tkUnixEmbed.c $(UNIX_DIR)/tkUnixEvent.c \
	$(UNIX_DIR)/tkUnixFocus.c \
	$(UNIX_DIR)/tkUnixRFont.c \
	$(UNIX_DIR)/tkUnixFont.c $(UNIX_DIR)/tkUnixInit.c \
	$(UNIX_DIR)/tkUnixKey.c \
	$(UNIX_DIR)/tkUnixMenu.c $(UNIX_DIR)/tkUnixMenubu.c \
	$(UNIX_DIR)/tkUnixScale.c $(UNIX_DIR)/tkUnixScrlbr.c \
	$(UNIX_DIR)/tkUnixSelect.c \
	$(UNIX_DIR)/tkUnixSend.c $(UNIX_DIR)/tkUnixWm.c \
	$(UNIX_DIR)/tkUnixXId.c

AQUA_SRCS = \
	$(MAC_OSX_DIR)/tkMacOSXBitmap.c $(MAC_OSX_DIR)/tkMacOSXButton.c \
	$(MAC_OSX_DIR)/tkMacOSXClipboard.c $(MAC_OSX_DIR)/tkMacOSXColor.c \
	$(MAC_OSX_DIR)/tkMacOSXConfig.c $(MAC_OSX_DIR)/tkMacOSXCursor.c \
	$(MAC_OSX_DIR)/tkMacOSXDebug.c $(MAC_OSX_DIR)/tkMacOSXDialog.c \
	$(MAC_OSX_DIR)/tkMacOSXDraw.c $(MAC_OSX_DIR)/tkMacOSXEmbed.c \
	$(MAC_OSX_DIR)/tkMacOSXEntry.c $(MAC_OSX_DIR)/tkMacOSXEvent.c \
	$(MAC_OSX_DIR)/tkMacOSXFont.c $(MAC_OSX_DIR)/tkMacOSXHLEvents.c \
	$(MAC_OSX_DIR)/tkMacOSXImage.c \
	$(MAC_OSX_DIR)/tkMacOSXInit.c $(MAC_OSX_DIR)/tkMacOSXKeyboard.c \
	$(MAC_OSX_DIR)/tkMacOSXKeyEvent.c $(MAC_OSX_DIR)/tkMacOSXMenu.c \
	$(MAC_OSX_DIR)/tkMacOSXMenubutton.c $(MAC_OSX_DIR)/tkMacOSXMenus.c \
	$(MAC_OSX_DIR)/tkMacOSXMouseEvent.c $(MAC_OSX_DIR)/tkMacOSXNotify.c \
	$(MAC_OSX_DIR)/tkMacOSXRegion.c $(MAC_OSX_DIR)/tkMacOSXScrlbr.c \
	$(MAC_OSX_DIR)/tkMacOSXSend.c $(MAC_OSX_DIR)/tkMacOSXSubwindows.c \
	$(MAC_OSX_DIR)/tkMacOSXTest.c $(MAC_OSX_DIR)/tkMacOSXWindowEvent.c \
	$(MAC_OSX_DIR)/tkMacOSXWm.c $(MAC_OSX_DIR)/tkMacOSXXStubs.c \
	$(GENERIC_DIR)/tkFileFilter.c $(GENERIC_DIR)/tkMacWinMenu.c \
	$(GENERIC_DIR)/tkPointer.c $(UNIX_DIR)/tkUnix3d.c \
	$(UNIX_DIR)/tkUnixScale.c $(XLIB_DIR)/xcolors.c $(XLIB_DIR)/xdraw.c \
	$(XLIB_DIR)/xgc.c $(XLIB_DIR)/ximage.c $(XLIB_DIR)/xutil.c \
	$(TTK_DIR)/ttkMacOSXTheme.c

SRCS = $(GENERIC_SRCS) $(@TK_WINDOWINGSYSTEM@_SRCS) @PLAT_SRCS@

AQUA_RESOURCES = \
	$(MAC_OSX_DIR)/tkAboutDlg.r $(MAC_OSX_DIR)/tkMacOSXCursors.r \
	$(MAC_OSX_DIR)/tkMacOSXXCursors.r

AQUA_WISH_RESOURCES = $(MAC_OSX_DIR)/tkMacOSXAETE.r

AQUA_HDRS = $(MAC_OSX_DIR)/tkMacOSX.h $(GENERIC_DIR)/tkIntXlibDecls.h

AQUA_XLIB_HDRS = $(XLIB_DIR)/X11/*.h $(XLIB_DIR)/xbytes.h

AQUA_PRIVATE_HDRS = $(MAC_OSX_DIR)/tkMacOSXPort.h $(MAC_OSX_DIR)/tkMacOSXInt.h

X11_PRIVATE_HDRS = $(UNIX_DIR)/tkUnixPort.h $(UNIX_DIR)/tkUnixInt.h $(GENERIC_DIR)/tkIntXlibDecls.h

# Currently private, eventually public
TTK_HDRS = $(TTK_DIR)/ttkTheme.h $(TTK_DIR)/ttkDecls.h

PUBLIC_HDRS = $(GENERIC_DIR)/tk.h $(GENERIC_DIR)/tkDecls.h \
	$(GENERIC_DIR)/tkPlatDecls.h $(@TK_WINDOWINGSYSTEM@_HDRS)

# The private headers we want installed for install-private-headers
PRIVATE_HDRS = $(GENERIC_DIR)/tkInt.h $(GENERIC_DIR)/tkIntDecls.h \
	$(GENERIC_DIR)/tkIntPlatDecls.h $(GENERIC_DIR)/tkPort.h \
	$(TTK_HDRS) $(@TK_WINDOWINGSYSTEM@_PRIVATE_HDRS)

DEMOPROGS = browse hello ixset rmt rolodex square tcolor timer widget

SHELL_ENV = \
	@LD_LIBRARY_PATH_VAR@="`pwd`:${TCL_BIN_DIR}:$${@LD_LIBRARY_PATH_VAR@}"; \
	export @LD_LIBRARY_PATH_VAR@; \
	TCL_LIBRARY=@TCL_SRC_DIR@/library; export TCL_LIBRARY; \
	TK_LIBRARY=@TK_SRC_DIR@/library; export TK_LIBRARY;

all: binaries libraries doc

binaries: ${LIB_FILE} ${WISH_EXE}

libraries:

$(TOP_DIR)/doc/man.macros:
	$(INSTALL_DATA) @TCL_SRC_DIR@/doc/man.macros $(TOP_DIR)/doc/man.macros

doc: $(TOP_DIR)/doc/man.macros

# The following target is configured by autoconf to generate either
# a shared library or non-shared library for Tk.
${LIB_FILE}: ${STUB_LIB_FILE} @LIB_RSRC_FILE@ ${OBJS}
	rm -f $@
	@MAKE_LIB@

${STUB_LIB_FILE}: ${STUB_LIB_OBJS}
	@if test "x${LIB_FILE}" = "xlibtk${MAJOR_VERSION}.${MINOR_VERSION}.dll"; then \
	    (cd ${TOP_DIR}/win; ${MAKE} tk${MAJOR_VERSION}${MINOR_VERSION}.dll); \
	    cp "${TOP_DIR}/win/tk${MAJOR_VERSION}${MINOR_VERSION}.dll" .; \
	fi
	rm -f $@
	@MAKE_STUB_LIB@

# Build Aqua resource files
${TK_RSRC_FILE}: $(AQUA_RESOURCES)
	rm -f $@
	if test "$(REZ)" != ""; then \
	    $(REZ) -o $@ $(REZ_SWITCHES) $(AQUA_RESOURCES); fi

${WISH_RSRC_FILE}: $(AQUA_WISH_RESOURCES)
	rm -f $@
	if test "$(REZ)" != ""; then \
	    $(REZ) -o $@ $(REZ_SWITCHES) $(AQUA_WISH_RESOURCES); fi

# Make target which outputs the list of the .o contained in the Tk lib
# usefull to build a single big shared library containing Tcl/Tk and other
# extensions.  used for the Tcl Plugin.  -- dl
tkLibObjs:
	@echo ${OBJS}
# This targets actually build the objects needed for the lib in the above
# case
objs: ${OBJS}


${WISH_EXE}: $(TK_STUB_LIB_FILE) $(WISH_OBJS) $(TK_LIB_FILE) @APP_RSRC_FILE@
	${CC} ${CFLAGS} ${LDFLAGS} $(WISH_OBJS) @TK_BUILD_LIB_SPEC@ \
		$(WISH_LIBS) $(CC_SEARCH_FLAGS) -o ${WISH_EXE}

# Resetting the LIB_RUNTIME_DIR below is required so that
# the generated tktest executable gets the build directory
# burned into its ld search path. This keeps tktest from
# picking up an already installed version of the Tcl or
# Tk shared libraries.

$(TKTEST_EXE): $(TKTEST_OBJS) $(TK_LIB_FILE)
	$(MAKE) tktest-real LIB_RUNTIME_DIR="`pwd`:$(TCL_BIN_DIR)"

tktest-real: ${TK_STUB_LIB_FILE}
	${CC} ${CFLAGS} ${LDFLAGS} $(TKTEST_OBJS) ${TK_STUB_LIB_FILE} ${TCL_STUB_LIB_SPEC} @TK_BUILD_LIB_SPEC@ \
		$(WISH_LIBS) $(CC_SEARCH_FLAGS) -o $(TKTEST_EXE)

# # FIXME: This xttest rule seems to be broken in a number of ways.  It should
# # use CC_SEARCH_FLAGS, it does not include the shared lib location logic from
# # tktest, and it is not clear where this test.o object file comes from.
#
# xttest: test.o tkTest.o tkSquare.o $(TK_LIB_FILE) ${TK_STUB_LIB_FILE}
# 	${CC} ${CFLAGS} ${LDFLAGS} test.o tkTest.o tkSquare.o \
# 		@TK_BUILD_LIB_SPEC@ ${TK_STUB_LIB_FILE}  ${TCL_STUB_LIB_SPEC} \
# 		$(WISH_LIBS) $(LD_SEARCH_FLAGS) -lXt -o xttest

# Note, in the target below TCL_LIBRARY needs to be set or else
# "make test" won't work in the case where the compilation directory
# isn't the same as the source directory.
# Specifying TESTFLAGS on the command line is the standard way to pass
# args to tcltest, ie:
#	% make test TESTFLAGS="-verbose bps -file fileName.test"

test: test-classic test-ttk

test-classic: $(TKTEST_EXE)
	$(SHELL_ENV) ./$(TKTEST_EXE) $(TEST_DIR)/all.tcl -geometry +0+0 $(TESTFLAGS)

test-ttk: $(TKTEST_EXE)
	$(SHELL_ENV) ./$(TKTEST_EXE) $(TEST_DIR)/ttk/all.tcl -geometry +0+0 \
	$(TESTFLAGS)

# Tests with different languages
testlang: $(TKTEST_EXE)
	$(SHELL_ENV) \
	for lang in $(LOCALES) ;  \
	do \
	LANG=$(lang); export LANG; \
	./$(TKTEST_EXE) $(TEST_DIR)/all.tcl -geometry +0+0 \
	$(TESTFLAGS); \
	done

# Useful target to launch a built tktest with the proper path,...
runtest: $(TKTEST_EXE)
	$(SHELL_ENV) ./$(TKTEST_EXE)

# This target can be used to run wish from the build directory
# via `make shell` or `make shell SCRIPT=/tmp/foo.tcl`
shell: ${WISH_EXE}
	$(SHELL_ENV) ./${WISH_EXE} $(SCRIPT)

demo:
	$(SHELL_ENV) ./${WISH_EXE} $(TOP_DIR)/library/demos/widget

# This target can be used to run wish inside either gdb or insight
gdb: ${WISH_EXE}
	@echo "set env @LD_LIBRARY_PATH_VAR@=\"`pwd`:${TCL_BIN_DIR}:$${@LD_LIBRARY_PATH_VAR@}\"" > gdb.run
	@echo "set env TCL_LIBRARY=@TCL_SRC_DIR@/library" >> gdb.run
	@echo "set env TK_LIBRARY=@TK_SRC_DIR@/library" >> gdb.run
	gdb ./${WISH_EXE} --command=gdb.run
	rm gdb.run

VALGRINDARGS=--tool=memcheck --num-callers=8 --leak-resolution=high --leak-check=yes --show-reachable=yes -v

valgrind: $(TKTEST_EXE)
	$(SHELL_ENV) valgrind $(VALGRINDARGS) ./$(TKTEST_EXE) $(TEST_DIR)/all.tcl -geometry +0+0 -singleproc 1 $(TESTFLAGS)

valgrindshell: $(TKTEST_EXE)
	$(SHELL_ENV) valgrind $(VALGRINDARGS) ./$(TKTEST_EXE) $(SCRIPT)

INSTALL_BASE_TARGETS = install-binaries install-libraries
INSTALL_DOC_TARGETS = install-doc
INSTALL_DEV_TARGETS = install-headers
INSTALL_DEMO_TARGETS = install-demos
INSTALL_EXTRA_TARGETS = @EXTRA_INSTALL@
INSTALL_TARGETS = $(INSTALL_BASE_TARGETS) $(INSTALL_DOC_TARGETS) $(INSTALL_DEV_TARGETS) \
		$(INSTALL_DEMO_TARGETS) $(INSTALL_EXTRA_TARGETS)

install: $(INSTALL_TARGETS)

install-strip:
	$(MAKE) $(INSTALL_TARGETS) \
		INSTALL_PROGRAM="$(INSTALL_PROGRAM) ${INSTALL_STRIP_PROGRAM}" \
		INSTALL_LIBRARY="$(INSTALL_LIBRARY) ${INSTALL_STRIP_LIBRARY}"

install-binaries: $(TK_STUB_LIB_FILE) $(TK_LIB_FILE) ${WISH_EXE}
	@for i in "$(LIB_INSTALL_DIR)" "$(BIN_INSTALL_DIR)" \
	    "$(PKG_INSTALL_DIR)" "$(CONFIG_INSTALL_DIR)" ; \
	    do \
	    if [ ! -d "$$i" ] ; then \
		echo "Making directory $$i"; \
		$(INSTALL_DATA_DIR) "$$i"; \
		else true; \
		fi; \
	    done;
	@if test "x$(TK_SHARED_BUILD)" = "x1"; then \
	    echo "Creating package index $(PKG_INDEX)"; \
	    rm -f "$(PKG_INDEX)"; \
	    (\
	    echo "if {[catch {package present Tcl 8.6.0}]} return";\
	    relative=`echo | awk '{ORS=" "; split("$(TK_PKG_DIR)",a,"/"); for (f in a) {print ".."}}'`;\
	    if test "x$(DLL_INSTALL_DIR)" != "x$(BIN_INSTALL_DIR)"; then \
	    echo "package ifneeded Tk $(MAJOR_VERSION).$(MINOR_VERSION)$(PATCH_LEVEL) [list load [file normalize [file join \$$dir $${relative}$(TK_LIB_FILE)]] Tk]";\
	    else \
	    echo "if {(\$$::tcl_platform(platform) eq \"unix\") && ([info exists ::env(DISPLAY)]";\
	    echo "	|| ([info exists ::argv] && (\"-display\" in \$$::argv)))} {";\
	    echo "    package ifneeded Tk $(MAJOR_VERSION).$(MINOR_VERSION)$(PATCH_LEVEL) [list load [file normalize [file join \$$dir $${relative}.. bin $(TK_LIB_FILE)]] Tk]";\
	    echo "} else {";\
	    echo "    package ifneeded Tk $(MAJOR_VERSION).$(MINOR_VERSION)$(PATCH_LEVEL) [list load [file normalize [file join \$$dir $${relative}.. bin tk${MAJOR_VERSION}${MINOR_VERSION}.dll]] Tk]";\
	    echo "}";\
	    fi \
	    ) > "$(PKG_INDEX)"; \
	    fi
	@echo "Installing $(LIB_FILE) to $(DLL_INSTALL_DIR)/"
	@@INSTALL_LIB@
	@chmod 555 "$(DLL_INSTALL_DIR)/$(LIB_FILE)"
	@if test -f "tk${MAJOR_VERSION}${MINOR_VERSION}.dll"; then \
	    $(INSTALL_LIBRARY) "tk${MAJOR_VERSION}${MINOR_VERSION}.dll" "$(DLL_INSTALL_DIR)";\
	    chmod 555 "$(DLL_INSTALL_DIR)/tk${MAJOR_VERSION}${MINOR_VERSION}.dll";\
	    $(INSTALL_LIBRARY) "../win/libtk${MAJOR_VERSION}${MINOR_VERSION}.a" "$(LIB_INSTALL_DIR)";\
	    chmod 555 "$(LIB_INSTALL_DIR)/libtk${MAJOR_VERSION}${MINOR_VERSION}.a";\
	fi
	@echo "Installing ${WISH_EXE} as $(BIN_INSTALL_DIR)/wish$(VERSION)${EXE_SUFFIX}"
	@$(INSTALL_PROGRAM) ${WISH_EXE} "$(BIN_INSTALL_DIR)/wish$(VERSION)${EXE_SUFFIX}"
	@echo "Installing tkConfig.sh to $(CONFIG_INSTALL_DIR)/"
	@$(INSTALL_DATA) tkConfig.sh "$(CONFIG_INSTALL_DIR)/tkConfig.sh"
	@if test "$(STUB_LIB_FILE)" != "" ; then \
	    echo "Installing $(STUB_LIB_FILE) to $(LIB_INSTALL_DIR)/"; \
	    @INSTALL_STUB_LIB@ ; \
	fi
	@EXTRA_INSTALL_BINARIES@
	@echo "Installing pkg-config file to $(LIB_INSTALL_DIR)/pkgconfig/"
	@$(INSTALL_DATA_DIR) $(LIB_INSTALL_DIR)/pkgconfig
	@$(INSTALL_DATA) tk.pc $(LIB_INSTALL_DIR)/pkgconfig/tk.pc

install-libraries: libraries
	@for i in "$(SCRIPT_INSTALL_DIR)" "$(SCRIPT_INSTALL_DIR)/images" \
		"$(SCRIPT_INSTALL_DIR)/msgs" "$(SCRIPT_INSTALL_DIR)/ttk"; \
	    do \
	    if [ -n "$$i" -a ! -d "$$i" ] ; then \
		echo "Making directory $$i"; \
		$(INSTALL_DATA_DIR) "$$i"; \
		else true; \
		fi; \
	    done;
	@echo "Installing Tk library files to $(SCRIPT_INSTALL_DIR)/";
	@for i in $(TOP_DIR)/library/*.tcl $(TOP_DIR)/library/tclIndex \
		$(UNIX_DIR)/tkAppInit.c; \
	    do \
	    $(INSTALL_DATA) $$i "$(SCRIPT_INSTALL_DIR)"; \
	    done;
	@echo "Installing Ttk library files to $(SCRIPT_INSTALL_DIR)/ttk/";
	@for i in $(TOP_DIR)/library/ttk/*.tcl; \
	    do \
	    if [ -f $$i ] ; then \
		$(INSTALL_DATA) $$i "$(SCRIPT_INSTALL_DIR)/ttk"; \
	    fi; \
	    done;
	@echo "Installing library image files to $(SCRIPT_INSTALL_DIR)/images/";
	@for i in $(TOP_DIR)/library/images/*; \
	    do \
	    if [ -f $$i ] ; then \
		$(INSTALL_DATA) $$i "$(SCRIPT_INSTALL_DIR)/images"; \
	    fi; \
	    done;
	@echo "Installing message catalog files to $(SCRIPT_INSTALL_DIR)/msgs/";
	@for i in $(TOP_DIR)/library/msgs/*.msg; \
	    do \
	    if [ -f $$i ] ; then \
		$(INSTALL_DATA) $$i "$(SCRIPT_INSTALL_DIR)/msgs"; \
	    fi; \
	    done;

install-demos:
	@for i in "$(DEMO_INSTALL_DIR)" "$(DEMO_INSTALL_DIR)/images" ; \
	    do \
	    if [ ! -d "$$i" ] ; then \
		echo "Making directory $$i"; \
		$(INSTALL_DATA_DIR) "$$i"; \
		else true; \
		fi; \
	    done;
	@echo "Installing demo files to $(DEMO_INSTALL_DIR)/";
	@for i in $(TOP_DIR)/library/demos/*; \
	    do \
	    if [ -f $$i ] ; then \
		sed -e '3 s|exec wish|exec wish$(VERSION)|' \
			$$i > "$(DEMO_INSTALL_DIR)"/`basename $$i`; \
	    fi; \
	    done;
	@for i in $(DEMOPROGS); \
	    do \
	    if test $$i = "square"; then \
	    rm -f  "$(DEMO_INSTALL_DIR)/$$i"; \
	    else \
	    chmod 755 "$(DEMO_INSTALL_DIR)/$$i"; \
	    fi; \
	    done;
	@echo "Installing demo image files to $(DEMO_INSTALL_DIR)/images/";
	@for i in $(TOP_DIR)/library/demos/images/*; \
	    do \
	    if [ -f $$i ] ; then \
		$(INSTALL_DATA) $$i "$(DEMO_INSTALL_DIR)/images"; \
		fi; \
	    done;

install-doc:
	@for i in "$(MAN_INSTALL_DIR)" "$(MAN1_INSTALL_DIR)" "$(MAN3_INSTALL_DIR)" "$(MANN_INSTALL_DIR)" ; \
	    do \
	    if [ ! -d "$$i" ] ; then \
		echo "Making directory $$i"; \
		$(INSTALL_DATA_DIR) "$$i"; \
		else true; \
		fi; \
	    done;
	@echo "Installing and cross-linking top-level (.1) docs to $(MAN1_INSTALL_DIR)/";
	@for i in $(TOP_DIR)/doc/*.1; do \
	    $(SHELL) $(UNIX_DIR)/installManPage $(MAN_FLAGS) $$i "$(MAN1_INSTALL_DIR)"; \
	done
	@echo "Installing and cross-linking C API (.3) docs to $(MAN3_INSTALL_DIR)/";
	@for i in $(TOP_DIR)/doc/*.3; do \
	    $(SHELL) $(UNIX_DIR)/installManPage $(MAN_FLAGS) $$i "$(MAN3_INSTALL_DIR)"; \
	done
	@echo "Installing and cross-linking command (.n) docs to $(MANN_INSTALL_DIR)/";
	@for i in $(TOP_DIR)/doc/*.n; do \
	    $(SHELL) $(UNIX_DIR)/installManPage $(MAN_FLAGS) $$i "$(MANN_INSTALL_DIR)"; \
	done

install-headers:
	@if test "$(@TK_WINDOWINGSYSTEM@_XLIB_HDRS)" != ""; then \
	    XLIB_INCLUDE_INSTALL_DIR="$(INCLUDE_INSTALL_DIR)"/X11; fi; \
	for i in "$(INCLUDE_INSTALL_DIR)" "$${XLIB_INCLUDE_INSTALL_DIR}"; \
	    do \
	    if [ -n "$$i" -a ! -d "$$i" ] ; then \
		echo "Making directory $$i"; \
		$(INSTALL_DATA_DIR) "$$i"; \
		else true; \
		fi; \
	    done;
	@echo "Installing header files to $(INCLUDE_INSTALL_DIR)/";
	@for i in $(PUBLIC_HDRS); \
	    do \
	    $(INSTALL_DATA) $$i "$(INCLUDE_INSTALL_DIR)"; \
	    done;
	@list='$(@TK_WINDOWINGSYSTEM@_XLIB_HDRS)'; for i in $$list ; \
	    do \
	    $(INSTALL_DATA) $$i "$(INCLUDE_INSTALL_DIR)/X11"; \
	    done;

# Optional target to install private headers
install-private-headers:
	@for i in "$(PRIVATE_INCLUDE_INSTALL_DIR)"; \
	    do \
	    if [ ! -d "$$i" ] ; then \
		echo "Making directory $$i"; \
		$(INSTALL_DATA_DIR) "$$i"; \
		else true; \
		fi; \
	    done;
	@echo "Installing private header files to $(PRIVATE_INCLUDE_INSTALL_DIR)/";
	@for i in $(PRIVATE_HDRS); \
	    do \
	    $(INSTALL_DATA) $$i "$(PRIVATE_INCLUDE_INSTALL_DIR)"; \
	    done;
	@if test -f tkConfig.h; then\
	    $(INSTALL_DATA) tkConfig.h "$(PRIVATE_INCLUDE_INSTALL_DIR)"; \
	    fi;

Makefile: $(UNIX_DIR)/Makefile.in
	$(SHELL) config.status
#tkConfig.h: $(UNIX_DIR)/tkConfig.h.in
#	$(SHELL) config.status

clean:
	rm -f *.a *.o libtk* core errs *~ \#* TAGS *.E a.out \
		errors ${WISH_EXE} $(TKTEST_EXE) lib.exp Tk *.rsrc

distclean: clean
	rm -rf Makefile config.status config.cache config.log tkConfig.sh \
		tkConfig.h *.plist Tk.framework tk.pc

depend:
	makedepend -- $(DEPEND_SWITCHES) -- $(SRCS)

# Test binaries.  The rule for tkTestInit.o is complicated because
# it is is compiled from tkAppInit.c.  Can't use the "-o" option
# because this doesn't work on some strange compilers (e.g. UnixWare).
# To enable concurrent parallel make of wish and tktest, this target has to
# depend on wish, this ensures that linking of wish with tkTestInit.o does not
# execute concurrently with the renaming and recompiling of that same object
# file in the target below.

tkTestInit.o: $(UNIX_DIR)/tkAppInit.c ${WISH_EXE}
	@if test -f tkAppInit.o ; then \
	    rm -f tkAppInit.sav; \
	    mv tkAppInit.o tkAppInit.sav; \
	fi;
	$(CC) -c $(APP_CC_SWITCHES) -DTK_TEST $(UNIX_DIR)/tkAppInit.c
	rm -f tkTestInit.o
	mv tkAppInit.o tkTestInit.o
	@if test -f tkAppInit.sav ; then \
	    mv tkAppInit.sav tkAppInit.o; \
	fi;

tkAppInit.o: $(UNIX_DIR)/tkAppInit.c
	$(CC) -c $(APP_CC_SWITCHES) $(UNIX_DIR)/tkAppInit.c

tk3d.o: $(GENERIC_DIR)/tk3d.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tk3d.c

tkArgv.o: $(GENERIC_DIR)/tkArgv.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkArgv.c

tkAtom.o: $(GENERIC_DIR)/tkAtom.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkAtom.c

tkBind.o: $(GENERIC_DIR)/tkBind.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkBind.c

tkBitmap.o: $(GENERIC_DIR)/tkBitmap.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkBitmap.c

tkBusy.o: $(GENERIC_DIR)/tkBusy.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkBusy.c

tkClipboard.o: $(GENERIC_DIR)/tkClipboard.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkClipboard.c

tkCmds.o: $(GENERIC_DIR)/tkCmds.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkCmds.c

tkColor.o: $(GENERIC_DIR)/tkColor.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkColor.c

tkConfig.o: $(GENERIC_DIR)/tkConfig.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkConfig.c

tkConsole.o: $(GENERIC_DIR)/tkConsole.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkConsole.c

tkCursor.o: $(GENERIC_DIR)/tkCursor.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkCursor.c

tkError.o: $(GENERIC_DIR)/tkError.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkError.c

tkEvent.o: $(GENERIC_DIR)/tkEvent.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkEvent.c

tkFocus.o: $(GENERIC_DIR)/tkFocus.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkFocus.c

tkFont.o: $(GENERIC_DIR)/tkFont.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkFont.c

tkGet.o: $(GENERIC_DIR)/tkGet.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkGet.c

tkGC.o: $(GENERIC_DIR)/tkGC.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkGC.c

tkGeometry.o: $(GENERIC_DIR)/tkGeometry.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkGeometry.c

tkGrab.o: $(GENERIC_DIR)/tkGrab.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkGrab.c

tkGrid.o: $(GENERIC_DIR)/tkGrid.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkGrid.c

tkMain.o: $(GENERIC_DIR)/tkMain.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkMain.c

tkObj.o: $(GENERIC_DIR)/tkObj.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkObj.c

tkOldConfig.o: $(GENERIC_DIR)/tkOldConfig.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkOldConfig.c

tkOption.o: $(GENERIC_DIR)/tkOption.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkOption.c

tkPack.o: $(GENERIC_DIR)/tkPack.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkPack.c

tkPlace.o: $(GENERIC_DIR)/tkPlace.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkPlace.c

tkSelect.o: $(GENERIC_DIR)/tkSelect.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkSelect.c

tkStyle.o: $(GENERIC_DIR)/tkStyle.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkStyle.c

tkUtil.o: $(GENERIC_DIR)/tkUtil.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkUtil.c

tkVisual.o: $(GENERIC_DIR)/tkVisual.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkVisual.c

tkWindow.o: $(GENERIC_DIR)/tkWindow.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkWindow.c

tkButton.o: $(GENERIC_DIR)/tkButton.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkButton.c

tkEntry.o: $(GENERIC_DIR)/tkEntry.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkEntry.c

tkFrame.o: $(GENERIC_DIR)/tkFrame.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkFrame.c

tkListbox.o: $(GENERIC_DIR)/tkListbox.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkListbox.c

tkMenu.o: $(GENERIC_DIR)/tkMenu.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkMenu.c

tkMenubutton.o: $(GENERIC_DIR)/tkMenubutton.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkMenubutton.c

tkMenuDraw.o: $(GENERIC_DIR)/tkMenuDraw.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkMenuDraw.c

tkMessage.o: $(GENERIC_DIR)/tkMessage.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkMessage.c

tkPanedWindow.o: $(GENERIC_DIR)/tkPanedWindow.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkPanedWindow.c

tkScale.o: $(GENERIC_DIR)/tkScale.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkScale.c

tkScrollbar.o: $(GENERIC_DIR)/tkScrollbar.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkScrollbar.c

tkSquare.o: $(GENERIC_DIR)/tkSquare.c
	$(CC) -c $(APP_CC_SWITCHES) $(GENERIC_DIR)/tkSquare.c

tkCanvas.o: $(GENERIC_DIR)/tkCanvas.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkCanvas.c

tkCanvArc.o: $(GENERIC_DIR)/tkCanvArc.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkCanvArc.c

tkCanvBmap.o: $(GENERIC_DIR)/tkCanvBmap.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkCanvBmap.c

tkCanvImg.o: $(GENERIC_DIR)/tkCanvImg.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkCanvImg.c

tkCanvLine.o: $(GENERIC_DIR)/tkCanvLine.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkCanvLine.c

tkCanvPoly.o: $(GENERIC_DIR)/tkCanvPoly.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkCanvPoly.c

tkCanvPs.o: $(GENERIC_DIR)/tkCanvPs.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkCanvPs.c

tkCanvText.o: $(GENERIC_DIR)/tkCanvText.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkCanvText.c

tkCanvUtil.o: $(GENERIC_DIR)/tkCanvUtil.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkCanvUtil.c

tkCanvWind.o: $(GENERIC_DIR)/tkCanvWind.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkCanvWind.c

tkRectOval.o: $(GENERIC_DIR)/tkRectOval.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkRectOval.c

tkTrig.o: $(GENERIC_DIR)/tkTrig.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkTrig.c

tkImage.o: $(GENERIC_DIR)/tkImage.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkImage.c

tkImgBmap.o: $(GENERIC_DIR)/tkImgBmap.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkImgBmap.c

tkImgGIF.o: $(GENERIC_DIR)/tkImgGIF.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkImgGIF.c

tkImgPNG.o: $(GENERIC_DIR)/tkImgPNG.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkImgPNG.c

tkImgPPM.o: $(GENERIC_DIR)/tkImgPPM.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkImgPPM.c

tkImgPhoto.o: $(GENERIC_DIR)/tkImgPhoto.c $(GENERIC_DIR)/tkImgPhoto.h
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkImgPhoto.c

tkImgPhInstance.o: $(GENERIC_DIR)/tkImgPhInstance.c $(GENERIC_DIR)/tkImgPhoto.h
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkImgPhInstance.c

tkOldTest.o: $(GENERIC_DIR)/tkOldTest.c
	$(CC) -c $(APP_CC_SWITCHES) $(GENERIC_DIR)/tkOldTest.c

tkTest.o: $(GENERIC_DIR)/tkTest.c
	$(CC) -c $(APP_CC_SWITCHES) $(GENERIC_DIR)/tkTest.c

tkText.o: $(GENERIC_DIR)/tkText.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkText.c

tkTextBTree.o: $(GENERIC_DIR)/tkTextBTree.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkTextBTree.c

tkTextDisp.o: $(GENERIC_DIR)/tkTextDisp.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkTextDisp.c

tkTextImage.o: $(GENERIC_DIR)/tkTextImage.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkTextImage.c

tkTextIndex.o: $(GENERIC_DIR)/tkTextIndex.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkTextIndex.c

tkTextMark.o: $(GENERIC_DIR)/tkTextMark.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkTextMark.c

tkTextTag.o: $(GENERIC_DIR)/tkTextTag.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkTextTag.c

tkTextWind.o: $(GENERIC_DIR)/tkTextWind.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkTextWind.c

tkStubInit.o: $(GENERIC_DIR)/tkStubInit.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkStubInit.c

# Stub library binaries, these must be compiled for use in a shared library
# even though they will be placed in a static archive

tkStubLib.o: $(GENERIC_DIR)/tkStubLib.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkStubLib.c

tkUndo.o: $(GENERIC_DIR)/tkUndo.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkUndo.c

tkUnix.o: $(UNIX_DIR)/tkUnix.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnix.c

tkUnix3d.o: $(UNIX_DIR)/tkUnix3d.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnix3d.c

tkUnixButton.o: $(UNIX_DIR)/tkUnixButton.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixButton.c

tkUnixColor.o: $(UNIX_DIR)/tkUnixColor.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixColor.c

tkUnixConfig.o: $(UNIX_DIR)/tkUnixConfig.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixConfig.c

tkUnixCursor.o: $(UNIX_DIR)/tkUnixCursor.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixCursor.c

tkUnixDraw.o: $(UNIX_DIR)/tkUnixDraw.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixDraw.c

tkUnixEmbed.o: $(UNIX_DIR)/tkUnixEmbed.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixEmbed.c

tkUnixEvent.o: $(UNIX_DIR)/tkUnixEvent.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixEvent.c

tkUnixFocus.o: $(UNIX_DIR)/tkUnixFocus.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixFocus.c

tkUnixFont.o: $(UNIX_DIR)/tkUnixFont.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixFont.c

# NB: tkUnixRFont.o uses nondefault CFLAGS
tkUnixRFont.o: $(UNIX_DIR)/tkUnixRFont.c
	$(CC) -c $(CC_SWITCHES) $(XFT_CFLAGS) $(UNIX_DIR)/tkUnixRFont.c

tkUnixInit.o: $(UNIX_DIR)/tkUnixInit.c tkConfig.sh
	$(CC) -c $(CC_SWITCHES) -DTK_LIBRARY=\"${TK_LIBRARY}\" \
	    $(UNIX_DIR)/tkUnixInit.c

tkUnixKey.o: $(UNIX_DIR)/tkUnixKey.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixKey.c

tkUnixMenu.o: $(UNIX_DIR)/tkUnixMenu.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixMenu.c

tkUnixMenubu.o: $(UNIX_DIR)/tkUnixMenubu.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixMenubu.c

tkUnixScale.o: $(UNIX_DIR)/tkUnixScale.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixScale.c

tkUnixScrlbr.o: $(UNIX_DIR)/tkUnixScrlbr.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixScrlbr.c

tkUnixSelect.o: $(UNIX_DIR)/tkUnixSelect.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixSelect.c

tkUnixSend.o: $(UNIX_DIR)/tkUnixSend.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixSend.c

tkUnixWm.o: $(UNIX_DIR)/tkUnixWm.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixWm.c

tkUnixXId.o: $(UNIX_DIR)/tkUnixXId.c
	$(CC) -c $(CC_SWITCHES) $(UNIX_DIR)/tkUnixXId.c

tkMacOSXBitmap.o: $(MAC_OSX_DIR)/tkMacOSXBitmap.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXBitmap.c

tkMacOSXButton.o: $(MAC_OSX_DIR)/tkMacOSXButton.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXButton.c

tkMacOSXClipboard.o: $(MAC_OSX_DIR)/tkMacOSXClipboard.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXClipboard.c

tkMacOSXColor.o: $(MAC_OSX_DIR)/tkMacOSXColor.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXColor.c

tkMacOSXConfig.o: $(MAC_OSX_DIR)/tkMacOSXConfig.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXConfig.c

tkMacOSXCursor.o: $(MAC_OSX_DIR)/tkMacOSXCursor.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXCursor.c

tkMacOSXDebug.o: $(MAC_OSX_DIR)/tkMacOSXDebug.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXDebug.c

tkMacOSXDialog.o: $(MAC_OSX_DIR)/tkMacOSXDialog.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXDialog.c

tkMacOSXDraw.o: $(MAC_OSX_DIR)/tkMacOSXDraw.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXDraw.c

tkMacOSXEmbed.o: $(MAC_OSX_DIR)/tkMacOSXEmbed.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXEmbed.c

tkMacOSXEntry.o: $(MAC_OSX_DIR)/tkMacOSXEntry.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXEntry.c

tkMacOSXEvent.o: $(MAC_OSX_DIR)/tkMacOSXEvent.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXEvent.c

tkMacOSXFont.o: $(MAC_OSX_DIR)/tkMacOSXFont.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXFont.c

tkMacOSXHLEvents.o: $(MAC_OSX_DIR)/tkMacOSXHLEvents.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXHLEvents.c

tkMacOSXImage.o: $(MAC_OSX_DIR)/tkMacOSXImage.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXImage.c

tkMacOSXInit.o: $(MAC_OSX_DIR)/tkMacOSXInit.c tkConfig.sh
	$(CC) -c $(CC_SWITCHES) -DTK_LIBRARY=\"${TK_LIBRARY}\" \
	    $(MAC_OSX_DIR)/tkMacOSXInit.c

tkMacOSXKeyboard.o: $(MAC_OSX_DIR)/tkMacOSXKeyboard.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXKeyboard.c

tkMacOSXKeyEvent.o: $(MAC_OSX_DIR)/tkMacOSXKeyEvent.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXKeyEvent.c

tkMacOSXMenu.o: $(MAC_OSX_DIR)/tkMacOSXMenu.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXMenu.c

tkMacOSXMenubutton.o: $(MAC_OSX_DIR)/tkMacOSXMenubutton.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXMenubutton.c

tkMacOSXMenus.o: $(MAC_OSX_DIR)/tkMacOSXMenus.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXMenus.c

tkMacOSXMouseEvent.o: $(MAC_OSX_DIR)/tkMacOSXMouseEvent.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXMouseEvent.c

tkMacOSXNotify.o: $(MAC_OSX_DIR)/tkMacOSXNotify.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXNotify.c

tkMacOSXRegion.o: $(MAC_OSX_DIR)/tkMacOSXRegion.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXRegion.c

tkMacOSXScale.o: $(MAC_OSX_DIR)/tkMacOSXScale.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXScale.c

tkMacOSXScrlbr.o: $(MAC_OSX_DIR)/tkMacOSXScrlbr.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXScrlbr.c

tkMacOSXSend.o: $(MAC_OSX_DIR)/tkMacOSXSend.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXSend.c

tkMacOSXSubwindows.o: $(MAC_OSX_DIR)/tkMacOSXSubwindows.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXSubwindows.c

tkMacOSXTest.o: $(MAC_OSX_DIR)/tkMacOSXTest.c
	$(CC) -c $(APP_CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXTest.c

tkMacOSXWindowEvent.o: $(MAC_OSX_DIR)/tkMacOSXWindowEvent.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXWindowEvent.c

tkMacOSXWm.o: $(MAC_OSX_DIR)/tkMacOSXWm.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXWm.c

tkMacOSXXStubs.o: $(MAC_OSX_DIR)/tkMacOSXXStubs.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/tkMacOSXXStubs.c

tkFileFilter.o: $(GENERIC_DIR)/tkFileFilter.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkFileFilter.c

tkMacWinMenu.o: $(GENERIC_DIR)/tkMacWinMenu.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkMacWinMenu.c

tkPointer.o: $(GENERIC_DIR)/tkPointer.c
	$(CC) -c $(CC_SWITCHES) $(GENERIC_DIR)/tkPointer.c

xcolors.o: $(XLIB_DIR)/xcolors.c
	$(CC) -c $(CC_SWITCHES) $(XLIB_DIR)/xcolors.c

xdraw.o: $(XLIB_DIR)/xdraw.c
	$(CC) -c $(CC_SWITCHES) $(XLIB_DIR)/xdraw.c

xgc.o: $(XLIB_DIR)/xgc.c
	$(CC) -c $(CC_SWITCHES) $(XLIB_DIR)/xgc.c

ximage.o: $(XLIB_DIR)/ximage.c
	$(CC) -c $(CC_SWITCHES) $(XLIB_DIR)/ximage.c

xutil.o: $(XLIB_DIR)/xutil.c
	$(CC) -c $(CC_SWITCHES) $(XLIB_DIR)/xutil.c

ttkBlink.o: $(TTK_DIR)/ttkBlink.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkBlink.c

ttkButton.o: $(TTK_DIR)/ttkButton.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkButton.c

ttkCache.o: $(TTK_DIR)/ttkCache.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkCache.c

ttkClamTheme.o: $(TTK_DIR)/ttkClamTheme.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkClamTheme.c

ttkClassicTheme.o: $(TTK_DIR)/ttkClassicTheme.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkClassicTheme.c

ttkDefaultTheme.o: $(TTK_DIR)/ttkDefaultTheme.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkDefaultTheme.c

ttkElements.o: $(TTK_DIR)/ttkElements.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkElements.c

ttkEntry.o: $(TTK_DIR)/ttkEntry.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkEntry.c

ttkFrame.o: $(TTK_DIR)/ttkFrame.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkFrame.c

ttkImage.o: $(TTK_DIR)/ttkImage.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkImage.c

ttkInit.o: $(TTK_DIR)/ttkInit.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkInit.c

ttkLabel.o: $(TTK_DIR)/ttkLabel.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkLabel.c

ttkLayout.o: $(TTK_DIR)/ttkLayout.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkLayout.c

ttkManager.o: $(TTK_DIR)/ttkManager.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkManager.c

ttkNotebook.o: $(TTK_DIR)/ttkNotebook.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkNotebook.c

ttkPanedwindow.o: $(TTK_DIR)/ttkPanedwindow.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkPanedwindow.c

ttkProgress.o: $(TTK_DIR)/ttkProgress.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkProgress.c

ttkScale.o: $(TTK_DIR)/ttkScale.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkScale.c

ttkScroll.o: $(TTK_DIR)/ttkScroll.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkScroll.c

ttkScrollbar.o: $(TTK_DIR)/ttkScrollbar.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkScrollbar.c

ttkSeparator.o: $(TTK_DIR)/ttkSeparator.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkSeparator.c

ttkSquare.o: $(TTK_DIR)/ttkSquare.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkSquare.c

ttkState.o: $(TTK_DIR)/ttkState.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkState.c

ttkStubInit.o: $(TTK_DIR)/ttkStubInit.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkStubInit.c

ttkStubLib.o: $(TTK_DIR)/ttkStubLib.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkStubLib.c

ttkTagSet.o: $(TTK_DIR)/ttkTagSet.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkTagSet.c

ttkTheme.o: $(TTK_DIR)/ttkTheme.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkTheme.c

ttkTrace.o: $(TTK_DIR)/ttkTrace.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkTrace.c

ttkTrack.o: $(TTK_DIR)/ttkTrack.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkTrack.c

ttkTreeview.o: $(TTK_DIR)/ttkTreeview.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkTreeview.c

ttkWidget.o: $(TTK_DIR)/ttkWidget.c
	$(CC) -c $(CC_SWITCHES) $(TTK_DIR)/ttkWidget.c

ttkMacOSXTheme.o: $(MAC_OSX_DIR)/ttkMacOSXTheme.c
	$(CC) -c $(CC_SWITCHES) $(MAC_OSX_DIR)/ttkMacOSXTheme.c

.c.o:
	$(CC) -c $(CC_SWITCHES) $<

#
# Target to regenerate header files and stub files from the *.decls tables.
#

$(GENERIC_DIR)/tkStubInit.c: $(GENERIC_DIR)/tk.decls \
		$(GENERIC_DIR)/tkInt.decls
	@echo "Warning: tkStubInit.c may be out of date."
	@echo "Developers may want to run \"make genstubs\" to regenerate."
	@echo "This warning can be safely ignored, do not report as a bug!"

$(TTK_DIR)/ttkStubInit.c: $(TTK_DIR)/ttk.decls
	@echo "Warning: ttkStubInit.c may be out of date."
	@echo "Developers may want to run \"make genstubs\" to regenerate."
	@echo "This warning can be safely ignored, do not report as a bug!"

genstubs:
	$(TCL_EXE) $(TOOL_DIR)/genStubs.tcl $(GENERIC_DIR) \
		$(GENERIC_DIR)/tk.decls $(GENERIC_DIR)/tkInt.decls
	$(TCL_EXE) $(TTK_DIR)/ttkGenStubs.tcl $(TTK_DIR) $(TTK_DIR)/ttk.decls

#
# Target to check that all exported functions have an entry in the stubs
# tables.
#

checkstubs: $(TK_LIB_FILE)
	-@for i in `nm -p $(TK_LIB_FILE) \
		| awk '$$2 ~ /^[TDBCS]$$/ { sub("^_", "", $$3); print $$3 }' \
		| sort -n`; do \
		match=0; \
		for j in $(TK_DECLS) $(TTK_DECLS); do \
		    if [ `grep -c "$$i *(" $$j` -gt 0 ]; then \
			match=1; \
		    fi; \
		done; \
		if [ $$match -eq 0 ]; then echo $$i; fi \
	done

#
# Target to check for proper usage of UCHAR macro.
#

checkuchar:
	-egrep isalnum\|isalpha\|iscntrl\|isdigit\|islower\|isprint\|ispunct\|isspace\|isupper\|isxdigit\|toupper\|tolower $(SRCS) | grep -v UCHAR

#
# Target to make sure that only symbols with "Tk", "tk", "Ttk", "ttk" or "X"
# prefixes are exported.
#

checkexports: $(TK_LIB_FILE)
	-@nm -p $(TK_LIB_FILE) \
	| awk '$$2 ~ /^[TDBCS]$$/ { sub("^_", "", $$3); print $$3 }' \
	| sort -n | grep -E -v '^([Tt]t?k|_?X)' || true

#
# Target to create a Tk RPM for Linux.  Requires that you be on a Linux
# system.
#

rpm: all
	rm -f THIS.TCL.SPEC
	echo "%define _builddir `pwd`" > THIS.TK.SPEC
	echo "%define _rpmdir `pwd`/RPMS" >> THIS.TK.SPEC
	cat tk.spec >> THIS.TK.SPEC
	mkdir -p RPMS/i386
	rpmbuild -bb THIS.TK.SPEC
	mv RPMS/i386/*.rpm .
	rm -rf RPMS THIS.TK.SPEC

#
# Target to create a proper Tk distribution from information in the
# master source directory.  DISTDIR must be defined to indicate where
# to put the distribution.  DISTDIR must be an absolute path name.
#

DISTROOT = /tmp/dist
DISTNAME = tk${VERSION}${PATCH_LEVEL}
ZIPNAME	 = tk${MAJOR_VERSION}${MINOR_VERSION}${PATCH_LEVEL}-src.zip
DISTDIR	 = $(DISTROOT)/$(DISTNAME)
TCLDIR   = @TCL_SRC_DIR@
$(UNIX_DIR)/configure: $(UNIX_DIR)/configure.in $(UNIX_DIR)/tcl.m4 \
		$(UNIX_DIR)/aclocal.m4
	cd $(UNIX_DIR); autoconf
$(MAC_OSX_DIR)/configure: $(MAC_OSX_DIR)/configure.ac $(UNIX_DIR)/configure
	cd $(MAC_OSX_DIR); autoconf
$(UNIX_DIR)/tkConfig.h.in: $(MAC_OSX_DIR)/configure
	cd $(MAC_OSX_DIR); autoheader; touch $@

dist:   $(UNIX_DIR)/configure $(UNIX_DIR)/tkConfig.h.in $(UNIX_DIR)/tk.pc.in $(MAC_OSX_DIR)/configure genstubs
	rm -rf $(DISTDIR)
	mkdir -p $(DISTDIR)/unix
	cp -p $(UNIX_DIR)/*.c $(UNIX_DIR)/*.h $(DISTDIR)/unix
	cp $(TOP_DIR)/license.terms $(UNIX_DIR)/Makefile.in $(DISTDIR)/unix
	chmod 664 $(DISTDIR)/unix/Makefile.in
	cp $(UNIX_DIR)/configure $(UNIX_DIR)/configure.in $(UNIX_DIR)/tk.spec \
		$(UNIX_DIR)/aclocal.m4 $(UNIX_DIR)/tcl.m4 \
		$(UNIX_DIR)/tkConfig.sh.in $(TCLDIR)/unix/install-sh \
		$(UNIX_DIR)/README $(UNIX_DIR)/installManPage \
		$(UNIX_DIR)/tkConfig.h.in $(UNIX_DIR)/tk.pc.in $(DISTDIR)/unix
	chmod 775 $(DISTDIR)/unix/configure $(DISTDIR)/unix/configure.in
	mkdir $(DISTDIR)/bitmaps
	@(cd $(TOP_DIR); for i in bitmaps/* ; do \
	    if [ -f $$i ] ; then \
		sed -e 's/static char/static unsigned char/' \
		       $$i > $(DISTDIR)/$$i; \
	    fi; \
	done;)
	mkdir $(DISTDIR)/generic
	cp -p $(GENERIC_DIR)/*.[ch] $(DISTDIR)/generic
	cp -p $(GENERIC_DIR)/*.decls $(DISTDIR)/generic
	cp -p $(GENERIC_DIR)/README $(DISTDIR)/generic
	cp -p $(TOP_DIR)/changes $(TOP_DIR)/ChangeLog \
		$(TOP_DIR)/ChangeLog.2??? $(TOP_DIR)/README \
		$(TOP_DIR)/license.terms $(DISTDIR)
	rm -f $(DISTDIR)/generic/blt*.[ch]
	mkdir $(DISTDIR)/generic/ttk
	cp -p $(TTK_DIR)/*.[ch] $(TTK_DIR)/ttk.decls \
		$(TTK_DIR)/ttkGenStubs.tcl $(DISTDIR)/generic/ttk
	mkdir $(DISTDIR)/win
	cp $(TOP_DIR)/win/Makefile.in $(DISTDIR)/win
	cp $(TOP_DIR)/win/configure.in \
		$(TOP_DIR)/win/configure \
		$(TOP_DIR)/win/tkConfig.sh.in \
		$(TOP_DIR)/win/aclocal.m4 $(TOP_DIR)/win/tcl.m4 \
		$(DISTDIR)/win
	cp -p $(TOP_DIR)/win/*.[ch] $(TOP_DIR)/win/*.bat $(DISTDIR)/win
	cp -p $(TOP_DIR)/win/*.vc $(DISTDIR)/win
	cp -p $(TOP_DIR)/win/README $(DISTDIR)/win
	cp -p $(TOP_DIR)/license.terms $(DISTDIR)/win
	mkdir $(DISTDIR)/win/rc
	cp -p $(TOP_DIR)/win/wish.exe.manifest.in $(DISTDIR)/win/
	cp -p $(TOP_DIR)/win/rc/*.{rc,cur,ico,bmp} $(DISTDIR)/win/rc
	mkdir $(DISTDIR)/macosx
	cp -p $(MAC_OSX_DIR)/GNUmakefile $(MAC_OSX_DIR)/README \
		$(MAC_OSX_DIR)/*.icns $(MAC_OSX_DIR)/*.tiff \
		$(MAC_OSX_DIR)/*.[ch] $(MAC_OSX_DIR)/*.in \
		$(MAC_OSX_DIR)/*.ac $(MAC_OSX_DIR)/*.xcconfig \
		$(MAC_OSX_DIR)/*.sdef $(MAC_OSX_DIR)/configure \
		$(DISTDIR)/macosx
	cp -p $(TOP_DIR)/license.terms $(DISTDIR)/macosx
	mkdir $(DISTDIR)/macosx/Tk.xcode
	cp -p $(MAC_OSX_DIR)/Tk.xcode/project.pbxproj \
		$(MAC_OSX_DIR)/Tk.xcode/default.pbxuser \
		$(DISTDIR)/macosx/Tk.xcode
	mkdir $(DISTDIR)/macosx/Tk.xcodeproj
	cp -p $(MAC_OSX_DIR)/Tk.xcodeproj/project.pbxproj \
		$(MAC_OSX_DIR)/Tk.xcodeproj/default.pbxuser \
		$(DISTDIR)/macosx/Tk.xcodeproj
	mkdir $(DISTDIR)/compat
	cp -p $(TOP_DIR)/license.terms $(TCLDIR)/compat/unistd.h \
		$(TCLDIR)/compat/stdlib.h \
		$(DISTDIR)/compat
	mkdir $(DISTDIR)/xlib
	cp -p $(XLIB_DIR)/*.[ch] $(DISTDIR)/xlib
	cp -p $(TOP_DIR)/license.terms $(DISTDIR)/xlib
	mkdir $(DISTDIR)/xlib/X11
	cp -p $(XLIB_DIR)/X11/*.h $(DISTDIR)/xlib/X11
	cp -p $(TOP_DIR)/license.terms $(DISTDIR)/xlib/X11
	mkdir $(DISTDIR)/library
	cp -p $(TOP_DIR)/license.terms $(TOP_DIR)/library/*.tcl \
		$(TOP_DIR)/library/tclIndex \
		$(DISTDIR)/library
	mkdir $(DISTDIR)/library/ttk
	cp -p $(TOP_DIR)/library/ttk/*.tcl $(DISTDIR)/library/ttk
	mkdir $(DISTDIR)/library/images
	@(cd $(TOP_DIR); for i in library/images/* ; do \
	    if [ -f $$i ] ; then \
		cp $$i $(DISTDIR)/$$i; \
	    fi; \
	done;)
	mkdir $(DISTDIR)/library/msgs
	@(cd $(TOP_DIR); for i in library/msgs/*.msg ; do \
	    if [ -f $$i ] ; then \
		cp $$i $(DISTDIR)/$$i; \
	    fi; \
	done;)
	mkdir $(DISTDIR)/library/demos
	cp -pr $(TOP_DIR)/library/demos/*.tcl \
		$(TOP_DIR)/library/demos/*.msg \
		$(TOP_DIR)/library/demos/tclIndex \
		$(TOP_DIR)/library/demos/browse \
		$(TOP_DIR)/library/demos/hello $(TOP_DIR)/library/demos/ixset \
		$(TOP_DIR)/library/demos/rmt $(TOP_DIR)/library/demos/rolodex \
		$(TOP_DIR)/library/demos/square \
		$(TOP_DIR)/library/demos/tcolor \
		$(TOP_DIR)/library/demos/timer \
		$(TOP_DIR)/library/demos/widget \
		$(TOP_DIR)/library/demos/README \
		$(TOP_DIR)/license.terms $(DISTDIR)/library/demos
	mkdir $(DISTDIR)/library/demos/images
	@(cd $(TOP_DIR); for i in library/demos/images/* ; do \
	    if [ -f $$i ] ; then \
		cp $$i $(DISTDIR)/$$i; \
	    fi; \
	done;)
	mkdir $(DISTDIR)/doc
	cp -p $(TOP_DIR)/license.terms $(TOP_DIR)/doc/*.[13n] \
		$(TCLDIR)/doc/man.macros $(DISTDIR)/doc
	mkdir $(DISTDIR)/tests
	cp -p $(TOP_DIR)/license.terms $(TEST_DIR)/*.{test,tcl} \
		$(TEST_DIR)/README $(TEST_DIR)/*.{gif,png,ppm,xbm} \
		$(TEST_DIR)/option.file* $(DISTDIR)/tests
	mkdir $(DISTDIR)/tests/ttk
	cp -p $(TEST_DIR)/ttk/*.{test,tcl} $(DISTDIR)/tests/ttk

alldist: dist
	rm -f $(DISTROOT)/$(DISTNAME)-src.tar.gz $(DISTROOT)/$(ZIPNAME)
	cd $(DISTROOT); tar cf $(DISTNAME)-src.tar $(DISTNAME); \
		gzip -9 $(DISTNAME)-src.tar; zip -qr8 $(ZIPNAME) $(DISTNAME)

#
# This target creates the HTML folder for Tcl & Tk and places it
# in DISTDIR/html.  It uses the tcltk-man2html.tcl tool from
# the Tcl group's tool workspace.  It depends on the Tcl & Tk being
# in directories called tcl8.3 & tk8.3 up two directories from the
# TOOL_DIR.
#

html:
	$(BUILD_HTML)
	@EXTRA_BUILD_HTML@
html-tcl:
	$(BUILD_HTML) --tcl
	@EXTRA_BUILD_HTML@
html-tk:
	$(BUILD_HTML) --tk
	@EXTRA_BUILD_HTML@

BUILD_HTML = \
	@if test -f "$(BUILD_TCLSH)"; then \
	$(SHELL_ENV) TCLSH="$(BUILD_TCLSH)"; else \
	TCLSH="$(TCL_EXE)"; fi ;\
	"$${TCLSH}" $(TOOL_DIR)/tcltk-man2html.tcl --htmldir="$(HTML_INSTALL_DIR)" \
		--srcdir=$(TOP_DIR)/.. $(BUILD_HTML_FLAGS)

#
# The list of all the targets that do not correspond to real files. This stops
# 'make' from getting confused when someone makes an error in a rule.
#

.PHONY: all binaries libraries objs doc html html-tcl html-tk test runtest
.PHONY: install install-strip install-binaries install-libraries
.PHONY: install-headers install-private-headers install-doc
.PHONY: clean distclean depend genstubs checkstubs checkexports checkuchar
.PHONY: shell gdb valgrind valgrindshell dist alldist rpm
.PHONY: tkLibObjs tktest-real test-classic test-ttk testlang
.PHONY: demo install-demos

# DO NOT DELETE THIS LINE -- make depend depends on it.
