/* vim: set tabstop=8 shiftwidth=4 softtabstop=4 expandtab smarttab colorcolumn=80: */
/*
 * Copyright (c) 2019 Red Hat, Inc.
 * Author: Sergio Correia <scorreia@redhat.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

struct file_list {
    char **m_files;
    size_t m_size;
};

struct file_list* new_file_list(void);
void free_file_list(struct file_list*);
void cleanup_file_list(struct file_list**);
int file_list_add(struct file_list* /* fl */, const char* /* filepath */);
int match_file(const char* /* file */, const char* /* pattern */);
int list_files_cmp_func(const void*, const void*);
struct file_list* list_files(const char* /* path */, const char* /* match */, int /* ignore_hidden */);
