/*****************************************************************************\
 *  $Id: genrand.c 68 2006-02-14 21:54:16Z garlick $
 *****************************************************************************
 *  Copyright (C) 2001-2008 The Regents of the University of California.
 *  Produced at Lawrence Livermore National Laboratory (cf, DISCLAIMER).
 *  Written by Jim Garlick <garlick@llnl.gov>.
 *  UCRL-CODE-2003-006.
 *  
 *  This file is part of Scrub, a program for erasing disks.
 *  For details, see https://code.google.com/p/diskscrub/
 *  
 *  Scrub is free software; you can redistribute it and/or modify it under
 *  the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 2 of the License, or (at your option)
 *  any later version.
 *  
 *  Scrub is distributed in the hope that it will be useful, but WITHOUT ANY
 *  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 *  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *  
 *  You should have received a copy of the GNU General Public License along
 *  with Scrub; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
\*****************************************************************************/

#if HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <sys/time.h>
#include <assert.h>
#include <libgen.h>

#include <gcrypt.h>

#include "util.h"
#include "genrand.h"
#include "hwrand.h"

extern char *prog;

static bool no_hwrand = false;
static hwrand_t gen_hwrand;

/* Initialize the module.
 */
int
initrand(void)
{
    if (!gcry_check_version(GCRYPT_VERSION)) {
        goto error;
    }

    gcry_control(GCRYCTL_INITIALIZATION_FINISHED, 0);

    if (!no_hwrand)
        gen_hwrand = init_hwrand();

    return 0;
error:
    return -1;
}

/* Fill buf with random data.
 */
void 
genrand(unsigned char *buf, int buflen)
{
    if (gen_hwrand) {
        bool hwok = gen_hwrand(buf, buflen);
        if (hwok)
            return;
    }

    gcry_randomize(buf, buflen, GCRY_STRONG_RANDOM);
}

/*
 * Disable hardware random number generation
 */
void
disable_hwrand(void)
{
    no_hwrand = true;
}

/*
 * vi:tabstop=4 shiftwidth=4 expandtab
 */
