#ifndef __RC4_HH__
#define __RC4_HH__

#include <qpdf/qpdf-config.h>

#ifdef HAVE_GNUTLS
# include <gnutls/crypto.h>
#endif

class RC4
{
  public:
    // key_len of -1 means treat key_data as a null-terminated string
    RC4(unsigned char const* key_data, int key_len = -1);

    // out_data = 0 means to encrypt/decrypt in place
    void process(unsigned char* in_data, int len, unsigned char* out_data = 0);

#ifdef HAVE_GNUTLS
    ~RC4();
#endif

  private:
#ifdef HAVE_GNUTLS
    gnutls_cipher_hd_t ctx;
    gnutls_datum_t key;
#else
    class RC4Key
    {
      public:
        unsigned char state[256];
        unsigned char x;
        unsigned char y;
    };

    RC4Key key;
#endif
};

#endif // __RC4_HH__
