# Sample UDev data for various MD RAID devices:
# - member_boot: data for the member disk or partition after booting the system
# - member_assemble: data for the member disk or partition after re-assembling stopped array using
#                    'mdadm --assemble --scan' (yes, this is different from member_boot)
# - raid_device: data for the RAID array device
# - raid_partition: data for partition on the array
#
# We have data for different combinations of member "types", MD metadata versions and named v unnamed
# RAID devices.
# The data were gathered on Fedora 32.


class RaidOnDisk1():
    member_name = "sda"
    raid_name = "127"
    raid_node = "md127"
    metadata_version = "1.2"

    member_boot = {'DEVLINKS': '/dev/disk/by-path/pci-0000:00:11.0-scsi-0:0:0:0 /dev/disk/by-id/scsi-0QEMU_QEMU_HARDDISK_drive-scsi0-0-0-0',
                   'DEVNAME': '/dev/sda',
                   'DEVPATH': '/devices/pci0000:00/0000:00:11.0/virtio5/host8/target8:0:0/8:0:0:0/block/sda',
                   'DEVTYPE': 'disk',
                   'ID_BUS': 'scsi',
                   'ID_FS_LABEL': 'localhost.localdomain:127',
                   'ID_FS_LABEL_ENC': 'localhost.localdomain:127',
                   'ID_FS_TYPE': 'linux_raid_member',
                   'ID_FS_USAGE': 'raid',
                   'ID_FS_UUID': '54956eb2-6983-8759-e2ad-4c40acc92e4b',
                   'ID_FS_UUID_ENC': '54956eb2-6983-8759-e2ad-4c40acc92e4b',
                   'ID_FS_UUID_SUB': '64f96f0b-e97c-9157-d393-1fe457f3dd59',
                   'ID_FS_UUID_SUB_ENC': '64f96f0b-e97c-9157-d393-1fe457f3dd59',
                   'ID_FS_VERSION': '1.2',
                   'ID_MODEL': 'QEMU_HARDDISK',
                   'ID_MODEL_ENC': 'QEMU\\x20HARDDISK\\x20\\x20\\x20',
                   'ID_PATH': 'pci-0000:00:11.0-scsi-0:0:0:0',
                   'ID_PATH_TAG': 'pci-0000_00_11_0-scsi-0_0_0_0',
                   'ID_REVISION': '2.5+',
                   'ID_SCSI': '1',
                   'ID_SERIAL': '0QEMU_QEMU_HARDDISK_drive-scsi0-0-0-0',
                   'ID_SERIAL_SHORT': 'drive-scsi0-0-0-0',
                   'ID_TYPE': 'disk',
                   'ID_VENDOR': 'QEMU',
                   'ID_VENDOR_ENC': 'QEMU\\x20\\x20\\x20\\x20',
                   'MAJOR': '8',
                   'MD_DEVICE': 'md127',
                   'MD_DEVNAME': '127',
                   'MD_FOREIGN': 'no',
                   'MD_STARTED': 'unsafe',
                   'MINOR': '0',
                   'SUBSYSTEM': 'block',
                   'SYSTEMD_WANTS': 'mdadm-last-resort@md127.timer',
                   'TAGS': ':systemd:',
                   'USEC_INITIALIZED': '5529231',
                   'SYS_NAME': 'sda',
                   'SYS_PATH': '/sys/devices/pci0000:00/0000:00:11.0/virtio5/host8/target8:0:0/8:0:0:0/block/sda'}

    member_assemble = {'DEVLINKS': '/dev/disk/by-path/pci-0000:00:11.0-scsi-0:0:0:0 /dev/disk/by-id/scsi-0QEMU_QEMU_HARDDISK_drive-scsi0-0-0-0',
                       'DEVNAME': '/dev/sda',
                       'DEVPATH': '/devices/pci0000:00/0000:00:11.0/virtio5/host8/target8:0:0/8:0:0:0/block/sda',
                       'DEVTYPE': 'disk',
                       'ID_BUS': 'scsi',
                       'ID_FS_LABEL': 'localhost.localdomain:127',
                       'ID_FS_LABEL_ENC': 'localhost.localdomain:127',
                       'ID_FS_TYPE': 'linux_raid_member',
                       'ID_FS_USAGE': 'raid',
                       'ID_FS_UUID': '54956eb2-6983-8759-e2ad-4c40acc92e4b',
                       'ID_FS_UUID_ENC': '54956eb2-6983-8759-e2ad-4c40acc92e4b',
                       'ID_FS_UUID_SUB': '64f96f0b-e97c-9157-d393-1fe457f3dd59',
                       'ID_FS_UUID_SUB_ENC': '64f96f0b-e97c-9157-d393-1fe457f3dd59',
                       'ID_FS_VERSION': '1.2',
                       'ID_MODEL': 'QEMU_HARDDISK',
                       'ID_MODEL_ENC': 'QEMU\\x20HARDDISK\\x20\\x20\\x20',
                       'ID_PATH': 'pci-0000:00:11.0-scsi-0:0:0:0',
                       'ID_PATH_TAG': 'pci-0000_00_11_0-scsi-0_0_0_0',
                       'ID_REVISION': '2.5+',
                       'ID_SCSI': '1',
                       'ID_SERIAL': '0QEMU_QEMU_HARDDISK_drive-scsi0-0-0-0',
                       'ID_SERIAL_SHORT': 'drive-scsi0-0-0-0',
                       'ID_TYPE': 'disk',
                       'ID_VENDOR': 'QEMU',
                       'ID_VENDOR_ENC': 'QEMU\\x20\\x20\\x20\\x20',
                       'MAJOR': '8',
                       'MINOR': '0',
                       'SUBSYSTEM': 'block',
                       'TAGS': ':systemd:',
                       'USEC_INITIALIZED': '5529231',
                       'SYS_NAME': 'sda',
                       'SYS_PATH': '/sys/devices/pci0000:00/0000:00:11.0/virtio5/host8/target8:0:0/8:0:0:0/block/sda'}

    raid_device = {'DEVLINKS': '/dev/disk/by-id/md-name-localhost.localdomain:127 /dev/disk/by-id/md-uuid-54956eb2:69838759:e2ad4c40:acc92e4b /dev/md/127',
                   'DEVNAME': '/dev/md127',
                   'DEVPATH': '/devices/virtual/block/md127',
                   'DEVTYPE': 'disk',
                   'ID_PART_TABLE_TYPE': 'dos',
                   'ID_PART_TABLE_UUID': '4eec0361',
                   'MAJOR': '9',
                   'MD_DEVICES': '2',
                   'MD_DEVICE_ev_sda_DEV': '/dev/sda',
                   'MD_DEVICE_ev_sda_ROLE': '0',
                   'MD_DEVICE_ev_sdb_DEV': '/dev/sdb',
                   'MD_DEVICE_ev_sdb_ROLE': '1',
                   'MD_DEVNAME': '127',
                   'MD_LEVEL': 'raid1',
                   'MD_METADATA': '1.2',
                   'MD_NAME': 'localhost.localdomain:127',
                   'MD_UUID': '54956eb2:69838759:e2ad4c40:acc92e4b',
                   'MINOR': '127',
                   'SUBSYSTEM': 'block',
                   'SYSTEMD_WANTS': 'mdmonitor.service',
                   'TAGS': ':systemd:',
                   'USEC_INITIALIZED': '603606045',
                   'SYS_NAME': 'md127',
                   'SYS_PATH': '/sys/devices/virtual/block/md127'}

    raid_partition = {'DEVLINKS': '/dev/md/127p1 /dev/disk/by-id/md-uuid-54956eb2:69838759:e2ad4c40:acc92e4b-part1 /dev/disk/by-id/md-name-localhost.localdomain:127-part1',
                      'DEVNAME': '/dev/md127p1',
                      'DEVPATH': '/devices/virtual/block/md127/md127p1',
                      'DEVTYPE': 'partition',
                      'ID_PART_ENTRY_DISK': '9:127',
                      'ID_PART_ENTRY_NUMBER': '1',
                      'ID_PART_ENTRY_OFFSET': '2048',
                      'ID_PART_ENTRY_SCHEME': 'dos',
                      'ID_PART_ENTRY_SIZE': '2091008',
                      'ID_PART_ENTRY_TYPE': '0x83',
                      'ID_PART_ENTRY_UUID': '4eec0361-01',
                      'MAJOR': '259',
                      'MD_DEVICES': '2',
                      'MD_DEVICE_ev_sda_DEV': '/dev/sda',
                      'MD_DEVICE_ev_sda_ROLE': '0',
                      'MD_DEVICE_ev_sdb_DEV': '/dev/sdb',
                      'MD_DEVICE_ev_sdb_ROLE': '1',
                      'MD_DEVNAME': '127',
                      'MD_LEVEL': 'raid1',
                      'MD_METADATA': '1.2',
                      'MD_NAME': 'localhost.localdomain:127',
                      'MD_UUID': '54956eb2:69838759:e2ad4c40:acc92e4b',
                      'MINOR': '2',
                      'PARTN': '1',
                      'SUBSYSTEM': 'block',
                      'SYSTEMD_WANTS': 'mdmonitor.service',
                      'TAGS': ':systemd:',
                      'USEC_INITIALIZED': '603714783',
                      'SYS_NAME': 'md127p1',
                      'SYS_PATH': '/sys/devices/virtual/block/md127/md127p1'}


class RaidOnDisk2():
    member_name = "sdc"
    raid_name = "name"
    raid_node = "md127"
    metadata_version = "1.2"

    member_boot = {'DEVLINKS': '/dev/disk/by-id/scsi-0QEMU_QEMU_HARDDISK_drive-scsi0-0-0-4 /dev/disk/by-path/pci-0000:00:11.0-scsi-0:0:0:4',
                   'DEVNAME': '/dev/sdc',
                   'DEVPATH': '/devices/pci0000:00/0000:00:11.0/virtio5/host8/target8:0:0/8:0:0:4/block/sdc',
                   'DEVTYPE': 'disk',
                   'ID_BUS': 'scsi',
                   'ID_FS_LABEL': 'localhost.localdomain:name',
                   'ID_FS_LABEL_ENC': 'localhost.localdomain:name',
                   'ID_FS_TYPE': 'linux_raid_member',
                   'ID_FS_USAGE': 'raid',
                   'ID_FS_UUID': '143d480c-12c3-909f-5476-98a9f94a1c4f',
                   'ID_FS_UUID_ENC': '143d480c-12c3-909f-5476-98a9f94a1c4f',
                   'ID_FS_UUID_SUB': '121f2b71-3634-4183-dc9c-08bfceda765c',
                   'ID_FS_UUID_SUB_ENC': '121f2b71-3634-4183-dc9c-08bfceda765c',
                   'ID_FS_VERSION': '1.2',
                   'ID_MODEL': 'QEMU_HARDDISK',
                   'ID_MODEL_ENC': 'QEMU\\x20HARDDISK\\x20\\x20\\x20',
                   'ID_PATH': 'pci-0000:00:11.0-scsi-0:0:0:4',
                   'ID_PATH_TAG': 'pci-0000_00_11_0-scsi-0_0_0_4',
                   'ID_REVISION': '2.5+',
                   'ID_SCSI': '1',
                   'ID_SERIAL': '0QEMU_QEMU_HARDDISK_drive-scsi0-0-0-4',
                   'ID_SERIAL_SHORT': 'drive-scsi0-0-0-4',
                   'ID_TYPE': 'disk',
                   'ID_VENDOR': 'QEMU',
                   'ID_VENDOR_ENC': 'QEMU\\x20\\x20\\x20\\x20',
                   'MAJOR': '8',
                   'MD_DEVICE': 'md127',
                   'MD_DEVNAME': 'name',
                   'MD_FOREIGN': 'no',
                   'MD_STARTED': 'yes',
                   'MINOR': '32',
                   'SUBSYSTEM': 'block',
                   'TAGS': ':systemd:',
                   'USEC_INITIALIZED': '6109555',
                   'SYS_NAME': 'sdc',
                   'SYS_PATH': '/sys/devices/pci0000:00/0000:00:11.0/virtio5/host8/target8:0:0/8:0:0:4/block/sdc'}

    member_assemble = {'DEVLINKS': '/dev/disk/by-id/scsi-0QEMU_QEMU_HARDDISK_drive-scsi0-0-0-4 /dev/disk/by-path/pci-0000:00:11.0-scsi-0:0:0:4',
                       'DEVNAME': '/dev/sdc',
                       'DEVPATH': '/devices/pci0000:00/0000:00:11.0/virtio5/host8/target8:0:0/8:0:0:4/block/sdc',
                       'DEVTYPE': 'disk',
                       'ID_BUS': 'scsi',
                       'ID_FS_LABEL': 'localhost.localdomain:name',
                       'ID_FS_LABEL_ENC': 'localhost.localdomain:name',
                       'ID_FS_TYPE': 'linux_raid_member',
                       'ID_FS_USAGE': 'raid',
                       'ID_FS_UUID': '143d480c-12c3-909f-5476-98a9f94a1c4f',
                       'ID_FS_UUID_ENC': '143d480c-12c3-909f-5476-98a9f94a1c4f',
                       'ID_FS_UUID_SUB': '121f2b71-3634-4183-dc9c-08bfceda765c',
                       'ID_FS_UUID_SUB_ENC': '121f2b71-3634-4183-dc9c-08bfceda765c',
                       'ID_FS_VERSION': '1.2',
                       'ID_MODEL': 'QEMU_HARDDISK',
                       'ID_MODEL_ENC': 'QEMU\\x20HARDDISK\\x20\\x20\\x20',
                       'ID_PATH': 'pci-0000:00:11.0-scsi-0:0:0:4',
                       'ID_PATH_TAG': 'pci-0000_00_11_0-scsi-0_0_0_4',
                       'ID_REVISION': '2.5+',
                       'ID_SCSI': '1',
                       'ID_SERIAL': '0QEMU_QEMU_HARDDISK_drive-scsi0-0-0-4',
                       'ID_SERIAL_SHORT': 'drive-scsi0-0-0-4',
                       'ID_TYPE': 'disk',
                       'ID_VENDOR': 'QEMU',
                       'ID_VENDOR_ENC': 'QEMU\\x20\\x20\\x20\\x20',
                       'MAJOR': '8',
                       'MINOR': '32',
                       'SUBSYSTEM': 'block',
                       'TAGS': ':systemd:',
                       'USEC_INITIALIZED': '6109555',
                       'SYS_NAME': 'sdc',
                       'SYS_PATH': '/sys/devices/pci0000:00/0000:00:11.0/virtio5/host8/target8:0:0/8:0:0:4/block/sdc'}

    raid_device = {'DEVLINKS': '/dev/disk/by-id/md-name-localhost.localdomain:name /dev/disk/by-id/md-uuid-143d480c:12c3909f:547698a9:f94a1c4f /dev/md/name',
                   'DEVNAME': '/dev/md127',
                   'DEVPATH': '/devices/virtual/block/md127',
                   'DEVTYPE': 'disk',
                   'ID_PART_TABLE_TYPE': 'dos',
                   'ID_PART_TABLE_UUID': '19e9cb5b',
                   'MAJOR': '9',
                   'MD_DEVICES': '2',
                   'MD_DEVICE_ev_sdc_DEV': '/dev/sdc',
                   'MD_DEVICE_ev_sdc_ROLE': '0',
                   'MD_DEVICE_ev_sdd_DEV': '/dev/sdd',
                   'MD_DEVICE_ev_sdd_ROLE': '1',
                   'MD_DEVNAME': 'name',
                   'MD_LEVEL': 'raid1',
                   'MD_METADATA': '1.2',
                   'MD_NAME': 'localhost.localdomain:name',
                   'MD_UUID': '143d480c:12c3909f:547698a9:f94a1c4f',
                   'MINOR': '127',
                   'SUBSYSTEM': 'block',
                   'SYSTEMD_WANTS': 'mdmonitor.service',
                   'TAGS': ':systemd:',
                   'USEC_INITIALIZED': '5844744',
                   'SYS_NAME': 'md127',
                   'SYS_PATH': '/sys/devices/virtual/block/md127'}

    raid_partition = {'DEVLINKS': '/dev/disk/by-id/md-uuid-143d480c:12c3909f:547698a9:f94a1c4f-part1 /dev/disk/by-id/md-name-localhost.localdomain:name-part1 /dev/md/name1',
                      'DEVNAME': '/dev/md127p1',
                      'DEVPATH': '/devices/virtual/block/md127/md127p1',
                      'DEVTYPE': 'partition',
                      'ID_PART_ENTRY_DISK': '9:127',
                      'ID_PART_ENTRY_NUMBER': '1',
                      'ID_PART_ENTRY_OFFSET': '2048',
                      'ID_PART_ENTRY_SCHEME': 'dos',
                      'ID_PART_ENTRY_SIZE': '2091008',
                      'ID_PART_ENTRY_TYPE': '0x83',
                      'ID_PART_ENTRY_UUID': '19e9cb5b-01',
                      'ID_PART_TABLE_TYPE': 'dos',
                      'ID_PART_TABLE_UUID': 'ec985633',
                      'MAJOR': '259',
                      'MD_DEVICES': '2',
                      'MD_DEVICE_ev_sdc_DEV': '/dev/sdc',
                      'MD_DEVICE_ev_sdc_ROLE': '0',
                      'MD_DEVICE_ev_sdd_DEV': '/dev/sdd',
                      'MD_DEVICE_ev_sdd_ROLE': '1',
                      'MD_DEVNAME': 'name',
                      'MD_LEVEL': 'raid1',
                      'MD_METADATA': '1.2',
                      'MD_NAME': 'localhost.localdomain:name',
                      'MD_UUID': '143d480c:12c3909f:547698a9:f94a1c4f',
                      'MINOR': '1',
                      'PARTN': '1',
                      'SUBSYSTEM': 'block',
                      'SYSTEMD_WANTS': 'mdmonitor.service',
                      'TAGS': ':systemd:',
                      'USEC_INITIALIZED': '5928255',
                      'SYS_NAME': 'md127p1',
                      'SYS_PATH': '/sys/devices/virtual/block/md127/md127p1'}


class RaidOnDisk3():
    member_name = "sde"
    raid_name = "125"
    raid_node = "md125"
    metadata_version = "0.9"

    member_boot = {'DEVLINKS': '/dev/disk/by-id/scsi-0QEMU_QEMU_HARDDISK_drive-scsi0-0-0-1 /dev/disk/by-path/pci-0000:00:11.0-scsi-0:0:0:1',
                   'DEVNAME': '/dev/sde',
                   'DEVPATH': '/devices/pci0000:00/0000:00:11.0/virtio5/host8/target8:0:0/8:0:0:1/block/sde',
                   'DEVTYPE': 'disk',
                   'ID_BUS': 'scsi',
                   'ID_FS_TYPE': 'linux_raid_member',
                   'ID_FS_USAGE': 'raid',
                   'ID_FS_UUID': 'c4ef60f5-e374-5f70-bfe7-8010bc810f04',
                   'ID_FS_UUID_ENC': 'c4ef60f5-e374-5f70-bfe7-8010bc810f04',
                   'ID_FS_VERSION': '0.90.0',
                   'ID_MODEL': 'QEMU_HARDDISK',
                   'ID_MODEL_ENC': 'QEMU\\x20HARDDISK\\x20\\x20\\x20',
                   'ID_PATH': 'pci-0000:00:11.0-scsi-0:0:0:1',
                   'ID_PATH_TAG': 'pci-0000_00_11_0-scsi-0_0_0_1',
                   'ID_REVISION': '2.5+',
                   'ID_SCSI': '1',
                   'ID_SERIAL': '0QEMU_QEMU_HARDDISK_drive-scsi0-0-0-1',
                   'ID_SERIAL_SHORT': 'drive-scsi0-0-0-1',
                   'ID_TYPE': 'disk',
                   'ID_VENDOR': 'QEMU',
                   'ID_VENDOR_ENC': 'QEMU\\x20\\x20\\x20\\x20',
                   'MAJOR': '8',
                   'MD_DEVICE': 'md125',
                   'MD_DEVNAME': '125',
                   'MD_FOREIGN': 'no',
                   'MD_STARTED': 'unsafe',
                   'MINOR': '64',
                   'SUBSYSTEM': 'block',
                   'SYSTEMD_WANTS': 'mdadm-last-resort@md125.timer',
                   'TAGS': ':systemd:',
                   'USEC_INITIALIZED': '5538551',
                   'SYS_NAME': 'sde',
                   'SYS_PATH': '/sys/devices/pci0000:00/0000:00:11.0/virtio5/host8/target8:0:0/8:0:0:1/block/sde'}

    member_assemble = {'DEVLINKS': '/dev/disk/by-id/scsi-0QEMU_QEMU_HARDDISK_drive-scsi0-0-0-1 /dev/disk/by-path/pci-0000:00:11.0-scsi-0:0:0:1',
                       'DEVNAME': '/dev/sde',
                       'DEVPATH': '/devices/pci0000:00/0000:00:11.0/virtio5/host8/target8:0:0/8:0:0:1/block/sde',
                       'DEVTYPE': 'disk',
                       'ID_BUS': 'scsi',
                       'ID_FS_TYPE': 'linux_raid_member',
                       'ID_FS_USAGE': 'raid',
                       'ID_FS_UUID': 'c4ef60f5-e374-5f70-bfe7-8010bc810f04',
                       'ID_FS_UUID_ENC': 'c4ef60f5-e374-5f70-bfe7-8010bc810f04',
                       'ID_FS_VERSION': '0.90.0',
                       'ID_MODEL': 'QEMU_HARDDISK',
                       'ID_MODEL_ENC': 'QEMU\\x20HARDDISK\\x20\\x20\\x20',
                       'ID_PATH': 'pci-0000:00:11.0-scsi-0:0:0:1',
                       'ID_PATH_TAG': 'pci-0000_00_11_0-scsi-0_0_0_1',
                       'ID_REVISION': '2.5+',
                       'ID_SCSI': '1',
                       'ID_SERIAL': '0QEMU_QEMU_HARDDISK_drive-scsi0-0-0-1',
                       'ID_SERIAL_SHORT': 'drive-scsi0-0-0-1',
                       'ID_TYPE': 'disk',
                       'ID_VENDOR': 'QEMU',
                       'ID_VENDOR_ENC': 'QEMU\\x20\\x20\\x20\\x20',
                       'MAJOR': '8',
                       'MINOR': '64',
                       'SUBSYSTEM': 'block',
                       'TAGS': ':systemd:',
                       'USEC_INITIALIZED': '5538551',
                       'SYS_NAME': 'sde',
                       'SYS_PATH': '/sys/devices/pci0000:00/0000:00:11.0/virtio5/host8/target8:0:0/8:0:0:1/block/sde'}

    raid_device = {'DEVLINKS': '/dev/md/125 /dev/disk/by-id/md-uuid-c4ef60f5:e3745f70:bfe78010:bc810f04',
                   'DEVNAME': '/dev/md125',
                   'DEVPATH': '/devices/virtual/block/md125',
                   'DEVTYPE': 'disk',
                   'ID_PART_TABLE_TYPE': 'dos',
                   'ID_PART_TABLE_UUID': 'e74877cd',
                   'MAJOR': '9',
                   'MD_DEVICES': '2',
                   'MD_DEVICE_ev_sde_DEV': '/dev/sde',
                   'MD_DEVICE_ev_sde_ROLE': '0',
                   'MD_DEVICE_ev_sdf_DEV': '/dev/sdf',
                   'MD_DEVICE_ev_sdf_ROLE': '1',
                   'MD_DEVNAME': '125',
                   'MD_LEVEL': 'raid1',
                   'MD_METADATA': '0.90',
                   'MD_UUID': 'c4ef60f5:e3745f70:bfe78010:bc810f04',
                   'MINOR': '125',
                   'SUBSYSTEM': 'block',
                   'SYSTEMD_WANTS': 'mdmonitor.service',
                   'TAGS': ':systemd:',
                   'USEC_INITIALIZED': '5786380',
                   'SYS_NAME': 'md125',
                   'SYS_PATH': '/sys/devices/virtual/block/md125'}

    raid_partition = {'DEVLINKS': '/dev/md/125p1 /dev/disk/by-id/md-uuid-c4ef60f5:e3745f70:bfe78010:bc810f04-part1',
                      'DEVNAME': '/dev/md125p1',
                      'DEVPATH': '/devices/virtual/block/md125/md125p1',
                      'DEVTYPE': 'partition',
                      'ID_PART_ENTRY_DISK': '9:125',
                      'ID_PART_ENTRY_NUMBER': '1',
                      'ID_PART_ENTRY_OFFSET': '2048',
                      'ID_PART_ENTRY_SCHEME': 'dos',
                      'ID_PART_ENTRY_SIZE': '2094976',
                      'ID_PART_ENTRY_TYPE': '0x83',
                      'ID_PART_ENTRY_UUID': 'e74877cd-01',
                      'MAJOR': '259',
                      'MD_DEVICES': '2',
                      'MD_DEVICE_ev_sde_DEV': '/dev/sde',
                      'MD_DEVICE_ev_sde_ROLE': '0',
                      'MD_DEVICE_ev_sdf_DEV': '/dev/sdf',
                      'MD_DEVICE_ev_sdf_ROLE': '1',
                      'MD_DEVNAME': '125',
                      'MD_LEVEL': 'raid1',
                      'MD_METADATA': '0.90',
                      'MD_UUID': 'c4ef60f5:e3745f70:bfe78010:bc810f04',
                      'MINOR': '3',
                      'PARTN': '1',
                      'SUBSYSTEM': 'block',
                      'SYSTEMD_WANTS': 'mdmonitor.service',
                      'TAGS': ':systemd:',
                      'USEC_INITIALIZED': '8808457',
                      'SYS_NAME': 'md125p1',
                      'SYS_PATH': '/sys/devices/virtual/block/md125/md125p1'}


class RaidOnPartition1():
    member_name = "sdh3"
    raid_name = "122"
    raid_node = "md122"
    metadata_version = "1.2"

    member_boot = {'DEVLINKS': '/dev/disk/by-path/pci-0000:00:07.0-scsi-0:0:2:0-part3 /dev/disk/by-id/scsi-0QEMU_QEMU_HARDDISK_drive-scsi1-0-2-part3 /dev/disk/by-partuuid/73eb11a9-03',
                   'DEVNAME': '/dev/sdh3',
                   'DEVPATH': '/devices/pci0000:00/0000:00:07.0/host9/target9:0:2/9:0:2:0/block/sdh/sdh3',
                   'DEVTYPE': 'partition',
                   'ID_BUS': 'scsi',
                   'ID_FS_LABEL': 'localhost.localdomain:122',
                   'ID_FS_LABEL_ENC': 'localhost.localdomain:122',
                   'ID_FS_TYPE': 'linux_raid_member',
                   'ID_FS_USAGE': 'raid',
                   'ID_FS_UUID': '0628d995-eb60-ebd1-a767-51730b16f212',
                   'ID_FS_UUID_ENC': '0628d995-eb60-ebd1-a767-51730b16f212',
                   'ID_FS_UUID_SUB': 'b301779b-f759-ad7d-5324-b38d4b6d944d',
                   'ID_FS_UUID_SUB_ENC': 'b301779b-f759-ad7d-5324-b38d4b6d944d',
                   'ID_FS_VERSION': '1.2',
                   'ID_MODEL': 'QEMU_HARDDISK',
                   'ID_MODEL_ENC': 'QEMU\\x20HARDDISK\\x20\\x20\\x20',
                   'ID_PART_ENTRY_DISK': '8:112',
                   'ID_PART_ENTRY_NUMBER': '3',
                   'ID_PART_ENTRY_OFFSET': '411648',
                   'ID_PART_ENTRY_SCHEME': 'dos',
                   'ID_PART_ENTRY_SIZE': '204800',
                   'ID_PART_ENTRY_TYPE': '0x83',
                   'ID_PART_ENTRY_UUID': '73eb11a9-03',
                   'ID_PART_TABLE_TYPE': 'dos',
                   'ID_PART_TABLE_UUID': '73eb11a9',
                   'ID_PATH': 'pci-0000:00:07.0-scsi-0:0:2:0',
                   'ID_PATH_TAG': 'pci-0000_00_07_0-scsi-0_0_2_0',
                   'ID_REVISION': '2.5+',
                   'ID_SCSI': '1',
                   'ID_SERIAL': '0QEMU_QEMU_HARDDISK_drive-scsi1-0-2',
                   'ID_SERIAL_SHORT': 'drive-scsi1-0-2',
                   'ID_TYPE': 'disk',
                   'ID_VENDOR': 'QEMU',
                   'ID_VENDOR_ENC': 'QEMU\\x20\\x20\\x20\\x20',
                   'MAJOR': '8',
                   'MD_DEVICE': 'md122',
                   'MD_DEVNAME': '122',
                   'MD_FOREIGN': 'no',
                   'MD_STARTED': 'yes',
                   'MINOR': '115',
                   'PARTN': '3',
                   'SUBSYSTEM': 'block',
                   'TAGS': ':systemd:',
                   'USEC_INITIALIZED': '8920462',
                   'SYS_NAME': 'sdh3',
                   'SYS_PATH': '/sys/devices/pci0000:00/0000:00:07.0/host9/target9:0:2/9:0:2:0/block/sdh/sdh3'}

    member_assemble = {'DEVLINKS': '/dev/disk/by-path/pci-0000:00:07.0-scsi-0:0:2:0-part3 /dev/disk/by-id/scsi-0QEMU_QEMU_HARDDISK_drive-scsi1-0-2-part3 /dev/disk/by-partuuid/73eb11a9-03',
                       'DEVNAME': '/dev/sdh3',
                       'DEVPATH': '/devices/pci0000:00/0000:00:07.0/host9/target9:0:2/9:0:2:0/block/sdh/sdh3',
                       'DEVTYPE': 'partition',
                       'ID_BUS': 'scsi',
                       'ID_FS_LABEL': 'localhost.localdomain:122',
                       'ID_FS_LABEL_ENC': 'localhost.localdomain:122',
                       'ID_FS_TYPE': 'linux_raid_member',
                       'ID_FS_USAGE': 'raid',
                       'ID_FS_UUID': '0628d995-eb60-ebd1-a767-51730b16f212',
                       'ID_FS_UUID_ENC': '0628d995-eb60-ebd1-a767-51730b16f212',
                       'ID_FS_UUID_SUB': 'b301779b-f759-ad7d-5324-b38d4b6d944d',
                       'ID_FS_UUID_SUB_ENC': 'b301779b-f759-ad7d-5324-b38d4b6d944d',
                       'ID_FS_VERSION': '1.2',
                       'ID_MODEL': 'QEMU_HARDDISK',
                       'ID_MODEL_ENC': 'QEMU\\x20HARDDISK\\x20\\x20\\x20',
                       'ID_PART_ENTRY_DISK': '8:112',
                       'ID_PART_ENTRY_NUMBER': '3',
                       'ID_PART_ENTRY_OFFSET': '411648',
                       'ID_PART_ENTRY_SCHEME': 'dos',
                       'ID_PART_ENTRY_SIZE': '204800',
                       'ID_PART_ENTRY_TYPE': '0x83',
                       'ID_PART_ENTRY_UUID': '73eb11a9-03',
                       'ID_PART_TABLE_TYPE': 'dos',
                       'ID_PART_TABLE_UUID': '73eb11a9',
                       'ID_PATH': 'pci-0000:00:07.0-scsi-0:0:2:0',
                       'ID_PATH_TAG': 'pci-0000_00_07_0-scsi-0_0_2_0',
                       'ID_REVISION': '2.5+',
                       'ID_SCSI': '1',
                       'ID_SERIAL': '0QEMU_QEMU_HARDDISK_drive-scsi1-0-2',
                       'ID_SERIAL_SHORT': 'drive-scsi1-0-2',
                       'ID_TYPE': 'disk',
                       'ID_VENDOR': 'QEMU',
                       'ID_VENDOR_ENC': 'QEMU\\x20\\x20\\x20\\x20',
                       'MAJOR': '8',
                       'MINOR': '115',
                       'PARTN': '3',
                       'SUBSYSTEM': 'block',
                       'TAGS': ':systemd:',
                       'USEC_INITIALIZED': '8920462',
                       'SYS_NAME': 'sdh3',
                       'SYS_PATH': '/sys/devices/pci0000:00/0000:00:07.0/host9/target9:0:2/9:0:2:0/block/sdh/sdh3'}

    raid_device = {'DEVLINKS': '/dev/disk/by-id/md-uuid-0628d995:eb60ebd1:a7675173:0b16f212 /dev/disk/by-id/md-name-localhost.localdomain:122 /dev/md/122',
                   'DEVNAME': '/dev/md122',
                   'DEVPATH': '/devices/virtual/block/md122',
                   'DEVTYPE': 'disk',
                   'ID_PART_TABLE_TYPE': 'dos',
                   'ID_PART_TABLE_UUID': '6dc80b3b',
                   'MAJOR': '9',
                   'MD_DEVICES': '2',
                   'MD_DEVICE_ev_sdh3_DEV': '/dev/sdh3',
                   'MD_DEVICE_ev_sdh3_ROLE': '0',
                   'MD_DEVICE_ev_sdh5_DEV': '/dev/sdh5',
                   'MD_DEVICE_ev_sdh5_ROLE': '1',
                   'MD_DEVNAME': '122',
                   'MD_LEVEL': 'raid1',
                   'MD_METADATA': '1.2',
                   'MD_NAME': 'localhost.localdomain:122',
                   'MD_UUID': '0628d995:eb60ebd1:a7675173:0b16f212',
                   'MINOR': '122',
                   'SUBSYSTEM': 'block',
                   'SYSTEMD_WANTS': 'mdmonitor.service',
                   'TAGS': ':systemd:',
                   'USEC_INITIALIZED': '8770105',
                   'SYS_NAME': 'md122',
                   'SYS_PATH': '/sys/devices/virtual/block/md122'}

    raid_partition = {'DEVLINKS': '/dev/disk/by-id/md-uuid-0628d995:eb60ebd1:a7675173:0b16f212-part1 /dev/disk/by-id/md-name-localhost.localdomain:122-part1 /dev/md/122p1',
                      'DEVNAME': '/dev/md122p1',
                      'DEVPATH': '/devices/virtual/block/md122/md122p1',
                      'DEVTYPE': 'partition',
                      'ID_PART_ENTRY_DISK': '9:122',
                      'ID_PART_ENTRY_NUMBER': '1',
                      'ID_PART_ENTRY_OFFSET': '2048',
                      'ID_PART_ENTRY_SCHEME': 'dos',
                      'ID_PART_ENTRY_SIZE': '200704',
                      'ID_PART_ENTRY_TYPE': '0x83',
                      'ID_PART_ENTRY_UUID': '6dc80b3b-01',
                      'MAJOR': '259',
                      'MD_DEVICES': '2',
                      'MD_DEVICE_ev_sdh3_DEV': '/dev/sdh3',
                      'MD_DEVICE_ev_sdh3_ROLE': '0',
                      'MD_DEVICE_ev_sdh5_DEV': '/dev/sdh5',
                      'MD_DEVICE_ev_sdh5_ROLE': '1',
                      'MD_DEVNAME': '122',
                      'MD_LEVEL': 'raid1',
                      'MD_METADATA': '1.2',
                      'MD_NAME': 'localhost.localdomain:122',
                      'MD_UUID': '0628d995:eb60ebd1:a7675173:0b16f212',
                      'MINOR': '6',
                      'PARTN': '1',
                      'SUBSYSTEM': 'block',
                      'SYSTEMD_WANTS': 'mdmonitor.service',
                      'TAGS': ':systemd:',
                      'USEC_INITIALIZED': '9003885',
                      'SYS_NAME': 'md122p1',
                      'SYS_PATH': '/sys/devices/virtual/block/md122/md122p1'}


class RaidOnPartition2():
    member_name = "sdh1"
    raid_name = "123"
    raid_node = "md123"
    metadata_version = "0.9"

    member_boot = {'DEVLINKS': '/dev/disk/by-path/pci-0000:00:07.0-scsi-0:0:2:0-part1 /dev/disk/by-id/scsi-0QEMU_QEMU_HARDDISK_drive-scsi1-0-2-part1 /dev/disk/by-partuuid/73eb11a9-01',
                   'DEVNAME': '/dev/sdh1',
                   'DEVPATH': '/devices/pci0000:00/0000:00:07.0/host9/target9:0:2/9:0:2:0/block/sdh/sdh1',
                   'DEVTYPE': 'partition',
                   'ID_BUS': 'scsi',
                   'ID_FS_TYPE': 'linux_raid_member',
                   'ID_FS_USAGE': 'raid',
                   'ID_FS_UUID': '335b35e0-f1af-8e86-bfe7-8010bc810f04',
                   'ID_FS_UUID_ENC': '335b35e0-f1af-8e86-bfe7-8010bc810f04',
                   'ID_FS_VERSION': '0.90.0',
                   'ID_MODEL': 'QEMU_HARDDISK',
                   'ID_MODEL_ENC': 'QEMU\\x20HARDDISK\\x20\\x20\\x20',
                   'ID_PART_ENTRY_DISK': '8:112',
                   'ID_PART_ENTRY_NUMBER': '1',
                   'ID_PART_ENTRY_OFFSET': '2048',
                   'ID_PART_ENTRY_SCHEME': 'dos',
                   'ID_PART_ENTRY_SIZE': '204800',
                   'ID_PART_ENTRY_TYPE': '0x83',
                   'ID_PART_ENTRY_UUID': '73eb11a9-01',
                   'ID_PART_TABLE_TYPE': 'dos',
                   'ID_PART_TABLE_UUID': '73eb11a9',
                   'ID_PATH': 'pci-0000:00:07.0-scsi-0:0:2:0',
                   'ID_PATH_TAG': 'pci-0000_00_07_0-scsi-0_0_2_0',
                   'ID_REVISION': '2.5+',
                   'ID_SCSI': '1',
                   'ID_SERIAL': '0QEMU_QEMU_HARDDISK_drive-scsi1-0-2',
                   'ID_SERIAL_SHORT': 'drive-scsi1-0-2',
                   'ID_TYPE': 'disk',
                   'ID_VENDOR': 'QEMU',
                   'ID_VENDOR_ENC': 'QEMU\\x20\\x20\\x20\\x20',
                   'MAJOR': '8',
                   'MD_DEVICE': 'md123',
                   'MD_DEVNAME': '123',
                   'MD_FOREIGN': 'no',
                   'MD_STARTED': 'unsafe',
                   'MINOR': '113',
                   'PARTN': '1',
                   'SUBSYSTEM': 'block',
                   'SYSTEMD_WANTS': 'mdadm-last-resort@md123.timer',
                   'TAGS': ':systemd:',
                   'USEC_INITIALIZED': '8778733',
                   'SYS_NAME': 'sdh1',
                   'SYS_PATH': '/sys/devices/pci0000:00/0000:00:07.0/host9/target9:0:2/9:0:2:0/block/sdh/sdh1'}

    member_assemble = {'DEVLINKS': '/dev/disk/by-path/pci-0000:00:07.0-scsi-0:0:2:0-part1 /dev/disk/by-id/scsi-0QEMU_QEMU_HARDDISK_drive-scsi1-0-2-part1 /dev/disk/by-partuuid/73eb11a9-01',
                       'DEVNAME': '/dev/sdh1',
                       'DEVPATH': '/devices/pci0000:00/0000:00:07.0/host9/target9:0:2/9:0:2:0/block/sdh/sdh1',
                       'DEVTYPE': 'partition',
                       'ID_BUS': 'scsi',
                       'ID_FS_TYPE': 'linux_raid_member',
                       'ID_FS_USAGE': 'raid',
                       'ID_FS_UUID': '335b35e0-f1af-8e86-bfe7-8010bc810f04',
                       'ID_FS_UUID_ENC': '335b35e0-f1af-8e86-bfe7-8010bc810f04',
                       'ID_FS_VERSION': '0.90.0',
                       'ID_MODEL': 'QEMU_HARDDISK',
                       'ID_MODEL_ENC': 'QEMU\\x20HARDDISK\\x20\\x20\\x20',
                       'ID_PART_ENTRY_DISK': '8:112',
                       'ID_PART_ENTRY_NUMBER': '1',
                       'ID_PART_ENTRY_OFFSET': '2048',
                       'ID_PART_ENTRY_SCHEME': 'dos',
                       'ID_PART_ENTRY_SIZE': '204800',
                       'ID_PART_ENTRY_TYPE': '0x83',
                       'ID_PART_ENTRY_UUID': '73eb11a9-01',
                       'ID_PART_TABLE_TYPE': 'dos',
                       'ID_PART_TABLE_UUID': '73eb11a9',
                       'ID_PATH': 'pci-0000:00:07.0-scsi-0:0:2:0',
                       'ID_PATH_TAG': 'pci-0000_00_07_0-scsi-0_0_2_0',
                       'ID_REVISION': '2.5+',
                       'ID_SCSI': '1',
                       'ID_SERIAL': '0QEMU_QEMU_HARDDISK_drive-scsi1-0-2',
                       'ID_SERIAL_SHORT': 'drive-scsi1-0-2',
                       'ID_TYPE': 'disk',
                       'ID_VENDOR': 'QEMU',
                       'ID_VENDOR_ENC': 'QEMU\\x20\\x20\\x20\\x20',
                       'MAJOR': '8',
                       'MINOR': '113',
                       'PARTN': '1',
                       'SUBSYSTEM': 'block',
                       'TAGS': ':systemd:',
                       'UDISKS_MD_MEMBER_DEVICES': '2',
                       'UDISKS_MD_MEMBER_EVENTS': '18',
                       'UDISKS_MD_MEMBER_LEVEL': 'raid1',
                       'UDISKS_MD_MEMBER_UPDATE_TIME': '1597143914',
                       'UDISKS_MD_MEMBER_UUID': '335b35e0:f1af8e86:bfe78010:bc810f04',
                       'USEC_INITIALIZED': '8778733',
                       'SYS_NAME': 'sdh1',
                       'SYS_PATH': '/sys/devices/pci0000:00/0000:00:07.0/host9/target9:0:2/9:0:2:0/block/sdh/sdh1'}

    raid_device = {'DEVLINKS': '/dev/md/123 /dev/disk/by-id/md-uuid-335b35e0:f1af8e86:bfe78010:bc810f04',
                   'DEVNAME': '/dev/md123',
                   'DEVPATH': '/devices/virtual/block/md123',
                   'DEVTYPE': 'disk',
                   'ID_PART_TABLE_TYPE': 'dos',
                   'ID_PART_TABLE_UUID': '653f84c8',
                   'MAJOR': '9',
                   'MD_DEVICES': '2',
                   'MD_DEVICE_ev_sdh1_DEV': '/dev/sdh1',
                   'MD_DEVICE_ev_sdh1_ROLE': '0',
                   'MD_DEVICE_ev_sdh2_DEV': '/dev/sdh2',
                   'MD_DEVICE_ev_sdh2_ROLE': '1',
                   'MD_DEVNAME': '123',
                   'MD_LEVEL': 'raid1',
                   'MD_METADATA': '0.90',
                   'MD_UUID': '335b35e0:f1af8e86:bfe78010:bc810f04',
                   'MINOR': '123',
                   'SUBSYSTEM': 'block',
                   'SYSTEMD_WANTS': 'mdmonitor.service',
                   'TAGS': ':systemd:',
                   'USEC_INITIALIZED': '8760382',
                   'SYS_NAME': 'md123',
                   'SYS_PATH': '/sys/devices/virtual/block/md123'}

    raid_partition = {'DEVLINKS': '/dev/disk/by-id/md-uuid-335b35e0:f1af8e86:bfe78010:bc810f04-part1 /dev/md/123p1',
                      'DEVNAME': '/dev/md123p1',
                      'DEVPATH': '/devices/virtual/block/md123/md123p1',
                      'DEVTYPE': 'partition',
                      'ID_PART_ENTRY_DISK': '9:123',
                      'ID_PART_ENTRY_NUMBER': '1',
                      'ID_PART_ENTRY_OFFSET': '2048',
                      'ID_PART_ENTRY_SCHEME': 'dos',
                      'ID_PART_ENTRY_SIZE': '202624',
                      'ID_PART_ENTRY_TYPE': '0x83',
                      'ID_PART_ENTRY_UUID': '653f84c8-01',
                      'MAJOR': '259',
                      'MD_DEVICES': '2',
                      'MD_DEVICE_ev_sdh1_DEV': '/dev/sdh1',
                      'MD_DEVICE_ev_sdh1_ROLE': '0',
                      'MD_DEVICE_ev_sdh2_DEV': '/dev/sdh2',
                      'MD_DEVICE_ev_sdh2_ROLE': '1',
                      'MD_DEVNAME': '123',
                      'MD_LEVEL': 'raid1',
                      'MD_METADATA': '0.90',
                      'MD_UUID': '335b35e0:f1af8e86:bfe78010:bc810f04',
                      'MINOR': '5',
                      'PARTN': '1',
                      'SUBSYSTEM': 'block',
                      'SYSTEMD_WANTS': 'mdmonitor.service',
                      'TAGS': ':systemd:',
                      'USEC_INITIALIZED': '8952876',
                      'SYS_NAME': 'md123p1',
                      'SYS_PATH': '/sys/devices/virtual/block/md123/md123p1'}
