/*
 * Copyright 2014-2016, Intel Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *
 *     * Neither the name of the copyright holder nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * blk_nblock.c -- unit test for pmemblk_nblock()
 *
 * usage: blk_nblock bsize:file...
 *
 */

#include "unittest.h"

int
main(int argc, char *argv[])
{
	START(argc, argv, "blk_nblock");

	if (argc < 2)
		UT_FATAL("usage: %s bsize:file...", argv[0]);

	/* map each file argument with the given map type */
	for (int arg = 1; arg < argc; arg++) {
		char *fname;
		size_t bsize = strtoul(argv[arg], &fname, 0);
		if (*fname != ':')
			UT_FATAL("usage: %s bsize:file...", argv[0]);
		fname++;

		PMEMblkpool *handle;
		handle = pmemblk_create(fname, bsize, 0, S_IWUSR | S_IRUSR);
		if (handle == NULL) {
			UT_OUT("!%s: pmemblk_create", fname);
		} else {
			UT_OUT("%s: block size %zu usable blocks: %zu",
					fname, bsize, pmemblk_nblock(handle));
			UT_ASSERTeq(pmemblk_bsize(handle), bsize);
			pmemblk_close(handle);
			int result = pmemblk_check(fname, bsize);
			if (result < 0)
				UT_OUT("!%s: pmemblk_check", fname);
			else if (result == 0)
				UT_OUT("%s: pmemblk_check: not consistent",
						fname);
			else {
				UT_ASSERTeq(pmemblk_check(fname, bsize + 1),
						-1);
				UT_ASSERTeq(pmemblk_check(fname, 0), 1);

				handle = pmemblk_open(fname, 0);
				UT_ASSERTeq(pmemblk_bsize(handle), bsize);
				pmemblk_close(handle);
			}
		}
	}

	DONE(NULL);
}
