/* == Start of generated table == */
/*
 * The following tables are generated by running:
 *
 *   ./gen-emoji-table.py emoji-data.txt
 *
 * on file with this header:
 *
 * # emoji-data.txt
 * # Date: 2020-01-28, 20:52:38 GMT
 * # © 2020 Unicode®, Inc.
 * # Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
 * # For terms of use, see http://www.unicode.org/terms_of_use.html
 * #
 * # Emoji Data for UTS #51
 * # Version: 13.0
 * #
 * # For documentation and usage, see http://www.unicode.org/reports/tr51
 */

#ifndef PANGO_EMOJI_TABLE_H
#define PANGO_EMOJI_TABLE_H

#include <glib.h>

struct Interval {
  gunichar start, end;
};

static const struct Interval _pango_Emoji_table[] =
{
  {0x0023, 0x0023},
  {0x002A, 0x002A},
  {0x0030, 0x0039},
  {0x00A9, 0x00A9},
  {0x00AE, 0x00AE},
  {0x203C, 0x203C},
  {0x2049, 0x2049},
  {0x2122, 0x2122},
  {0x2139, 0x2139},
  {0x2194, 0x2199},
  {0x21A9, 0x21AA},
  {0x231A, 0x231B},
  {0x2328, 0x2328},
  {0x23CF, 0x23CF},
  {0x23E9, 0x23EC},
  {0x23ED, 0x23EE},
  {0x23EF, 0x23EF},
  {0x23F0, 0x23F0},
  {0x23F1, 0x23F2},
  {0x23F3, 0x23F3},
  {0x23F8, 0x23FA},
  {0x24C2, 0x24C2},
  {0x25AA, 0x25AB},
  {0x25B6, 0x25B6},
  {0x25C0, 0x25C0},
  {0x25FB, 0x25FE},
  {0x2600, 0x2601},
  {0x2602, 0x2603},
  {0x2604, 0x2604},
  {0x260E, 0x260E},
  {0x2611, 0x2611},
  {0x2614, 0x2615},
  {0x2618, 0x2618},
  {0x261D, 0x261D},
  {0x2620, 0x2620},
  {0x2622, 0x2623},
  {0x2626, 0x2626},
  {0x262A, 0x262A},
  {0x262E, 0x262E},
  {0x262F, 0x262F},
  {0x2638, 0x2639},
  {0x263A, 0x263A},
  {0x2640, 0x2640},
  {0x2642, 0x2642},
  {0x2648, 0x2653},
  {0x265F, 0x265F},
  {0x2660, 0x2660},
  {0x2663, 0x2663},
  {0x2665, 0x2666},
  {0x2668, 0x2668},
  {0x267B, 0x267B},
  {0x267E, 0x267E},
  {0x267F, 0x267F},
  {0x2692, 0x2692},
  {0x2693, 0x2693},
  {0x2694, 0x2694},
  {0x2695, 0x2695},
  {0x2696, 0x2697},
  {0x2699, 0x2699},
  {0x269B, 0x269C},
  {0x26A0, 0x26A1},
  {0x26A7, 0x26A7},
  {0x26AA, 0x26AB},
  {0x26B0, 0x26B1},
  {0x26BD, 0x26BE},
  {0x26C4, 0x26C5},
  {0x26C8, 0x26C8},
  {0x26CE, 0x26CE},
  {0x26CF, 0x26CF},
  {0x26D1, 0x26D1},
  {0x26D3, 0x26D3},
  {0x26D4, 0x26D4},
  {0x26E9, 0x26E9},
  {0x26EA, 0x26EA},
  {0x26F0, 0x26F1},
  {0x26F2, 0x26F3},
  {0x26F4, 0x26F4},
  {0x26F5, 0x26F5},
  {0x26F7, 0x26F9},
  {0x26FA, 0x26FA},
  {0x26FD, 0x26FD},
  {0x2702, 0x2702},
  {0x2705, 0x2705},
  {0x2708, 0x270C},
  {0x270D, 0x270D},
  {0x270F, 0x270F},
  {0x2712, 0x2712},
  {0x2714, 0x2714},
  {0x2716, 0x2716},
  {0x271D, 0x271D},
  {0x2721, 0x2721},
  {0x2728, 0x2728},
  {0x2733, 0x2734},
  {0x2744, 0x2744},
  {0x2747, 0x2747},
  {0x274C, 0x274C},
  {0x274E, 0x274E},
  {0x2753, 0x2755},
  {0x2757, 0x2757},
  {0x2763, 0x2763},
  {0x2764, 0x2764},
  {0x2795, 0x2797},
  {0x27A1, 0x27A1},
  {0x27B0, 0x27B0},
  {0x27BF, 0x27BF},
  {0x2934, 0x2935},
  {0x2B05, 0x2B07},
  {0x2B1B, 0x2B1C},
  {0x2B50, 0x2B50},
  {0x2B55, 0x2B55},
  {0x3030, 0x3030},
  {0x303D, 0x303D},
  {0x3297, 0x3297},
  {0x3299, 0x3299},
  {0x1F004, 0x1F004},
  {0x1F0CF, 0x1F0CF},
  {0x1F170, 0x1F171},
  {0x1F17E, 0x1F17F},
  {0x1F18E, 0x1F18E},
  {0x1F191, 0x1F19A},
  {0x1F1E6, 0x1F1FF},
  {0x1F201, 0x1F202},
  {0x1F21A, 0x1F21A},
  {0x1F22F, 0x1F22F},
  {0x1F232, 0x1F23A},
  {0x1F250, 0x1F251},
  {0x1F300, 0x1F30C},
  {0x1F30D, 0x1F30E},
  {0x1F30F, 0x1F30F},
  {0x1F310, 0x1F310},
  {0x1F311, 0x1F311},
  {0x1F312, 0x1F312},
  {0x1F313, 0x1F315},
  {0x1F316, 0x1F318},
  {0x1F319, 0x1F319},
  {0x1F31A, 0x1F31A},
  {0x1F31B, 0x1F31B},
  {0x1F31C, 0x1F31C},
  {0x1F31D, 0x1F31E},
  {0x1F31F, 0x1F320},
  {0x1F321, 0x1F321},
  {0x1F324, 0x1F32C},
  {0x1F32D, 0x1F32F},
  {0x1F330, 0x1F331},
  {0x1F332, 0x1F333},
  {0x1F334, 0x1F335},
  {0x1F336, 0x1F336},
  {0x1F337, 0x1F34A},
  {0x1F34B, 0x1F34B},
  {0x1F34C, 0x1F34F},
  {0x1F350, 0x1F350},
  {0x1F351, 0x1F37B},
  {0x1F37C, 0x1F37C},
  {0x1F37D, 0x1F37D},
  {0x1F37E, 0x1F37F},
  {0x1F380, 0x1F393},
  {0x1F396, 0x1F397},
  {0x1F399, 0x1F39B},
  {0x1F39E, 0x1F39F},
  {0x1F3A0, 0x1F3C4},
  {0x1F3C5, 0x1F3C5},
  {0x1F3C6, 0x1F3C6},
  {0x1F3C7, 0x1F3C7},
  {0x1F3C8, 0x1F3C8},
  {0x1F3C9, 0x1F3C9},
  {0x1F3CA, 0x1F3CA},
  {0x1F3CB, 0x1F3CE},
  {0x1F3CF, 0x1F3D3},
  {0x1F3D4, 0x1F3DF},
  {0x1F3E0, 0x1F3E3},
  {0x1F3E4, 0x1F3E4},
  {0x1F3E5, 0x1F3F0},
  {0x1F3F3, 0x1F3F3},
  {0x1F3F4, 0x1F3F4},
  {0x1F3F5, 0x1F3F5},
  {0x1F3F7, 0x1F3F7},
  {0x1F3F8, 0x1F407},
  {0x1F408, 0x1F408},
  {0x1F409, 0x1F40B},
  {0x1F40C, 0x1F40E},
  {0x1F40F, 0x1F410},
  {0x1F411, 0x1F412},
  {0x1F413, 0x1F413},
  {0x1F414, 0x1F414},
  {0x1F415, 0x1F415},
  {0x1F416, 0x1F416},
  {0x1F417, 0x1F429},
  {0x1F42A, 0x1F42A},
  {0x1F42B, 0x1F43E},
  {0x1F43F, 0x1F43F},
  {0x1F440, 0x1F440},
  {0x1F441, 0x1F441},
  {0x1F442, 0x1F464},
  {0x1F465, 0x1F465},
  {0x1F466, 0x1F46B},
  {0x1F46C, 0x1F46D},
  {0x1F46E, 0x1F4AC},
  {0x1F4AD, 0x1F4AD},
  {0x1F4AE, 0x1F4B5},
  {0x1F4B6, 0x1F4B7},
  {0x1F4B8, 0x1F4EB},
  {0x1F4EC, 0x1F4ED},
  {0x1F4EE, 0x1F4EE},
  {0x1F4EF, 0x1F4EF},
  {0x1F4F0, 0x1F4F4},
  {0x1F4F5, 0x1F4F5},
  {0x1F4F6, 0x1F4F7},
  {0x1F4F8, 0x1F4F8},
  {0x1F4F9, 0x1F4FC},
  {0x1F4FD, 0x1F4FD},
  {0x1F4FF, 0x1F502},
  {0x1F503, 0x1F503},
  {0x1F504, 0x1F507},
  {0x1F508, 0x1F508},
  {0x1F509, 0x1F509},
  {0x1F50A, 0x1F514},
  {0x1F515, 0x1F515},
  {0x1F516, 0x1F52B},
  {0x1F52C, 0x1F52D},
  {0x1F52E, 0x1F53D},
  {0x1F549, 0x1F54A},
  {0x1F54B, 0x1F54E},
  {0x1F550, 0x1F55B},
  {0x1F55C, 0x1F567},
  {0x1F56F, 0x1F570},
  {0x1F573, 0x1F579},
  {0x1F57A, 0x1F57A},
  {0x1F587, 0x1F587},
  {0x1F58A, 0x1F58D},
  {0x1F590, 0x1F590},
  {0x1F595, 0x1F596},
  {0x1F5A4, 0x1F5A4},
  {0x1F5A5, 0x1F5A5},
  {0x1F5A8, 0x1F5A8},
  {0x1F5B1, 0x1F5B2},
  {0x1F5BC, 0x1F5BC},
  {0x1F5C2, 0x1F5C4},
  {0x1F5D1, 0x1F5D3},
  {0x1F5DC, 0x1F5DE},
  {0x1F5E1, 0x1F5E1},
  {0x1F5E3, 0x1F5E3},
  {0x1F5E8, 0x1F5E8},
  {0x1F5EF, 0x1F5EF},
  {0x1F5F3, 0x1F5F3},
  {0x1F5FA, 0x1F5FA},
  {0x1F5FB, 0x1F5FF},
  {0x1F600, 0x1F600},
  {0x1F601, 0x1F606},
  {0x1F607, 0x1F608},
  {0x1F609, 0x1F60D},
  {0x1F60E, 0x1F60E},
  {0x1F60F, 0x1F60F},
  {0x1F610, 0x1F610},
  {0x1F611, 0x1F611},
  {0x1F612, 0x1F614},
  {0x1F615, 0x1F615},
  {0x1F616, 0x1F616},
  {0x1F617, 0x1F617},
  {0x1F618, 0x1F618},
  {0x1F619, 0x1F619},
  {0x1F61A, 0x1F61A},
  {0x1F61B, 0x1F61B},
  {0x1F61C, 0x1F61E},
  {0x1F61F, 0x1F61F},
  {0x1F620, 0x1F625},
  {0x1F626, 0x1F627},
  {0x1F628, 0x1F62B},
  {0x1F62C, 0x1F62C},
  {0x1F62D, 0x1F62D},
  {0x1F62E, 0x1F62F},
  {0x1F630, 0x1F633},
  {0x1F634, 0x1F634},
  {0x1F635, 0x1F635},
  {0x1F636, 0x1F636},
  {0x1F637, 0x1F640},
  {0x1F641, 0x1F644},
  {0x1F645, 0x1F64F},
  {0x1F680, 0x1F680},
  {0x1F681, 0x1F682},
  {0x1F683, 0x1F685},
  {0x1F686, 0x1F686},
  {0x1F687, 0x1F687},
  {0x1F688, 0x1F688},
  {0x1F689, 0x1F689},
  {0x1F68A, 0x1F68B},
  {0x1F68C, 0x1F68C},
  {0x1F68D, 0x1F68D},
  {0x1F68E, 0x1F68E},
  {0x1F68F, 0x1F68F},
  {0x1F690, 0x1F690},
  {0x1F691, 0x1F693},
  {0x1F694, 0x1F694},
  {0x1F695, 0x1F695},
  {0x1F696, 0x1F696},
  {0x1F697, 0x1F697},
  {0x1F698, 0x1F698},
  {0x1F699, 0x1F69A},
  {0x1F69B, 0x1F6A1},
  {0x1F6A2, 0x1F6A2},
  {0x1F6A3, 0x1F6A3},
  {0x1F6A4, 0x1F6A5},
  {0x1F6A6, 0x1F6A6},
  {0x1F6A7, 0x1F6AD},
  {0x1F6AE, 0x1F6B1},
  {0x1F6B2, 0x1F6B2},
  {0x1F6B3, 0x1F6B5},
  {0x1F6B6, 0x1F6B6},
  {0x1F6B7, 0x1F6B8},
  {0x1F6B9, 0x1F6BE},
  {0x1F6BF, 0x1F6BF},
  {0x1F6C0, 0x1F6C0},
  {0x1F6C1, 0x1F6C5},
  {0x1F6CB, 0x1F6CB},
  {0x1F6CC, 0x1F6CC},
  {0x1F6CD, 0x1F6CF},
  {0x1F6D0, 0x1F6D0},
  {0x1F6D1, 0x1F6D2},
  {0x1F6D5, 0x1F6D5},
  {0x1F6D6, 0x1F6D7},
  {0x1F6E0, 0x1F6E5},
  {0x1F6E9, 0x1F6E9},
  {0x1F6EB, 0x1F6EC},
  {0x1F6F0, 0x1F6F0},
  {0x1F6F3, 0x1F6F3},
  {0x1F6F4, 0x1F6F6},
  {0x1F6F7, 0x1F6F8},
  {0x1F6F9, 0x1F6F9},
  {0x1F6FA, 0x1F6FA},
  {0x1F6FB, 0x1F6FC},
  {0x1F7E0, 0x1F7EB},
  {0x1F90C, 0x1F90C},
  {0x1F90D, 0x1F90F},
  {0x1F910, 0x1F918},
  {0x1F919, 0x1F91E},
  {0x1F91F, 0x1F91F},
  {0x1F920, 0x1F927},
  {0x1F928, 0x1F92F},
  {0x1F930, 0x1F930},
  {0x1F931, 0x1F932},
  {0x1F933, 0x1F93A},
  {0x1F93C, 0x1F93E},
  {0x1F93F, 0x1F93F},
  {0x1F940, 0x1F945},
  {0x1F947, 0x1F94B},
  {0x1F94C, 0x1F94C},
  {0x1F94D, 0x1F94F},
  {0x1F950, 0x1F95E},
  {0x1F95F, 0x1F96B},
  {0x1F96C, 0x1F970},
  {0x1F971, 0x1F971},
  {0x1F972, 0x1F972},
  {0x1F973, 0x1F976},
  {0x1F977, 0x1F978},
  {0x1F97A, 0x1F97A},
  {0x1F97B, 0x1F97B},
  {0x1F97C, 0x1F97F},
  {0x1F980, 0x1F984},
  {0x1F985, 0x1F991},
  {0x1F992, 0x1F997},
  {0x1F998, 0x1F9A2},
  {0x1F9A3, 0x1F9A4},
  {0x1F9A5, 0x1F9AA},
  {0x1F9AB, 0x1F9AD},
  {0x1F9AE, 0x1F9AF},
  {0x1F9B0, 0x1F9B9},
  {0x1F9BA, 0x1F9BF},
  {0x1F9C0, 0x1F9C0},
  {0x1F9C1, 0x1F9C2},
  {0x1F9C3, 0x1F9CA},
  {0x1F9CB, 0x1F9CB},
  {0x1F9CD, 0x1F9CF},
  {0x1F9D0, 0x1F9E6},
  {0x1F9E7, 0x1F9FF},
  {0x1FA70, 0x1FA73},
  {0x1FA74, 0x1FA74},
  {0x1FA78, 0x1FA7A},
  {0x1FA80, 0x1FA82},
  {0x1FA83, 0x1FA86},
  {0x1FA90, 0x1FA95},
  {0x1FA96, 0x1FAA8},
  {0x1FAB0, 0x1FAB6},
  {0x1FAC0, 0x1FAC2},
  {0x1FAD0, 0x1FAD6},
};

static const struct Interval _pango_Emoji_Presentation_table[] =
{
  {0x231A, 0x231B},
  {0x23E9, 0x23EC},
  {0x23F0, 0x23F0},
  {0x23F3, 0x23F3},
  {0x25FD, 0x25FE},
  {0x2614, 0x2615},
  {0x2648, 0x2653},
  {0x267F, 0x267F},
  {0x2693, 0x2693},
  {0x26A1, 0x26A1},
  {0x26AA, 0x26AB},
  {0x26BD, 0x26BE},
  {0x26C4, 0x26C5},
  {0x26CE, 0x26CE},
  {0x26D4, 0x26D4},
  {0x26EA, 0x26EA},
  {0x26F2, 0x26F3},
  {0x26F5, 0x26F5},
  {0x26FA, 0x26FA},
  {0x26FD, 0x26FD},
  {0x2705, 0x2705},
  {0x270A, 0x270B},
  {0x2728, 0x2728},
  {0x274C, 0x274C},
  {0x274E, 0x274E},
  {0x2753, 0x2755},
  {0x2757, 0x2757},
  {0x2795, 0x2797},
  {0x27B0, 0x27B0},
  {0x27BF, 0x27BF},
  {0x2B1B, 0x2B1C},
  {0x2B50, 0x2B50},
  {0x2B55, 0x2B55},
  {0x1F004, 0x1F004},
  {0x1F0CF, 0x1F0CF},
  {0x1F18E, 0x1F18E},
  {0x1F191, 0x1F19A},
  {0x1F1E6, 0x1F1FF},
  {0x1F201, 0x1F201},
  {0x1F21A, 0x1F21A},
  {0x1F22F, 0x1F22F},
  {0x1F232, 0x1F236},
  {0x1F238, 0x1F23A},
  {0x1F250, 0x1F251},
  {0x1F300, 0x1F30C},
  {0x1F30D, 0x1F30E},
  {0x1F30F, 0x1F30F},
  {0x1F310, 0x1F310},
  {0x1F311, 0x1F311},
  {0x1F312, 0x1F312},
  {0x1F313, 0x1F315},
  {0x1F316, 0x1F318},
  {0x1F319, 0x1F319},
  {0x1F31A, 0x1F31A},
  {0x1F31B, 0x1F31B},
  {0x1F31C, 0x1F31C},
  {0x1F31D, 0x1F31E},
  {0x1F31F, 0x1F320},
  {0x1F32D, 0x1F32F},
  {0x1F330, 0x1F331},
  {0x1F332, 0x1F333},
  {0x1F334, 0x1F335},
  {0x1F337, 0x1F34A},
  {0x1F34B, 0x1F34B},
  {0x1F34C, 0x1F34F},
  {0x1F350, 0x1F350},
  {0x1F351, 0x1F37B},
  {0x1F37C, 0x1F37C},
  {0x1F37E, 0x1F37F},
  {0x1F380, 0x1F393},
  {0x1F3A0, 0x1F3C4},
  {0x1F3C5, 0x1F3C5},
  {0x1F3C6, 0x1F3C6},
  {0x1F3C7, 0x1F3C7},
  {0x1F3C8, 0x1F3C8},
  {0x1F3C9, 0x1F3C9},
  {0x1F3CA, 0x1F3CA},
  {0x1F3CF, 0x1F3D3},
  {0x1F3E0, 0x1F3E3},
  {0x1F3E4, 0x1F3E4},
  {0x1F3E5, 0x1F3F0},
  {0x1F3F4, 0x1F3F4},
  {0x1F3F8, 0x1F407},
  {0x1F408, 0x1F408},
  {0x1F409, 0x1F40B},
  {0x1F40C, 0x1F40E},
  {0x1F40F, 0x1F410},
  {0x1F411, 0x1F412},
  {0x1F413, 0x1F413},
  {0x1F414, 0x1F414},
  {0x1F415, 0x1F415},
  {0x1F416, 0x1F416},
  {0x1F417, 0x1F429},
  {0x1F42A, 0x1F42A},
  {0x1F42B, 0x1F43E},
  {0x1F440, 0x1F440},
  {0x1F442, 0x1F464},
  {0x1F465, 0x1F465},
  {0x1F466, 0x1F46B},
  {0x1F46C, 0x1F46D},
  {0x1F46E, 0x1F4AC},
  {0x1F4AD, 0x1F4AD},
  {0x1F4AE, 0x1F4B5},
  {0x1F4B6, 0x1F4B7},
  {0x1F4B8, 0x1F4EB},
  {0x1F4EC, 0x1F4ED},
  {0x1F4EE, 0x1F4EE},
  {0x1F4EF, 0x1F4EF},
  {0x1F4F0, 0x1F4F4},
  {0x1F4F5, 0x1F4F5},
  {0x1F4F6, 0x1F4F7},
  {0x1F4F8, 0x1F4F8},
  {0x1F4F9, 0x1F4FC},
  {0x1F4FF, 0x1F502},
  {0x1F503, 0x1F503},
  {0x1F504, 0x1F507},
  {0x1F508, 0x1F508},
  {0x1F509, 0x1F509},
  {0x1F50A, 0x1F514},
  {0x1F515, 0x1F515},
  {0x1F516, 0x1F52B},
  {0x1F52C, 0x1F52D},
  {0x1F52E, 0x1F53D},
  {0x1F54B, 0x1F54E},
  {0x1F550, 0x1F55B},
  {0x1F55C, 0x1F567},
  {0x1F57A, 0x1F57A},
  {0x1F595, 0x1F596},
  {0x1F5A4, 0x1F5A4},
  {0x1F5FB, 0x1F5FF},
  {0x1F600, 0x1F600},
  {0x1F601, 0x1F606},
  {0x1F607, 0x1F608},
  {0x1F609, 0x1F60D},
  {0x1F60E, 0x1F60E},
  {0x1F60F, 0x1F60F},
  {0x1F610, 0x1F610},
  {0x1F611, 0x1F611},
  {0x1F612, 0x1F614},
  {0x1F615, 0x1F615},
  {0x1F616, 0x1F616},
  {0x1F617, 0x1F617},
  {0x1F618, 0x1F618},
  {0x1F619, 0x1F619},
  {0x1F61A, 0x1F61A},
  {0x1F61B, 0x1F61B},
  {0x1F61C, 0x1F61E},
  {0x1F61F, 0x1F61F},
  {0x1F620, 0x1F625},
  {0x1F626, 0x1F627},
  {0x1F628, 0x1F62B},
  {0x1F62C, 0x1F62C},
  {0x1F62D, 0x1F62D},
  {0x1F62E, 0x1F62F},
  {0x1F630, 0x1F633},
  {0x1F634, 0x1F634},
  {0x1F635, 0x1F635},
  {0x1F636, 0x1F636},
  {0x1F637, 0x1F640},
  {0x1F641, 0x1F644},
  {0x1F645, 0x1F64F},
  {0x1F680, 0x1F680},
  {0x1F681, 0x1F682},
  {0x1F683, 0x1F685},
  {0x1F686, 0x1F686},
  {0x1F687, 0x1F687},
  {0x1F688, 0x1F688},
  {0x1F689, 0x1F689},
  {0x1F68A, 0x1F68B},
  {0x1F68C, 0x1F68C},
  {0x1F68D, 0x1F68D},
  {0x1F68E, 0x1F68E},
  {0x1F68F, 0x1F68F},
  {0x1F690, 0x1F690},
  {0x1F691, 0x1F693},
  {0x1F694, 0x1F694},
  {0x1F695, 0x1F695},
  {0x1F696, 0x1F696},
  {0x1F697, 0x1F697},
  {0x1F698, 0x1F698},
  {0x1F699, 0x1F69A},
  {0x1F69B, 0x1F6A1},
  {0x1F6A2, 0x1F6A2},
  {0x1F6A3, 0x1F6A3},
  {0x1F6A4, 0x1F6A5},
  {0x1F6A6, 0x1F6A6},
  {0x1F6A7, 0x1F6AD},
  {0x1F6AE, 0x1F6B1},
  {0x1F6B2, 0x1F6B2},
  {0x1F6B3, 0x1F6B5},
  {0x1F6B6, 0x1F6B6},
  {0x1F6B7, 0x1F6B8},
  {0x1F6B9, 0x1F6BE},
  {0x1F6BF, 0x1F6BF},
  {0x1F6C0, 0x1F6C0},
  {0x1F6C1, 0x1F6C5},
  {0x1F6CC, 0x1F6CC},
  {0x1F6D0, 0x1F6D0},
  {0x1F6D1, 0x1F6D2},
  {0x1F6D5, 0x1F6D5},
  {0x1F6D6, 0x1F6D7},
  {0x1F6EB, 0x1F6EC},
  {0x1F6F4, 0x1F6F6},
  {0x1F6F7, 0x1F6F8},
  {0x1F6F9, 0x1F6F9},
  {0x1F6FA, 0x1F6FA},
  {0x1F6FB, 0x1F6FC},
  {0x1F7E0, 0x1F7EB},
  {0x1F90C, 0x1F90C},
  {0x1F90D, 0x1F90F},
  {0x1F910, 0x1F918},
  {0x1F919, 0x1F91E},
  {0x1F91F, 0x1F91F},
  {0x1F920, 0x1F927},
  {0x1F928, 0x1F92F},
  {0x1F930, 0x1F930},
  {0x1F931, 0x1F932},
  {0x1F933, 0x1F93A},
  {0x1F93C, 0x1F93E},
  {0x1F93F, 0x1F93F},
  {0x1F940, 0x1F945},
  {0x1F947, 0x1F94B},
  {0x1F94C, 0x1F94C},
  {0x1F94D, 0x1F94F},
  {0x1F950, 0x1F95E},
  {0x1F95F, 0x1F96B},
  {0x1F96C, 0x1F970},
  {0x1F971, 0x1F971},
  {0x1F972, 0x1F972},
  {0x1F973, 0x1F976},
  {0x1F977, 0x1F978},
  {0x1F97A, 0x1F97A},
  {0x1F97B, 0x1F97B},
  {0x1F97C, 0x1F97F},
  {0x1F980, 0x1F984},
  {0x1F985, 0x1F991},
  {0x1F992, 0x1F997},
  {0x1F998, 0x1F9A2},
  {0x1F9A3, 0x1F9A4},
  {0x1F9A5, 0x1F9AA},
  {0x1F9AB, 0x1F9AD},
  {0x1F9AE, 0x1F9AF},
  {0x1F9B0, 0x1F9B9},
  {0x1F9BA, 0x1F9BF},
  {0x1F9C0, 0x1F9C0},
  {0x1F9C1, 0x1F9C2},
  {0x1F9C3, 0x1F9CA},
  {0x1F9CB, 0x1F9CB},
  {0x1F9CD, 0x1F9CF},
  {0x1F9D0, 0x1F9E6},
  {0x1F9E7, 0x1F9FF},
  {0x1FA70, 0x1FA73},
  {0x1FA74, 0x1FA74},
  {0x1FA78, 0x1FA7A},
  {0x1FA80, 0x1FA82},
  {0x1FA83, 0x1FA86},
  {0x1FA90, 0x1FA95},
  {0x1FA96, 0x1FAA8},
  {0x1FAB0, 0x1FAB6},
  {0x1FAC0, 0x1FAC2},
  {0x1FAD0, 0x1FAD6},
};

static const struct Interval _pango_Emoji_Modifier_table[] =
{
  {0x1F3FB, 0x1F3FF},
};

static const struct Interval _pango_Emoji_Modifier_Base_table[] =
{
  {0x261D, 0x261D},
  {0x26F9, 0x26F9},
  {0x270A, 0x270C},
  {0x270D, 0x270D},
  {0x1F385, 0x1F385},
  {0x1F3C2, 0x1F3C4},
  {0x1F3C7, 0x1F3C7},
  {0x1F3CA, 0x1F3CA},
  {0x1F3CB, 0x1F3CC},
  {0x1F442, 0x1F443},
  {0x1F446, 0x1F450},
  {0x1F466, 0x1F46B},
  {0x1F46C, 0x1F46D},
  {0x1F46E, 0x1F478},
  {0x1F47C, 0x1F47C},
  {0x1F481, 0x1F483},
  {0x1F485, 0x1F487},
  {0x1F48F, 0x1F48F},
  {0x1F491, 0x1F491},
  {0x1F4AA, 0x1F4AA},
  {0x1F574, 0x1F575},
  {0x1F57A, 0x1F57A},
  {0x1F590, 0x1F590},
  {0x1F595, 0x1F596},
  {0x1F645, 0x1F647},
  {0x1F64B, 0x1F64F},
  {0x1F6A3, 0x1F6A3},
  {0x1F6B4, 0x1F6B5},
  {0x1F6B6, 0x1F6B6},
  {0x1F6C0, 0x1F6C0},
  {0x1F6CC, 0x1F6CC},
  {0x1F90C, 0x1F90C},
  {0x1F90F, 0x1F90F},
  {0x1F918, 0x1F918},
  {0x1F919, 0x1F91E},
  {0x1F91F, 0x1F91F},
  {0x1F926, 0x1F926},
  {0x1F930, 0x1F930},
  {0x1F931, 0x1F932},
  {0x1F933, 0x1F939},
  {0x1F93C, 0x1F93E},
  {0x1F977, 0x1F977},
  {0x1F9B5, 0x1F9B6},
  {0x1F9B8, 0x1F9B9},
  {0x1F9BB, 0x1F9BB},
  {0x1F9CD, 0x1F9CF},
  {0x1F9D1, 0x1F9DD},
};

static const struct Interval _pango_Emoji_Component_table[] =
{
  {0x0023, 0x0023},
  {0x002A, 0x002A},
  {0x0030, 0x0039},
  {0x200D, 0x200D},
  {0x20E3, 0x20E3},
  {0xFE0F, 0xFE0F},
  {0x1F1E6, 0x1F1FF},
  {0x1F3FB, 0x1F3FF},
  {0x1F9B0, 0x1F9B3},
  {0xE0020, 0xE007F},
};

static const struct Interval _pango_Extended_Pictographic_table[] =
{
  {0x00A9, 0x00A9},
  {0x00AE, 0x00AE},
  {0x203C, 0x203C},
  {0x2049, 0x2049},
  {0x2122, 0x2122},
  {0x2139, 0x2139},
  {0x2194, 0x2199},
  {0x21A9, 0x21AA},
  {0x231A, 0x231B},
  {0x2328, 0x2328},
  {0x2388, 0x2388},
  {0x23CF, 0x23CF},
  {0x23E9, 0x23EC},
  {0x23ED, 0x23EE},
  {0x23EF, 0x23EF},
  {0x23F0, 0x23F0},
  {0x23F1, 0x23F2},
  {0x23F3, 0x23F3},
  {0x23F8, 0x23FA},
  {0x24C2, 0x24C2},
  {0x25AA, 0x25AB},
  {0x25B6, 0x25B6},
  {0x25C0, 0x25C0},
  {0x25FB, 0x25FE},
  {0x2600, 0x2601},
  {0x2602, 0x2603},
  {0x2604, 0x2604},
  {0x2605, 0x2605},
  {0x2607, 0x260D},
  {0x260E, 0x260E},
  {0x260F, 0x2610},
  {0x2611, 0x2611},
  {0x2612, 0x2612},
  {0x2614, 0x2615},
  {0x2616, 0x2617},
  {0x2618, 0x2618},
  {0x2619, 0x261C},
  {0x261D, 0x261D},
  {0x261E, 0x261F},
  {0x2620, 0x2620},
  {0x2621, 0x2621},
  {0x2622, 0x2623},
  {0x2624, 0x2625},
  {0x2626, 0x2626},
  {0x2627, 0x2629},
  {0x262A, 0x262A},
  {0x262B, 0x262D},
  {0x262E, 0x262E},
  {0x262F, 0x262F},
  {0x2630, 0x2637},
  {0x2638, 0x2639},
  {0x263A, 0x263A},
  {0x263B, 0x263F},
  {0x2640, 0x2640},
  {0x2641, 0x2641},
  {0x2642, 0x2642},
  {0x2643, 0x2647},
  {0x2648, 0x2653},
  {0x2654, 0x265E},
  {0x265F, 0x265F},
  {0x2660, 0x2660},
  {0x2661, 0x2662},
  {0x2663, 0x2663},
  {0x2664, 0x2664},
  {0x2665, 0x2666},
  {0x2667, 0x2667},
  {0x2668, 0x2668},
  {0x2669, 0x267A},
  {0x267B, 0x267B},
  {0x267C, 0x267D},
  {0x267E, 0x267E},
  {0x267F, 0x267F},
  {0x2680, 0x2685},
  {0x2690, 0x2691},
  {0x2692, 0x2692},
  {0x2693, 0x2693},
  {0x2694, 0x2694},
  {0x2695, 0x2695},
  {0x2696, 0x2697},
  {0x2698, 0x2698},
  {0x2699, 0x2699},
  {0x269A, 0x269A},
  {0x269B, 0x269C},
  {0x269D, 0x269F},
  {0x26A0, 0x26A1},
  {0x26A2, 0x26A6},
  {0x26A7, 0x26A7},
  {0x26A8, 0x26A9},
  {0x26AA, 0x26AB},
  {0x26AC, 0x26AF},
  {0x26B0, 0x26B1},
  {0x26B2, 0x26BC},
  {0x26BD, 0x26BE},
  {0x26BF, 0x26C3},
  {0x26C4, 0x26C5},
  {0x26C6, 0x26C7},
  {0x26C8, 0x26C8},
  {0x26C9, 0x26CD},
  {0x26CE, 0x26CE},
  {0x26CF, 0x26CF},
  {0x26D0, 0x26D0},
  {0x26D1, 0x26D1},
  {0x26D2, 0x26D2},
  {0x26D3, 0x26D3},
  {0x26D4, 0x26D4},
  {0x26D5, 0x26E8},
  {0x26E9, 0x26E9},
  {0x26EA, 0x26EA},
  {0x26EB, 0x26EF},
  {0x26F0, 0x26F1},
  {0x26F2, 0x26F3},
  {0x26F4, 0x26F4},
  {0x26F5, 0x26F5},
  {0x26F6, 0x26F6},
  {0x26F7, 0x26F9},
  {0x26FA, 0x26FA},
  {0x26FB, 0x26FC},
  {0x26FD, 0x26FD},
  {0x26FE, 0x2701},
  {0x2702, 0x2702},
  {0x2703, 0x2704},
  {0x2705, 0x2705},
  {0x2708, 0x270C},
  {0x270D, 0x270D},
  {0x270E, 0x270E},
  {0x270F, 0x270F},
  {0x2710, 0x2711},
  {0x2712, 0x2712},
  {0x2714, 0x2714},
  {0x2716, 0x2716},
  {0x271D, 0x271D},
  {0x2721, 0x2721},
  {0x2728, 0x2728},
  {0x2733, 0x2734},
  {0x2744, 0x2744},
  {0x2747, 0x2747},
  {0x274C, 0x274C},
  {0x274E, 0x274E},
  {0x2753, 0x2755},
  {0x2757, 0x2757},
  {0x2763, 0x2763},
  {0x2764, 0x2764},
  {0x2765, 0x2767},
  {0x2795, 0x2797},
  {0x27A1, 0x27A1},
  {0x27B0, 0x27B0},
  {0x27BF, 0x27BF},
  {0x2934, 0x2935},
  {0x2B05, 0x2B07},
  {0x2B1B, 0x2B1C},
  {0x2B50, 0x2B50},
  {0x2B55, 0x2B55},
  {0x3030, 0x3030},
  {0x303D, 0x303D},
  {0x3297, 0x3297},
  {0x3299, 0x3299},
  {0x1F000, 0x1F003},
  {0x1F004, 0x1F004},
  {0x1F005, 0x1F0CE},
  {0x1F0CF, 0x1F0CF},
  {0x1F0D0, 0x1F0FF},
  {0x1F10D, 0x1F10F},
  {0x1F12F, 0x1F12F},
  {0x1F16C, 0x1F16F},
  {0x1F170, 0x1F171},
  {0x1F17E, 0x1F17F},
  {0x1F18E, 0x1F18E},
  {0x1F191, 0x1F19A},
  {0x1F1AD, 0x1F1E5},
  {0x1F201, 0x1F202},
  {0x1F203, 0x1F20F},
  {0x1F21A, 0x1F21A},
  {0x1F22F, 0x1F22F},
  {0x1F232, 0x1F23A},
  {0x1F23C, 0x1F23F},
  {0x1F249, 0x1F24F},
  {0x1F250, 0x1F251},
  {0x1F252, 0x1F2FF},
  {0x1F300, 0x1F30C},
  {0x1F30D, 0x1F30E},
  {0x1F30F, 0x1F30F},
  {0x1F310, 0x1F310},
  {0x1F311, 0x1F311},
  {0x1F312, 0x1F312},
  {0x1F313, 0x1F315},
  {0x1F316, 0x1F318},
  {0x1F319, 0x1F319},
  {0x1F31A, 0x1F31A},
  {0x1F31B, 0x1F31B},
  {0x1F31C, 0x1F31C},
  {0x1F31D, 0x1F31E},
  {0x1F31F, 0x1F320},
  {0x1F321, 0x1F321},
  {0x1F322, 0x1F323},
  {0x1F324, 0x1F32C},
  {0x1F32D, 0x1F32F},
  {0x1F330, 0x1F331},
  {0x1F332, 0x1F333},
  {0x1F334, 0x1F335},
  {0x1F336, 0x1F336},
  {0x1F337, 0x1F34A},
  {0x1F34B, 0x1F34B},
  {0x1F34C, 0x1F34F},
  {0x1F350, 0x1F350},
  {0x1F351, 0x1F37B},
  {0x1F37C, 0x1F37C},
  {0x1F37D, 0x1F37D},
  {0x1F37E, 0x1F37F},
  {0x1F380, 0x1F393},
  {0x1F394, 0x1F395},
  {0x1F396, 0x1F397},
  {0x1F398, 0x1F398},
  {0x1F399, 0x1F39B},
  {0x1F39C, 0x1F39D},
  {0x1F39E, 0x1F39F},
  {0x1F3A0, 0x1F3C4},
  {0x1F3C5, 0x1F3C5},
  {0x1F3C6, 0x1F3C6},
  {0x1F3C7, 0x1F3C7},
  {0x1F3C8, 0x1F3C8},
  {0x1F3C9, 0x1F3C9},
  {0x1F3CA, 0x1F3CA},
  {0x1F3CB, 0x1F3CE},
  {0x1F3CF, 0x1F3D3},
  {0x1F3D4, 0x1F3DF},
  {0x1F3E0, 0x1F3E3},
  {0x1F3E4, 0x1F3E4},
  {0x1F3E5, 0x1F3F0},
  {0x1F3F1, 0x1F3F2},
  {0x1F3F3, 0x1F3F3},
  {0x1F3F4, 0x1F3F4},
  {0x1F3F5, 0x1F3F5},
  {0x1F3F6, 0x1F3F6},
  {0x1F3F7, 0x1F3F7},
  {0x1F3F8, 0x1F3FA},
  {0x1F400, 0x1F407},
  {0x1F408, 0x1F408},
  {0x1F409, 0x1F40B},
  {0x1F40C, 0x1F40E},
  {0x1F40F, 0x1F410},
  {0x1F411, 0x1F412},
  {0x1F413, 0x1F413},
  {0x1F414, 0x1F414},
  {0x1F415, 0x1F415},
  {0x1F416, 0x1F416},
  {0x1F417, 0x1F429},
  {0x1F42A, 0x1F42A},
  {0x1F42B, 0x1F43E},
  {0x1F43F, 0x1F43F},
  {0x1F440, 0x1F440},
  {0x1F441, 0x1F441},
  {0x1F442, 0x1F464},
  {0x1F465, 0x1F465},
  {0x1F466, 0x1F46B},
  {0x1F46C, 0x1F46D},
  {0x1F46E, 0x1F4AC},
  {0x1F4AD, 0x1F4AD},
  {0x1F4AE, 0x1F4B5},
  {0x1F4B6, 0x1F4B7},
  {0x1F4B8, 0x1F4EB},
  {0x1F4EC, 0x1F4ED},
  {0x1F4EE, 0x1F4EE},
  {0x1F4EF, 0x1F4EF},
  {0x1F4F0, 0x1F4F4},
  {0x1F4F5, 0x1F4F5},
  {0x1F4F6, 0x1F4F7},
  {0x1F4F8, 0x1F4F8},
  {0x1F4F9, 0x1F4FC},
  {0x1F4FD, 0x1F4FD},
  {0x1F4FE, 0x1F4FE},
  {0x1F4FF, 0x1F502},
  {0x1F503, 0x1F503},
  {0x1F504, 0x1F507},
  {0x1F508, 0x1F508},
  {0x1F509, 0x1F509},
  {0x1F50A, 0x1F514},
  {0x1F515, 0x1F515},
  {0x1F516, 0x1F52B},
  {0x1F52C, 0x1F52D},
  {0x1F52E, 0x1F53D},
  {0x1F546, 0x1F548},
  {0x1F549, 0x1F54A},
  {0x1F54B, 0x1F54E},
  {0x1F54F, 0x1F54F},
  {0x1F550, 0x1F55B},
  {0x1F55C, 0x1F567},
  {0x1F568, 0x1F56E},
  {0x1F56F, 0x1F570},
  {0x1F571, 0x1F572},
  {0x1F573, 0x1F579},
  {0x1F57A, 0x1F57A},
  {0x1F57B, 0x1F586},
  {0x1F587, 0x1F587},
  {0x1F588, 0x1F589},
  {0x1F58A, 0x1F58D},
  {0x1F58E, 0x1F58F},
  {0x1F590, 0x1F590},
  {0x1F591, 0x1F594},
  {0x1F595, 0x1F596},
  {0x1F597, 0x1F5A3},
  {0x1F5A4, 0x1F5A4},
  {0x1F5A5, 0x1F5A5},
  {0x1F5A6, 0x1F5A7},
  {0x1F5A8, 0x1F5A8},
  {0x1F5A9, 0x1F5B0},
  {0x1F5B1, 0x1F5B2},
  {0x1F5B3, 0x1F5BB},
  {0x1F5BC, 0x1F5BC},
  {0x1F5BD, 0x1F5C1},
  {0x1F5C2, 0x1F5C4},
  {0x1F5C5, 0x1F5D0},
  {0x1F5D1, 0x1F5D3},
  {0x1F5D4, 0x1F5DB},
  {0x1F5DC, 0x1F5DE},
  {0x1F5DF, 0x1F5E0},
  {0x1F5E1, 0x1F5E1},
  {0x1F5E2, 0x1F5E2},
  {0x1F5E3, 0x1F5E3},
  {0x1F5E4, 0x1F5E7},
  {0x1F5E8, 0x1F5E8},
  {0x1F5E9, 0x1F5EE},
  {0x1F5EF, 0x1F5EF},
  {0x1F5F0, 0x1F5F2},
  {0x1F5F3, 0x1F5F3},
  {0x1F5F4, 0x1F5F9},
  {0x1F5FA, 0x1F5FA},
  {0x1F5FB, 0x1F5FF},
  {0x1F600, 0x1F600},
  {0x1F601, 0x1F606},
  {0x1F607, 0x1F608},
  {0x1F609, 0x1F60D},
  {0x1F60E, 0x1F60E},
  {0x1F60F, 0x1F60F},
  {0x1F610, 0x1F610},
  {0x1F611, 0x1F611},
  {0x1F612, 0x1F614},
  {0x1F615, 0x1F615},
  {0x1F616, 0x1F616},
  {0x1F617, 0x1F617},
  {0x1F618, 0x1F618},
  {0x1F619, 0x1F619},
  {0x1F61A, 0x1F61A},
  {0x1F61B, 0x1F61B},
  {0x1F61C, 0x1F61E},
  {0x1F61F, 0x1F61F},
  {0x1F620, 0x1F625},
  {0x1F626, 0x1F627},
  {0x1F628, 0x1F62B},
  {0x1F62C, 0x1F62C},
  {0x1F62D, 0x1F62D},
  {0x1F62E, 0x1F62F},
  {0x1F630, 0x1F633},
  {0x1F634, 0x1F634},
  {0x1F635, 0x1F635},
  {0x1F636, 0x1F636},
  {0x1F637, 0x1F640},
  {0x1F641, 0x1F644},
  {0x1F645, 0x1F64F},
  {0x1F680, 0x1F680},
  {0x1F681, 0x1F682},
  {0x1F683, 0x1F685},
  {0x1F686, 0x1F686},
  {0x1F687, 0x1F687},
  {0x1F688, 0x1F688},
  {0x1F689, 0x1F689},
  {0x1F68A, 0x1F68B},
  {0x1F68C, 0x1F68C},
  {0x1F68D, 0x1F68D},
  {0x1F68E, 0x1F68E},
  {0x1F68F, 0x1F68F},
  {0x1F690, 0x1F690},
  {0x1F691, 0x1F693},
  {0x1F694, 0x1F694},
  {0x1F695, 0x1F695},
  {0x1F696, 0x1F696},
  {0x1F697, 0x1F697},
  {0x1F698, 0x1F698},
  {0x1F699, 0x1F69A},
  {0x1F69B, 0x1F6A1},
  {0x1F6A2, 0x1F6A2},
  {0x1F6A3, 0x1F6A3},
  {0x1F6A4, 0x1F6A5},
  {0x1F6A6, 0x1F6A6},
  {0x1F6A7, 0x1F6AD},
  {0x1F6AE, 0x1F6B1},
  {0x1F6B2, 0x1F6B2},
  {0x1F6B3, 0x1F6B5},
  {0x1F6B6, 0x1F6B6},
  {0x1F6B7, 0x1F6B8},
  {0x1F6B9, 0x1F6BE},
  {0x1F6BF, 0x1F6BF},
  {0x1F6C0, 0x1F6C0},
  {0x1F6C1, 0x1F6C5},
  {0x1F6C6, 0x1F6CA},
  {0x1F6CB, 0x1F6CB},
  {0x1F6CC, 0x1F6CC},
  {0x1F6CD, 0x1F6CF},
  {0x1F6D0, 0x1F6D0},
  {0x1F6D1, 0x1F6D2},
  {0x1F6D3, 0x1F6D4},
  {0x1F6D5, 0x1F6D5},
  {0x1F6D6, 0x1F6D7},
  {0x1F6D8, 0x1F6DF},
  {0x1F6E0, 0x1F6E5},
  {0x1F6E6, 0x1F6E8},
  {0x1F6E9, 0x1F6E9},
  {0x1F6EA, 0x1F6EA},
  {0x1F6EB, 0x1F6EC},
  {0x1F6ED, 0x1F6EF},
  {0x1F6F0, 0x1F6F0},
  {0x1F6F1, 0x1F6F2},
  {0x1F6F3, 0x1F6F3},
  {0x1F6F4, 0x1F6F6},
  {0x1F6F7, 0x1F6F8},
  {0x1F6F9, 0x1F6F9},
  {0x1F6FA, 0x1F6FA},
  {0x1F6FB, 0x1F6FC},
  {0x1F6FD, 0x1F6FF},
  {0x1F774, 0x1F77F},
  {0x1F7D5, 0x1F7DF},
  {0x1F7E0, 0x1F7EB},
  {0x1F7EC, 0x1F7FF},
  {0x1F80C, 0x1F80F},
  {0x1F848, 0x1F84F},
  {0x1F85A, 0x1F85F},
  {0x1F888, 0x1F88F},
  {0x1F8AE, 0x1F8FF},
  {0x1F90C, 0x1F90C},
  {0x1F90D, 0x1F90F},
  {0x1F910, 0x1F918},
  {0x1F919, 0x1F91E},
  {0x1F91F, 0x1F91F},
  {0x1F920, 0x1F927},
  {0x1F928, 0x1F92F},
  {0x1F930, 0x1F930},
  {0x1F931, 0x1F932},
  {0x1F933, 0x1F93A},
  {0x1F93C, 0x1F93E},
  {0x1F93F, 0x1F93F},
  {0x1F940, 0x1F945},
  {0x1F947, 0x1F94B},
  {0x1F94C, 0x1F94C},
  {0x1F94D, 0x1F94F},
  {0x1F950, 0x1F95E},
  {0x1F95F, 0x1F96B},
  {0x1F96C, 0x1F970},
  {0x1F971, 0x1F971},
  {0x1F972, 0x1F972},
  {0x1F973, 0x1F976},
  {0x1F977, 0x1F978},
  {0x1F979, 0x1F979},
  {0x1F97A, 0x1F97A},
  {0x1F97B, 0x1F97B},
  {0x1F97C, 0x1F97F},
  {0x1F980, 0x1F984},
  {0x1F985, 0x1F991},
  {0x1F992, 0x1F997},
  {0x1F998, 0x1F9A2},
  {0x1F9A3, 0x1F9A4},
  {0x1F9A5, 0x1F9AA},
  {0x1F9AB, 0x1F9AD},
  {0x1F9AE, 0x1F9AF},
  {0x1F9B0, 0x1F9B9},
  {0x1F9BA, 0x1F9BF},
  {0x1F9C0, 0x1F9C0},
  {0x1F9C1, 0x1F9C2},
  {0x1F9C3, 0x1F9CA},
  {0x1F9CB, 0x1F9CB},
  {0x1F9CC, 0x1F9CC},
  {0x1F9CD, 0x1F9CF},
  {0x1F9D0, 0x1F9E6},
  {0x1F9E7, 0x1F9FF},
  {0x1FA00, 0x1FA6F},
  {0x1FA70, 0x1FA73},
  {0x1FA74, 0x1FA74},
  {0x1FA75, 0x1FA77},
  {0x1FA78, 0x1FA7A},
  {0x1FA7B, 0x1FA7F},
  {0x1FA80, 0x1FA82},
  {0x1FA83, 0x1FA86},
  {0x1FA87, 0x1FA8F},
  {0x1FA90, 0x1FA95},
  {0x1FA96, 0x1FAA8},
  {0x1FAA9, 0x1FAAF},
  {0x1FAB0, 0x1FAB6},
  {0x1FAB7, 0x1FABF},
  {0x1FAC0, 0x1FAC2},
  {0x1FAC3, 0x1FACF},
  {0x1FAD0, 0x1FAD6},
  {0x1FAD7, 0x1FAFF},
  {0x1FC00, 0x1FFFD},
};

#endif /* PANGO_EMOJI_TABLE_H */

/* == End of generated table == */
