# How to update Node.js in Fedora

## Determine the Node.js version
Monitor the [Node.js Blog](https://nodejs.org/en/blog/) to be notified of
available updates.

For simplicity and copy-and-paste of instructions below, set some variables
here:

```
NODEJS_MAJOR=12
NODEJS_VERSION=12.9.0
```

## Clone the Fedora package repository
These steps assume that you are a comaintainer of Node.js or a provenpackager
in Fedora.

```
fedpkg clone nodejs nodejs-fedora
```

Next, switch to the major version branch you are going to update. We'll use
Node.js 12.9.0 in this document. Adjust the versions appropriately for the
version you are working on.

```
pushd nodejs-fedora
fedpkg switch-branch $NODEJS_MAJOR
popd
```


## Clone the Fedora Module repository

```
fedpkg clone modules/nodejs nodejs-fedora-module
```


## Clone the upstream Node.js repository
```
git clone -o upstream git://github.com/nodejs/node.git nodejs-upstream
```


## Rebase the Fedora patches atop the latest release

```
pushd nodejs-upstream
git checkout -b fedora-v$NODEJS_VERSION v$NODEJS_VERSION
git am -3 ../nodejs-fedora/*.patch
```

If the patches do not apply cleanly, resolve the merges appropriately. Once
they have all been applied, output them again:

```
git format-patch -M --patience --full-index -o ../nodejs-fedora v$NODEJS_VERSION..HEAD
popd
```


## Update the Node.js tarball and specfile

```
pushd nodejs-fedora
./nodejs-tarball.sh $NODEJS_VERSION
```

Note that this command will also output all of the versions for the software
bundled with Node.js. You will need to edit `nodejs.spec` and update the
%global values near the top of that file to include the appropriate values
matching the dependencies. Make sure to also update the Node.js versions too!

Note that if libuv is updated, you need to ensure that the libuv in each
buildroot is of a sufficient version. If not, you may need to update that
package first and submit a buildroot override.

Update the RPM spec %changelog appropriately.


## (Preferred) Perform a scratch-build on at least one architecture

```
fedpkg scratch-build [--arches x86_64] --srpm
```

Verify that it built successfully.


## Push the changes up to Fedora
```
fedpkg commit -cs
fedpkg push
popd
```


## (Optional) Build for Fedora releases

If this major version is the default for one or more Fedora releases, build it
for them. (Note: this step will go away in the future, once module default
streams are available in the non-modular buildroot.)

In the case of Node.js 12.x, this is the default version for Fedora 31 and 32.

```
pushd nodejs-fedora
fedpkg switch-branch [master|31]
git merge $NODEJS_MAJOR
fedpkg push
fedpkg build
popd
```

## Build module stream

```
pushd nodejs-fedora-module
fedpkg switch-branch $NODEJS_MAJOR
```

If the module has changed any package dependencies (such as added a dep on a
new shared library), you may need to modify nodejs.yaml here. If not, you can
simply run:

```
git commit --allow-empty -sm "Update to $NODEJS_VERSION"
fedpkg push
fedpkg module-build
popd
```

## Submit built packages to Bodhi
Follow the usual processes for stable/branched releases to submit builds for
testing.
