.TH MT 1 "April 2008" \" -*- nroff -*-
.SH NAME
mt \- control magnetic tape drive operation
.SH SYNOPSIS
.B mt
[\-h] [\-f device] operation [count] [arguments...]
.SH DESCRIPTION
This manual page documents the tape control program
.BR mt .
.B mt
performs the given
.IR operation ,
which must be one of the tape operations listed below, on a tape
drive. The commands can also be listed by running the program with the
.I \-h
option. The version of mt is printed with the
.I \-v
or
.I \-\-version
option. The path of the tape device on which to operate can be given with
the
.I \-f
or
.I \-t
option.  If neither of those options is given, and the environment
variable
.B TAPE
is set, it is used.  Otherwise, a default device defined in the file
.I /usr/include/sys/mtio.h
is used.
.PP
Some operations optionally take an argument or repeat count, which can be given
after the operation name and defaults to 1. The postfix
.I k
,
.I M
, or
.I G
can be used to give counts in units of 1024, 1024 * 1024, or 1024 *
1024 * 1024, respectively.
.PP
The available operations are listed below.  Unique abbreviations are
accepted.  Not all operations are available on all systems, or work on
all types of tape drives.
.IP fsf
Forward space
.I count
files.
The tape is positioned on the first block of the next file.
.IP fsfm
Forward space past
.I count
file marks, then backward space one file record.
This leaves the tape positioned on the last block of the file that is count-1
files past the current file.
.IP bsf
Backward space
.I count
files.
The tape is positioned on the last block of the previous file.
.IP bsfm
Backward space past
.I count
file marks, then forward space one file record.
This leaves the tape positioned on the first block of the file that is count-1
files before the current file.
.IP asf
The tape is positioned at the beginning of the
.I count
file. Positioning is done by first rewinding the tape and then spacing
forward over
.I count
filemarks.
.IP fsr
Forward space
.I count
records.
.IP bsr
Backward space
.I count
records.
.IP fss
(SCSI tapes) Forward space
.I count
setmarks.
.IP bss
(SCSI tapes) Backward space
.I count
setmarks.
.IP "eod, seod"
Space to end of valid data.  Used on streamer tape
drives to append data to the logical end of tape.
.IP rewind
Rewind the tape.
.IP "offline, rewoffl, eject"
Rewind the tape and, if applicable, unload the tape.
.IP retension
Rewind the tape, then wind it to the end of the reel,
then rewind it again.
.IP "weof, eof"
Write
.I count
EOF marks at current position.
.IP "wset"
(SCSI tapes) Write
.I count
setmarks at current position (only SCSI tape).
.IP erase
Erase the tape.
.IP status
Print status information about the tape unit. (If the density code is
"no translation" in the status output, this does not affect working of the
tape drive.)
.IP seek
(SCSI tapes) Seek to the
.I count
block on the tape.  This operation is available on some
Tandberg and Wangtek streamers and some SCSI-2 tape drives. The block
address should be obtained from a
.I tell
call earlier.
.IP tell
(SCSI tapes) Tell the current block on tape.  This operation is available on some
Tandberg and Wangtek streamers and some SCSI-2 tape drives.
.IP setpartition
(SCSI tapes) Switch to the partition determined by
.I count.
The default data partition of the tape is numbered zero. Switching
partition is available only if enabled for the device, the device
supports multiple partitions, and the tape is formatted with multiple
partitions.
.IP partseek
(SCSI tapes) The tape position is set to block
.I count
in the partition given by the argument after count. The default
partition is zero.
.IP mkpartition
(SCSI tapes) Format the tape with one (count is zero) or two partitions
(count gives the size of the second partition in megabytes). The tape
drive must be able to format partitioned tapes with
initiator-specified partition size and partition support
must be enabled for the drive.
.IP load
(SCSI tapes) Send the load command to the tape drive. The drives usually load the
tape when a new cartridge is inserted. The argument
.I count
can usually be omitted. Some HP changers load tape n if the
.I count
10000 + n is given (a special funtion in the Linux st driver).
.IP lock
(SCSI tapes) Lock the tape drive door.
.IP unlock
(SCSI tapes) Unlock the tape drive door.
.IP setblk
(SCSI tapes) Set the block size of the drive to
.I count
bytes per record.
.IP setdensity
(SCSI tapes) Set the tape density code to
.I count.
The proper codes to use with each drive should be looked up from the
drive documentation.
.IP densities
(SCSI tapes) Write explanation of some common density codes to
standard output.
.IP drvbuffer
(SCSI tapes) Set the tape drive buffer code to
.I number.
The proper value for unbuffered operation is zero and "normal" buffered
operation one. The meanings of other values can be found in the drive
documentation or, in the case of a SCSI-2 drive, from the SCSI-2 standard.
.IP compression
(SCSI tapes) The compression within the drive can be switched on or
off using the MTCOMPRESSION ioctl. Note that this method is not
supported by all drives implementing compression. For instance, the
Exabyte 8 mm drives use density codes to select compression.
.IP stoptions
(SCSI tapes) Set the driver options bits for the device to the defined
values. Allowed only for the superuser. The bits can be set
either by ORing the option bits from the file /usr/include/linux/mtio.h to
.I count,
or by using the following keywords (as many keywords can be used on
the same line as necessary, unambiguous abbreviations allowed):
.RS
.IP buffer-writes 15
buffered writes enabled
.IP async-writes
asynchronous writes enabled
.IP read-ahead
read-ahead for fixed block size
.IP debug
debugging (if compiled into driver)
.IP two-fms
write two filemarks when file closed
.IP fast-eod
space directly to eod (and lose file number)
.IP no-wait
don't wait until rewind, etc. complete
.IP auto-lock
automatically lock/unlock drive door
.IP def-writes
the block size and density are for writes
.IP can-bsr
drive can space backwards as well
.IP no-blklimits
drive doesn't support read block limits
.IP can-partitions
drive can handle partitioned tapes
.IP scsi2logical
seek and tell use SCSI-2 logical block addresses instead of device
dependent addresses
.IP sili
Set the SILI bit is when reading in variable block mode. This may speed up
reading blocks shorter than the read byte count. Set this option only if
you know that the drive supports SILI and the HBA reliably returns transfer
residual byte counts. Requires kernel version >= 2.6.26.
.IP sysv
enable the System V semantics
.RE
.IP stsetoptions
(SCSI tapes) Set selected driver options bits.
The methods to specify the bits to set are given above in the
description of
.BR stoptions.
Allowed only for the superuser.
.IP stclearoptions
(SCSI tapes) Clear selected driver option bits.
The methods to specify the bits to clear are given above in description of
.BR stoptions.
Allowed only for the superuser.
.IP stshowoptions
(SCSI tapes) Print the currently enabled options for the device. Requires
kernel version >= 2.6.26 and sysfs must be mounted at /sys.
.IP stwrthreshold
(SCSI tapes) The write threshold for the tape device is set to
.I count
kilobytes. The value must be smaller than or equal to the driver
buffer size. Allowed only for the superuser.
.IP defblksize
(SCSI tapes) Set the default block size of the device to
.I count
bytes. The value -1 disables the default block size.
The block size set by
.I setblk
overrides the default until a new tape is inserted.
Allowed only for the superuser.
.IP defdensity
(SCSI tapes) Set the default density code. The value -1 disables the
default density. The density set by
.I setdensity
overrides the default until a new tape is inserted. Allowed only for the
superuser.
.IP defdrvbuffer
(SCSI tapes) Set the default drive buffer code. The value -1 disables the
default drive buffer code. The drive buffer code set by
.I drvbuffer
overrides the default until a new tape is inserted. Allowed only for the
superuser.
.IP defcompression
(SCSI tapes) Set the default compression state. The value -1 disables the
default compression. The compression state set by
.I compression
overrides the default until a new tape is inserted. Allowed only for the
superuser.
.IP sttimeout
sets the normal timeout for the device. The value is given in
seconds. Allowed only for the superuser.
.IP stlongtimeout
sets the long timeout for the device. The value is given in
seconds. Allowed only for the superuser.
.IP stsetcln
set the cleaning request interpretation parameters.
.PP
.B mt
exits with a status of 0 if the operation succeeded, 1 if the
operation or device name given was invalid, or 2 if the operation
failed.
.SH AUTHOR
The program is written by Kai Makisara <Kai.Makisara@kolumbus.fi>.
.SH COPYRIGHT
The program and the manual page are copyrighted by Kai Makisara, 1998-2008.
They can be distributed according to the GNU Copyleft.
.SH SEE ALSO
st(4)
