; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -loop-unroll -unroll-runtime %s -o - | FileCheck %s
; RUN: opt -S -loop-unroll -unroll-runtime -unroll-max-upperbound=6 %s -o - | FileCheck %s --check-prefix=UPPER

target datalayout = "e-m:e-p:32:32-i64:64-v128:64:128-a:0:32-n32-S64"

@global = dso_local local_unnamed_addr global i32 0, align 4
@global.1 = dso_local local_unnamed_addr global i8* null, align 4

; Check that loop in hoge_3, with a runtime upperbound of 3, is not unrolled.
define dso_local void @hoge_3(i8 %arg) {
; CHECK-LABEL: @hoge_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = load i32, i32* @global, align 4
; CHECK-NEXT:    [[Y:%.*]] = load i8*, i8** @global.1, align 4
; CHECK-NEXT:    [[TMP0:%.*]] = icmp ult i32 [[X]], 17
; CHECK-NEXT:    br i1 [[TMP0]], label [[LOOP_PREHEADER:%.*]], label [[EXIT:%.*]]
; CHECK:       loop.preheader:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_NEXT:%.*]], [[LOOP]] ], [ [[X]], [[LOOP_PREHEADER]] ]
; CHECK-NEXT:    [[PTR:%.*]] = phi i8* [ [[PTR_NEXT:%.*]], [[LOOP]] ], [ [[Y]], [[LOOP_PREHEADER]] ]
; CHECK-NEXT:    [[IV_NEXT]] = add nuw i32 [[IV]], 8
; CHECK-NEXT:    [[PTR_NEXT]] = getelementptr inbounds i8, i8* [[PTR]], i32 1
; CHECK-NEXT:    store i8 [[ARG:%.*]], i8* [[PTR_NEXT]], align 1
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i32 [[IV_NEXT]], 17
; CHECK-NEXT:    br i1 [[TMP1]], label [[LOOP]], label [[EXIT_LOOPEXIT:%.*]]
; CHECK:       exit.loopexit:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
; UPPER-LABEL: @hoge_3(
; UPPER-NEXT:  entry:
; UPPER-NEXT:    [[X:%.*]] = load i32, i32* @global, align 4
; UPPER-NEXT:    [[Y:%.*]] = load i8*, i8** @global.1, align 4
; UPPER-NEXT:    [[TMP0:%.*]] = icmp ult i32 [[X]], 17
; UPPER-NEXT:    br i1 [[TMP0]], label [[LOOP_PREHEADER:%.*]], label [[EXIT:%.*]]
; UPPER:       loop.preheader:
; UPPER-NEXT:    br label [[LOOP:%.*]]
; UPPER:       loop:
; UPPER-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_NEXT:%.*]], [[LOOP]] ], [ [[X]], [[LOOP_PREHEADER]] ]
; UPPER-NEXT:    [[PTR:%.*]] = phi i8* [ [[PTR_NEXT:%.*]], [[LOOP]] ], [ [[Y]], [[LOOP_PREHEADER]] ]
; UPPER-NEXT:    [[IV_NEXT]] = add nuw i32 [[IV]], 8
; UPPER-NEXT:    [[PTR_NEXT]] = getelementptr inbounds i8, i8* [[PTR]], i32 1
; UPPER-NEXT:    store i8 [[ARG:%.*]], i8* [[PTR_NEXT]], align 1
; UPPER-NEXT:    [[TMP1:%.*]] = icmp ult i32 [[IV_NEXT]], 17
; UPPER-NEXT:    br i1 [[TMP1]], label [[LOOP]], label [[EXIT_LOOPEXIT:%.*]]
; UPPER:       exit.loopexit:
; UPPER-NEXT:    br label [[EXIT]]
; UPPER:       exit:
; UPPER-NEXT:    ret void
;
entry:
  %x = load i32, i32* @global, align 4
  %y = load i8*, i8** @global.1, align 4
  %0 = icmp ult i32 %x, 17
  br i1 %0, label %loop, label %exit

loop:
  %iv = phi i32 [ %x, %entry ], [ %iv.next, %loop ]
  %ptr = phi i8* [ %y, %entry ], [ %ptr.next, %loop ]
  %iv.next = add nuw i32 %iv, 8
  %ptr.next = getelementptr inbounds i8, i8* %ptr, i32 1
  store i8 %arg, i8* %ptr.next, align 1
  %1 = icmp ult i32 %iv.next, 17
  br i1 %1, label %loop, label %exit

exit:
  ret void
}

; Check that loop in hoge_5, with a runtime upperbound of 5, is unrolled when -unroll-max-upperbound=4
define dso_local void @hoge_5(i8 %arg) {
; CHECK-LABEL: @hoge_5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = load i32, i32* @global, align 4
; CHECK-NEXT:    [[Y:%.*]] = load i8*, i8** @global.1, align 4
; CHECK-NEXT:    [[TMP0:%.*]] = icmp ult i32 [[X]], 17
; CHECK-NEXT:    br i1 [[TMP0]], label [[LOOP_PREHEADER:%.*]], label [[EXIT:%.*]]
; CHECK:       loop.preheader:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_NEXT:%.*]], [[LOOP]] ], [ [[X]], [[LOOP_PREHEADER]] ]
; CHECK-NEXT:    [[PTR:%.*]] = phi i8* [ [[PTR_NEXT:%.*]], [[LOOP]] ], [ [[Y]], [[LOOP_PREHEADER]] ]
; CHECK-NEXT:    [[IV_NEXT]] = add nuw i32 [[IV]], 4
; CHECK-NEXT:    [[PTR_NEXT]] = getelementptr inbounds i8, i8* [[PTR]], i32 1
; CHECK-NEXT:    store i8 [[ARG:%.*]], i8* [[PTR_NEXT]], align 1
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i32 [[IV_NEXT]], 17
; CHECK-NEXT:    br i1 [[TMP1]], label [[LOOP]], label [[EXIT_LOOPEXIT:%.*]]
; CHECK:       exit.loopexit:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
; UPPER-LABEL: @hoge_5(
; UPPER-NEXT:  entry:
; UPPER-NEXT:    [[X:%.*]] = load i32, i32* @global, align 4
; UPPER-NEXT:    [[Y:%.*]] = load i8*, i8** @global.1, align 4
; UPPER-NEXT:    [[TMP0:%.*]] = icmp ult i32 [[X]], 17
; UPPER-NEXT:    br i1 [[TMP0]], label [[LOOP_PREHEADER:%.*]], label [[EXIT:%.*]]
; UPPER:       loop.preheader:
; UPPER-NEXT:    [[TMP1:%.*]] = sub i32 16, [[X]]
; UPPER-NEXT:    [[TMP2:%.*]] = lshr i32 [[TMP1]], 2
; UPPER-NEXT:    [[TMP3:%.*]] = add nuw nsw i32 [[TMP2]], 1
; UPPER-NEXT:    [[TMP4:%.*]] = urem i32 [[TMP2]], 6
; UPPER-NEXT:    [[TMP5:%.*]] = add i32 [[TMP4]], 1
; UPPER-NEXT:    [[XTRAITER:%.*]] = urem i32 [[TMP5]], 6
; UPPER-NEXT:    [[LCMP_MOD:%.*]] = icmp ne i32 [[XTRAITER]], 0
; UPPER-NEXT:    br i1 [[LCMP_MOD]], label [[LOOP_PROL_PREHEADER:%.*]], label [[LOOP_PROL_LOOPEXIT:%.*]]
; UPPER:       loop.prol.preheader:
; UPPER-NEXT:    br label [[LOOP_PROL:%.*]]
; UPPER:       loop.prol:
; UPPER-NEXT:    [[IV_PROL:%.*]] = phi i32 [ [[IV_NEXT_PROL:%.*]], [[LOOP_PROL]] ], [ [[X]], [[LOOP_PROL_PREHEADER]] ]
; UPPER-NEXT:    [[PTR_PROL:%.*]] = phi i8* [ [[PTR_NEXT_PROL:%.*]], [[LOOP_PROL]] ], [ [[Y]], [[LOOP_PROL_PREHEADER]] ]
; UPPER-NEXT:    [[PROL_ITER:%.*]] = phi i32 [ [[XTRAITER]], [[LOOP_PROL_PREHEADER]] ], [ [[PROL_ITER_SUB:%.*]], [[LOOP_PROL]] ]
; UPPER-NEXT:    [[IV_NEXT_PROL]] = add nuw i32 [[IV_PROL]], 4
; UPPER-NEXT:    [[PTR_NEXT_PROL]] = getelementptr inbounds i8, i8* [[PTR_PROL]], i32 1
; UPPER-NEXT:    store i8 [[ARG:%.*]], i8* [[PTR_NEXT_PROL]], align 1
; UPPER-NEXT:    [[TMP6:%.*]] = icmp ult i32 [[IV_NEXT_PROL]], 17
; UPPER-NEXT:    [[PROL_ITER_SUB]] = sub i32 [[PROL_ITER]], 1
; UPPER-NEXT:    [[PROL_ITER_CMP:%.*]] = icmp ne i32 [[PROL_ITER_SUB]], 0
; UPPER-NEXT:    br i1 [[PROL_ITER_CMP]], label [[LOOP_PROL]], label [[LOOP_PROL_LOOPEXIT_UNR_LCSSA:%.*]], [[LOOP0:!llvm.loop !.*]]
; UPPER:       loop.prol.loopexit.unr-lcssa:
; UPPER-NEXT:    [[IV_UNR_PH:%.*]] = phi i32 [ [[IV_NEXT_PROL]], [[LOOP_PROL]] ]
; UPPER-NEXT:    [[PTR_UNR_PH:%.*]] = phi i8* [ [[PTR_NEXT_PROL]], [[LOOP_PROL]] ]
; UPPER-NEXT:    br label [[LOOP_PROL_LOOPEXIT]]
; UPPER:       loop.prol.loopexit:
; UPPER-NEXT:    [[IV_UNR:%.*]] = phi i32 [ [[X]], [[LOOP_PREHEADER]] ], [ [[IV_UNR_PH]], [[LOOP_PROL_LOOPEXIT_UNR_LCSSA]] ]
; UPPER-NEXT:    [[PTR_UNR:%.*]] = phi i8* [ [[Y]], [[LOOP_PREHEADER]] ], [ [[PTR_UNR_PH]], [[LOOP_PROL_LOOPEXIT_UNR_LCSSA]] ]
; UPPER-NEXT:    [[TMP7:%.*]] = icmp ult i32 [[TMP2]], 5
; UPPER-NEXT:    br i1 [[TMP7]], label [[EXIT_LOOPEXIT:%.*]], label [[LOOP_PREHEADER_NEW:%.*]]
; UPPER:       loop.preheader.new:
; UPPER-NEXT:    br label [[LOOP:%.*]]
; UPPER:       loop:
; UPPER-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_UNR]], [[LOOP_PREHEADER_NEW]] ], [ [[IV_NEXT_5:%.*]], [[LOOP]] ]
; UPPER-NEXT:    [[PTR:%.*]] = phi i8* [ [[PTR_UNR]], [[LOOP_PREHEADER_NEW]] ], [ [[PTR_NEXT_5:%.*]], [[LOOP]] ]
; UPPER-NEXT:    [[IV_NEXT:%.*]] = add nuw i32 [[IV]], 4
; UPPER-NEXT:    [[PTR_NEXT:%.*]] = getelementptr inbounds i8, i8* [[PTR]], i32 1
; UPPER-NEXT:    store i8 [[ARG]], i8* [[PTR_NEXT]], align 1
; UPPER-NEXT:    [[IV_NEXT_1:%.*]] = add nuw i32 [[IV_NEXT]], 4
; UPPER-NEXT:    [[PTR_NEXT_1:%.*]] = getelementptr inbounds i8, i8* [[PTR_NEXT]], i32 1
; UPPER-NEXT:    store i8 [[ARG]], i8* [[PTR_NEXT_1]], align 1
; UPPER-NEXT:    [[IV_NEXT_2:%.*]] = add nuw i32 [[IV_NEXT_1]], 4
; UPPER-NEXT:    [[PTR_NEXT_2:%.*]] = getelementptr inbounds i8, i8* [[PTR_NEXT_1]], i32 1
; UPPER-NEXT:    store i8 [[ARG]], i8* [[PTR_NEXT_2]], align 1
; UPPER-NEXT:    [[IV_NEXT_3:%.*]] = add nuw i32 [[IV_NEXT_2]], 4
; UPPER-NEXT:    [[PTR_NEXT_3:%.*]] = getelementptr inbounds i8, i8* [[PTR_NEXT_2]], i32 1
; UPPER-NEXT:    store i8 [[ARG]], i8* [[PTR_NEXT_3]], align 1
; UPPER-NEXT:    [[IV_NEXT_4:%.*]] = add nuw i32 [[IV_NEXT_3]], 4
; UPPER-NEXT:    [[PTR_NEXT_4:%.*]] = getelementptr inbounds i8, i8* [[PTR_NEXT_3]], i32 1
; UPPER-NEXT:    store i8 [[ARG]], i8* [[PTR_NEXT_4]], align 1
; UPPER-NEXT:    [[IV_NEXT_5]] = add nuw i32 [[IV_NEXT_4]], 4
; UPPER-NEXT:    [[PTR_NEXT_5]] = getelementptr inbounds i8, i8* [[PTR_NEXT_4]], i32 1
; UPPER-NEXT:    store i8 [[ARG]], i8* [[PTR_NEXT_5]], align 1
; UPPER-NEXT:    [[TMP8:%.*]] = icmp ult i32 [[IV_NEXT_5]], 17
; UPPER-NEXT:    br i1 [[TMP8]], label [[LOOP]], label [[EXIT_LOOPEXIT_UNR_LCSSA:%.*]]
; UPPER:       exit.loopexit.unr-lcssa:
; UPPER-NEXT:    br label [[EXIT_LOOPEXIT]]
; UPPER:       exit.loopexit:
; UPPER-NEXT:    br label [[EXIT]]
; UPPER:       exit:
; UPPER-NEXT:    ret void
;
entry:
  %x = load i32, i32* @global, align 4
  %y = load i8*, i8** @global.1, align 4
  %0 = icmp ult i32 %x, 17
  br i1 %0, label %loop, label %exit

loop:
  %iv = phi i32 [ %x, %entry ], [ %iv.next, %loop ]
  %ptr = phi i8* [ %y, %entry ], [ %ptr.next, %loop ]
  %iv.next = add nuw i32 %iv, 4
  %ptr.next = getelementptr inbounds i8, i8* %ptr, i32 1
  store i8 %arg, i8* %ptr.next, align 1
  %1 = icmp ult i32 %iv.next, 17
  br i1 %1, label %loop, label %exit

exit:
  ret void
}
