; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -gvn -S | FileCheck %s

declare void @llvm.assume(i1)
declare void @use(i1)

define void @assume_arg(i1 %x) {
; CHECK-LABEL: @assume_arg(
; CHECK-NEXT:    call void @llvm.assume(i1 [[X:%.*]])
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    ret void
;
  call void @llvm.assume(i1 %x)
  call void @use(i1 %x)
  ret void
}

define void @assume_not_arg(i1 %x) {
; CHECK-LABEL: @assume_not_arg(
; CHECK-NEXT:    [[XOR:%.*]] = xor i1 [[X:%.*]], true
; CHECK-NEXT:    call void @llvm.assume(i1 [[XOR]])
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    ret void
;
  %xor = xor i1 %x, true
  call void @llvm.assume(i1 %xor)
  call void @use(i1 %x)
  ret void
}

define void @pr47496(i8 %x) {
; CHECK-LABEL: @pr47496(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[X:%.*]], 0
; CHECK-NEXT:    [[XOR:%.*]] = xor i1 [[CMP]], true
; CHECK-NEXT:    call void @llvm.assume(i1 [[XOR]])
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    ret void
;
  %cmp = icmp slt i8 %x, 0
  %xor = xor i1 %cmp, true
  call void @llvm.assume(i1 %xor)
  call void @use(i1 %cmp)
  ret void
}
