
import glob
import re
import sys
from six.moves import cStringIO as StringIO
import six

enable_wsf = 0

if '-wsf' in sys.argv:
    enable_wsf = 1

if len(sys.argv) == 2+enable_wsf:
    srcdir = sys.argv[1]
else:
    srcdir = '.'

wsf = ['lasso_disco_', 'lasso_dst_', 'lasso_is_', 'lasso_profile_service_',
        'lasso_discovery', 'lasso_wsf', 'lasso_interaction_', 'lasso_utility_',
        'lasso_sa_', 'lasso_soap_binding', 'lasso_authentication', 'lasso_wsse_',
        'lasso_sec_', 'lasso_idwsf2', 'lasso_wsf2', 'lasso_wsa_',
        'lasso_wsu_']
if enable_wsf:
    wsf = []

fd = StringIO()

six.print_("/* This file has been autogenerated; changes will be lost */", file=fd)
six.print_("", file=fd)
six.print_("typedef GType (*type_function) ();", file=fd)
six.print_("", file=fd)

header_files = []
for header_file in glob.glob('%s/*/*.h' % srcdir) + glob.glob('%s/*/*/*.h' % srcdir):
    if ('/id-wsf/' in header_file or '/id-wsf-2.0' in header_file) and not enable_wsf:
        continue
    header_files.append(header_file)
    try:
        type = re.findall('lasso_.*get_type', open(header_file).read())[0]
    except IndexError:
        continue
    for t in wsf:
        if type.startswith(t):
            break
    else:
        six.print_("extern GType %s();" % type, file=fd)

six.print_("", file=fd)
six.print_("type_function functions[] = {", file=fd)
for header_file in header_files:
    try:
        type = re.findall('lasso_.*get_type', open(header_file).read())[0]
    except IndexError:
        continue
    for t in wsf:
        if type.startswith(t):
            break
    else:
        six.print_("\t%s," % type, file=fd)
six.print_("\tNULL", file=fd)
six.print_("};", file=fd)

open('types.c', 'w').write(fd.getvalue())
