#!/usr/bin/perl -w

require "./PrefixBits.pl";

sub find_prefixes {
	my $INQUISITIVE_HE=shift;

	my ($mask,$prefix);
	my %prefixes;

	foreach $W ('',''){
	  foreach $S ('','',''){
	    foreach $K ('','','',''){
	      foreach $k ('',''){
		foreach $B ('','','','','','',''){
		  next if (!$INQUISITIVE_HE && $S eq '');
		  next if ($k eq '' && $B eq '');
		  $prefix = "$W$S$K$k$B";
		  $mask = $PS_MISC;
		  $mask |= $PS_L if $B =~ m/[]$/;
		  $mask |= $PS_B if $prefix =~ m/^??$/;
		  $mask |= $PS_VERB if ($k eq "" && $B eq "");
		  $mask |= $PS_NONDEF if $B !~ m/$/;
		  $prefixes{$prefix} = 0 if !defined $prefixes{$prefix};
		  $prefixes{$prefix} |= $mask;
		}
	      }
	    }
	  }
	}
	foreach $W ('',''){
	  foreach $S ('','',''){
	    foreach $K ('','','',''){
	      foreach $B ('','','',''){
	      	foreach $k ('',''){
		  next if (!$INQUISITIVE_HE && $S eq '');
		  $prefix = "$W$S$K$B$k";
		  $mask = $PS_MISC;
		  $mask |= $PS_L if $B =~ m/[]$/;
		  $mask |= $PS_B if $prefix =~ m/^??$/;
		  $mask |= $PS_VERB if ($k eq "" && $B eq "");
		  $mask |= $PS_NONDEF if $B !~ m/$/;
		  $prefixes{$prefix} = 0 if !defined $prefixes{$prefix};
		  $prefixes{$prefix} |= $mask;
		}
	      }
	    }
	  }
	}
	foreach $B ('',''){
		$prefix = "$B";
		$mask = $PS_MISC;
		$mask |= $PS_L if $B =~ m/[]$/;
		$mask |= $PS_B if $prefix =~ m/^??$/;
		$mask |= $PS_NONDEF if $B !~ m/$/;
		$prefixes{$prefix} = 0 if !defined $prefixes{$prefix};
		$prefixes{$prefix} |= $mask;
	}

	$prefixes{""} |= $PS_IMPER;
	$prefixes{""} |= $PS_IMPER;

	return %prefixes;
}

print "/* This file is automatically generated by genprefixes.pl.\n";
print "   DO NOT EDIT THIS FILE DIRECTLY!\n */\n\n";

# Prefix list without He Ha-She'ela (but with He Ha-Yedi`a, of course)

my %prefixes = find_prefixes(0);

print "static char *prefixes_noH[]={";
foreach (sort keys %prefixes) {print "\"$_\",\n"}
print "0};\n";

print "static int masks_noH[]={";
foreach (sort keys %prefixes) {print "$prefixes{$_},\n"}
print "-1};\n";

# Output the same thing, but with He Ha-She'ela...

%prefixes = find_prefixes(1);

print "static char *prefixes_H[]={";
foreach (sort keys %prefixes) {print "\"$_\",\n"}
print "0};\n";

print "static int masks_H[]={";
foreach (sort keys %prefixes) {print "$prefixes{$_},\n"}
print "-1};\n";
