/*******************************************************************************
 * Copyright (c) 2009  Clark N. Hobbie
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Clark N. Hobbie - initial API and implementation
 *******************************************************************************/
package org.eclipse.ecf.ipc;

/**
 * A problem occurred while trying to use an IPC mechanism.
 *
 * <P>
 * This class allows clients to distinguish between exceptions generated by the classes
 * in this package and exceptions from other sources.  The exact nature of the exception
 * should be denoted by the message, which should be taken from one of the constants 
 * defined in the {@link Messages} class.
 * 
 * @author Clark N. Hobbie
 */
@SuppressWarnings("serial")
public class IPCException extends Exception
{
	public static final String MSG_ALREADY_CONNECTED 
		= "The system is already connected to the shared memory segment";

	public static final String MSG_ERROR_OPENING_MAPPING_FILE 
		= "Caught an exception while trying to open the underlying file for the segment";

	public static final String MSG_ERROR_CREATING_MAP 
		= "Caught an exception while trying to obtain a map from the underlying file channel";

	public static final String MSG_NOT_CONNECTED 
		= "Attempt to access the segment before connecting to it.";

	public static final String MSG_PERMISSIONS =
		"The process is not allowed to manipulate the semaphore";
	
	public static final String MSG_UNKNOWN =
		"An unknown/unanticipated error occurred while trying ot manipulate the semaphore";
	
	public static final String MSG_EXCEPTION_CREATING_FILE =
		"Caught an exception while trying to create a file associated with the IPC mechanism";
	
	public static final String MSG_TIMEOUT =
		"A timeout occurred while waiting for the resource to become available";
	
	public enum Errors
	{
		AlreadyConnected(MSG_ALREADY_CONNECTED),
		ErrorOpeningMappingFile(MSG_ERROR_OPENING_MAPPING_FILE),
		ErrorCreatingMap(MSG_ERROR_CREATING_MAP),
		NotConnected(MSG_NOT_CONNECTED),
		Permissions(MSG_PERMISSIONS),
		Unknown(MSG_UNKNOWN),
		ExceptionCreatingFile(MSG_EXCEPTION_CREATING_FILE),
		Timeout(MSG_TIMEOUT),
		;
		
		public String message;
		
		private Errors(String msg)
		{
			message = msg;
		}	
	}

	private Errors myError;
	
	public Errors getError()
	{
		return myError;
	}
	
	public void setError(Errors error)
	{
		myError = error;
	}
	
	
	public IPCException()
	{}
	
	public IPCException (String msg)
	{
		super(msg);
	}
	
	public IPCException(Throwable cause)
	{
		super(cause);
	}
	
	public IPCException (String msg, Throwable cause)
	{
		super(msg, cause);
	}

	public IPCException(Errors error)
	{
		super(error.message);
		setError(error);
	}
	
	
	public IPCException(Errors error, Throwable t)
	{
		super(error.message, t);
		setError(error);
	}
}
