#
# Writer: Sun Haiyong (youbest@sina.com)
#
import os

from pyanaconda.modules.storage.bootloader.base import BootLoader, Arguments, BootLoaderError
from pyanaconda.core import util
from pyanaconda.core.configuration.anaconda import conf
from pyanaconda.product import productName

from pyanaconda.anaconda_loggers import get_module_logger
log = get_module_logger(__name__)

__all__ = ["PMON", "LOONGARCHPMON"]


class PMON(BootLoader):
    name = "PMON"
    _config_file = "boot.cfg"
    _config_dir = "/boot"

    stage2_format_types = ["ext3", "ext2"]
    stage2_device_types = ["partition"]
#    stage2_bootable = True

    @property
    def config_file(self):
        return "%s/%s" % (self._config_dir, self._config_file)

    @property
    def boot_prefix(self):
        """ Prefix, if any, to paths in /boot. """
        if self.stage2_device.format.mountpoint == "/":
            prefix = "/boot"
        else:
            prefix = ""

        return prefix

    def write_config_console(self, config):
        if not self.console:
            return

        console_arg = "console=%s" % self.console
        if self.console_options:
            console_arg += ",%s" % self.console_options
        self.boot_args.add(console_arg)

    def write_config_images(self, config):
        self.write_config_console(config)
        for image in self.images:
            args = Arguments()
            args.update(["root=%s" % image.device.path, "ro"])
            args.update(self.boot_args)
            log.info("bootloader.py: used boot args: %s ", args)

            # extlinux labels cannot have spaces
            label = "%s(%s)" % (self.image_label(image), image.version)
            label = label.replace(" ", "")
            stanza = ("title %(label)s\n"
                      "\tkernel /dev/fs/ext2@wd0%(boot_prefix)s/%(kernel)s\n"
                      "\tinitrd /dev/fs/ext2@wd0%(boot_prefix)s/%(initrd)s\n"
                      "\targs %(args)s\n\n"
                      % {"label": label,
                         "kernel": image.kernel,
                         "initrd": image.initrd,
                         "args": args,
                         "boot_prefix": self.boot_prefix})
            config.write(stanza)

    def write_config_header(self, config):
        header = ("timeout %(timeout)d\n"
                  "showmenu 1\n"
                  % {"timeout": self.timeout})
        config.write(header)
        if self.default is not None:
            config.write("default 0\n\n")

    def install(self, args=None):
        """installation should be a no-op, just writing the config is sufficient for the
        firmware's bootloader (petitboot)
        """
        pass


class LOONGARCHPMON(PMON):
    """ LOONGARCHPMON """
