#!/usr/bin/env python3

import os
import sys

destdir = os.environ.get('DESTDIR', '')
localstatedir = os.path.normpath(destdir + os.sep + sys.argv[1])
datadir = os.path.normpath(destdir + os.sep + sys.argv[2])
interfacedir = os.path.join(datadir, 'accountsservice', 'interfaces')

# FIXME: meson will not track the creation of these directories
#        https://github.com/mesonbuild/meson/blob/master/mesonbuild/scripts/uninstall.py#L39
dst_dirs = [
  (os.path.join(localstatedir, 'lib', 'AccountsService', 'icons'), 0o775),
  (os.path.join(localstatedir, 'lib', 'AccountsService', 'users'), 0o700),
  (interfacedir, 0o775),
]

for (dst_dir, dst_dir_mode) in dst_dirs:
  if not os.path.exists(dst_dir):
    os.makedirs(dst_dir, mode=dst_dir_mode)

interface_files = [
  'com.redhat.AccountsServiceUser.System.xml',
]

for interface_file in interface_files:
    src_path = os.path.join('../../dbus-1/interfaces', interface_file)
    dst_path = os.path.join(interfacedir, interface_file)
    if not os.path.exists(dst_path):
        os.symlink(src_path, dst_path)


