/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *  	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.catalina.startup;

import java.io.IOException;

import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import org.junit.Assert;
import org.junit.Test;

import org.apache.catalina.Context;
import org.apache.tomcat.util.buf.ByteChunk;

// Shamelessly copied from o.a.c.startup.TestTomcat just to verify that submodules work as expected ;)
public class TomcatSmokeTest extends TomcatBaseTest {

	/**
 	* Simple servlet to test in-line registration.
 	*/
	public static class HelloWorld extends HttpServlet {

    	private static final long serialVersionUID = 1L;

    	@Override
    	public void doGet(HttpServletRequest req, HttpServletResponse res)
            	throws IOException {
        	res.getWriter().write("Hello world");
    	}
	}

	/*
 	* Start tomcat with a single context and one
 	* servlet - all programmatic, no server.xml or
 	* web.xml used.
 	*
 	* @throws Exception
 	*/
	@Test
	public void testProgrammaticSmokeTest() throws Exception {
        Tomcat tomcat = getTomcatInstance();

        // No file system docBase required
        Context ctx = tomcat.addContext("", null);

        Tomcat.addServlet(ctx, "myServlet", new HelloWorld());
        ctx.addServletMappingDecoded("/", "myServlet");

        tomcat.start();

        ByteChunk res = getUrl("http://localhost:" + getPort() + "/");
        Assert.assertEquals("Hello world", res.toString());

	}
}
