/*
   Unix SMB/CIFS implementation.
   SMB2 torture tester - deny mode scanning functions
   Copyright (C) Andrew Tridgell 2001
   Copyright (C) David Mulder 2019

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "includes.h"
#include "libcli/smb2/smb2.h"
#include "libcli/smb2/smb2_calls.h"
#include "torture/util.h"
#include "torture/smb2/proto.h"

enum deny_result {A_0=0, A_X=1, A_R=2, A_W=3, A_RW=5};

static const char *denystr(int denymode)
{
	const struct {
		int v;
		const char *name;
	} deny_modes[] = {
		{NTCREATEX_SHARE_ACCESS_NONE, "NTCREATEX_SHARE_ACCESS_NONE"},
		{NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, "NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE"},
		{NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, "NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE"},
		{NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, "NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE"},
		{-1, NULL}};
	int i;
	for (i=0;deny_modes[i].name;i++) {
		if (deny_modes[i].v == denymode) return deny_modes[i].name;
	}
	return "DENY_XXX";
}

static const char *openstr(int mode)
{
	const struct {
		int v;
		const char *name;
	} open_modes[] = {
		{SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, "SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA"},
		{SEC_FILE_READ_DATA, "SEC_FILE_READ_DATA"},
		{SEC_FILE_WRITE_DATA, "SEC_FILE_WRITE_DATA"},
		{-1, NULL}};
	int i;
	for (i=0;open_modes[i].name;i++) {
		if (open_modes[i].v == mode) return open_modes[i].name;
	}
	return "O_XXX";
}

static const char *resultstr(enum deny_result res)
{
	const struct {
		enum deny_result res;
		const char *name;
	} results[] = {
		{A_X, "X"},
		{A_0, "-"},
		{A_R, "R"},
		{A_W, "W"},
		{A_RW,"RW"}};
	int i;
	for (i=0;i<ARRAY_SIZE(results);i++) {
		if (results[i].res == res) return results[i].name;
	}
	return "*";
}

static const struct {
	int isexe;
	int mode1, deny1;
	int mode2, deny2;
	enum deny_result result;
} denytable[] = {
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_RW},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{1, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_RW},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_RW},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{1, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_RW},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_RW},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{1, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_RW},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{0, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_RW},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_RW},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{0, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_NONE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_DELETE, A_0},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_RW},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA|SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_RW},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_READ_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_R},
{0, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, SEC_FILE_WRITE_DATA, NTCREATEX_SHARE_ACCESS_READ|NTCREATEX_SHARE_ACCESS_WRITE|NTCREATEX_SHARE_ACCESS_DELETE, A_W},
};


static void progress_bar(struct torture_context *tctx, unsigned int i, unsigned int total)
{
	if (torture_setting_bool(tctx, "progress", true)) {
		torture_comment(tctx, "%5d/%5d\r", i, total);
		fflush(stdout);
	}
}


/*
  this produces a matrix of deny mode behaviour with 2 connections
 */
static bool torture_smb2_denytest2(struct torture_context *tctx,
		       struct smb2_tree *tree1,
		       struct smb2_tree *tree2)
{
	NTSTATUS status;
	struct smb2_handle fnum1 = {{0}}, fnum2 = {{0}};
	int i;
	bool correct = true;
	const char *fnames[2] = {"denytest2.dat", "denytest2.exe"};
	struct timespec tv, tv_start;

	for (i=0;i<2;i++) {
		struct smb2_create io = {0};
		smb2_util_unlink(tree1, fnames[i]);
		io.in.fname = fnames[i];
		io.in.desired_access = SEC_FILE_READ_DATA | SEC_FILE_WRITE_DATA;
		io.in.create_disposition = NTCREATEX_DISP_CREATE;
		io.in.share_access = NTCREATEX_SHARE_ACCESS_READ |
				     NTCREATEX_SHARE_ACCESS_WRITE |
				     NTCREATEX_SHARE_ACCESS_DELETE;
		status = smb2_create(tree1, tree1, &io);
		torture_assert_ntstatus_ok_goto(tctx, status, correct, failed,
		talloc_asprintf(tctx, "Open of %s failed (%s)",
			fnames[i], nt_errstr(status)));
				fnum1 = io.out.file.handle;
		smb2_util_write(tree1, fnum1, fnames[i], 0, strlen(fnames[i]));
		smb2_util_close(tree1, fnum1);
	}

	clock_gettime_mono(&tv_start);

	for (i=0; i<ARRAY_SIZE(denytable); i++) {
		NTSTATUS s1, s2;
		struct smb2_create io1 = {0}, io2 = {0};
		enum deny_result res;
		const char *fname = fnames[denytable[i].isexe];

		progress_bar(tctx, i, ARRAY_SIZE(denytable));

		io1.in.fname = fname;
		io1.in.desired_access = denytable[i].mode1;
		io1.in.create_disposition = NTCREATEX_DISP_OPEN;
		io1.in.share_access = denytable[i].deny1;
		s1 = smb2_create(tree1, tree1, &io1);
		fnum1 = io1.out.file.handle;

		io2.in.fname = fname;
		io2.in.desired_access = denytable[i].mode2;
		io2.in.create_disposition = NTCREATEX_DISP_OPEN;
		io2.in.share_access = denytable[i].deny2;
		s2 = smb2_create(tree2, tree2, &io2);
		fnum2 = io2.out.file.handle;

		if (!NT_STATUS_IS_OK(s1)) {
			res = A_X;
		} else if (!NT_STATUS_IS_OK(s2)) {
			res = A_0;
		} else {
			struct smb2_read io = {0};
			struct smb2_write wio = {0};
			uint8_t x = 1;
			res = A_0;

			io.in.file.handle = fnum2;
			io.in.length = 1;
			status = smb2_read(tree2, tree2, &io);
			if (NT_STATUS_IS_OK(status) && io.out.data.length == 1) {
				res += A_R;
			}

			wio.in.file.handle = fnum2;
			wio.in.data = data_blob_const(&x, 1);
			status = smb2_write(tree2, &wio);
			if (NT_STATUS_IS_OK(status) && wio.out.nwritten == 1) {
				res += A_W;
			}
		}

		if (torture_setting_bool(tctx, "showall", false) ||
			res != denytable[i].result) {
			int64_t tdif;
			clock_gettime_mono(&tv);
			tdif = nsec_time_diff(&tv, &tv_start);
			tdif /= 1000000;
			torture_comment(tctx, "%lld: %s %8s %10s    %8s %10s    %s (correct=%s)\n",
			       (long long)tdif,
			       fname,
			       denystr(denytable[i].deny1),
			       openstr(denytable[i].mode1),
			       denystr(denytable[i].deny2),
			       openstr(denytable[i].mode2),
			       resultstr(res),
			       resultstr(denytable[i].result));
		}

		torture_assert_goto(tctx, res == denytable[i].result,
				    correct, failed,
				    talloc_asprintf(tctx,
				    "Result %s did not match deny table %s\n",
				    resultstr(res),
				    resultstr(denytable[i].result)));

		smb2_util_close(tree1, fnum1);
		smb2_util_close(tree2, fnum2);
	}

failed:
	for (i=0;i<2;i++) {
		smb2_util_unlink(tree1, fnames[i]);
	}

	return correct;
}


/*
  this produces a matrix of deny mode behaviour for 1 connection
 */
static bool torture_smb2_denytest1(struct torture_context *tctx,
		       struct smb2_tree *tree)
{
	return torture_smb2_denytest2(tctx, tree, tree);
}


struct torture_suite *torture_smb2_deny_init(TALLOC_CTX *ctx)
{
	struct torture_suite *suite = torture_suite_create(ctx, "deny");

	torture_suite_add_1smb2_test(suite, "deny1",  torture_smb2_denytest1);
	torture_suite_add_2smb2_test(suite, "deny2",  torture_smb2_denytest2);

	suite->description = talloc_strdup(suite, "SMB2 deny tests");

	return suite;
}
