#Copyright ReportLab Europe Ltd. 2000-2004
#see license.txt for license details
#history http://www.reportlab.co.uk/cgi-bin/viewcvs.cgi/public/reportlab/trunk/reportlab/__init__.py
__version__=''' $Id: __init__.py 3788 2010-09-29 10:44:00Z rgbecker $ '''
__doc__="""The Reportlab PDF generation library."""
Version = "2.5"

import sys

if sys.version_info[0:2] < (2, 4):
    warning = """The trunk of reportlab requires Python 2.4 or higher.

    Python 2.3 users may still use ReportLab 2.4 or any other bugfixes
    derived from it.  Python 2.2 and below need to use released versions 
    beginning     with 1.x (e.g. 1.21), or snapshots or checkouts from 
    our 'version1' branch.
    """
    raise ImportError("reportlab needs Python 2.4 or higher", warning)

def getStory(context):
    "This is a helper for our old autogenerated documentation system"
    if context.target == 'UserGuide':
        # parse some local file
        import os
        myDir = os.path.split(__file__)[0]
        import yaml
        return yaml.parseFile(myDir + os.sep + 'mydocs.yaml')
    else:
        # this signals that it should revert to default processing
        return None


def getMonitor():
    import reportlab.monitor
    mon = reportlab.monitor.ReportLabToolkitMonitor()
    return mon
