// Package v2 provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen version v1.8.2 DO NOT EDIT.
package v2

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

const (
	BearerScopes = "Bearer.Scopes"
)

// Defines values for ComposeStatusValue.
const (
	ComposeStatusValueFailure ComposeStatusValue = "failure"

	ComposeStatusValuePending ComposeStatusValue = "pending"

	ComposeStatusValueSuccess ComposeStatusValue = "success"
)

// Defines values for ImageStatusValue.
const (
	ImageStatusValueBuilding ImageStatusValue = "building"

	ImageStatusValueFailure ImageStatusValue = "failure"

	ImageStatusValuePending ImageStatusValue = "pending"

	ImageStatusValueRegistering ImageStatusValue = "registering"

	ImageStatusValueSuccess ImageStatusValue = "success"

	ImageStatusValueUploading ImageStatusValue = "uploading"
)

// Defines values for ImageTypes.
const (
	ImageTypesAws ImageTypes = "aws"

	ImageTypesAwsHaRhui ImageTypes = "aws-ha-rhui"

	ImageTypesAwsRhui ImageTypes = "aws-rhui"

	ImageTypesAwsSapRhui ImageTypes = "aws-sap-rhui"

	ImageTypesAzure ImageTypes = "azure"

	ImageTypesAzureRhui ImageTypes = "azure-rhui"

	ImageTypesAzureSapRhui ImageTypes = "azure-sap-rhui"

	ImageTypesEdgeCommit ImageTypes = "edge-commit"

	ImageTypesEdgeContainer ImageTypes = "edge-container"

	ImageTypesEdgeInstaller ImageTypes = "edge-installer"

	ImageTypesGcp ImageTypes = "gcp"

	ImageTypesGcpRhui ImageTypes = "gcp-rhui"

	ImageTypesGuestImage ImageTypes = "guest-image"

	ImageTypesImageInstaller ImageTypes = "image-installer"

	ImageTypesIotCommit ImageTypes = "iot-commit"

	ImageTypesIotContainer ImageTypes = "iot-container"

	ImageTypesIotInstaller ImageTypes = "iot-installer"

	ImageTypesIotRawImage ImageTypes = "iot-raw-image"

	ImageTypesVsphere ImageTypes = "vsphere"
)

// Defines values for UploadStatusValue.
const (
	UploadStatusValueFailure UploadStatusValue = "failure"

	UploadStatusValuePending UploadStatusValue = "pending"

	UploadStatusValueRunning UploadStatusValue = "running"

	UploadStatusValueSuccess UploadStatusValue = "success"
)

// Defines values for UploadTypes.
const (
	UploadTypesAws UploadTypes = "aws"

	UploadTypesAwsS3 UploadTypes = "aws.s3"

	UploadTypesAzure UploadTypes = "azure"

	UploadTypesContainer UploadTypes = "container"

	UploadTypesGcp UploadTypes = "gcp"
)

// AWSEC2CloneCompose defines model for AWSEC2CloneCompose.
type AWSEC2CloneCompose struct {
	Region            string    `json:"region"`
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// AWSEC2UploadOptions defines model for AWSEC2UploadOptions.
type AWSEC2UploadOptions struct {
	Region            string   `json:"region"`
	ShareWithAccounts []string `json:"share_with_accounts"`
	SnapshotName      *string  `json:"snapshot_name,omitempty"`
}

// AWSEC2UploadStatus defines model for AWSEC2UploadStatus.
type AWSEC2UploadStatus struct {
	Ami    string `json:"ami"`
	Region string `json:"region"`
}

// AWSS3UploadOptions defines model for AWSS3UploadOptions.
type AWSS3UploadOptions struct {
	// If set to false (the default value), a long, obfuscated URL
	// is returned. Its expiration might be sooner than for other upload
	// targets.
	//
	// If set to true, a shorter URL is returned and
	// its expiration is the same as for the other upload targets.
	Public *bool  `json:"public,omitempty"`
	Region string `json:"region"`
}

// AWSS3UploadStatus defines model for AWSS3UploadStatus.
type AWSS3UploadStatus struct {
	Url string `json:"url"`
}

// AzureUploadOptions defines model for AzureUploadOptions.
type AzureUploadOptions struct {
	// Name of the uploaded image. It must be unique in the given resource group.
	// If name is omitted from the request, a random one based on a UUID is
	// generated.
	ImageName *string `json:"image_name,omitempty"`

	// Location of the provided resource_group, where the image should be uploaded and registered.
	// How to list all locations:
	// https://docs.microsoft.com/en-us/cli/azure/account?view=azure-cli-latest#az_account_list_locations'
	// If the location is not specified, it is deducted from the provided resource_group.
	Location *string `json:"location,omitempty"`

	// Name of the resource group where the image should be uploaded.
	ResourceGroup string `json:"resource_group"`

	// ID of subscription where the image should be uploaded.
	SubscriptionId string `json:"subscription_id"`

	// ID of the tenant where the image should be uploaded.
	// How to find it in the Azure Portal:
	// https://docs.microsoft.com/en-us/azure/active-directory/fundamentals/active-directory-how-to-find-tenant
	TenantId string `json:"tenant_id"`
}

// AzureUploadStatus defines model for AzureUploadStatus.
type AzureUploadStatus struct {
	ImageName string `json:"image_name"`
}

// CloneComposeBody defines model for CloneComposeBody.
type CloneComposeBody interface{}

// CloneComposeResponse defines model for CloneComposeResponse.
type CloneComposeResponse struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// CloneStatus defines model for CloneStatus.
type CloneStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded struct due to allOf(#/components/schemas/UploadStatus)
	UploadStatus `yaml:",inline"`
}

// ComposeId defines model for ComposeId.
type ComposeId struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// ComposeLogs defines model for ComposeLogs.
type ComposeLogs struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageBuilds []interface{} `json:"image_builds"`
	Koji        *KojiLogs     `json:"koji,omitempty"`
}

// ComposeManifests defines model for ComposeManifests.
type ComposeManifests struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Manifests []interface{} `json:"manifests"`
}

// ComposeMetadata defines model for ComposeMetadata.
type ComposeMetadata struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// ID (hash) of the built commit
	OstreeCommit *string `json:"ostree_commit,omitempty"`

	// Package list including NEVRA
	Packages *[]PackageMetadata `json:"packages,omitempty"`
}

// ComposeRequest defines model for ComposeRequest.
type ComposeRequest struct {
	Customizations *Customizations `json:"customizations,omitempty"`
	Distribution   string          `json:"distribution"`
	ImageRequest   *ImageRequest   `json:"image_request,omitempty"`
	ImageRequests  *[]ImageRequest `json:"image_requests,omitempty"`
	Koji           *Koji           `json:"koji,omitempty"`
}

// ComposeStatus defines model for ComposeStatus.
type ComposeStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageStatus   ImageStatus        `json:"image_status"`
	ImageStatuses *[]ImageStatus     `json:"image_statuses,omitempty"`
	KojiStatus    *KojiStatus        `json:"koji_status,omitempty"`
	Status        ComposeStatusValue `json:"status"`
}

// ComposeStatusError defines model for ComposeStatusError.
type ComposeStatusError struct {
	Details *interface{} `json:"details,omitempty"`
	Id      int          `json:"id"`
	Reason  string       `json:"reason"`
}

// ComposeStatusValue defines model for ComposeStatusValue.
type ComposeStatusValue string

// Container defines model for Container.
type Container struct {
	// Name to use for the container from the image
	Name   *string `json:"name,omitempty"`
	Source string  `json:"source"`

	// Control TLS verifification
	TlsVerify *bool `json:"tls_verify,omitempty"`
}

// ContainerUploadOptions defines model for ContainerUploadOptions.
type ContainerUploadOptions struct {
	// Name for the created container image
	Name *string `json:"name,omitempty"`

	// Tag for the created container image
	Tag *string `json:"tag,omitempty"`
}

// ContainerUploadStatus defines model for ContainerUploadStatus.
type ContainerUploadStatus struct {
	// Digest of the manifest of the uploaded container on the registry
	Digest string `json:"digest"`

	// FQDN of the uploaded image
	Url string `json:"url"`
}

// Customizations defines model for Customizations.
type Customizations struct {
	Containers  *[]Container  `json:"containers,omitempty"`
	Directories *[]Directory  `json:"directories,omitempty"`
	Files       *[]File       `json:"files,omitempty"`
	Filesystem  *[]Filesystem `json:"filesystem,omitempty"`
	Packages    *[]string     `json:"packages,omitempty"`

	// Extra repositories for packages specified in customizations. These
	// repositories will only be used to depsolve and retrieve packages
	// for the OS itself (they will not be available for the build root or
	// any other part of the build process). The package_sets field for these
	// repositories is ignored.
	PayloadRepositories *[]Repository `json:"payload_repositories,omitempty"`
	Services            *struct {
		// List of services to disable by default
		Disabled *[]string `json:"disabled,omitempty"`

		// List of services to enable by default
		Enabled *[]string `json:"enabled,omitempty"`
	} `json:"services,omitempty"`
	Subscription *Subscription `json:"subscription,omitempty"`
	Users        *[]User       `json:"users,omitempty"`
}

// A custom directory to create in the final artifact.
type Directory struct {
	// Ensure that the parent directories exist
	EnsureParents *bool `json:"ensure_parents,omitempty"`

	// Group of the directory as a group name or a gid
	Group *interface{} `json:"group,omitempty"`

	// Permissions string for the directory in octal format
	Mode *string `json:"mode,omitempty"`

	// Path to the directory
	Path string `json:"path"`

	// Owner of the directory as a user name or a uid
	User *interface{} `json:"user,omitempty"`
}

// Error defines model for Error.
type Error struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Code        string       `json:"code"`
	Details     *interface{} `json:"details,omitempty"`
	OperationId string       `json:"operation_id"`
	Reason      string       `json:"reason"`
}

// ErrorList defines model for ErrorList.
type ErrorList struct {
	// Embedded struct due to allOf(#/components/schemas/List)
	List `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Items []Error `json:"items"`
}

// A custom file to create in the final artifact.
type File struct {
	// Contents of the file as plain text
	Data *string `json:"data,omitempty"`

	// Ensure that the parent directories exist
	EnsureParents *bool `json:"ensure_parents,omitempty"`

	// Group of the file as a gid or a group name
	Group *interface{} `json:"group,omitempty"`

	// Permissions string for the file in octal format
	Mode *string `json:"mode,omitempty"`

	// Path to the file
	Path string `json:"path"`

	// Owner of the file as a uid or a user name
	User *interface{} `json:"user,omitempty"`
}

// Filesystem defines model for Filesystem.
type Filesystem struct {
	MinSize    uint64 `json:"min_size"`
	Mountpoint string `json:"mountpoint"`
}

// GCPUploadOptions defines model for GCPUploadOptions.
type GCPUploadOptions struct {
	// Name of an existing STANDARD Storage class Bucket.
	Bucket *string `json:"bucket,omitempty"`

	// The name to use for the imported and shared Compute Engine image.
	// The image name must be unique within the GCP project, which is used
	// for the OS image upload and import. If not specified a random
	// 'composer-api-<uuid>' string is used as the image name.
	ImageName *string `json:"image_name,omitempty"`

	// The GCP region where the OS image will be imported to and shared from.
	// The value must be a valid GCP location. See https://cloud.google.com/storage/docs/locations.
	// If not specified, the multi-region location closest to the source
	// (source Storage Bucket location) is chosen automatically.
	Region string `json:"region"`

	// List of valid Google accounts to share the imported Compute Engine image with.
	// Each string must contain a specifier of the account type. Valid formats are:
	//   - 'user:{emailid}': An email address that represents a specific
	//     Google account. For example, 'alice@example.com'.
	//   - 'serviceAccount:{emailid}': An email address that represents a
	//     service account. For example, 'my-other-app@appspot.gserviceaccount.com'.
	//   - 'group:{emailid}': An email address that represents a Google group.
	//     For example, 'admins@example.com'.
	//   - 'domain:{domain}': The G Suite domain (primary) that represents all
	//     the users of that domain. For example, 'google.com' or 'example.com'.
	// If not specified, the imported Compute Engine image is not shared with any
	// account.
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// GCPUploadStatus defines model for GCPUploadStatus.
type GCPUploadStatus struct {
	ImageName string `json:"image_name"`
	ProjectId string `json:"project_id"`
}

// ImageRequest defines model for ImageRequest.
type ImageRequest struct {
	Architecture string       `json:"architecture"`
	ImageType    ImageTypes   `json:"image_type"`
	Ostree       *OSTree      `json:"ostree,omitempty"`
	Repositories []Repository `json:"repositories"`

	// This should really be oneOf but AWSS3UploadOptions is a subset of
	// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
	// are also valid AWSS3UploadOptionas objects which violates the oneOf
	// rules. Therefore, we have to use anyOf here but be aware that it isn't
	// possible to mix and match more schemas together.
	UploadOptions *UploadOptions `json:"upload_options,omitempty"`
}

// ImageStatus defines model for ImageStatus.
type ImageStatus struct {
	Error        *ComposeStatusError `json:"error,omitempty"`
	Status       ImageStatusValue    `json:"status"`
	UploadStatus *UploadStatus       `json:"upload_status,omitempty"`
}

// ImageStatusValue defines model for ImageStatusValue.
type ImageStatusValue string

// ImageTypes defines model for ImageTypes.
type ImageTypes string

// Koji defines model for Koji.
type Koji struct {
	Name    string `json:"name"`
	Release string `json:"release"`
	Server  string `json:"server"`
	TaskId  int    `json:"task_id"`
	Version string `json:"version"`
}

// KojiLogs defines model for KojiLogs.
type KojiLogs struct {
	Import interface{} `json:"import"`
	Init   interface{} `json:"init"`
}

// KojiStatus defines model for KojiStatus.
type KojiStatus struct {
	BuildId *int `json:"build_id,omitempty"`
}

// List defines model for List.
type List struct {
	Kind  string `json:"kind"`
	Page  int    `json:"page"`
	Size  int    `json:"size"`
	Total int    `json:"total"`
}

// OSTree defines model for OSTree.
type OSTree struct {
	// A URL which, if set, is used for fetching content. Implies that `url` is set as well,
	// which will be used for metadata only.
	Contenturl *string `json:"contenturl,omitempty"`

	// Can be either a commit (example: 02604b2da6e954bd34b8b82a835e5a77d2b60ffa), or a branch-like reference (example: rhel/8/x86_64/edge)
	Parent *string `json:"parent,omitempty"`
	Ref    *string `json:"ref,omitempty"`

	// Determines whether a valid subscription manager (candlepin) identity is required to
	// access this repository. Consumer certificates will be used as client certificates when
	// fetching metadata and content.
	Rhsm *bool   `json:"rhsm,omitempty"`
	Url  *string `json:"url,omitempty"`
}

// ObjectReference defines model for ObjectReference.
type ObjectReference struct {
	Href string `json:"href"`
	Id   string `json:"id"`
	Kind string `json:"kind"`
}

// PackageMetadata defines model for PackageMetadata.
type PackageMetadata struct {
	Arch      string  `json:"arch"`
	Epoch     *string `json:"epoch,omitempty"`
	Name      string  `json:"name"`
	Release   string  `json:"release"`
	Sigmd5    string  `json:"sigmd5"`
	Signature *string `json:"signature,omitempty"`
	Type      string  `json:"type"`
	Version   string  `json:"version"`
}

// Repository configuration.
// At least one of the 'baseurl', 'mirrorlist', 'metalink' properties must
// be specified. If more of them are specified, the order of precedence is
// the same as listed above.
type Repository struct {
	Baseurl  *string `json:"baseurl,omitempty"`
	CheckGpg *bool   `json:"check_gpg,omitempty"`

	// GPG key used to sign packages in this repository.
	Gpgkey     *string `json:"gpgkey,omitempty"`
	IgnoreSsl  *bool   `json:"ignore_ssl,omitempty"`
	Metalink   *string `json:"metalink,omitempty"`
	Mirrorlist *string `json:"mirrorlist,omitempty"`

	// Naming package sets for a repository assigns it to a specific part
	// (pipeline) of the build process.
	PackageSets *[]string `json:"package_sets,omitempty"`

	// Determines whether a valid subscription is required to access this repository.
	Rhsm *bool `json:"rhsm,omitempty"`
}

// Subscription defines model for Subscription.
type Subscription struct {
	ActivationKey string `json:"activation_key"`
	BaseUrl       string `json:"base_url"`
	Insights      bool   `json:"insights"`
	Organization  string `json:"organization"`

	// Optional flag to use rhc to register the system, which also always enables Insights.
	Rhc       *bool  `json:"rhc,omitempty"`
	ServerUrl string `json:"server_url"`
}

// This should really be oneOf but AWSS3UploadOptions is a subset of
// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
// are also valid AWSS3UploadOptionas objects which violates the oneOf
// rules. Therefore, we have to use anyOf here but be aware that it isn't
// possible to mix and match more schemas together.
type UploadOptions interface{}

// UploadStatus defines model for UploadStatus.
type UploadStatus struct {
	Options interface{}       `json:"options"`
	Status  UploadStatusValue `json:"status"`
	Type    UploadTypes       `json:"type"`
}

// UploadStatusValue defines model for UploadStatusValue.
type UploadStatusValue string

// UploadTypes defines model for UploadTypes.
type UploadTypes string

// User defines model for User.
type User struct {
	Groups *[]string `json:"groups,omitempty"`
	Key    *string   `json:"key,omitempty"`
	Name   string    `json:"name"`
}

// Page defines model for page.
type Page string

// Size defines model for size.
type Size string

// PostComposeJSONBody defines parameters for PostCompose.
type PostComposeJSONBody ComposeRequest

// PostCloneComposeJSONBody defines parameters for PostCloneCompose.
type PostCloneComposeJSONBody CloneComposeBody

// GetErrorListParams defines parameters for GetErrorList.
type GetErrorListParams struct {
	// Page index
	Page *Page `json:"page,omitempty"`

	// Number of items in each page
	Size *Size `json:"size,omitempty"`
}

// PostComposeJSONRequestBody defines body for PostCompose for application/json ContentType.
type PostComposeJSONRequestBody PostComposeJSONBody

// PostCloneComposeJSONRequestBody defines body for PostCloneCompose for application/json ContentType.
type PostCloneComposeJSONRequestBody PostCloneComposeJSONBody

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// The status of a cloned compose
	// (GET /clones/{id})
	GetCloneStatus(ctx echo.Context, id string) error
	// Create compose
	// (POST /compose)
	PostCompose(ctx echo.Context) error
	// The status of a compose
	// (GET /composes/{id})
	GetComposeStatus(ctx echo.Context, id string) error
	// Clone an existing compose
	// (POST /composes/{id}/clone)
	PostCloneCompose(ctx echo.Context, id string) error
	// Get logs for a compose.
	// (GET /composes/{id}/logs)
	GetComposeLogs(ctx echo.Context, id string) error
	// Get the manifests for a compose.
	// (GET /composes/{id}/manifests)
	GetComposeManifests(ctx echo.Context, id string) error
	// Get the metadata for a compose.
	// (GET /composes/{id}/metadata)
	GetComposeMetadata(ctx echo.Context, id string) error
	// Get a list of all possible errors
	// (GET /errors)
	GetErrorList(ctx echo.Context, params GetErrorListParams) error
	// Get error description
	// (GET /errors/{id})
	GetError(ctx echo.Context, id string) error
	// Get the openapi spec in json format
	// (GET /openapi)
	GetOpenapi(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetCloneStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetCloneStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetCloneStatus(ctx, id)
	return err
}

// PostCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCompose(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCompose(ctx)
	return err
}

// GetComposeStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeStatus(ctx, id)
	return err
}

// PostCloneCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCloneCompose(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCloneCompose(ctx, id)
	return err
}

// GetComposeLogs converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeLogs(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeLogs(ctx, id)
	return err
}

// GetComposeManifests converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeManifests(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeManifests(ctx, id)
	return err
}

// GetComposeMetadata converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeMetadata(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeMetadata(ctx, id)
	return err
}

// GetErrorList converts echo context to params.
func (w *ServerInterfaceWrapper) GetErrorList(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetErrorListParams
	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", ctx.QueryParams(), &params.Page)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter page: %s", err))
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", ctx.QueryParams(), &params.Size)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter size: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetErrorList(ctx, params)
	return err
}

// GetError converts echo context to params.
func (w *ServerInterfaceWrapper) GetError(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetError(ctx, id)
	return err
}

// GetOpenapi converts echo context to params.
func (w *ServerInterfaceWrapper) GetOpenapi(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetOpenapi(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface) {
	RegisterHandlersWithBaseURL(router, si, "")
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/clones/:id", wrapper.GetCloneStatus)
	router.POST(baseURL+"/compose", wrapper.PostCompose)
	router.GET(baseURL+"/composes/:id", wrapper.GetComposeStatus)
	router.POST(baseURL+"/composes/:id/clone", wrapper.PostCloneCompose)
	router.GET(baseURL+"/composes/:id/logs", wrapper.GetComposeLogs)
	router.GET(baseURL+"/composes/:id/manifests", wrapper.GetComposeManifests)
	router.GET(baseURL+"/composes/:id/metadata", wrapper.GetComposeMetadata)
	router.GET(baseURL+"/errors", wrapper.GetErrorList)
	router.GET(baseURL+"/errors/:id", wrapper.GetError)
	router.GET(baseURL+"/openapi", wrapper.GetOpenapi)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+x9eXPiuLb4V1HxflXdXWFfEpKqqfuAkIQAWYCsQ1eesGVbYEuOJLNkqr/7ryQv2GAS",
	"Mrdn7rv39fwxwbZ0dHR0ztHZpP4jo1HHpQQRwTMnf2RcyKCDBGLBk4nkXx1xjWFXYEoyJ5kbaCKAiY6W",
	"mWwGLaHj2ijRfA5tD2VOMqXMjx/ZDJZ9Xj3EVplshkBHflEtsxmuWciBsotYufI9FwwTU3Xj+C1l7CvP",
	"mSAGqAGwQA4HmAAENQsEAOPYhAAibIrFnfiotu/h8yP8qEA3HobtVrllU4JaknxcDeQy6iImsD88Q6ZC",
	"eQtWNsMtyNDLAgvrBWoa9QLaB8hnTn7PlMqVau3wqH5cLJUz37MZNdlUWMELyBhcqekx9OphhnQJJsDh",
	"e9SMTqZIE7KfP4U716ZQv1bU5e/NIcItg7zcAnGRK2Wyf+fMshlOoMstKl78NYvj5Kxy4ddtrNJpko7r",
	"R5QaCii8FEJBBycxgg7OFbV6pXh0XDk6qtWOa3p1kkaxT5J4YzJy3OwHyzysfLDKrjexsebLmgE9W2RO",
	"DGhzlN2QvY4BOBJAUKA+g6/CQiDoApSUfcsCCGxKzCygE8PjGhRIB3eD3phgDhgSHiNIz4OO4AAtXcyg",
	"BA0cbFoCTBDglBLEgLAgAQZlgAoLMeAp9MdEQGYiwfNjMiZrXATzkByWW5QJxORoIDYYgEQfE5wcEHMg",
	"cefQQQByNZR8jg8H1qOtV2FCqY0g+efXbb8V28VtHrPTdWZ8CNkoFf6bx9AHHIEdaKJIzjY0sCQaNRTB",
	"fFIhHagOcl2B43G1lB7Br57cJlRDE88RAQxx6jENAZNRz82rVZSDyPWgDhaSWQxGHdVFzgVxIZeWQaJT",
	"B1CCwARypANKAAR3d51TgPmYmIggJjnNX6uEWlCIpcmdTTUoghVMTrAXfAkn6TI6x3KSIfovCv0sWFiI",
	"IdVEjSI50LN1NfmQLpDIbibmAjGF3wVdSKa1MRcA2jYI0eAnY2IJ4fKTQkGnGs87WGOUU0PkNeoUEMl5",
	"vKDZuADl8hUChfWPOUaL39SrnGbjnA0F4uK/4Fuo0V7kQC/RIF8UySXG4StJekIF4C7SsIGRngVYyJc6",
	"0j0tsSA76LBJdCkByJPslK7u4n3f564ku+xB7k1URtTTIBkEYM7ViGmbljeJUHjB+jZSnVOJUrzZn0Cm",
	"imp6fVLWcnBSruaq1VIld1zUarnDUrlSPET14jEqp2EnEIFEvIOXRMJvtB9WAQsamOhqrX0JVWoB3FAm",
	"oL0PL4Z8KPAc5XTMkCYoWxUMj+jQQURAm299zVl0kRM0J4fO+ShvEKmmHSGjNjnMlbSKkavqsJiDh+Vy",
	"rjgpHhbLlWP9SD/6ULmuKba9tlsc+IGK3KWCkxpyH5WzgWQMQBoKcduySfWVHIUSdG1kTn7/I/P/GDIy",
	"J5n/KqyN90JgnhZSbNMf3zcgDhB3KfGtVmjbe0C9VpgNkIEYIhrK/MhuUURPUqJUriBp6eVQ/XiSK5X1",
	"Sg5Wa4e5avnwsFarVovFYjGTzRiUOVBkTjKep5bnA6rpKdSKZrderD8/qffaJ1jCH9anZ0f/D6KkP6Ue",
	"NflPnZTi94mHbd1/3rD7AxSymWXOpLngJSYCMQNq6I8faR7BjE6V2f0eZl06xWou6QIYIPQuKfqQYANx",
	"8VPp4cSB/vPE2JjcGvr7M0MC6lDAnzkxygVD6EWjjoNF6p711YLc+hZuXXIFBAiap+x/LtRm0PRhb8Yh",
	"1BffmMJEsz0dExNcte8HjUzMs3xvPgGMiBBphN1Nv4Fvo25vD5rHBXXwG4wM7PeQaCVb/8hmdCwJMPHE",
	"lo/BLGTn6mmE8hmarVF6b8iObByiv9k5yZOfAfNnJXSLgRMEiFH8Z6j4NMXEI7gfTjfU/9lEV/RJoq2h",
	"pNFsT3wk6daA9uuTIOS9io1tEj8AlJzg+5rEB9dmjLJtadCRgNiWPyXR9JiikzrNRMz3DCBPjZdtb1xR",
	"4y0E/PlIgSGeo6biaRrici4GxLbHpGHmIiIVhZzQWq7WDbcEq0WJgJiglJm94yILCjyOotiCFgJZO1Q7",
	"fVPfQA3grsFGXKzCHgmYggLkTJCeMKZ9x5Ot8sErZb2rQU8ENFN9DZu/zBHDxmp7UpIKjNpg1BsC1QYb",
	"OHChY4OqaMxWuGSTv/z5pdq94ZS2IhRQ17F8gPZNbAmCQNXeqxItB0MqNrUmoSLMhjtCubIPUkkFze0h",
	"RtD85Ai+x55qrX1Em5gq3J80OjaD3SGJ+al6H+7JofmwFedZT4aSwEf3eSweJVsTKQhUJYc6uz29Sg8g",
	"bdDm1YOrPKYFZxVEMwrBepy8Q7XNEFg2nHIqt21t0xvbeDjd/ZX7WlmkqPbQE8af2C1OQ+85DaCB7U+A",
	"OsM22gllxQVyPgUq6JICMG6zxWL/LuXCZIh/Lu7vwpVkkheGXMrxmnpJrmovBYMg3kZJYojJOsAFMAFJ",
	"8ywPRhbiaEwSvRfYtgEl9kqFTzjSpZLVkcupPUdBYE8wjOYoGmRMQuG/HgIsOLINFSRf+cAIVZFROIfY",
	"hhN7rYwUUwNGqQCUjQkkqyAU7UIm4nayDlxG5Tb1TeEcDvzCkeDAwMjWQ5hb08EcYJNQFgam9lrlQQgh",
	"lfk4YnOsoc+rIC5nnxLP6mFf5YSAFcX91mCyClMNceTXysLADC2gna6sHUw6fpfS9jQQ+QQ6fuMPsSGG",
	"kO34J5FJ0/rxCNZH6zWMt5X6l39Gdd3xNK2VhtNaJ20RrREIF4iifpJs/mYYxhoNTKANIBPYgJrw+THJ",
	"I4hwj6EXF7IwMf1+aqqt2gNhQeHHqlVHENO3AC1xfMuIpXJ2hKJVvDiUvvVsIAcwiEir3AVl8hlvmF5U",
	"ZSLXEbtNLti2gKUt61A9Ld+OmIM5l6oK+AAizbFGCxNANQFtEISB4tgUj2q1dNdaWGlutbBCCzOCn4BX",
	"QEIrOCsds9RNn/uWchLq9YL4efsUasoeMWJ6P4OYG6aAmmqaCRC5LD/Ln9SCNdyiS8ILkj1gLOGQkijZ",
	"zx1Sw0XNNwCnu2xqylK57T9t1TrFdw7Vyl76xSf1R6ErH1Q65sqA2a1ypB3zZ7RNGALbdngk/iHTKuiQ",
	"A9eGEjJapoar/kLN9YGTtZ8iC2ehdFagvCJl9i/RYQqjd9XXYbX659SXBJ2muYL3f0Z1rennhfSL1Nff",
	"p7XOEhb7RmQZk5ew9ilCp1QsV5PhZA8TcVhVBon0rVyKiUgaMYU5ZB/6WLHO2fXQaTift24+KDuYeNoM",
	"id1JYUh8WZDcMxw1rk4bg1MwFJRBEwHNhpyDpgKR3ywDCB5ywQg7o6fpkQNpapOUmA52XMpEkOZX5UQ6",
	"aFHH9QQCbWJiEsR48mMyinKyCtBGlcQCCyvQVuetG2nkS6JlwcLCmiVNd+l/JL0LBSsoVZHD+7jkQcdI",
	"5vOj8okx+aL5oTKWgy7Ojb1isaJ5HtbVL/QllMtgOMnkIoH1Z8or1uUx26SUU/S/xxLW0ZyUqzSJEVfQ",
	"OH0NRp2AnqrkKCIllM9YV9DD6oY8GCIEwly2ZlNPz5uUmkEsjPuso5LchahIIqhLSRZFqKiIZwucCzCP",
	"Cig0m3LERahy/NjWmHwNahdC9vQZM+r2TZJZsyhHBEBPUAcKrEHbXm0SGXmfqLNL918Cuqh5g7C5xFdB",
	"SXJyGvsq9syPSRtqVsgkiupBeATAiFKRmgyGARLzPLhXGPiqnQPI0MmYAJADX6TqPPkDORDbWP/x5QQ0",
	"CFBPAOo6Q5z7GyNDLkNcbcbRWJoEATamlQdnlIGAelnwBdpYQ/8di39+yQcjB05dw+/3SRz8oQMQu8Z2",
	"Vjnlxeeg6/43dF3uUpE3g05hnzhKah/+LDWC+YelOBKvDRLoDiY8lQY6dSAmJ3/4f+WASjzB0MMCAf8t",
	"+Ooy7EC2+rY9uG37A6pInnQ1/dWHIui7SZG16H2RO+eXDZzSpe591gzLl3zlIBkVQLIak5C+SWn6Xe3w",
	"J1tckYmCGSE/7Lt4mcDqOtkmcyabCQgcf/mXFPNGW+vPK1dRNrKE/7JZjgC5hogOichNGMR6rlKs1EqV",
	"Dw2FGLjsR9UvibTidrEt0ywskCY8tjGdZf3w5bC6e3v3X++RnRutXKRyan42+6M+18ORbKVmnAxS/oQw",
	"m7/Jv1B3r1xy0sTaqheOky5BlQ3Uv4ersIujUOg3751rjNy/T+dagyxlRIr9ACSrddJTnBvT/FT6MJtR",
	"IVn/p4+Z/zss+AxyjFu8GOOw2FBwIYeBC56zYI5ZHg6eYj85dKPHNx8Zv/Yz/jLeCukmykWlFcFTmJ8I",
	"XmDCBbRt9cLUXP//IQBTSmCkItTfRAdMxRq+/7AGL583GzO4iMDNuSvNv1QadYPCgfTE3lriz5BOGcy1",
	"pGmXa0K+wxi1EeQbPcvFcrF4XDzKF1MNLMTmvi+47hHakTM6xXlDDRwotTxlpnpteZNEJRbD6blDPttU",
	"q9VyNiUpPkeMb5WAVD6uLw/QXw8VnHRZQ1xTJU0BR1VTKTuJ3I6DVD5RFT5bERzis4Pfchf4XYpFCdU+",
	"1EkLTIdRrSTIGSbpQbbwwNI24UMHevuLoALaaZ82qKAGzUYnnfwDRn7n7M4gVzYTbCWpqUhERGpGtaEO",
	"PShnMQuwOhmRjdw46TQaSGiWNNsDKHnQcVwbo8Cg/B+P2f8jO3AkpNu3QLadHRPf+wz9sQiYE9RKqeRY",
	"Pj3x60exUmJqkEhYCKv0FgzKvsDXYKFPQLF8WKxOyjo8RMe16kSvVCf1Sb0M65UaqsGjI708OSwaBvyW",
	"9WMvEwaJZuVsPEOARfURa3jMQnahXvANg4JUeN82HKztFukqxNiuw9qjm8Wdj2OAp0gg5mCCuHSIA9L4",
	"Xlui6NyBBJqIga8aJLqNXCzdSB0RgcXKP/Pisx8QVFnAvsegPoQGRh60KOGegxjQJHOpGo4w2xmuMuRA",
	"szEiYqONhciYRLwU8YH0zkPG2nFaZueJlW3+3wiwbwmCFSzFtomXLuM7hD+tqigQWTVCmmxuFgumWqap",
	"SCCX7vgSbmnvbVrbuxM2Hb226xOBoWW8w8FI+RDbaD4orveNxZ27SdYnQoSjtLBi9u2WRlh/kzxkYNPz",
	"0xf5MWkIIGEKdfAniCt8mUCOPGZ/kQ42lhaljblQT0hAG5PZF7BeExWmGJMJWjuVKkLmUBZCdABkaNPn",
	"pEz3QxkuQxrSlU7BfEzih8bkuFJWJnSO0pIKAaLpJoSmkzxDugX9IxWB9BR0zEVBapb6WrVIOJQXKC/s",
	"YVloFtJmL6ZrxhYyniBwzRlKWYTzm3MwQ6uozEEy0bp0QkUmk1okoUFz8r9m+7xzBW7Ob8DNXbPXaYFu",
	"+wk0e9etrvo8JmPi3HaumucNbajRZrtx2jPqTxcz9HZ5CHW7/7Q4gufnHfsS2qJ+OS0vC81y98DqGB1v",
	"eS7c++kRGpPewDy9OzqcwlHNvT+tOWf9y4o7QwQNCtrIeX29nV2tbrn1WKa3j4v2291wUmpd9VtG69yc",
	"PdZvy2Py9jxjHa3Fzoq35QXrTmzo6dbdAb6HpHHKnVL9qf3KJ7XGXeVIF3esX7l90h/M48HBI74x7uuD",
	"Mek2p6NiZX7fvNb7Q/5UOe7BFjnsuKXruVvvtGmhg9r3T6VXp3V904Dd4uTyouIZZrXloRk/GA3HZHH7",
	"MEKt3tJ77h1e9x/p9U13Me/fGsuJWXo8rc+952JXTAva1UV5Cb3i0uEN7/ji0kWz+fXNYGmPyepVTFfP",
	"BqP3GJ2t3MWzOb9dCEL69YI5bHuFy/sReyrWyk77bnTU0iZH1Zl2cTY6M/ozm8zOC2NSNO6qjQGsFasX",
	"leW0OBMTVJl3tZtHenPtdZv3/GI4Lxbvzp8aqxvkrQ7qR9pd4alt9Y9mleF9dzomh6jzbK5w/7q4sEtP",
	"56eDrubZixk/bhx49sws0dGkyitvzvP8pnh0TkfLh2p5Cru1h+HBlfWM0JjUD4uP9N6aaKWuOzyYGs90",
	"yllbPNdvJnfPB0/zs/rAZfpDg00vJpez8qU76DaWI2vJbxu8aZ2XxqTY85blB9hvFs1yp3aj9fXLgvY6",
	"pcW6prFp89HDyweGa9g77j+69ddRwRi+XTlc75ikXnh97o4Jrt96tuEdHXmv1kNhIcoTQbAwB/x1ai37",
	"3vTprvo8qVozcVa3uneFx8ejavnV6tW6i8agcdtojok4PTt/fhjMNadtdk/7pe6wUX927meTyqXVG/VL",
	"vcfmCj6ULI3YjfC9dnE5h879VG/V5mOiOdoBvr28bjb7zVajUT3D7Ta6OHSYdXZx5N3z216/Xy4+1bRn",
	"iyyf6mcNR8lQ63xRP2stZp0xaS4652e39LLV4K1m86nVWLRbF2a7dVZtNFrm7Hbd++DqqVE4aj65pr0a",
	"Np6fLqzpqmuNSeHAOHy7Me7nk4tysf1amXWOrs+aV0XSezxo3pUcbz48eB15w8pDjzUrTuXcs4XbHbQv",
	"uz3h1NqnY1Ji52+PDToqrdzjp0691zjV+63W9WramHL6cFc/errzWgeFCZmyERqUe4PrlrG6aR0dPhzX",
	"a/j6fkyc2vBgwm9PF0etco/ZeqNf7Z96dPVcGmJxDp+r3dvevTgYtWGpivnT8Lw1faNHN0/1+8rl9axW",
	"HBPz9cGsl68KE6fcfhsejeqVh/bppGTPp9WOPV+andcuMkult8enpcOehs+Xly1j/mYc2FfDQ29pXozJ",
	"dFm4LK7s53IPT87Z4Xmjsbo+vntgjefhYtgvtrXpqL5ot8hyNjz1Vq/Ow+J+ftV89Nqd+/o1qjyNSR/f",
	"lYzLqzrXj05dfras9Q8eddInt8ODCzYd3XRPK84Dsxs6aY8s/em+Pn2euQ/W6YpXCsfH6HpMrFmR9ciq",
	"OL1azKBnFPBd/Vo7fJz3Z9PeoH9p1u6O77urS+/hQbwtHsm0f1V7GJw1X7tV/kydfn9MDDEZXZQOaqvJ",
	"4KHQqMybE7gcPJTF0d3b1VR7Q7PhcxvD3tVxr3ChXbY6g9LtWf2wXj7VG3b77Fgfk1nZvMVPw9sGhJfF",
	"y8vG28V8MBtc9npmt/x0+4Qvru5XZVG5XJ0ZnEGnthi2Hq4N6wZ1Vr3m6PlyTObMvbJvJsjgo+Pa0cgo",
	"N686nvn2zFq1++XpsDt7NgdW6f58PuzcktbqbXa7OmzflV9vXPxQO5Y6yrrpPD6zLtW6lW5veFzAb5e3",
	"o4Etpv3Gb2Py240xOhoTtbu0r07f23pSA4KqGO6Fczt9qwzNifT92zc9eEoUIOz3D7lb/uZ/z1XKY69Y",
	"LB9K0+i3KEj50Wa+tm+2kYhwkJ/zGiKCcjX+PwJD7Ld6jguGoBMbGcr/H1b9Nwq/JuToergHLvFKw9QE",
	"rfQIgkbAL0dU/tnaZgCQS7OCA6xyZes8jqpyHJOvLnaRjQn6llrxuBXJDyuz6SfLSX+uS5b0usAOpyuT",
	"WhK/5V8MN0r9NpwLTeC5X9oTGHHJCzCQxpDIyU+x5XQh5wvKUqsipWX5kmqibluoe7AIJhyb1saFH7tK",
	"VSgzIQkKcDfjctVipVxN96b3uKXCD31DGxg2NMOMPbM0+TOMzPqZWlU/ESbZoc0pgPYCrnhQ5MlBJ5jR",
	"Bu/tmpMfdNumaJxh8pL9YoT9kK4b7leCbtlNnkjgEFvg2OKk+bXbZy3Iau+TxhsJh+yHfTbvI/moy1bd",
	"yIdjbN9w8VGXHcdOfnzPbtUvYB4eq2cI2n55uCryARNPgO35SRUBldJAAlBjTFLIlgcKroMgCUJy0LZB",
	"SkPgLxofE+m1Kp71ldLWuDBqGzD4HFN1bMJ3cCXCY8I8G/nl7wwZlKEsWCBgwXlU6aIYAagiDTm7CQJw",
	"AcNyNXVRBPkixsSlnOOJX3zn4KWKCDlQaJbvaQdUBoKaSpVKeYrYblccOJbv+szB92TWZ39u3LPHZqb1",
	"E7y4Z4/0Uz6qtO7zea8oc7ZP5tPvGKQ+dx0JDOI/4ep831jHT2bQmEfIrjRZHJ20PFmeV6KUVZgOW6ef",
	"UiHytDN8Kn+fTNaudbf6mHrV1daxzc09mXMrh/RyrVY6Bo1Go9GqXL3BVsl+Pu2UrkbtmnzXuWLn3Tbr",
	"P+GDfv9u4V3AQePSGfRo521glF9Py/pp7a3YHC0Lh8s0JLYTYh5H7OP80I7Mu9rENI9hsRpKpvAJ1ESQ",
	"+YSbqF9n4YZ1+TAKL01TW6HfLoIqLQn/6jRMDLptNQ6D+hlBA1NP1bH5CUO/vINLy8nGGgruqghua2u4",
	"ULMQKKvUndpuI8N8sVjkofqsrOGgLy/0Oq321bCdK+eLeUs4tlpBLBTJrodNNXyQrWZAFYoB6OJYhPMk",
	"U874ddtEfjjJVPLFfCnjV6EqMhU0mxLEC39g/Yfiq7RSxnPkl/n68qSKGkEgBIAyIKXSRiI8EOefFVVp",
	"EomZqnvDPDjrHjNNKVNVMOtyPVUBLe1TJX5IR3o+Xhve0X1U4rdmZBN3//2eftdMcK2Mj7ygwFTFlOpG",
	"PVWrGl2oF5zSDTnON5nW1+v99MstvquLXdSlJmoxysViLGumbBrXtYMDq4VpUFq/RuhdjRyjkmLnJGXi",
	"NJEsUv2JQwc1E9uDdoi/7wecAbDuD13664dueKrAeoaU94N9RPzRK3/96HcEesKiDL/5HpeLmOQNEPG2",
	"j0n178BkRuiCbCxB7e9Y/TuCli5S13OpOhxANc1jUtLiKlxJcai8f/8uZYR7jgPZKijEjSshpbwiflJw",
	"Clrsbkuadmq45R+0gICgRdg1C1wqp46VcaxRwoOKbXWSbo4YDJW70vdBCbO6xNMvocUM6Eh2CcpxtxTX",
	"DeUivNrIVzKIi/CSpJ8j8cnrPX4kt0+pzH5s6ZvSzx69o6ctffARWJDL9WMC6f8ypcPWF3/80jy/NM+e",
	"midQGmma5mcZT5+wl0IafmAoJW6f2ctUigD/HzOWEpRK4aAkXX4ZTL/U1r+pwbRTf/mOYNxqSrFf4vcz",
	"7qVPYsrqf5EW+Qtsr82bL/9u6yvtnswUllKHAtFifQ5lglSFpX/tT7peE2gpCur8cBKflNvm99Ne1Z81",
	"QJps/kjs2pIsiROY7wiAHZQO/5ld3MAEcyu2iYN393As1lt3VnkUKiruIAEBJj4PY0oAnFBPhNcKe7Z4",
	"b5tXlc+/NvkPN/ngXs1U0ZAsEB2U9a//jhxETAChKu2LNc+GLDgZCL4Ki3qmFaQ0LofXV9/y/3GCdK5O",
	"gZphgjzk8jQxStwR+q4sRS33EKeBuhmfq6rK6KIviYzywQN1RuJ3sOeBOvoZNdaoEiweHbP3l09HBlY3",
	"7gsQD8cGl3b51RGQhJd45UJw+do7ori+e/WXPH4oj2ti7RDKxHJvCeZ/pqwlxWMPoYtVd78vc9E5CCly",
	"W3Lmn1FHS6iJxEYU/cMUOnIR0fn6Jj0la1HoX52cfk8yQjx/CcbHghFd77tDLsKl/Ixc/HJSfzmp/9uc",
	"1C3dlKbvFPC4TbGlYtY3RG0pl7SZrZsU1HG3XSUOsXbqPNxfKvrrOaRxu39pODVAQIxfYvavETOf0f/9",
	"hAxGDARtG0T1TyE3rcXs44g2JH7RA9GiU04+Zus7fCYroLbOdEHdP36Egub/1K5f+Zv38J1LqT6A+Ltf",
	"UvxLij8jxWibg6TkRkU+u3fI66BJOt8nkQ3AKXmWnrWkQXjP3b+hbfHudH5EddBpmqgfXChEdU/zb8GK",
	"LipIlnFBF+flONzCwb86BV3s312fU9EDxHLhbWaFeVlZHBvFZQKamJjvDcAFNNE/OYwiIgkvPIqG+QjO",
	"9x//PwAA//+8fVvneXUAAA==",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
