/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import netscape.ldap.util.BadFilterException;
import netscape.ldap.util.LDAPFilter;
import netscape.ldap.util.LDAPIntFilterList;

public class LDAPIntFilterSet {
    private Vector<LDAPIntFilterList> m_vLDAPIntFilterList;
    private String m_strTag;
    private Matcher m_matcher = null;

    Vector<LDAPFilter> getFilters(Pattern patTag, String matcherValue) {
        Vector<LDAPFilter> vRet = new Vector<LDAPFilter>();
        if (this.m_matcher == null) {
            this.m_matcher = patTag.matcher(this.m_strTag);
        }
        if (this.m_matcher.find()) {
            for (int i = 0; i < this.m_vLDAPIntFilterList.size(); ++i) {
                LDAPIntFilterList tmpIntFilterList = this.m_vLDAPIntFilterList.elementAt(i);
                if (!tmpIntFilterList.MatchFilter(matcherValue)) continue;
                for (int j = 0; j < tmpIntFilterList.numFilters(); ++j) {
                    vRet.addElement(tmpIntFilterList.getFilter(j));
                }
                return vRet;
            }
        }
        return vRet;
    }

    public LDAPIntFilterSet(String strTag) {
        this.m_strTag = strTag;
        this.m_vLDAPIntFilterList = new Vector();
    }

    void newFilter(LDAPFilter filter) throws BadFilterException {
        LDAPIntFilterList tmpFilterList = new LDAPIntFilterList(filter);
        this.m_vLDAPIntFilterList.addElement(tmpFilterList);
    }

    void appendFilter(LDAPFilter filter) {
        this.m_vLDAPIntFilterList.lastElement().AddFilter(filter);
    }

    boolean match(String strTagPat) {
        return Pattern.matches(strTagPat, this.m_strTag);
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer(2000);
        strBuf.append("  strTag: " + this.m_strTag + "\n");
        for (int i = 0; i < this.m_vLDAPIntFilterList.size(); ++i) {
            strBuf.append("  filter #: " + i + "\n");
            strBuf.append(this.m_vLDAPIntFilterList.elementAt(i).toString());
            strBuf.append("\n");
        }
        return strBuf.toString();
    }
}

