#! /usr/bin/perl

# Autor: Piotr Kosowski <pklosows@press.umcs.lublin.pl> Wersja
# pierwsza dziaajca (0.1a): 1. lutego 1998 r.  

# Skrypt "porzadki" jest napisanym od nowa nastpc awkowego skryptu
# "normtext.awk" z lata 96 r., ktry z kolei by rozwiniciem pomysw
# Tomasza Przechlewskiego.

# Filtr do robienia porzdkw w duchu TeX-a w plikach tekstowych
# (przede wszystkim znaki przestankowe i wstawianie nieamliwych spacji) 
# Podstawowe zastosowanie to pomoc w konwersji tekstw napisanych w
# rnych edytorach. 

# Gwne zaoenia i ograniczenia:
# - tekst jest podzielony na akapity pustymi wierszami,
# - tekst jest w jzyku polskim (kodowanie iso-latin2),
# - wntrze akapitw z wyjtkiem linijek zakoczonych przez "\\" moe ulega 
#   przeformatowaniu (prba usunicia przeniesie wyrazw) (uwaga na ew. 
#   znaki komentarza - "%"!)

# ========================================================================
# Stae wykorzystywane w skrypcie

$Odstep = "[\ \t~]";
$NieOdstep = "[^\ \t~]";
$Spojnik = "[aAiIoOuUwWzZ]";
$Litera = "[a-zA-ZʳӶ]";
$NieLitera = "[^a-zA-ZʳӶ]";
$DuzaLitera = "[A-ZʣӦ]";
$MalaLitera = "[a-z󶿼]";
$Cyfra = "[0-9]";
$CyfraRzymska = "[IVXL]";

$PominSrodowisko ="(tabular|array|tabbing|figure|equation|eqenarray|verbatim)";
# ========================================================================
sub PolaczWiersze {
# usunicie przeniesie	
	s/($Litera)-$Odstep*\n$Odstep*($MalaLitera)/$1$2/g;
	s/($Litera)-$Odstep*\n$Odstep*-($Litera)/$1\\dywiz $2/g;
	s/\n$Odstep+\n/\\\\\ \\\\\ /g;
	tr/\n/\ /;
};
# ========================================================================
sub PoprawAkapit {
	&PoprawNielamliwe;
	&PoprawPrzestankowe;
};
# ------------------------------------------------------------------------
# Nieamliwe spacje
sub PoprawNielamliwe {
	&NielamliweSpojniki;
	&NielamliweInicjaly;
	&NielamliweDaty;
	&NielamliweBibliograf;
	&NielamliweJednostki;
	&NielamliweTytuly;
	&NielamliweInne;
	&NielamliweWyliczenia;
};
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# nieamliwe spacje przy sowach jednoliterowych (uwaga na cyfr rzymsk "I")
sub NielamliweSpojniki {
	s/([\(,]|$Odstep+)($Spojnik)$Odstep+($Spojnik)$Odstep+/$1$2~$3~/g;
	s/([\(,]|$Odstep+)($Spojnik)$Odstep+/$1$2~/g;
};
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# nieamliwe spacje przy inicjaach
sub NielamliweInicjaly {
	s/($DuzaLitera)\.$Odstep*($DuzaLitera)\.$Odstep*($DuzaLitera$MalaLitera)/$1\.~$2\.~$3/g;
	s/($DuzaLitera)\.$Odstep*($DuzaLitera$MalaLitera)/$1\.~$2/g;
};
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# nieamliwe spacje przy skrtach zwizanych z pisowni daty
sub NielamliweDaty {
	s/($Cyfra)$Odstep*(r|w)\./$1~$2\./g;
	s/($NieLitera)(r|w)\.$Odstep*($Cyfra)/$1$2\.~$3/g;
	s/($CyfraRzymska)$Odstep+w\./$1~w\./g;
};
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# nieamliwe spacje przy skrtach wystpujcych w zapisie bibliograficznym
sub NielamliweBibliograf {
	s/($NieLitera)([sStTzZ]|ss|SS|[vV]ol|[aA]rt)\.$Odstep*($Cyfra|$CyfraRzymska)/$1$2\.~$3/g;
};
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# nieamliwe spacje midzy liczb a skrtem jednostki miary
$DuzoZer = "tys\\.|mln|mld";
sub NielamliweJednostki {
	s/($Cyfra)$Odstep*($DuzoZer)/$1~$2/g;
	s/($Cyfra|$DuzoZer)$Odstep*([kdcm]?[glmsVAW])($NieLitera)/$1~$2$3/g;
	s/($Cyfra|$DuzoZer)$Odstep*(z|gr|ha|t|mies|godz|min|sek)($NieLitera)/$1~$2$3$4/g;
};
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# nieamliwe spacje po tytuach
sub NielamliweTytuly {
	s/($NieLitera)(mgr|dr|prof\.|hab\.|bp|ks\.|o+\.|w\.|prez\.|przew\.|red\.|min\.|gen\.|pk|mjr|kpt\.)$Odstep+/$1$2~/g;
}
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# nieamliwe spacje przy innych skrtach
sub NielamliweInne {
	s/($NieLitera)([Tt]ab\.|[Tt]abl\.|[Rr]y[cs]\.|[Rr]ozdz\.|[Nn]r)$Odstep*($Cyfra)/$1$2~$3/g;
};
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# nieamliwe pfirety przy wyliczeniach
sub NielamliweWyliczenia {
	s/^-+$Odstep*/---\\enspace\ /;
	s/^($Cyfra+[\.\)\/])$Odstep+/$1\\enspace\ /;
	s/^($Litera[\.\)\/])[\ \t]+/$1\\enspace\ /;
};
# ------------------------------------------------------------------------
# Znaki przestankowe
sub PoprawPrzestankowe {
	&PrzestankowePolpauzy;
	&PrzestankowePauzy;
	&PrzestankoweDywizy;
	&PrzestankoweCudzyslowy;
	&PrzestankoweWielokropki;
	&PrzestankoweOdstepy;
	&PrzestankoweSymbole;
};
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# ppauzy
sub PrzestankowePolpauzy {
	s/($Cyfra)$Odstep*-$Odstep*($Cyfra)/$1--$2/g;
};
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# pauzy
sub PrzestankowePauzy {
	s/$Odstep+-$Odstep+/\ ---\ /g;
	s/$Odstep+---/~---/g;
};
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# dywizy
sub PrzestankoweDywizy {
	s/($Litera)-($Litera)/$1\\dywiz $2/g;
};
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# cudzysowy
sub PrzestankoweCudzyslowy {
	s/^\"/,,/;
	s/($NieLitera)\"($Litera)/$1,,$2/g;
	s/($Odstep)\"($NieOdstep)/$1,,$2/g;
	s/\"$/''/;
	s/($Litera)\"($NieLitera)/$1''$2/g;
	s/($NieOdstep)\"($Odstep)/$1''$2/g;
	s/\\,,/\\\"/g;
};
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# wielokropki
sub PrzestankoweWielokropki {
	s/\.{5,}/\\dotfill\{\}/g;
	s/\.{3,4}/\\ldots{}/g;
};
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# odstpy przy znakach przestankowych (uwaga: ryzykowne - duo wyjtkw)
sub PrzestankoweOdstepy {
	s/$Odstep*([\.;:!?\)\]])/$1/g;
	s/$Odstep*,([^,])/,$1/g;
	s/([\.!?;:\)\]])($Litera)/$1 $2/g;
	s/([^,]),($Litera)/$1, $2/g;
	s/([\(\[])$Odstep*/$1/g;
# skrty - wyjtki
	s/m\.\ +in\./m\.in\./g;
	s/p\.\ +n\.\ +e\./p\.n\.e\./g;
	s/l\.\ +c\./l\.c\./g;
	s/w\.\ +c\./w\.c\./g;
# due liczby
	1 while (s/(.*\d\d)(\d\d\d)/$1\\,$2/ or s/(.*\d)(\d\d\d)\\,/$1\\,$2\\,/);
};
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# uporzdkowanie kolejnoci nawias klamrowy - znak przestankowy (!!!sprawa 
# zwizana z grupowaniem texem - nie do zaatwienia w tym prostym programie)
#  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
# symbole niematematyczne 
sub PrzestankoweSymbole {
	s/([^\\])([\$\%])/$1\\$2/g;
	s/([^\$\<])\<([^\$\<])/$1\$\<\$$2/g;
	s/([^\$\>])\>([^\$\>])/$1\$\>\$$2/g;
}
# ========================================================================
# Zmiany w ksztacie akapitu - usunicie przeniesie i wci od marginesu 
# i przeformatowanie na szeroko <=70 zn (domylna w AUCTeX-u)
sub PrzeformatujAkapit {
	s/$Odstep*\\\\/\ \\\\/g;
	$IloscSlow = split;
	$DlugoscWiersza = length($_[0]);
	for ($i=1; $i<$IloscSlow; $i++) {
		$DlugoscWiersza += length($_[$i]) + 1;
		if (($DlugoscWiersza>70) || ($_[$i-1]=~/\\\\/)) {
			$_[$i-1] .= "\n";
			$DlugoscWiersza = length($_[$i]);
		};
	};
	$_ = join (" ", @_, "\n");
	s/$Odstep\\\\/\\\\/g;
	s/\n*\\\\\n\\\\\n/\n\n/g;
	s/\n$Odstep+/\n/g;
};
# ========================================================================
# Gwny program

$/ = "";
$\ = "\n";

while (<>) {
	if (/\\begin{$PominSrodowisko}/../\\end{$PominSrodowisko}/) {
		next;
	};
	&PolaczWiersze;
	&PoprawAkapit;
	&PrzeformatujAkapit;
} continue { print; };

# Koniec skryptu "porzadki".
